// stdafx.h : include file for standard system include files,
//  or project specific include files that are used frequently, but
//      are changed infrequently
//

#if !defined(AFX_STDAFX_H__D745D35D_8415_4821_9789_CD847CAF9B48__INCLUDED_)
#define AFX_STDAFX_H__D745D35D_8415_4821_9789_CD847CAF9B48__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
// BEGIN ADDED BY Lkb - 8/jun/2001
#pragma warning(disable : 4786)
// END ADDED BY Lkb

#include <stdio.h>
#include <windows.h>
#include <windowsx.h>
#include <winnt.h>			// For 32x32To64 multiplies
#include <commctrl.h>
#include <commdlg.h>
#include <math.h>			// For sqrt()
#include <shlwapi.h>		// PathCombine() etc
#include <shellapi.h>		// ShellExecute()
#include <shlobj.h>
#include <stdlib.h>
#include <stddef.h>		// offsetof
#include <float.h>

#include <vector>
// BEGIN ADDED BY Lkb - 8/jun/2001 - use stdlib iostream instead of deprecated ms iostream
#include <istream>
#include <fstream>
#include <strstream>
//using namespace std;

// BEGIN MODIFIED BY Lkb - 9/jun/2001 - GCC support
#ifdef _MSC_VER
#include <crtdbg.h>
#endif
// END MODIFIED BY Lkb - 9/jun/2001 - GCC support
// END ADDED BY Lkb - 8/jun/2001


// BEGIN MODIFIED BY Lkb - 9/jun/2001 - GCC support
#include "tchar.h"
// END MODIFIED BY Lkb - 9/jun/2001 - GCC support



#include "Debug\DaedalusAssert.h"
#include "DaedalusTypes.h"

#ifndef SAFE_DELETE
#define SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#endif

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p)  { if(p) { (p)->Release();     (p)=NULL; } }
#endif

#ifndef SAFE_DELETEARRAY
#define SAFE_DELETEARRAY(p)  { if(p) { delete [](p);     (p)=NULL; } }
#endif

#define ARRAYSIZE(arr)   (sizeof(arr) / sizeof(arr[0]))

#include "Localisation/localization.h"

#define DAEDLAUS_VERSION_NO		0x008b
#define DAEDALUS_VERSION		"0.08b"
#define DAEDALUS_SITE			"http://daedalus.boob.co.uk/"

// DAEDALUS_RELEASE_BUILD is now only defined for "Win32 Release" configuration
// It is disabled in Win32 Development Release etc

extern HINSTANCE	g_hInstance;
extern TCHAR		g_szDaedalusName[256];
extern TCHAR		g_szDaedalusExeDir[MAX_PATH+1];
extern TCHAR		g_szDaedalusIniFile[MAX_PATH+1];




// Config stuff
typedef struct
{
	BOOL bWarnMemoryErrors;
	BOOL bRunAutomatically;
	BOOL bTrapExceptions;		
	BOOL bShowDebug;
	RECT rcMainWindow;			// Could probably be removed?
	TCHAR		szAiPluginFileName[MAX_PATH];
	TCHAR		szGfxPluginFileName[MAX_PATH];
	
	// Urgh - will make this a vector at some point!!
	enum { MAX_ROMS_DIRS = 100 };
	u32			nNumRomsDirs;
	TCHAR		szRomsDirs[MAX_ROMS_DIRS][MAX_PATH+1];


	TCHAR		szSaveDir[MAX_PATH+1];

} DaedalusConfig;

extern DaedalusConfig	g_DaedalusConfig;

// Per-ROM config
extern BOOL	g_bEepromPresent;
extern BOOL g_bRDPEnableGfx;		// Show graphics
extern BOOL g_bUseDynarec;			// Use dynamic recompilation
extern BOOL g_bApplyPatches;		// Apply os-hooks
extern BOOL g_bSpeedSync;			// Sync vi speed

// Needs moving to Graphics plugin config
extern BOOL g_bDisplayNewCombiner;
extern BOOL g_bCRCCheck;			// Apply a crc-esque check to each texture each frame



#define ALIGNED_TYPE(type, alignval) type
#define ALIGNED_EXTERN(type, var, alignval) extern type var
#define ALIGNED_GLOBAL(type, var, alignval) type var
#define ALIGNED_MEMBER(type, var, alignval) type var

#ifdef _MSC_VER
#if defined(_MSC_FULL_VER) && (_MSC_FULL_VER >= 12008804) 
#undef ALIGNED_TYPE
#undef ALIGNED_GLOBAL
#undef ALIGNED_MEMBER
#define ALIGNED_TYPE(type, alignval) __declspec(align(alignval)) type
#define ALIGNED_GLOBAL(type, var, alignval) __declspec(align(alignval)) type var
#define ALIGNED_MEMBER(type, var, alignval) __declspec(align(alignval)) type var
#else
#pragma message("You should install Microsoft Visual C++ 6.0 Service Pack 5 and Processor Pack (both free of charge)")
#endif
#endif

#ifdef __GNUC__
// GCC has __attribute__((aligned)) but it complains that the maximum alignment is 16
#undef ALIGNED_GLOBAL
#undef ALIGNED_MEMBER
#define ALIGNED_GLOBAL(type, var, alignval) __asm__(".balign " #alignval ) type var;
#define ALIGNED_MEMBER(type, var, alignval) __attribute__((aligned(alignval))) type var;
#endif

// Pentium 4 has 64-byte cachelines
#define DATA_ALIGN	16
#define CACHE_ALIGN	64
#define PAGE_ALIGN	4096


// Windowsx.h type defines - hope these don't conflict with anything!
#define CheckBox_GetCheck(hwnd)			SendMessage(hwnd, BM_GETCHECK, 0,0)
#define CheckBox_SetCheck(hwnd, state)	SendMessage(hwnd, BM_SETCHECK, (WPARAM)state,0)



//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_STDAFX_H__D745D35D_8415_4821_9789_CD847CAF9B48__INCLUDED_)
