/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#include "stdafx.h"

#ifdef ZLIB_SUPPORT
#include "Core/Memory.h"

#pragma warning(disable : 4096)			// '__cdecl' must be used with '...' in zlib.h

#include "unzip.h"

#include "Debug/DBGConsole.h"

static HRESULT UnzipRom_UnzipFile(unzFile uf, BYTE ** ppBuffer, ULONG * pnRomSize, bool useAllocRegion, std::ostream & messages );


HRESULT __cdecl UnzipRom_Unzip(LPCSTR szZipFileName, BYTE ** ppBuffer, ULONG * pnRomSize, bool useAllocRegion, std::ostream & messages )
{
	unzFile uf;
    int err;
	BOOL bFoundROM;
	HRESULT hr;
	unz_file_info file_info;

	CHAR szRomFileName[MAX_PATH+1];

	uf = unzOpen(szZipFileName);
	if (uf == NULL)
	{
		messages << "Couldn't open " << szZipFileName;
		return E_FAIL;
	}

	err = unzGoToFirstFile(uf);
	if (err != UNZ_OK)
	{
		messages << "error " << err << "with zipfile in unzGoToFirstFile";
		unzCloseCurrentFile(uf);
		return E_FAIL;
	}

	bFoundROM = FALSE;
	do
	{
		err = unzGetCurrentFileInfo (uf, &file_info,
									 szRomFileName, MAX_PATH,
			                         NULL, 0,
									 NULL, 0);

		if (err != UNZ_OK)
		{
			messages << "error " << err << "with zipfile in unzGetCurrentFileInfo";
			break;
		}

		// If filesize is > 1MB, assume it's a rom
		if (file_info.uncompressed_size > 1*1024*1024)
		{

			// Open and try to find 4 byte header (0x80371240)
			err = unzOpenCurrentFile(uf);
			if (err == UNZ_OK)
			{
				LONG nBytesToRead;
				LONG nBytesRead;
				DWORD dwVal;
				
				nBytesToRead = 4;

				nBytesRead = unzReadCurrentFile(uf, (void *)&dwVal, nBytesToRead);
				if (nBytesRead == 4)
				{
					// Check the format:
					//DBGConsole_Msg(0, "%s %08x", szRomFileName, dwVal);

					// Could be byteswapped - check all variations
					if (dwVal == 0x80371240 ||
						dwVal == 0x40123780 ||
						dwVal == 0x12408037)
					{
						unzCloseCurrentFile(uf);
						bFoundROM = TRUE;
						break;
					}
				}
				unzCloseCurrentFile(uf);
			}
		}

	} while (unzGoToNextFile(uf) == UNZ_OK);

	if (!bFoundROM)
	{
		messages << "Couldn't find rom image in " << szRomFileName;
		unzClose(uf);
		return E_FAIL;
	}


	// Extract rom and return buffer;
	hr = UnzipRom_UnzipFile(uf, ppBuffer, pnRomSize, useAllocRegion, messages);

	unzClose(uf);

	return hr;

}


static HRESULT UnzipRom_UnzipFile(unzFile uf, BYTE ** ppBuffer, ULONG * pnRomSize, bool useAllocRegion, std::ostream & messages )
{
    int err;
    BYTE * buf;
	unz_file_info file_info;
	LONG nBytesToRead;
	LONG nBytesRead;

	nBytesToRead = *pnRomSize;

	// Clear buffer to start with
	*ppBuffer = NULL;
	*pnRomSize = 0;

	err = unzGetCurrentFileInfo(uf,&file_info, NULL,0, NULL,0, NULL,0);

	if (err != UNZ_OK)
	{
		messages << "error " << err << "with zipfile in unzGetCurrentFileInfo";
		return E_FAIL;
	}

	// If a size of 0 was specified, this indicates we should read entire file
	if (nBytesToRead == 0)
		nBytesToRead = file_info.uncompressed_size;

	// Round buffer up to 4byte boundary
 	if(useAllocRegion)
	{
		buf = (BYTE*)Memory_AllocCart((nBytesToRead+3)&(~3));
	}
	else
	{
		buf = new BYTE[(nBytesToRead+3)&(~3)];
	}
    if (buf == NULL)
    {
		messages << "Error allocating memory";
        return E_OUTOFMEMORY;
    }

	err = unzOpenCurrentFile(uf);
	if (err == UNZ_OK)
	{
		nBytesRead = unzReadCurrentFile(uf, (void *)buf, nBytesToRead);
		if (nBytesRead < 0)
		{
			messages << "error " << err << "with zipfile in unzReadCurrentFile";
			err = UNZ_ERRNO;
		}
		else if ( nBytesRead == 0 )
		{
			// EOF?
		}
		else if ( nBytesRead < nBytesToRead )
		{
			// Not enough bytes read
			messages << "Unable to read sufficent bytes from zip.\nRead " << nBytesRead << ", wanted " << nBytesToRead;
			err = UNZ_CRCERROR;
		}
		else
		{

		}
	}


 	if (err != UNZ_OK)
	{
		//printf("error %d with zipfile in unzOpenCurrentFile\n",err);
		if(useAllocRegion)
		{
			Memory_FreeCart();
		}
		else
		{
			delete [] buf;
		}
		unzCloseCurrentFile(uf);
		return E_FAIL;
	}
  
	err = unzCloseCurrentFile(uf);
	if ( err == UNZ_CRCERROR )
	{
		//printf("error %d with zipfile in unzOpenCurrentFile\n",err);
		messages << "CRC Error in ZipFile";
		if(useAllocRegion)
		{
			Memory_FreeCart();
		}
		else
		{
			delete [] buf;
		}
		unzCloseCurrentFile(uf);
		return E_FAIL;
	}

	*ppBuffer = buf;
	*pnRomSize = file_info.uncompressed_size;

    return S_OK;
}
#endif

