// GraphicsPlugin.h: interface for the CGraphicsPlugin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __GRAPHICSPLUGIN_H__
#define __GRAPHICSPLUGIN_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GraphicsPlugin_Spec.h"
#include "Utility/CritSect.h"
#include "Utility/Unique.h"
#include "Debug/DBGConsole.h"

#define PLUGIN_SPEC_CALL		__cdecl


#define GFX_LOCK		Lock();
#define GFX_UNLOCK	Unlock();

#define GFX_TRY		try
#define GFX_CATCH	catch(...)								\
		{													\
				DBGConsole_Msg(0, "Exception in [C%s]", m_szModuleName);	\
				Close();									\
				throw;			\
		}


class CGraphicsPlugin : public CUnique< CGraphicsPlugin >, protected CCritSect
{
	protected:
		friend class CUnique< CGraphicsPlugin >;
		friend class CPluginsPage;
		CGraphicsPlugin();

	public:
		virtual ~CGraphicsPlugin();

	public:


		//EXPORT void CALL ViWidthChanged (void);
		void ViWidthChanged()
		{
			GFX_LOCK
			if (m_pViWidthChanged)
			{
				GFX_TRY { m_pViWidthChanged(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL ViStatusChanged (void);
		void ViStatusChanged()
		{
			GFX_LOCK
			if (m_pViStatusChanged)
			{
				GFX_TRY { m_pViStatusChanged(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL MoveScreen(int xpos, int ypos);
		void MoveScreen(int xpos, int ypos)
		{
			GFX_LOCK
			if (m_pMoveScreen)
			{
				GFX_TRY { m_pMoveScreen(xpos, ypos); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL DrawScreen (void);
		void DrawScreen()
		{
			GFX_LOCK
			if (m_pDrawScreen)
			{
				GFX_TRY { m_pDrawScreen(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}



		//EXPORT void CALL ChangeWindow (void);
		void ChangeWindow()
		{
			GFX_LOCK
			if (m_pChangeWindow)
			{
				GFX_TRY { m_pChangeWindow(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}


		//EXPORT void CALL UpdateScreen (void);
		void UpdateScreen()
		{
			GFX_LOCK
			if (m_pUpdateScreen)
			{
				GFX_TRY { m_pUpdateScreen(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL DllAbout ( HWND hParent );
		void DllAbout(HWND hWndParent)
		{
			GFX_LOCK
			if (m_pDllAbout)
			{
				GFX_TRY { m_pDllAbout(hWndParent); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL DllConfig ( HWND hParent );
		void DllConfig(HWND hWndParent)
		{
			GFX_LOCK
			if (m_pDllConfig)
			{
				GFX_TRY { m_pDllConfig(hWndParent); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL DllTest ( HWND hParent );
		void DllTest(HWND hWndParent)
		{
			GFX_LOCK
			if (m_pDllTest)
			{
				GFX_TRY { m_pDllTest(hWndParent); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT BOOL CALL InitiateGFX (GFX_INFO Gfx_Info);
		BOOL InitiateGFX(GFX_INFO gi)
		{
			BOOL bInit = FALSE;

			GFX_LOCK
			if (m_pInitiateGFX)
			{
				GFX_TRY { bInit = m_pInitiateGFX(gi); }
				GFX_CATCH
			}
			GFX_UNLOCK
		
			return bInit;
		}

		//EXPORT void CALL ProcessDList(void);
		void ProcessDList(void)
		{
			GFX_LOCK
			if (m_pProcessDList)
			{
				GFX_TRY { m_pProcessDList(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}


		//EXPORT void CALL RomClosed (void);
		void RomClosed(void)
		{
			GFX_LOCK
			if (m_pRomClosed)
			{
				GFX_TRY { m_pRomClosed(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		//EXPORT void CALL RomOpen (void);
		void RomOpen(void)
		{
			GFX_LOCK
			if (m_pRomOpen)
			{
				GFX_TRY { m_pRomOpen(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		HRESULT ExecuteCommand( LPCSTR pszCommand, LPVOID * ppVoid )
		{
			HRESULT hr = E_NOTIMPL;

			GFX_LOCK
			if ( m_pExecuteCommand )
			{
				GFX_TRY { hr = m_pExecuteCommand( pszCommand, ppVoid ); }
				GFX_CATCH
			}
			GFX_UNLOCK

			return hr;
		}

		
		BOOL LoadedOk() const { return m_bLoadedOk; }

		// szName must be 100 chars
		void GetPluginName(LPSTR szName) const
		{
			if (!LoadedOk())
				lstrcpy(szName, "?");
			else
				lstrcpy(szName, m_pi.Name);

		}

		BOOL Open( LPCTSTR szDllName );
		BOOL Init();

		void Close();

		//EXPORT void CALL CloseDLL (void);
		void CloseDll()
		{
			GFX_LOCK
			if (m_pCloseDll)
			{
				GFX_TRY { m_pCloseDll(); }
				GFX_CATCH
			}
			GFX_UNLOCK
		}

		static BOOL GetPluginInfo( LPCTSTR szFilename, PLUGIN_INFO & pi );


	protected:
		void   (PLUGIN_SPEC_CALL * m_pViWidthChanged)(void);
		void   (PLUGIN_SPEC_CALL * m_pViStatusChanged)(void);
		void   (PLUGIN_SPEC_CALL * m_pMoveScreen)(int, int);
		void   (PLUGIN_SPEC_CALL * m_pDrawScreen)(void);
		void   (PLUGIN_SPEC_CALL * m_pChangeWindow)(void);
		void   (PLUGIN_SPEC_CALL * m_pUpdateScreen)();
		void   (PLUGIN_SPEC_CALL * m_pCloseDll)();
		void   (PLUGIN_SPEC_CALL * m_pDllAbout)(HWND);
		void   (PLUGIN_SPEC_CALL * m_pDllConfig)(HWND);
		void   (PLUGIN_SPEC_CALL * m_pDllTest)(HWND);
		BOOL   (PLUGIN_SPEC_CALL * m_pInitiateGFX)(GFX_INFO);
		void   (PLUGIN_SPEC_CALL * m_pProcessDList)(void);
		void   (PLUGIN_SPEC_CALL * m_pRomClosed)(void);
		void   (PLUGIN_SPEC_CALL * m_pRomOpen)(void);

		// Daedalus commands
		HRESULT (PLUGIN_SPEC_CALL * m_pExecuteCommand)( const CHAR * m_pszCommand, void ** m_ppResult );


		HINSTANCE m_hModule;
		PLUGIN_INFO m_pi;
		BOOL m_bLoadedOk;
		TCHAR m_szModuleName[MAX_PATH+1];

};

#endif // __GRAPHICSPLUGIN_H__
