// MakeLanguageTable.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

int main(int argc, char* argv[])
{
	// Only works on Windows NT/2000

	printf(
		"//File automatically generated by MakeLanguageTable\n"
		"\n"
		"#pragma once\n"
		"\n"
		"struct LanguageTableEntry\n"
		"{\n"
		"\tWORD nLangID;\n"
		"\tLPCTSTR pszLanguageName;\n"
		"};\n"
		"\n"
		"LanguageTableEntry g_LanguageTable[] =\n"
		"{\n"
		);

	for(DWORD primary = 1; primary <= 0x61;primary++)
	{
		TCHAR szData[256];
		for(DWORD sub = 1;;sub++)
		{
			szData[0] = 0;
			GetLocaleInfo(MAKELCID(MAKELANGID(primary, sub), SORT_DEFAULT), LOCALE_SISO639LANGNAME  , szData, 256);
			if(szData[0] == 0)
				break;
			strcat(szData, "-");
			GetLocaleInfo(MAKELCID(MAKELANGID(primary, sub), SORT_DEFAULT), LOCALE_SISO3166CTRYNAME , szData + strlen(szData), 256);
			_strlwr(szData);

			TCHAR szFriendlyName[256];
			GetLocaleInfo(MAKELCID(MAKELANGID(primary, sub), SORT_DEFAULT), LOCALE_SENGLANGUAGE , szFriendlyName, 256);

			TCHAR szCountryName[256];
			GetLocaleInfo(MAKELCID(MAKELANGID(primary, sub), SORT_DEFAULT), LOCALE_SENGCOUNTRY  , szCountryName, 256);

			printf("\t{MAKELANGID(0x%X, 0x%X), _T(\"%s\")}, // %s - %s\n", primary, sub, szData, szFriendlyName, szCountryName);
		}
	}

	printf(
		"\t{0, NULL}\n"
		"};\n"
		"\n"
		);
	return 0;
}

