/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef __PLUGINSPAGEDIALOG_H__
#define __PLUGINSPAGEDIALOG_H__

class CGraphicsPlugin;
class CAudioPlugin;

class CPluginsPage : public CPageDialog
{
	protected:
		friend class CPageDialog;			// Only CPageDialog::Create() can create!

		CPluginsPage( )
		{
		}

	public:
		virtual ~CPluginsPage()
		{
		}

		CPageDialog::PageType GetPageType() const { return CPageDialog::PAGE_PLUGINS; }
		UINT GetResourceID() const { return IDD_PAGE_PLUGINS; }

		BOOL DialogProc( HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam );


	protected:

		typedef struct 
		{
			TCHAR	szFileName[MAX_PATH+1];
			CGraphicsPlugin * pPlugin;
			BOOL bCurrentlyInUse;

		} GraphicsPluginInfo;

		typedef std::vector< GraphicsPluginInfo > GraphicsPluginVector;

		GraphicsPluginVector m_GraphicsPlugins;

		BOOL OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);

		void FreePluginList();
		BOOL InitPluginList();
		void FillPluginCombo(HWND hWndDlg);
		void EnableControls(HWND hWndDlg, BOOL bEnabled);





		BOOL AudioDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);
		void AudioDialog_FreePluginList();
		BOOL AudioDialog_InitPluginList();
		void AudioDialog_FillPluginCombo(HWND hWndDlg);
		void AudioDialog_EnableControls(HWND hWndDlg, BOOL bEnabled);

		typedef struct 
		{
			TCHAR	szFileName[MAX_PATH+1];
			CAudioPlugin * pPlugin;
			BOOL bCurrentlyInUse;

		} AudioPluginInfo;

		typedef std::vector< AudioPluginInfo > AudioPluginVector;

		AudioPluginVector m_AudioPlugins;





};

#endif // __PLUGINSPAGEDIALOG_H__