/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/



#ifndef __PAGEDIALOG_H__
#define __PAGEDIALOG_H__

extern DaedalusConfig g_CurrentConfig;

class CPageDialog
{
	protected:
		CPageDialog() :
			 m_hWndDlg( NULL )
		{
		}

		HWND m_hWndDlg;

	public:

		enum PageType
		{
			PAGE_SETTINGS = 0,
			PAGE_DIRECTORIES,
			PAGE_PLUGINS,
			PAGE_DEBUG,

			NUM_PAGE_TYPES
		};

	public:
		virtual ~CPageDialog()
		{
		}

		virtual PageType GetPageType() const = 0;
		virtual UINT GetResourceID() const = 0;
		virtual BOOL DialogProc( HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam ) = 0;

		static BOOL CALLBACK DialogProcStatic( HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
		{
			BOOL ret;

			//
			// If this is a WM_INITDIALOG message, the pointer is in the lParam parameter
			//
			if ( uMsg == WM_INITDIALOG )
			{
				DAEDALUS_ASSERT( lParam, "Null pointer in CPageDialog::DialogProcStatic/WM_USERDATA" );
				SetWindowLong( hWndDlg, GWL_USERDATA, lParam );
			}

			// Get the implementation pointer from the GWL_USERDATA field
			CPageDialog * p_dialog = reinterpret_cast< CPageDialog * >( GetWindowLong( hWndDlg, GWL_USERDATA ) );
			if ( p_dialog )
			{
				ret = p_dialog->DialogProc( hWndDlg, uMsg, wParam, lParam );
			}
			else
			{
				DAEDALUS_ASSERT( false, "Null pointer in CPageDialog::DialogProcStatic" );
				ret = FALSE;
			}
			
			if ( uMsg == WM_DESTROY )
			{
				// Clear the pointer
				SetWindowLong( hWndDlg, GWL_USERDATA, 0 );
			}

			return ret;

		}

		static CPageDialog * Create( HWND hWndParent, LONG x, LONG y, PageType page_type );

		virtual void Destroy( )
		{
			if ( IsWindow( m_hWndDlg ) )
			{
				// Ok this window before destroying?
				SendMessage( m_hWndDlg, WM_COMMAND, MAKELONG(IDOK,0), 0);
				DestroyWindow( m_hWndDlg );
				m_hWndDlg = NULL;
			}

			delete this;
		}

		static const CHAR * GetPageName( PageType page_type )
		{
			switch ( page_type )
			{
				case PAGE_SETTINGS:		return "Settings";
				case PAGE_DIRECTORIES:	return "Directories";
				case PAGE_PLUGINS:		return "Plugins";
				case PAGE_DEBUG:		return "Debug";
			}
			return "";
		}
};


#endif