/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#include "stdafx.h"

#include "Resources/resource.h"
#include "PageDialog.h"


#include "SettingsPage.h"
#include "DirectoriesPage.h"
#include "PluginsPage.h"
#include "DebugPage.h"





CPageDialog * CPageDialog::Create( HWND hWndParent, LONG x, LONG y, PageType page_type )
{
	CPageDialog * p_new = NULL;

	switch ( page_type )
	{
		case PAGE_SETTINGS:		p_new = new CSettingsPage(); break;
		case PAGE_DIRECTORIES:	p_new = new CDirectoriesPage(); break;
		case PAGE_PLUGINS:		p_new = new CPluginsPage(); break;
		case PAGE_DEBUG:		p_new = new CDebugPage(); break;
	}

	if ( p_new )
	{
		p_new->m_hWndDlg = CreateDialogParam( g_hInstance,
											  MAKEINTRESOURCE( p_new->GetResourceID() ),
											  hWndParent,
											  DialogProcStatic,
											  reinterpret_cast< LPARAM >( p_new ) );

		// Reposition and show
		SetWindowPos( p_new->m_hWndDlg, NULL, x, y, 0, 0, SWP_NOSIZE|SWP_NOZORDER|SWP_SHOWWINDOW);
		//ShowWindow( p_new->m_hWndDlg, SW_SHOWNORMAL );
		UpdateWindow( p_new->m_hWndDlg );
		InvalidateRect( p_new->m_hWndDlg, NULL, TRUE );
	}

	return p_new;
}