/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

#include "Utility/Unique.h"

// Declarations
class CMainWindow : public CUnique< CMainWindow >
{
	protected:
		HWND	m_hWnd;
		HWND	m_hWndStatus;

	public:
		virtual ~CMainWindow() {}

		virtual HRESULT CreateWnd(INT nWinMode) = 0;

		virtual HWND GetWindow() const { return m_hWnd; }
		virtual HWND GetStatusWindow() const { return m_hWndStatus; }

		virtual void __cdecl SetStatus(INT nPiece, LPCTSTR szFormat, ...) = 0;

		virtual void SelectSaveDir(HWND hWndParent) = 0;



		//
		// Window message handler
		//
		virtual LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) = 0;

		//
		// Utility functions
		//
		virtual LRESULT SendMessage(UINT msg, WPARAM wParam, LPARAM lParam)
		{
			return ::SendMessage( m_hWnd, msg, wParam, lParam);
		}
		virtual LRESULT PostMessage(UINT msg, WPARAM wParam, LPARAM lParam)
		{
			return ::PostMessage( m_hWnd, msg, wParam, lParam);
		}
		virtual MessageBox(LPCTSTR lpText, LPCTSTR lpCaption = g_szDaedalusName, UINT uType = MB_OK)
		{
			return ::MessageBox( m_hWnd, lpText, lpCaption, uType );
		}


		enum
		{
			MWM_STARTEMU = WM_USER+1,		// Start emulation	- disable list, grab focus
			MWM_ENDEMU						// Stop emulation - enable list
		};
};


#endif
