/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef __DIRECTORIESPAGEDIALOG_H__
#define __DIRECTORIESPAGEDIALOG_H__

#include "Debug/Dump.h"
#include "Utility/ResourceString.h"

class CDirectoriesPage : public CPageDialog
{
	protected:
		friend class CPageDialog;			// Only CPageDialog::Create() can create!

		CDirectoriesPage( )
		{
		}

	public:
		virtual ~CDirectoriesPage()
		{
		}

		CPageDialog::PageType GetPageType() const { return CPageDialog::PAGE_DIRECTORIES; }
		UINT GetResourceID() const { return IDD_PAGE_DIRECTORIES; }

		BOOL DialogProc( HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
		{
			switch (uMsg)
			{
				case WM_INITDIALOG:
					{
						// Init parameters

						HWND hWndRomsList = GetDlgItem( hWndDlg, IDC_ROM_DIRECTORY_LIST );

						ListBox_ResetContent( hWndRomsList );

						for ( u32 rd = 0; rd < g_CurrentConfig.nNumRomsDirs; rd++ )
						{
							ListBox_InsertString( hWndRomsList, -1, g_CurrentConfig.szRomsDirs[ rd ] );
						}

						Edit_SetText( GetDlgItem( hWndDlg, IDC_SAVE_DIR_EDIT ), g_CurrentConfig.szSaveDir );

						CHAR szDumpDir[ MAX_PATH + 1 ];
						Dump_GetDumpDirectory( szDumpDir, "" );
						Edit_SetText( GetDlgItem( hWndDlg, IDC_DUMPS_DIR_EDIT ), szDumpDir );
						return TRUE;
					}

				case WM_DESTROY:
					{
						// Set parameters (or set on change??)
					}
					return TRUE;


				case WM_COMMAND:
				{
					switch( LOWORD( wParam ) )
					{
						case IDC_ADD_ROMSDIR_BUTTON:
						{
							if ( g_CurrentConfig.nNumRomsDirs < DaedalusConfig::MAX_ROMS_DIRS )
							{
								if ( SelectDir( hWndDlg, g_CurrentConfig.szRomsDirs[ g_CurrentConfig.nNumRomsDirs ], CResourceString(IDS_SELECTFOLDER) ) )
								{
									g_CurrentConfig.nNumRomsDirs++;

									HWND hWndRomsList = GetDlgItem( hWndDlg, IDC_ROM_DIRECTORY_LIST );
									ListBox_ResetContent( hWndRomsList );

									for ( u32 rd = 0; rd < g_CurrentConfig.nNumRomsDirs; rd++ )
									{
										ListBox_InsertString( hWndRomsList, -1, g_CurrentConfig.szRomsDirs[ rd ] );
									}

								}
							}
						}
						return TRUE;

						case IDC_SELECT_SAVE_BUTTON:
						{
							SelectDir( hWndDlg, g_CurrentConfig.szSaveDir, CResourceString(IDS_SELECTSAVEFOLDER) );
						}
						return TRUE;
					}
				}
			}
			
			return FALSE;
		}



	protected:
		BOOL SelectDir( HWND hWndParent, CHAR * pszDirectory, const CHAR * pszPrompt )
		{
			BROWSEINFO bi;
			LPITEMIDLIST lpidl;
			TCHAR szDisplayName[MAX_PATH+1];

			bi.hwndOwner = hWndParent;
			bi.pidlRoot = NULL;
			bi.pszDisplayName = szDisplayName;
			bi.lpszTitle = pszPrompt;
			bi.ulFlags = BIF_RETURNONLYFSDIRS;
			bi.lpfn = NULL;
			bi.lParam = NULL;
			bi.iImage = 0;

			lpidl = SHBrowseForFolder(&bi);
			if (lpidl)
			{
				return SHGetPathFromIDList(lpidl, pszDirectory);
			}

			// None selected
			return FALSE;
		}

};

#endif // __DIRECTORIESPAGEDIALOG_H__