#define SR_STORE_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_STORE_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_STORE		//return FALSE;



BOOL SR_Emit_SW(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_STORE
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Save_B_S(dwBase, dwRT);
		
	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_SW);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;
		
		// We only optimise write using sp as the base (pushes onto the stack)
		// The reason for this is that other bases may point to hardware regs,
		// and so we may need to Update memory following the write
		if (dwBase == REG_sp && pCode->bSpCachedInESI)
		{
			// TODO - optimise for when dwRT is cached!
			LoadMIPSLo(pCode, EAX_CODE, dwRT);

			if (nOffset < 128 && nOffset > -128)
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using s16 offset");
				// Use s16 form:
				// mov dword ptr [esi + b], eax
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x40 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitBYTE((BYTE)nOffset);
			}
			else
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using long offset");
				// Use long form:
				// mov dword ptr [esi + nnnnnnnn], eax
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x80 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitDWORD((u32)nOffset);
			}
		}
		else
		{
			// This code is different from SWC1, because we want to call MemoryUpdate after
			// the call to update system registers, copy memory etc

			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 0, true, dwRT);
		}
	}
	
	return TRUE;
}





BOOL SR_Emit_SH(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_STORE
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Save_B_S(dwBase, dwRT);
	
	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_SH);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// TODO - Try and use cached base?
		// This is different from SW(), because for the most part we don't care about
		// Writes to system registers!

		SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 2, true);

		// EAX hold memory address to write to
		// Get value to write
		if (dwRT == 0)
		{
			DPF(DEBUG_DYNREC, "  ++ Using constant 0");
			pCode->XOR(EDX_CODE, EDX_CODE);
		}
		else
		{
			LoadMIPSLo(pCode, EDX_CODE, dwRT);
		}

		// mov word ptr [eax], dx
		pCode->EmitBYTE(0x66);
		pCode->EmitBYTE(0x89);
		pCode->EmitBYTE(0x10);

	}
	
	
	return TRUE;
}

BOOL SR_Emit_SB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_STORE
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Save_B_S(dwBase, dwRT);

	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_SB);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// TODO - Try and use cached base?
		// This is different from SW(), because for the most part we don't care about
		// Writes to system registers!
		
		SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 3, true);

		// EAX hold memory address to write to
		// Get value to write
		if (dwRT == 0)
		{
			DPF(DEBUG_DYNREC, "  ++ Using constant 0");
			pCode->XOR(EDX_CODE, EDX_CODE);
		}
		else
		{
			LoadMIPSLo(pCode, EDX_CODE, dwRT);
		}

		// mov byte ptr [eax], dl
		pCode->EmitBYTE(0x88);
		pCode->EmitBYTE(0x10);

	}
		
	return TRUE;
}




BOOL SR_Emit_SWC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_STORE
	const u32 dwBase = R4300_RS(dwOp);
	const u32 dwFT = R4300_FT(dwOp);

	pCode->Stat_Save_B(dwBase);
	pCode->Stat_Single_S(dwFT);
	
	if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_SWC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		/*
		DWORD dwAddress = (u32)((s32)g_qwGPR[dwBase] + (s32)wOffset);
		Write32Bits(dwAddress, LoadFPR_Word(dwFT));
		*/

		// Simulate SR_FP stuff
		SR_FP_SWC1(dwFT);


		// If the base is SP, and we have SP cached, use ESI instead:
		if (dwBase == REG_sp && pCode->bSpCachedInESI)
		{
			// Get value to write
			pCode->MOV_REG_MEM(EAX_CODE, &g_qwCPR[1][dwFT]);

			if (nOffset < 128 && nOffset > -128)
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using s16 offset");
				// Use s16 form:
				// mov dword ptr [esi + b], eax
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x40 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitBYTE((BYTE)nOffset);
			}
			else
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using long offset");
				// Use long form:
				// mov dword ptr [esi + nnnnnnnn], eax
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x80 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitDWORD((DWORD)nOffset);
			}				
		}
		else
		{
			// This is different from SW(), because for the most part we don't care about
			// Writes to system registers!
			
			// Get base (this could be cached!)
			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 0, true);

			// EAX hold memory address to write to
			// Get value to write
			pCode->MOV_REG_MEM(EDX_CODE, &g_qwCPR[1][dwFT]);

			// mov dword ptr [eax], edx
			pCode->EmitBYTE(0x89);
			pCode->EmitBYTE(0x00 | (EDX_CODE<<3));
		}

	}

	return TRUE;
}


BOOL SR_Emit_SDC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_STORE
	const u32 dwBase = R4300_RS(dwOp);
	const u32 dwFT = R4300_FT(dwOp);

	pCode->Stat_Save_B(dwBase);
	pCode->Stat_Double_S(dwFT);
	
	// By StrmnNrmn: Lkb: Can you check if the SR_Emit_ReadWriteAddress will handle 64bit reads?
	//if (SR_STORE_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_SDC1);
	}
	/*else
	{
		pCode->dwNumOptimised++;

		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		/*
		DWORD dwAddress = (u32)((s32)g_qwGPR[dwBase] + (s32)wOffset);
		Write32Bits(dwAddress, LoadFPR_Word(dwFT));
		* /

		// Simulate SR_FP stuff
		SR_FP_SDC1(dwFT);

		// If the base is SP, and we have SP cached, use ESI instead:
		if (dwBase == REG_sp && pCode->bSpCachedInESI)
		{
			// Get value to write
			// Note ordering is reversed EAX_CODE -> dwFT+1
			pCode->MOV_REG_MEM(EAX_CODE, &g_qwCPR[1][dwFT+1]);
			pCode->MOV_REG_MEM(EDX_CODE, &g_qwCPR[1][dwFT+0]);

			if (nOffset < (128-4) && nOffset > -128)
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using s16 offset");
				// Use s16 form:
				// mov dword ptr [esi + b], eax
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x40 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitBYTE((BYTE)nOffset);

				// mov dword ptr [esi + b], edx
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x40 | (EDX_CODE<<3) | ESI_CODE);
				pCode->EmitBYTE((BYTE)(nOffset+4));

			}
			else
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using long offset");
				// Use long form:
				// mov dword ptr [esi + nnnnnnnn], eax
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x80 | (EAX_CODE<<3) | (ESI_CODE));
				pCode->EmitDWORD((DWORD)nOffset);

				// mov dword ptr [esi + nnnnnnnn], edx
				pCode->EmitBYTE(0x89);
				pCode->EmitBYTE(0x80 | (EDX_CODE<<3) | (ESI_CODE));
				pCode->EmitDWORD((DWORD)(nOffset+4));
			}				
		}
		else
		{
			// This is different from SW(), because for the most part we don't care about
			// Writes to system registers!
			
			// Get base (this could be cached!)
			LoadMIPSLo(pCode, EAX_CODE, dwBase);

			// Add offset
			pCode->ADDI(EAX_CODE, nOffset);

			pCode->MOV(ECX_CODE, EAX_CODE);			// For fastcall

			// Get top bits (offset into table) in ECX
			pCode->SHRI(EAX_CODE, 18);

			// call dword ptr [g_WriteAddressLookupTable + eax*4]
			pCode->EmitBYTE(0xFF);
			pCode->EmitBYTE(0x14);
			pCode->EmitBYTE(0x85);
			pCode->EmitDWORD((DWORD)g_WriteAddressLookupTable);		// Won't work if g_WriteAddressLookupTable recreated

			// EAX hold memory address to write to
			// Get value to write
			pCode->MOV_REG_MEM(EDX_CODE, &g_qwCPR[1][dwFT+0]);
			pCode->MOV_REG_MEM(ECX_CODE, &g_qwCPR[1][dwFT+1]);

			// mov dword ptr [eax], ecx
			pCode->EmitBYTE(0x89);
			pCode->EmitBYTE(0x00 | (ECX_CODE<<3));

			// mov dword ptr [eax+4], edx
			pCode->EmitBYTE(0x89);
			pCode->EmitBYTE(0x40 | (EDX_CODE<<3));
			pCode->EmitBYTE(0x04);

		}

	}*/

	return TRUE;
}
