#define SR_COP1_D_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_COP1_D_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_COP1_D		//return FALSE;

BOOL SR_Emit_Cop1_D_ADD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S_S(dwFD, dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_ADD);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs+ft
		SR_FP_ADD(dwFD, dwFS, dwFT, FP_DOUBLE);
	}
	return TRUE;
}





BOOL SR_Emit_Cop1_D_SUB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S_S(dwFD, dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_SUB);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs-ft
		SR_FP_SUB(dwFD, dwFS, dwFT, FP_DOUBLE);
	}

	return TRUE;
}

BOOL SR_Emit_Cop1_D_MUL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S_S(dwFD, dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_MUL);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs*ft
		SR_FP_MUL(dwFD, dwFS, dwFT, FP_DOUBLE);
	}


	return TRUE;
}

BOOL SR_Emit_Cop1_D_DIV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S_S(dwFD, dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_DIV);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs/ft
		SR_FP_DIV(dwFD, dwFS, dwFT, FP_DOUBLE);
	}

	return TRUE;
}

BOOL SR_Emit_Cop1_D_SQRT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S(dwFD, dwFS);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_SQRT);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = sqrtf(fs)
		SR_FP_SQRT(dwFD, dwFS, FP_DOUBLE);
	}

	return TRUE;
}




BOOL SR_Emit_Cop1_D_ABS(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S(dwFD, dwFS);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_ABS);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_MOV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S(dwFD, dwFS);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_MOV);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs
		SR_FP_MOV(dwFD, dwFS, FP_DOUBLE);
	}

	return TRUE;
}

BOOL SR_Emit_Cop1_D_NEG(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_D_S(dwFD, dwFS);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_NEG);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = -fs
		SR_FP_NEG(dwFD, dwFS, FP_DOUBLE);
	}

	return TRUE;
}

BOOL SR_Emit_Cop1_D_ROUND_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_ROUND_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_TRUNC_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_TRUNC_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_CEIL_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_CEIL_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_FLOOR_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_FLOOR_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_ROUND_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_ROUND_W);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_TRUNC_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	//if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_TRUNC_W);
	}
	/*else
	{
		pCode->dwNumOptimised++;

		// TODO: This should really TRUNC
		// This does the same as R4300.cpp, but it's possibly wrong
		SR_FP_D_CVT_W(dwFD, dwFS);
	}*/


	return TRUE;
}

BOOL SR_Emit_Cop1_D_CEIL_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_CEIL_W);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_FLOOR_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_FLOOR_W);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_CVT_S(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Single_D(dwFD);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_CVT_S);
	}
	else
	{
		pCode->dwNumOptimised++;

		SR_FP_D_CVT_S(dwFD, dwFS);
	}

	return TRUE;
}

// TODO: There is a bug in SR_DP_D_CVT_W that causes the fades in mario to flash
BOOL SR_Emit_Cop1_D_CVT_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	//if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_CVT_W);
	}
	/*else
	{
		pCode->dwNumOptimised++;

		SR_FP_D_CVT_W(dwFD, dwFS);
	}*/

	return TRUE;
}

BOOL SR_Emit_Cop1_D_CVT_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Double_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_CVT_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_F(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_F);
	return TRUE;
}
BOOL SR_Emit_Cop1_D_UN(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_UN);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_EQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	
	pCode->Stat_Double_S_S(dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_EQ);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs <= ft?
		SR_FP_C(dwFS, dwFT, FLAG_C_EQ, FP_DOUBLE);
	}


	return TRUE;
}

BOOL SR_Emit_Cop1_D_UEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_UEQ);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_OLT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_OLT);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_ULT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_ULT);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_OLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_OLE);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_ULE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_ULE);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_SF(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_SF);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_NGLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_NGLE);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_SEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_SEQ);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_NGL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_NGL);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_LT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	
	pCode->Stat_Double_S_S(dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_LT);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs < ft?
		SR_FP_C(dwFS, dwFT, FLAG_C_LT, FP_DOUBLE);
	}

	return TRUE;
}

BOOL SR_Emit_Cop1_D_NGE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_NGE);
	return TRUE;
}

BOOL SR_Emit_Cop1_D_LE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	
	pCode->Stat_Double_S_S(dwFS, dwFT);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_LE);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs <= ft?
		SR_FP_C(dwFS, dwFT, FLAG_C_LE, FP_DOUBLE);
	}


	return TRUE;
}

BOOL SR_Emit_Cop1_D_NGT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	pCode->Stat_Double_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_D_NGT);
	return TRUE;
}






// Notice source is Word, dest is double!
BOOL SR_Emit_Cop1_W_CVT_D(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_D
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	//pCode->Stat_Word_S(dwFS);
	//pCode->Stat_Double_D(dwFD);
	pCode->Stat_Double_D_S(dwFD, dwFS);

	if (SR_COP1_D_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_W_CVT_D);
	}
	else
	{
		pCode->dwNumOptimised++;

		SR_FP_W_CVT_D(dwFD, dwFS);

	}
	return TRUE;
}