/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __ASM_H__
#define __ASM_H__

// Get the lo and high half indices for MIPS registers
#define lohalf(x)		(x*2 + 0)
#define hihalf(x)		(x*2 + 1)

// Emulated regs 0..31 here


// Some more friendly macros:
#define SetVar32(VarName, Value) \
	pCode->EmitWORD(0x05c7); pCode->EmitDWORD((DWORD)&VarName); pCode->EmitDWORD(Value);


#define MOVSX(reg1, reg2)		pCode->EmitWORD(0xbf0f); pCode->EmitBYTE((0xc0 | (reg1<<3) | reg2))



//#define CDQ			pCode->EmitBYTE(0x99)		//cdq						// 99	



#define FILD_MEM(pCode, mem)  { pCode->EmitWORD(0x05db);} \
						      pCode->EmitDWORD((DWORD)(mem))


//////////////////////////////////////
#define FLD_MEMp32(pCode, mem)  { pCode->EmitWORD(0x05d9);} \
						      pCode->EmitDWORD((DWORD)(mem))

#define FSTP_MEMp32(pCode, mem) { pCode->EmitWORD( 0x1dd9);} \
						      pCode->EmitDWORD((DWORD)(mem))


// 
static s64 longtemp;

#define FLD_MEMp64(pCode, memlo, memhi)  {					\
	pCode->MOV_REG_MEM(EAX_CODE, (BYTE*)(memlo));					\
	pCode->MOV_REG_MEM(EDX_CODE, (BYTE*)(memhi));					\
	pCode->MOV_MEM_REG(((BYTE*)&longtemp) + 0, EAX_CODE);			\
	pCode->MOV_MEM_REG(((BYTE*)&longtemp) + 4, EDX_CODE);			\
	pCode->EmitWORD(0x05dd);								\
	pCode->EmitDWORD((DWORD)(&longtemp));					\
}



// return (g_qwCPR[1][dwReg+1]<<32) | (g_qwCPR[1][dwReg+0]&0xFFFFFFFF);


#define FSTP_MEMp64(pCode, memlo, memhi) {					\
	pCode->EmitWORD(0x1ddd);								\
	pCode->EmitDWORD((DWORD)(&longtemp));					\
	pCode->MOV_REG_MEM(EAX_CODE, ((BYTE*)(&longtemp))+0);			\
	pCode->MOV_REG_MEM(EDX_CODE, ((BYTE*)(&longtemp))+4);			\
	pCode->MOV_MEM_REG(((BYTE*)(memlo)), EAX_CODE);				\
	pCode->MOV_MEM_REG(((BYTE*)(memhi)), EDX_CODE);				\
}



#define FISTP_MEMp(pCode, mem) { pCode->EmitWORD( 0x1ddb);} \
						         pCode->EmitDWORD((DWORD)(mem))


#define FLD(pCode, i)	pCode->EmitWORD((WORD)((0xc0 + (i))<<8) |(0xd9)); 


#define FXCH(pCode, i)	pCode->EmitWORD((WORD)((0xc8 + (i))<<8) |(0xd9)); 

#define FCOMP(pCode, i)	pCode->EmitWORD((WORD)((0xd8 + (i))<<8) |(0xd8)); 


//fnstsw      ax
#define FNSTSW(pCode) pCode->EmitWORD(0xe0df);

#define FFREE(pCode, i)	pCode->EmitWORD((WORD)((0xc0 + (i))<<8) |(0xdd)); 
#define FINCSTP(pCode) pCode->EmitWORD(0xf7d9);
#define FSQRTp(pCode) pCode->EmitWORD(0xfad9);
#define FCHSp(pCode) pCode->EmitWORD(0xe0d9);

// fadd st(0),st(i)
#define FADD(pCode, i)	pCode->EmitWORD((WORD)((0xc0 + (i))<<8) |(0xd8)); 

// fsub st(0),st(i)
#define FSUB(pCode, i)	pCode->EmitWORD((WORD)((0xe0 + (i))<<8) |(0xd8)); 

// fmul st(0),st(i)
#define FMUL(pCode, i)	pCode->EmitWORD((WORD)((0xc8 + (i))<<8) |(0xd8)); 

// fdiv st(0),st(i)
#define FDIV(pCode, i)	pCode->EmitWORD((WORD)((0xf0 + (i))<<8) |(0xd8)); 





#endif
