/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __DEBUG_H__
#define __DEBUG_H__


#ifdef DAEDALUS_LOG

enum DebugFlags
{
	DEBUG_PI =				 1<<1,
	DEBUG_SP =				 2<<1,
	DEBUG_DP =				 3<<1,
	DEBUG_MI =				 4<<1,
	DEBUG_SI =				 5<<1,
	DEBUG_VI =				 6<<1,
	DEBUG_AI =				 7<<1,

	DEBUG_MEMORY =			 8<<1,
	DEBUG_TLB =				 9<<1,

	DEBUG_INTR =			 10<<1,

	DEBUG_REGS =			 11<<1,

	DEBUG_MEMORY_RDRAM_REG = 13<<1,
	DEBUG_MEMORY_SP_DMEM =	 14<<1,
	DEBUG_MEMORY_SP_IMEM =	 15<<1,
	DEBUG_MEMORY_SP_REG =	 16<<1,
	DEBUG_MEMORY_MI =		 17<<1,
	DEBUG_MEMORY_VI =		 18<<1,
	DEBUG_MEMORY_AI =		 19<<1,
	DEBUG_MEMORY_RI =		 20<<1,
	DEBUG_MEMORY_SI =		 21<<1,
	DEBUG_MEMORY_PI =		 22<<1,
	DEBUG_MEMORY_PIF =		 23<<1,
	DEBUG_MEMORY_DP =		 24<<1,

	DEBUG_DYNREC =			 25<<1,
	DEBUG_OS =				 26<<1,

	DEBUG_DP_AUD =			 27<<1,
	DEBUG_DP_GFX =			 28<<1
};

extern BOOL  g_bLog;

HRESULT Debug_InitLogging();
void Debug_FinishLogging();
void __cdecl Debug_Printf(DWORD dwDebugLevel, LPCTSTR szFormat, ...);


#define DPF Debug_Printf 


     
#else		// DAEDALUS_LOGGING not defined


//#define DPF 1 ? (void)0 : (void)

#if _MSC_VER >= 1300
#define DL_PF __noop
#else
inline void DPF_Noop() {}
// avoid warning C4002: too many actual parameters for macro 'DPF'
#define DPF(x) DPF_Noop()
#pragma warning(disable : 4002) 
#endif


#endif // DAEDALUS_LOG


//
// General purpose functions used by all releases
//
HANDLE Debug_CreateDumpFile(LPCTSTR szFileName);
void Debug_CloseDumpFile(HANDLE & hFile);
void Debug_DumpLine(HANDLE hFile, LPCTSTR szFormat, va_list va);

#endif // End DEBUG_H


