// Unique.h: interface for the CUnique class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_UNIQUE_H__D8AABD48_DF5B_401F_A467_7DCF3472CCCA__INCLUDED_)
#define AFX_UNIQUE_H__D8AABD48_DF5B_401F_A467_7DCF3472CCCA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//
// CUnique is an abstract base class for classes where only one
// instance exists throughout the execution of the program
// Typical usuage is:
//
// CMyUniqueClass::Create();
// ..
// CMyUniqueClass::Get()->DoSomething();
// etc
// ..
// CMyUniqueClass::Destroy();
//
//

#ifdef _MSC_VER
#include <crtdbg.h>
#endif

template < class T > class CUnique  
{
protected:
	static T * m_pInstance;
public:
	//CUnique();
	virtual ~CUnique() {}

	static T * Get();
	static HRESULT Create();
	static void Destroy();
	static bool IsAvailable();
};

template < class T > T * CUnique< T >::m_pInstance = NULL;


template < class T > bool CUnique< T >::IsAvailable()
{
	return (m_pInstance != NULL);
}

template < class T > void CUnique< T >::Destroy()
{
	_ASSERT(m_pInstance != NULL);
	
	delete m_pInstance;
	m_pInstance = NULL;
}

template < class T > T * CUnique< T >::Get()
{
	_ASSERT(m_pInstance != NULL);
	
	return m_pInstance;
}

#endif // !defined(AFX_UNIQUE_H__D8AABD48_DF5B_401F_A467_7DCF3472CCCA__INCLUDED_)
