// Profiler.cpp: implementation of the CProfiler class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Profiler.h"
#ifdef _MSC_VER
#include <crtdbg.h>
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////



HRESULT CUnique< CProfiler >::Create()
{
	HRESULT hr;
	
	CProfiler * pNewInstance;
	
	_ASSERTE(m_pInstance == NULL);
	
	pNewInstance = new CProfiler();
	if (!pNewInstance)
		hr = E_OUTOFMEMORY;
	else
		hr = S_OK;
	
	m_pInstance = pNewInstance;
	return hr;
};

const CProfiler::ProfileInfo CProfiler::s_ItemInfo[ NUM_PROFILE_ITEMS ] =
{
	{ PROFILE_FRAME,		PROFILE_FRAME,		"Frame" },
	{ PROFILE_GFX,			PROFILE_FRAME,		"Graphics" },
	{ PROFILE_AUD,			PROFILE_FRAME,		"Audio" },
	{ PROFILE_DYNAREC,		PROFILE_FRAME,		"Dynarec" },
	{ PROFILE_GFX_TCACHE,	PROFILE_GFX,		"Gfx: TCache" },
	{ PROFILE_GFX_CONVERT,	PROFILE_GFX,		"Gfx: Convert" },
	{ PROFILE_GFX_COMBINER, PROFILE_GFX,		"Gfx: Combine" }

};