/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __CONFIGHANDLER_H__
#define __CONFIGHANDLER_H__


class ConfigHandler {
public:

	ConfigHandler(TCHAR *szSectionName);
	~ConfigHandler();

	void SetSection(TCHAR *szNewSection) { strcpy(m_szSectionName, szNewSection); };

	void WriteValue(TCHAR *szKeyName, DWORD nValue) {WriteValue(szKeyName, nValue, -1);};
	void WriteValue(TCHAR *szKeyName, DWORD nValue, LONG nNumber);

	void WriteString(TCHAR *szKeyName, TCHAR *szValue) {WriteString(szKeyName, szValue, -1);};
	void WriteString(TCHAR *szKeyName, TCHAR *szValue, LONG nNumber);

	void ReadValue(TCHAR *szKeyName, DWORD *nValue, DWORD nDefault);
	void ReadValue(TCHAR *szKeyName, DWORD *nValue, DWORD nDefault, DWORD nMin, DWORD nMax);
	void ReadValue(TCHAR *szKeyName, DWORD *nValue, DWORD nDefault, DWORD nMin, DWORD nMax, LONG nNumber);

	void ReadString(TCHAR *szKeyName, TCHAR *szOutBuffer, DWORD nOutSize, TCHAR *szDefaultBuffer);
	void ReadString(TCHAR *szKeyName, TCHAR *szOutBuffer, DWORD nOutSize, TCHAR *szDefaultBuffer, LONG nNumber);

private:
	void WriteRegValue(TCHAR *szKeyName, DWORD nValue);
	void WriteRegString(TCHAR *szKeyName, TCHAR *szValueBuffer);

	DWORD ReadRegValue(TCHAR *szKeyName, DWORD nDefault);
	DWORD ReadRegString(TCHAR *szKeyName, TCHAR *szOutBuffer, DWORD nOutSize);
private:
	TCHAR m_szSectionName[300];

};

#endif //__CONFIGHANDLER_H__
