// AudioPlugin.h: interface for the CAudioPlugin class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_AUDIOPLUGIN_H__84536ECC_B5BF_4FA5_9009_6BB07775A1FA__INCLUDED_)
#define AFX_AUDIOPLUGIN_H__84536ECC_B5BF_4FA5_9009_6BB07775A1FA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AudioPlugin_Spec.h"
#include "Utility/CritSect.h"
#include "Debug/DBGConsole.h"

#define PLUGIN_SPEC_CALL		__cdecl


#define AI_LOCK		Lock();
#define AI_UNLOCK	Unlock();

#define AI_TRY		try
#define AI_CATCH	catch(...)								\
		{													\
				DBGConsole_Msg(0, "Exception in [C%s]", szModuleName);	\
				Close();									\
		}


class CAudioPlugin : protected CCritSect
{
public:
	CAudioPlugin(LPCTSTR szDllName);
	virtual ~CAudioPlugin();

public:
	void DacrateChanged(int nSystemType)
	{
		AI_LOCK
		if (pDacrateChanged)
		{
			AI_TRY { pDacrateChanged(nSystemType); }
			AI_CATCH
		}
		AI_UNLOCK
	}
	void LenChanged()
	{
		AI_LOCK
		if (pLenChanged)
		{
			AI_TRY { pLenChanged(); }
			AI_CATCH
		}
		AI_UNLOCK
	}

	DWORD ReadLength()
	{
		DWORD dwLen = 0;

		AI_LOCK
		if (pReadLength)
		{
			AI_TRY { dwLen = pReadLength(); }
			AI_CATCH
		}
		AI_UNLOCK
		return dwLen;
	}

	void Update(BOOL bWait)
	{
		AI_LOCK
		if (pUpdate)
		{
			AI_TRY { pUpdate(bWait); }
			AI_CATCH
		}
		AI_UNLOCK
	}

	void DllAbout(HWND hWndParent)
	{
		AI_LOCK
		if (pDllAbout)
		{
			AI_TRY { pDllAbout(hWndParent); }
			AI_CATCH
		}
		AI_UNLOCK
	}


	void DllConfig(HWND hWndParent)
	{
		AI_LOCK
		if (pDllConfig)
		{
			AI_TRY { pDllConfig(hWndParent); }
			AI_CATCH
		}
		AI_UNLOCK
	}

	void DllTest(HWND hWndParent)
	{
		AI_LOCK
		if (pDllTest)
		{
			AI_TRY { pDllTest(hWndParent); }
			AI_CATCH
		}
		AI_UNLOCK
	}


	void GetDllInfo(PLUGIN_INFO * p)
	{
		AI_LOCK
		if (pGetDllInfo)
		{
			AI_TRY { pGetDllInfo(p); }
			AI_CATCH
		}
		AI_UNLOCK
	}

	BOOL InitiateAudio(AUDIO_INFO ai)
	{
		BOOL bInit = FALSE;

		AI_LOCK
		if (pInitiateAudio)
		{
			AI_TRY { bInit = pInitiateAudio(ai); }
			AI_CATCH
		}
		AI_UNLOCK
	
		return bInit;
	}

	void ProcessAList(void)
	{
		AI_LOCK
		if (pProcessAList)
		{
			AI_TRY { pProcessAList(); }
			AI_CATCH
		}
		AI_UNLOCK
	}
	void RomClosed(void)
	{
		AI_LOCK
		if (pRomClosed)
		{
			AI_TRY { pRomClosed(); }
			AI_CATCH
		}
		AI_UNLOCK
	}

	BOOL LoadedOk()
	{
		return bLoadedOk;
	}

	// szName must be 100 chars
	void GetPluginName(LPSTR szName)
	{
		if (!bLoadedOk)
			lstrcpy(szName, "?");
		else
			lstrcpy(szName, pi.Name);

	}

	BOOL ReInit()
	{
		AI_LOCK
		Close();
		if (Open())
			return Init();

		return FALSE;
		AI_UNLOCK
	}

	BOOL Open();
	BOOL Init();

	void Close();

	void CloseDll()
	{
		AI_LOCK
		if (pCloseDll)
		{
			AI_TRY { pCloseDll(); }
			AI_CATCH
		}
		AI_UNLOCK
	}


protected:
	void   (PLUGIN_SPEC_CALL * pDacrateChanged)(int);
	void   (PLUGIN_SPEC_CALL * pLenChanged)(void);
	DWORD  (PLUGIN_SPEC_CALL * pReadLength)(void);
	void   (PLUGIN_SPEC_CALL * pUpdate)(BOOL);
	void   (PLUGIN_SPEC_CALL * pCloseDll)();
	void   (PLUGIN_SPEC_CALL * pDllAbout)(HWND);
	void   (PLUGIN_SPEC_CALL * pDllConfig)(HWND);
	void   (PLUGIN_SPEC_CALL * pDllTest)(HWND);
	void   (PLUGIN_SPEC_CALL * pGetDllInfo)(PLUGIN_INFO *);
	BOOL   (PLUGIN_SPEC_CALL * pInitiateAudio)(AUDIO_INFO);
	void   (PLUGIN_SPEC_CALL * pProcessAList)(void);
	void   (PLUGIN_SPEC_CALL * pRomClosed)(void);

	HINSTANCE hModule;
	PLUGIN_INFO pi;
	BOOL bLoadedOk;
	TCHAR szModuleName[MAX_PATH+1];

};

#endif // !defined(AFX_AUDIOPLUGIN_H__84536ECC_B5BF_4FA5_9009_6BB07775A1FA__INCLUDED_)
