// AudioPlugin.cpp: implementation of the CAudioPlugin class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AudioPlugin.h"

#include "Core/CPU.h"
#include "Core/Memory.h"
#include "Core/ROM.h"
#include "Interface/MainWindow.h"

#define AI_REG_ADDRESS(reg)		\
	&((DWORD *)g_pMemoryBuffers[MEM_AI_REG])[(reg - AI_BASE_REG) / 4]

#define MI_REG_ADDRESS(reg)		\
	&((DWORD *)g_pMemoryBuffers[MEM_MI_REG])[(reg - MI_BASE_REG) / 4]





//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAudioPlugin::CAudioPlugin(LPCTSTR szDllName) :
	pDacrateChanged(NULL),
	pLenChanged(NULL),
	pReadLength(NULL),
	pUpdate(NULL),
	pCloseDll(NULL),
	pDllAbout(NULL),
	pDllConfig(NULL),
	pDllTest(NULL),
	pGetDllInfo(NULL),
	pInitiateAudio(NULL),
	pProcessAList(NULL),
	pRomClosed(NULL),
	hModule(NULL),
	bLoadedOk(FALSE)

{
	lstrcpyn(szModuleName, szDllName, MAX_PATH);
}


static void __cdecl CheckInterrupts(void)
{
	//DBGConsole_Msg(0, "AI Plugin called Check Interrupts");

	// Or check postponed?
	AddCPUJob(CPU_CHECK_INTERRUPTS);
}


CAudioPlugin::~CAudioPlugin()
{
	Close();
}


BOOL CAudioPlugin::Open()
{
	hModule = LoadLibrary(szModuleName);
	if (hModule == NULL)
		return FALSE;


	pGetDllInfo = (void (PLUGIN_SPEC_CALL *)(PLUGIN_INFO *))GetProcAddress(hModule, "GetDllInfo");
	if (pGetDllInfo == NULL)
		return FALSE;

	pGetDllInfo(&pi);
	if (pi.Type != PLUGIN_TYPE_AUDIO)
	{
		return FALSE;
	}

    pDacrateChanged = (void   (PLUGIN_SPEC_CALL * )(int))GetProcAddress(hModule, "AiDacrateChanged");
    pLenChanged     = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "AiLenChanged");
    pReadLength     = (DWORD  (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "AiReadLength");
    pUpdate         = (void   (PLUGIN_SPEC_CALL * )(BOOL))GetProcAddress(hModule, "AiUpdate");
    pCloseDll       = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "CloseDLL");
    pDllAbout       = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllAbout");
    pDllConfig      = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllConfig");
    pDllTest        = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllTest");
    pInitiateAudio  = (BOOL   (PLUGIN_SPEC_CALL * )(AUDIO_INFO))GetProcAddress(hModule, "InitiateAudio");
    pProcessAList   = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "ProcessAList");
    pRomClosed      = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "RomClosed");

	bLoadedOk = TRUE;

	return TRUE;

}

void CAudioPlugin::Close()
{
	bLoadedOk = FALSE;


	if (hModule != NULL)
	{
		//CloseDll();
		FreeLibrary(hModule);
	}

	pDacrateChanged = NULL;
	pLenChanged = NULL;
	pReadLength = NULL;
	pUpdate = NULL;
	pCloseDll = NULL;
	pDllAbout = NULL;
	pDllConfig = NULL;
	pDllTest = NULL;
	pGetDllInfo = NULL;
	pInitiateAudio = NULL;
	pProcessAList = NULL;
	pRomClosed = NULL;
	hModule = NULL;
}




BOOL CAudioPlugin::Init()
{
	AUDIO_INFO ai;

	ai.hwnd = CMainWindow::Get()->GetWindow();
	ai.hinst = g_hInstance;
	ai.MemoryBswaped = TRUE;
	ai.HEADER = (BYTE*)&g_ROM.rh;
	ai.RDRAM = (BYTE*)g_pMemoryBuffers[MEM_RD_RAM];
	ai.DMEM = (BYTE*)g_pMemoryBuffers[MEM_SP_MEM] + SP_DMA_DMEM;
	ai.IMEM = (BYTE*)g_pMemoryBuffers[MEM_SP_MEM] + SP_DMA_IMEM;

	ai.xMI_INTR_REG = MI_REG_ADDRESS(MI_INTR_REG);
	ai.xAI_DRAM_ADDR_REG = AI_REG_ADDRESS(AI_DRAM_ADDR_REG); 
	ai.xAI_LEN_REG = AI_REG_ADDRESS(AI_LEN_REG); 
	ai.xAI_CONTROL_REG = AI_REG_ADDRESS(AI_CONTROL_REG); 
	ai.xAI_STATUS_REG = AI_REG_ADDRESS(AI_STATUS_REG); 
	ai.xAI_DACRATE_REG = AI_REG_ADDRESS(AI_DACRATE_REG); 
	ai.xAI_BITRATE_REG = AI_REG_ADDRESS(AI_BITRATE_REG); 

	ai.CheckInterrupts = CheckInterrupts;

	BOOL bAudio = InitiateAudio(ai);
	if (!bAudio)
	{
		DBGConsole_Msg(0, "Unable to initialise audio plugin");
		return FALSE;
	}
	else
	{	
		DBGConsole_Msg(0, "Audio plugin initialised ok");
		return TRUE;
	}

	RomClosed();

}

