/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "Resources/resource.h"
#include "Utility/ResourceString.h"
#include "RomSettingsDialog.h"
#include "Debug/DBGConsole.h"
#include "IniFile.h"

static BOOL CALLBACK RomSettingsDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static BOOL RomSettingsDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);
static void RomSettingsDialog_UpdateEntry(HWND hWndDlg);

static void RomSettingsDialog_FillCommentCombo(HWND hWndDlg);

static LPROMINFO s_pRomInfo = NULL;


void RomSettingsDialog_DoModal(HWND hWndParent, LPROMINFO pRomInfo)
{
	s_pRomInfo = pRomInfo;
	DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_ROMSETTINGS), hWndParent, RomSettingsDialogProc);

}

#define CheckBox_GetCheck(hwnd)			SendMessage(hwnd, BM_GETCHECK, 0,0)
#define CheckBox_SetCheck(hwnd, state)	SendMessage(hwnd, BM_SETCHECK, (WPARAM)state,0)


BOOL CALLBACK RomSettingsDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_INITDIALOG:
		return RomSettingsDialog_OnInitDialog(hWndDlg, wParam, lParam);

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_EEPROM_CHECK:

			if (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_EEPROM_CHECK)) == BST_CHECKED)
			{
				EnableWindow(GetDlgItem(hWndDlg, IDC_SIZE_STATIC), TRUE);
				EnableWindow(GetDlgItem(hWndDlg, IDC_EEPROMSIZE_EDIT), TRUE);
			}
			else
			{
				EnableWindow(GetDlgItem(hWndDlg, IDC_SIZE_STATIC), FALSE);
				EnableWindow(GetDlgItem(hWndDlg, IDC_EEPROMSIZE_EDIT), FALSE);
			}

			return TRUE;

		case IDOK:
			RomSettingsDialog_UpdateEntry(hWndDlg);

			EndDialog(hWndDlg, IDOK);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWndDlg, IDCANCEL);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		// Free any plugins that were found
		return TRUE;

	}


	return FALSE;
}

BOOL RomSettingsDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{
	RomSettingsDialog_FillCommentCombo(hWndDlg);

	// Initialise the controls
	SetDlgItemText(hWndDlg, IDC_NAME_EDIT, s_pRomInfo->szGameName);
	// Comment initialised by RomSettingsDialog_FillCommentCombo()
	SetDlgItemText(hWndDlg, IDC_COMMENT2_EDIT, s_pRomInfo->szInfo);

	SetDlgItemInt(hWndDlg, IDC_UCODE_EDIT, s_pRomInfo->ucode, FALSE);

	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_DISABLE_TEXCRC_CHECK), s_pRomInfo->bDisableTextureCRC ? BST_CHECKED : BST_UNCHECKED);
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_DISABLE_DYNAREC_CHECK), s_pRomInfo->bDisableDynarec ? BST_CHECKED : BST_UNCHECKED);
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_DISABLE_SPEEDSYNC_CHECK), s_pRomInfo->bDisableSpeedSync ? BST_CHECKED : BST_UNCHECKED);
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_EXPANSIONPAK_CHECK), s_pRomInfo->bExpansionPak ? BST_CHECKED : BST_UNCHECKED);

	// OS HLE

	SetDlgItemInt(hWndDlg, IDC_RESCAN_EDIT, s_pRomInfo->dwRescanCount, FALSE);
	if (s_pRomInfo->bDisablePatches)
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_OSHLE_CHECK), BST_UNCHECKED);
		EnableWindow(GetDlgItem(hWndDlg, IDC_RESCAN1_STATIC), FALSE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_RESCAN2_STATIC), FALSE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_RESCAN_EDIT), FALSE);

	}
	else
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_OSHLE_CHECK), BST_CHECKED);
		EnableWindow(GetDlgItem(hWndDlg, IDC_RESCAN1_STATIC), TRUE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_RESCAN2_STATIC), TRUE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_RESCAN_EDIT), TRUE);

	}



	// Eeprom stuff:
	SetDlgItemInt(hWndDlg, IDC_EEPROMSIZE_EDIT, s_pRomInfo->dwEepromSize, FALSE);
	if (s_pRomInfo->bDisableEeprom)
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_EEPROM_CHECK), BST_UNCHECKED);
		EnableWindow(GetDlgItem(hWndDlg, IDC_SIZE_STATIC), FALSE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_EEPROMSIZE_EDIT), FALSE);
	}
	else
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_EEPROM_CHECK), BST_CHECKED);
		EnableWindow(GetDlgItem(hWndDlg, IDC_SIZE_STATIC), TRUE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_EEPROMSIZE_EDIT), TRUE);
	}



	SetFocus(GetDlgItem(hWndDlg, IDC_NAME_EDIT));

	// We set the focus, return false
	return FALSE;
}

enum 
{
	COMMENT_BLANK = 0,
	COMMENT_PLAYABLE = 1,
	COMMENT_ALMOSTPLAYABLE = 2,
	COMMENT_NOTPLAYABLE = 3, 
	COMMENT_DOESNTWORK = 4
};

LONG RomSettingsDialog_GetCommentType(LPCTSTR szComment)
{
	// NB: Don't use resource strings, as they might be in a different
	// language. Use the English defaults
	if (lstrcmp(szComment, TEXT("Playable")) == 0)
		return COMMENT_PLAYABLE;

	if (lstrcmp(szComment, TEXT("Almost Playable")) == 0)
		return COMMENT_ALMOSTPLAYABLE;

	if (lstrcmp(szComment, TEXT("Not Playable")) == 0)
		return COMMENT_NOTPLAYABLE;

	if (lstrcmp(szComment, TEXT("Doesn't Work")) == 0)
		return COMMENT_DOESNTWORK;

	return COMMENT_BLANK;
}

void RomSettingsDialog_FillCommentCombo(HWND hWndDlg)
{
	HWND hWndCombo;
	LONG nIndex;
	LONG nDefault;
	LONG nType;

	hWndCombo = GetDlgItem(hWndDlg, IDC_COMMENT_COMBO);

	ComboBox_ResetContent(hWndCombo);

	nType = RomSettingsDialog_GetCommentType(s_pRomInfo->szComment);

	nIndex = ComboBox_InsertString(hWndCombo, -1, TEXT(""));
	ComboBox_SetItemData(hWndCombo, nIndex, COMMENT_BLANK);

	// Set the default to blank (assuming none of the others match below)
	nDefault = nIndex;

	nIndex = ComboBox_InsertString(hWndCombo, -1, CResourceString(IDS_PLAYABLE));
	ComboBox_SetItemData(hWndCombo, nIndex, COMMENT_PLAYABLE);
	if (nType == COMMENT_PLAYABLE)
		nDefault = nIndex;

	nIndex = ComboBox_InsertString(hWndCombo, -1, CResourceString(IDS_ALMOSTPLAYABLE));
	ComboBox_SetItemData(hWndCombo, nIndex, COMMENT_ALMOSTPLAYABLE);
	if (nType == COMMENT_ALMOSTPLAYABLE)
		nDefault = nIndex;

	nIndex = ComboBox_InsertString(hWndCombo, -1, CResourceString(IDS_NOTPLAYABLE));
	ComboBox_SetItemData(hWndCombo, nIndex, COMMENT_NOTPLAYABLE);
	if (nType == COMMENT_NOTPLAYABLE)
		nDefault = nIndex;

	nIndex = ComboBox_InsertString(hWndCombo, -1, CResourceString(IDS_DOESNTWORK));
	ComboBox_SetItemData(hWndCombo, nIndex, COMMENT_DOESNTWORK);
	if (nType == COMMENT_DOESNTWORK)
		nDefault = nIndex;


	ComboBox_SetCurSel(hWndCombo, nDefault);


}

void RomSettingsDialog_UpdateEntry(HWND hWndDlg)
{
	LONG i;
	LONG val;
	BOOL bSuccess;
	LONG nSelComment;
	LONG nType;


	// Find out which entry we want to modify
	i = IniFile::Get()->FindEntry(s_pRomInfo->rh.dwCRC1,
							  s_pRomInfo->rh.dwCRC2,
							  s_pRomInfo->rh.nCountryID,
							  s_pRomInfo->szGameName);

	// Get comment string
	nSelComment =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_COMMENT_COMBO));
	if (nSelComment != CB_ERR)
	{
		nType = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_COMMENT_COMBO), nSelComment);

		// NB: Copy English text strings - don't use resource defaults
		switch (nType)
		{
		case COMMENT_BLANK: lstrcpy(s_pRomInfo->szComment, TEXT("")); break;
		case COMMENT_PLAYABLE: lstrcpy(s_pRomInfo->szComment, TEXT("Playable")); break;
		case COMMENT_ALMOSTPLAYABLE: lstrcpy(s_pRomInfo->szComment, TEXT("Almost Playable")); break;
		case COMMENT_NOTPLAYABLE: lstrcpy(s_pRomInfo->szComment, TEXT("Not Playable")); break;
		case COMMENT_DOESNTWORK: lstrcpy(s_pRomInfo->szComment, TEXT("Doesn't Work")); break;
		// default?
		}
	}

	// Copy fields across
	GetDlgItemText(hWndDlg, IDC_NAME_EDIT, s_pRomInfo->szGameName, sizeof(s_pRomInfo->szGameName));
	// Comment done above
	GetDlgItemText(hWndDlg, IDC_COMMENT2_EDIT, s_pRomInfo->szInfo, sizeof(s_pRomInfo->szInfo));

	val = GetDlgItemInt(hWndDlg, IDC_UCODE_EDIT, &bSuccess, FALSE);
	if (bSuccess)
		s_pRomInfo->ucode = val;

	val = GetDlgItemInt(hWndDlg, IDC_EEPROMSIZE_EDIT, &bSuccess, FALSE);
	if (bSuccess)
		s_pRomInfo->dwEepromSize = val;

	val = GetDlgItemInt(hWndDlg, IDC_RESCAN_EDIT, &bSuccess, FALSE);
	if (bSuccess)
		s_pRomInfo->dwRescanCount = val;


	if (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_OSHLE_CHECK)) == BST_CHECKED)
		s_pRomInfo->bDisablePatches = FALSE;
	else
		s_pRomInfo->bDisablePatches = TRUE;


	if (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_EEPROM_CHECK)) == BST_CHECKED)
		s_pRomInfo->bDisableEeprom = FALSE;
	else
		s_pRomInfo->bDisableEeprom = TRUE;


	s_pRomInfo->bDisableTextureCRC = (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_DISABLE_TEXCRC_CHECK)) == BST_CHECKED);
	s_pRomInfo->bDisableDynarec = (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_DISABLE_DYNAREC_CHECK)) == BST_CHECKED);
	s_pRomInfo->bDisableSpeedSync = (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_DISABLE_SPEEDSYNC_CHECK)) == BST_CHECKED);
	s_pRomInfo->bExpansionPak = (CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_EXPANSIONPAK_CHECK)) == BST_CHECKED);

	// Update inifile values
	lstrcpyn(IniFile::Get()->sections[i].name, s_pRomInfo->szGameName, sizeof(IniFile::Get()->sections[i].name));
	lstrcpyn(IniFile::Get()->sections[i].comment, s_pRomInfo->szComment, sizeof(IniFile::Get()->sections[i].comment));
	lstrcpyn(IniFile::Get()->sections[i].info, s_pRomInfo->szInfo, sizeof(IniFile::Get()->sections[i].info));

	IniFile::Get()->sections[i].ucode = s_pRomInfo->ucode;
	IniFile::Get()->sections[i].bDisableTextureCRC = s_pRomInfo->bDisableTextureCRC;
	IniFile::Get()->sections[i].bDisableDynarec = s_pRomInfo->bDisableDynarec;
	IniFile::Get()->sections[i].bDisablePatches = s_pRomInfo->bDisablePatches;
	IniFile::Get()->sections[i].bDisableSpeedSync = s_pRomInfo->bDisableSpeedSync;
	IniFile::Get()->sections[i].bDisableEeprom = s_pRomInfo->bDisableEeprom;
	IniFile::Get()->sections[i].bExpansionPak = s_pRomInfo->bExpansionPak;
	IniFile::Get()->sections[i].dwEepromSize = s_pRomInfo->dwEepromSize;
	IniFile::Get()->sections[i].dwRescanCount = s_pRomInfo->dwRescanCount;

	IniFile::Get()->bChanged = TRUE;
}
