/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "Resources/resource.h"

#include "PageDialog.h"
#include "PluginsPage.h"

#include "Core/CPU.h"

#include "Plugins/GraphicsPlugin.h"

#include "Utility/ResourceString.h"
#include "Utility/ConfigHandler.h"

//*****************************************************************************
// Class window proc
//*****************************************************************************
BOOL CPluginsPage::DialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LONG nSelection;
	LONG nIndex;
	LONG nCheckedState;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		return OnInitDialog(hWndDlg, wParam, lParam);


	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_ABOUT_GRAPHICS_BUTTON:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO));
			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < m_GraphicsPlugins.size())
			{
				if (m_GraphicsPlugins[nIndex].pPlugin != NULL)
				{
					m_GraphicsPlugins[nIndex].pPlugin->DllAbout(hWndDlg);
				}
			}
			return TRUE;
		/*case IDC_GRAPHICS_CONFIG_BUTTON:
			if ( !CGraphicsPlugin::IsAvailable() )
			{
				MessageBox(hWndDlg, CResourceString(IDS_CONFIGGFX), g_szDaedalusName, MB_OK);
			}
			else
			{
				nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO));
				nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO), nSelection);
				if (nIndex != CB_ERR && nIndex < m_GraphicsPlugins.size())
				{
					if (m_GraphicsPlugins[nIndex].pPlugin != NULL)
					{
						m_GraphicsPlugins[nIndex].pPlugin->DllConfig(hWndDlg);
					}
				}
			}
			return TRUE;*/




		case IDC_ENABLE_AUDIO_CHECK:

			nCheckedState = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_ENABLE_AUDIO_CHECK));
			if (nCheckedState == BST_CHECKED)
			{
				AudioDialog_EnableControls(hWndDlg, TRUE);
			}
			else if (nCheckedState == BST_UNCHECKED)
			{
				AudioDialog_EnableControls(hWndDlg, FALSE);
			}

			return TRUE;

		case IDC_ABOUT_AUDIO_BUTTON:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO));
			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < m_AudioPlugins.size())
			{
				if (m_AudioPlugins[nIndex].pPlugin != NULL)
				{
					m_AudioPlugins[nIndex].pPlugin->DllAbout(hWndDlg);
				}
			}
			return TRUE;
		/*case IDC_AUDIO_CONFIG_BUTTON:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO));
			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < m_AudioPlugins.size())
			{
				if (m_AudioPlugins[nIndex].pPlugin != NULL)
				{
					m_AudioPlugins[nIndex].pPlugin->DllConfig(hWndDlg);
				}
			}
			return TRUE;*/


		case IDOK:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO));

			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < m_GraphicsPlugins.size())
			{
				// Update main plugin!
				// Write to config!!!
				// Reinitialise!
				TCHAR szNewFileName[MAX_PATH+1];

				lstrcpyn(szNewFileName, m_GraphicsPlugins[nIndex].szFileName, MAX_PATH);

				{
					// NULL - Write to registry
					ConfigHandler * pConfig = new ConfigHandler("Main");
					
					if (pConfig != NULL)
					{
						pConfig->WriteString("GraphicsPlugin", szNewFileName);
						delete pConfig;
					}
				}

				lstrcpyn(g_CurrentConfig.szGfxPluginFileName, szNewFileName, MAX_PATH);

				// Set to null so that it is not deleted when we clean up
				//m_GraphicsPlugins[nSelection].pPlugin = NULL;
			}



			nCheckedState = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_ENABLE_AUDIO_CHECK));
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO));

			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < m_AudioPlugins.size())
			{
				// Update main plugin!
				// Write to config!!!
				// Reinitialise!
				TCHAR szNewFileName[MAX_PATH+1];

				if (nCheckedState == BST_CHECKED)
				{
					lstrcpyn(szNewFileName, m_AudioPlugins[nIndex].szFileName, MAX_PATH);
				}
				else if (nCheckedState == BST_UNCHECKED)
				{
					lstrcpyn(szNewFileName, TEXT(""), MAX_PATH);
				}

				{
					// NULL - Write to registry
					ConfigHandler * pConfig = new ConfigHandler("Main");
					
					if (pConfig != NULL)
					{
						pConfig->WriteString("AudioPlugin", szNewFileName);
						delete pConfig;
					}
				}

				lstrcpyn(g_CurrentConfig.szAiPluginFileName, szNewFileName, MAX_PATH);

				// Set to null so that it is not deleted when we clean up
				//m_AudioPlugins[nSelection].pPlugin = NULL;
			}




			EndDialog(hWndDlg, IDOK);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWndDlg, IDCANCEL);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		// Free any plugins that were found
		FreePluginList();
		return TRUE;

	}


	return FALSE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL CPluginsPage::OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{

	// Initialise the 
	if (InitPluginList())
		FillPluginCombo(hWndDlg);

	if (lstrlen(g_CurrentConfig.szGfxPluginFileName) == 0)
	{
		EnableControls(hWndDlg, FALSE);
	}
	else
	{
		EnableControls(hWndDlg, TRUE);
	}


	// Initialise the 
	if (AudioDialog_InitPluginList())
		AudioDialog_FillPluginCombo(hWndDlg);

	if (lstrlen(g_CurrentConfig.szAiPluginFileName) == 0)
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_ENABLE_AUDIO_CHECK), BST_UNCHECKED);
		AudioDialog_EnableControls(hWndDlg, FALSE);
	}
	else
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_ENABLE_AUDIO_CHECK), BST_CHECKED);
		AudioDialog_EnableControls(hWndDlg, TRUE);
	}


	SetFocus(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO));




	SetFocus(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO));


	// We set the foucus, return false
	return FALSE;
}

//*****************************************************************************
// Free all plugins in list
//*****************************************************************************
void CPluginsPage::FreePluginList()
{
	LONG i;
	LONG nNumPlugins;

	nNumPlugins = m_GraphicsPlugins.size();
	for (i = 0; i < nNumPlugins; i++)
	{
		if (m_GraphicsPlugins[i].pPlugin != NULL &&
			!m_GraphicsPlugins[i].bCurrentlyInUse)
		{
			delete m_GraphicsPlugins[i].pPlugin;
		}
	}
	m_GraphicsPlugins.clear();
}

//*****************************************************************************
// Scan
//*****************************************************************************
BOOL CPluginsPage::InitPluginList()
{
	HANDLE hFind;
	WIN32_FIND_DATA fd;
	TCHAR szFileSpec[MAX_PATH+1];
	GraphicsPluginInfo api;

	// Delete existing plugins
	FreePluginList();

	lstrcpyn(szFileSpec, g_szDaedalusExeDir, MAX_PATH);
	PathAppend(szFileSpec, TEXT("Plugins"));
	PathAppend(szFileSpec, TEXT("*.dll"));


	hFind = FindFirstFile(szFileSpec, &fd);
	if (hFind == INVALID_HANDLE_VALUE)
		return FALSE;

	do
	{
		lstrcpyn(api.szFileName, szFileSpec, MAX_PATH);
		PathRemoveFileSpec(api.szFileName);
		PathAppend(api.szFileName, fd.cFileName);

		/*if (lstrcmpi(api.szFileName, g_CurrentConfig.szGfxPluginFileName) == 0)
		{
			api.pPlugin = g_pAiPlugin;
			api.bCurrentlyInUse = TRUE;
		}
		else*/
		{
			api.pPlugin = new CGraphicsPlugin();
			if (api.pPlugin != NULL)
			{
				api.pPlugin->Open(api.szFileName);

			//	api.pPlugin->Init();
			}
			api.bCurrentlyInUse = FALSE;
		}

		if (api.pPlugin == NULL)
			continue;

		if (api.pPlugin->LoadedOk())
			m_GraphicsPlugins.push_back(api);
		else if (!api.bCurrentlyInUse)
			delete api.pPlugin;

	} while (FindNextFile(hFind, &fd));

	FindClose(hFind);

	return TRUE;
}


//*****************************************************************************
//
//*****************************************************************************
void CPluginsPage::FillPluginCombo(HWND hWndDlg)
{

	LONG i;
	LONG nNumPlugins;
	HWND hWndCombo;
	CHAR szName[100];
	LONG nIndex;
	LONG nSelection;

	hWndCombo = GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO);
	nNumPlugins = m_GraphicsPlugins.size();

	ComboBox_ResetContent(hWndCombo);

	nSelection = -1;

	for (i = 0; i < nNumPlugins; i++)
	{
		if (m_GraphicsPlugins[i].pPlugin == NULL)
			continue;

		m_GraphicsPlugins[i].pPlugin->GetPluginName(szName);

		nIndex = ComboBox_InsertString(hWndCombo, -1, szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Record the index if this is the current selection
			if (lstrcmpi(m_GraphicsPlugins[i].szFileName, 
				g_CurrentConfig.szGfxPluginFileName) == 0)
			{
				nSelection = nIndex;
			}

			// Set item data
			ComboBox_SetItemData(hWndCombo, nIndex, i);
		}
	}

	if (nSelection == -1)
		nSelection = 0;

	ComboBox_SetCurSel(hWndCombo, nSelection);

}


//*****************************************************************************
//
//*****************************************************************************
void CPluginsPage::EnableControls(HWND hWndDlg, BOOL bEnabled)
{
//	EnableWindow(GetDlgItem(hWndDlg, IDC_GRAPHICS_PLUGIN_COMBO), bEnabled);
	EnableWindow(GetDlgItem(hWndDlg, IDC_ABOUT_GRAPHICS_BUTTON), bEnabled);
	//EnableWindow(GetDlgItem(hWndDlg, IDC_CONFIG_BUTTON), bEnabled);

}








// Free all plugins in list
void CPluginsPage::AudioDialog_FreePluginList()
{
	LONG i;
	LONG nNumPlugins;

	nNumPlugins = m_AudioPlugins.size();
	for (i = 0; i < nNumPlugins; i++)
	{
		if (m_AudioPlugins[i].pPlugin != NULL &&
			!m_AudioPlugins[i].bCurrentlyInUse)
		{
			delete m_AudioPlugins[i].pPlugin;
		}
	}
	m_AudioPlugins.clear();
}

// Scan
BOOL CPluginsPage::AudioDialog_InitPluginList()
{
	HANDLE hFind;
	WIN32_FIND_DATA fd;
	TCHAR szFileSpec[MAX_PATH+1];
	AudioPluginInfo api;

	// Delete existing plugins
	AudioDialog_FreePluginList();

	lstrcpyn(szFileSpec, g_szDaedalusExeDir, MAX_PATH);
	PathAppend(szFileSpec, TEXT("Plugins"));
	PathAppend(szFileSpec, TEXT("*.dll"));


	hFind = FindFirstFile(szFileSpec, &fd);
	if (hFind == INVALID_HANDLE_VALUE)
		return FALSE;

	do
	{
		lstrcpyn(api.szFileName, szFileSpec, MAX_PATH);
		PathRemoveFileSpec(api.szFileName);
		PathAppend(api.szFileName, fd.cFileName);

		/*if (lstrcmpi(api.szFileName, g_CurrentConfig.szAiPluginFileName) == 0)
		{
			api.pPlugin = g_pAiPlugin;
			api.bCurrentlyInUse = TRUE;
		}
		else*/
		{
			api.pPlugin = new CAudioPlugin(api.szFileName);
			if (api.pPlugin != NULL)
				api.pPlugin->Open();
			api.bCurrentlyInUse = FALSE;
		}

		if (api.pPlugin == NULL)
			continue;

		if (api.pPlugin->LoadedOk())
			m_AudioPlugins.push_back(api);
		else if (!api.bCurrentlyInUse)
			delete api.pPlugin;

	} while (FindNextFile(hFind, &fd));

	FindClose(hFind);

	return TRUE;
}


void CPluginsPage::AudioDialog_FillPluginCombo(HWND hWndDlg)
{
	LONG i;
	LONG nNumPlugins;
	HWND hWndCombo;
	CHAR szName[100];
	LONG nIndex;
	LONG nSelection;

	hWndCombo = GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO);
	nNumPlugins = m_AudioPlugins.size();

	ComboBox_ResetContent(hWndCombo);

	nSelection = -1;

	for (i = 0; i < nNumPlugins; i++)
	{
		if (m_AudioPlugins[i].pPlugin == NULL)
			continue;

		m_AudioPlugins[i].pPlugin->GetPluginName(szName);

		nIndex = ComboBox_InsertString(hWndCombo, -1, szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Record the index if this is the current selection
			if (lstrcmpi(m_AudioPlugins[i].szFileName, 
				g_CurrentConfig.szAiPluginFileName) == 0)
			{
				nSelection = nIndex;
			}

			// Set item data
			ComboBox_SetItemData(hWndCombo, nIndex, i);
		}
	}

	if (nSelection == -1)
		nSelection = 0;

	ComboBox_SetCurSel(hWndCombo, nSelection);

}


void CPluginsPage::AudioDialog_EnableControls(HWND hWndDlg, BOOL bEnabled)
{
	EnableWindow(GetDlgItem(hWndDlg, IDC_AUDIO_PLUGIN_COMBO), bEnabled);
	EnableWindow(GetDlgItem(hWndDlg, IDC_ABOUT_AUDIO_BUTTON), bEnabled);
	//EnableWindow(GetDlgItem(hWndDlg, IDC_CONFIG_BUTTON), bEnabled);

}

