/*
Copyright (C) 2001 CyRUS64 (http://www.boob.co.uk)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "IniFile.h"
#include "Debug/DBGConsole.h"

//*****************************************************************************
// Singleton creator
//*****************************************************************************
HRESULT CUnique< IniFile >::Create()
{
	_ASSERTE(m_pInstance == NULL);
	
	m_pInstance = new IniFile( g_szDaedalusIniFile );
	if (!m_pInstance)
		return E_OUTOFMEMORY;

	return S_OK;
};


//*****************************************************************************
// Constructor
//*****************************************************************************
IniFile::IniFile( LPCTSTR szFileName )
{
	sections.clear();
	bChanged = false;

	if (szFileName == NULL)
		strcpy(m_szFileName, "");
	else 
		strcpy(m_szFileName, szFileName);

}

IniFile::~IniFile()
{
	if (bChanged)
	{
		WriteIniFile(m_szFileName);
	}
}

char * left(char * src, int nchars)
{
	static char dst[300];			// BUGFIX (STRMNNRM)
	strncpy(dst,src,nchars);
	dst[nchars]=0;
	return dst;
}

char * right(char *src, int nchars)
{
	static char dst[300];			// BUGFIX (STRMNNRM)
	strncpy(dst, src + strlen(src) - nchars, nchars);
	dst[nchars]=0;
	return dst;
}

// (STRMNNRMN - Strip spaces from end of names)
char * tidy(char * s)
{
	char * p = s + lstrlen(s);

	p--;
	while (p >= s && *p == ' ')
	{
		*p = 0;
		p--;
	}
	return s;

}

BOOL IniFile::ReadIniFile()
{
	std::ifstream inifile;
	char readinfo[100];
	char trim[]="{}"; //remove first and last character
	
	inifile.open(m_szFileName);
	
	if (inifile.fail())
		return FALSE;

	while (getline(inifile,readinfo)/*&&sectionno<999*/)
	{
		tidy(readinfo);			// STRMNNRMN - Strip spaces from end of lines

		// STRMNNRMN - comments
		if (readinfo[0] == '/')
			continue;

		if (!lstrcmpi(readinfo,"")==0)
		{
			if (readinfo[0] == '{') //if a section heading
			{
				section newsection;

				StrTrim(readinfo,trim);
				strcpy(newsection.crccheck, readinfo);
				
				strcpy(newsection.comment, "");
				strcpy(newsection.info, "");
				newsection.ucode = 5;				// Most new games are ucode 5 - thanks CyRUS64
				newsection.bDisablePatches = false;
				newsection.bDisableTextureCRC = false;
				newsection.bDisableEeprom = false;
				newsection.bIncTexRectEdge = false;
				newsection.bDisableSpeedSync = false;
				newsection.bDisableDynarec = false;
				newsection.bExpansionPak = false;
				newsection.dwEepromSize = 2048;
				newsection.dwRescanCount = 0;

				sections.push_back(newsection);
				
			}
			else
			{		
				int sectionno = sections.size() - 1;

				if (lstrcmpi(left(readinfo,5), "UCode")==0)
					sections[sectionno].ucode=strtol(right(readinfo,1),NULL,10);
				
				if (lstrcmpi(left(readinfo,7), "Comment")==0)
					strcpy(sections[sectionno].comment,right(readinfo,strlen(readinfo)-8));
				
				if (lstrcmpi(left(readinfo,4), "Info")==0)
					strcpy(sections[sectionno].info,right(readinfo,strlen(readinfo)-5));
				
				if (lstrcmpi(left(readinfo,4), "Name")==0)
					strcpy(sections[sectionno].name,right(readinfo,strlen(readinfo)-5));
				
				if (lstrcmpi(left(readinfo,14), "DisableDynarec")==0)
					sections[sectionno].bDisableDynarec=true;
				
				if (lstrcmpi(left(readinfo,14), "DisablePatches")==0)
					sections[sectionno].bDisablePatches=true;
				
				if (lstrcmpi(left(readinfo,20), "DisableTextureCRC")==0)
					sections[sectionno].bDisableTextureCRC=true;
				
				if (lstrcmpi(left(readinfo,13), "DisableEeprom")==0)
					sections[sectionno].bDisableEeprom=true;
				
				if (lstrcmpi(left(readinfo,16), "DisableSpeedSync")==0)
					sections[sectionno].bDisableSpeedSync=true;
				
				if (lstrcmpi(left(readinfo,14), "IncTexRectEdge")==0)
					sections[sectionno].bIncTexRectEdge=true;

				if (lstrcmpi(left(readinfo,12), "ExpansionPak")==0)
					sections[sectionno].bExpansionPak = true;

				if (lstrcmpi(left(readinfo,10), "EepromSize")==0)
					sections[sectionno].dwEepromSize = strtol(right(readinfo,4),NULL,10);

				if (lstrcmpi(left(readinfo,13), "OSRescanCount")==0)
					sections[sectionno].dwRescanCount = strtol(right(readinfo,4),NULL,10);
				
			}
		}
	}
	inifile.close();

	return TRUE;
}

//read a line from the ini file
std::istream & IniFile::getline(std::istream & is, char *str)
{
    char buf[100];
	
    is.getline(buf,100);
    strcpy( str,buf);
    return is;
}

void IniFile::WriteIniFile(LPCTSTR szFileName)
{
	TCHAR szFileNameOut[MAX_PATH+1];
	TCHAR szFileNameDelete[MAX_PATH+1];
	LONG i;
	FILE * fhIn;
	FILE * fhOut;
	TCHAR szBuf[1024+1];
	char trim[]="{}\n\r"; //remove first and last character

	wsprintf(szFileNameOut, "%s.tmp", szFileName);
	wsprintf(szFileNameDelete, "%s.del", szFileName);

	fhIn = fopen(szFileName, "r");
	if (fhIn == NULL)
		return;

	fhOut = fopen(szFileNameOut, "w");
	if (fhOut == NULL)
	{
		fclose(fhIn);
		return;
	}

	// Mark all sections and needing to be written
	for (i = 0; i < sections.size(); i++)
	{
		sections[i].bOutput = false;
	}


	while (fgets(szBuf, 1024, fhIn))
	{
		if (szBuf[0] == '{')
		{
			BOOL bFound = FALSE;
			// Start of section
			StrTrim(szBuf,trim);


			for (i = 0; i < sections.size(); i++)
			{
				if (sections[i].bOutput)
					continue;

				if (lstrcmpi(szBuf, sections[i].crccheck) == 0)
				{
					// Output this CRC
					OutputSectionDetails(i, fhOut);
					sections[i].bOutput = true;
					bFound = TRUE;
					break;
				}
			}
			if (!bFound)
			{
				// Do what? This should never happen, unless the user
				// replaces the inifile while Daedalus is running!
			}
		}
		else if (szBuf[0] == '/')
		{
			// Comment
			fputs(szBuf, fhOut);
			continue;
		}

	}

	// Input buffer done-  process any new entries!
	for (i = 0; i < sections.size(); i++)
	{
		// Skip any that have not been done.
		if (sections[i].bOutput)
			continue;
		// Output this CRC
		// Removed at request of Genueix :)
		//fprintf(fhOut, "// Automatically generated entry - may need editing\n");
		OutputSectionDetails(i, fhOut);
		sections[i].bOutput = true;
	}

	fclose(fhOut);
	fclose(fhIn);

	// Create the new file
	MoveFile(szFileName, szFileNameDelete);
	MoveFile(szFileNameOut, szFileName);
	DeleteFile(szFileNameDelete);

	bChanged = false;
}


void IniFile::OutputSectionDetails(DWORD i, FILE * fh)
{
	fprintf(fh, "{%s}\n", sections[i].crccheck);
	
	fprintf(fh, "Name=%s\n", sections[i].name);
	fprintf(fh, "UCode=%d\n", sections[i].ucode);

	if (lstrlen(sections[i].comment) > 0)
		fprintf(fh, "Comment=%s\n", sections[i].comment);

	if (lstrlen(sections[i].info) > 0)
		fprintf(fh, "Info=%s\n", sections[i].info);

	if (sections[i].bDisableDynarec)
		fprintf(fh, "DisableDynarec\n");

	if (sections[i].bDisablePatches)
		fprintf(fh, "DisablePatches\n");

	if (sections[i].bDisableTextureCRC)
		fprintf(fh, "DisableTextureCRC\n");

	if (sections[i].bDisableEeprom)
		fprintf(fh, "DisableEeprom\n");

	if (sections[i].bDisableSpeedSync)
		fprintf(fh, "DisableSpeedSync\n");

	if (sections[i].bIncTexRectEdge)
		fprintf(fh, "IncTexRectEdge\n");

	if (sections[i].bExpansionPak)
		fprintf(fh, "ExpansionPak\n");

	if (sections[i].dwEepromSize != 2048)
		fprintf(fh, "EepromSize=%d\n", sections[i].dwEepromSize);

	if (sections[i].dwRescanCount != 0)
		fprintf(fh, "OSRescanCount=%d\n", sections[i].dwRescanCount);

	fprintf(fh, "\n");			// Spacer

}


// Find the entry corresponding to the specified rom. 
// If the rom is not found, a new entry is created
// The resulting value is returned
int IniFile::FindEntry(DWORD dwCRC1, DWORD dwCRC2, BYTE nCountryID, LPCTSTR szName)
{
	LONG i;
	CHAR szCRC[50+1];
	
	// Generate the CRC-ID for this rom:
	wsprintf(szCRC, "%08x%08x-%02x", dwCRC1, dwCRC2, nCountryID);

	for (i = 0; i < sections.size(); i++)
	{
		if (lstrcmpi(szCRC, sections[i].crccheck) == 0)
			return i;
	}
	
	// Add new entry!!!
	section newsection;

	strcpy(newsection.crccheck, szCRC);
	
	lstrcpyn(newsection.name, szName, 50);
	newsection.ucode = 5;				// Most new games are ucode 5 - thanks CyRUS64
	strcpy(newsection.comment, "");
	strcpy(newsection.info, "");
	newsection.bDisablePatches = false;
	newsection.bDisableTextureCRC = false;
	newsection.bDisableEeprom = false;
	newsection.bIncTexRectEdge = false;
	newsection.bDisableSpeedSync = false;
	newsection.bDisableDynarec = false;
	newsection.bExpansionPak = false;
	newsection.dwEepromSize = 2048;
	newsection.dwRescanCount = 0;

	sections.push_back(newsection);

	bChanged = true;				// Flag to indicate we should be updated
	return sections.size()-1;			// -1 takes into account increment
		
}
