/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef __DEBUGPAGEDIALOG_H__
#define __DEBUGPAGEDIALOG_H__

#include "Debug/DBGConsole.h"

class CDebugPage : public CPageDialog
{
	protected:
		friend class CPageDialog;			// Only CPageDialog::Create() can create!

		CDebugPage( )
		{
		}

	public:
		virtual ~CDebugPage()
		{
		}

		CPageDialog::PageType GetPageType() const { return CPageDialog::PAGE_DEBUG; }
		UINT GetResourceID() const { return IDD_PAGE_DEBUG; }

		BOOL DialogProc( HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
		{
			switch (uMsg)
			{
			case WM_INITDIALOG:
				{
					// Init parameters
						
					CheckBox_SetCheck( GetDlgItem( hWndDlg, IDC_DEBUG_CONSOLE_CHECK ),   g_CurrentConfig.bShowDebug      ? BST_CHECKED : BST_UNCHECKED );
					CheckBox_SetCheck( GetDlgItem( hWndDlg, IDC_TRAP_EXCEPTIONS_CHECK ), g_CurrentConfig.bTrapExceptions ? BST_CHECKED : BST_UNCHECKED );
					return TRUE;
				}

			case WM_DESTROY:
				{
					// Set parameters (or set on change??)
					g_CurrentConfig.bShowDebug      = CheckBox_GetCheck( GetDlgItem( hWndDlg, IDC_DEBUG_CONSOLE_CHECK ) ) == BST_CHECKED;
					g_CurrentConfig.bTrapExceptions = CheckBox_GetCheck( GetDlgItem( hWndDlg, IDC_TRAP_EXCEPTIONS_CHECK ) ) == BST_CHECKED;
				}
				return TRUE;

			}

			return FALSE;
		}

};

#endif // __DEBUGPAGEDIALOG_H__