/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef __CONFIGDIALOG_H__
#define __CONFIGDIALOG_H__

#include "Utility/Unique.h"

#include "PageDialog.h"

class CConfigDialog : public CUnique< CConfigDialog >
{
	protected:
		friend class CUnique< CConfigDialog >;
		
		CConfigDialog() :
			m_pPageDialog( NULL )
		{
		}

	public:

		INT DoModal(HWND hWndParent);

	protected:

		CPageDialog	*	m_pPageDialog;

		static BOOL CALLBACK DialogProcStatic(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

		BOOL DialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

		BOOL OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);

		void FillPageList(HWND hWndDlg);

		void ShowPage( HWND hWndDlg, CPageDialog::PageType page );
		void KillPage( );

};



#endif	// __CONFIGDIALOG_H__
