/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#include "stdafx.h"
#include "Resources/resource.h"
#include "ConfigDialog.h"

#include "Core/CPU.h"
#include "Debug/DBGConsole.h"
#include "Debug/Dump.h"
#include "Plugins/GraphicsPlugin.h"
#include "Utility/ResourceString.h"
#include "Utility/ConfigHandler.h"

DaedalusConfig g_CurrentConfig;

//*****************************************************************************
// Singleton creator
//*****************************************************************************
HRESULT CUnique< CConfigDialog >::Create()
{
	_ASSERTE(m_pInstance == NULL);
	
	m_pInstance = new CConfigDialog( );
	if (!m_pInstance)
		return E_OUTOFMEMORY;

	return S_OK;
}

//*****************************************************************************
// 
//*****************************************************************************
INT CConfigDialog::DoModal(HWND hWndParent)
{
	return DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_CONFIG), hWndParent, DialogProcStatic);
}

//*****************************************************************************
// Static Window Proc
//*****************************************************************************
BOOL CALLBACK CConfigDialog::DialogProcStatic(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return Get()->DialogProc( hWndDlg, uMsg, wParam, lParam );
}

//*****************************************************************************
// Class window proc
//*****************************************************************************
BOOL CConfigDialog::DialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LONG nSelection;
	LONG nIndex;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		// Copy the global config
		g_CurrentConfig = g_DaedalusConfig;
		return OnInitDialog(hWndDlg, wParam, lParam);

	//case WM_CLOSE:
		// Close the window as if the IDOK button had been pressed.
		// Normally an IDCANCEL would be sent if we didn't process this message
		//SendMessage( hWndDlg, WM_COMMAND, MAKELONG(IDOK,0), 0);
		//return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
			case IDOK:
			{
				// We have to do this so that the current settings are commited!
				KillPage();

				if (lstrcmpi(g_DaedalusConfig.szGfxPluginFileName, g_CurrentConfig.szGfxPluginFileName) != 0)
				{
					DBGConsole_Msg(0, "Graphics plugin [C%s] selected", g_CurrentConfig.szGfxPluginFileName);

					//g_bReloadGfxPlugin = TRUE;
					if (g_bCPURunning)
						MessageBox(hWndDlg, CResourceString(IDS_STOPSTARTCPU), g_szDaedalusName, MB_OK);
				}
				
				if (lstrcmpi(g_DaedalusConfig.szAiPluginFileName, g_CurrentConfig.szAiPluginFileName) != 0)
				{
					DBGConsole_Msg(0, "Audio plugin [C%s] selected", g_CurrentConfig.szAiPluginFileName);
					g_bReloadAiPlugin = TRUE;
				}

				BOOL bCurrDebugShow = g_DaedalusConfig.bShowDebug;

				// Copy across config to active config
				g_DaedalusConfig = g_CurrentConfig;

				if ( bCurrDebugShow != g_DaedalusConfig.bShowDebug )
				{
					DBGConsole_Enable( g_DaedalusConfig.bShowDebug );
				}

				EndDialog( hWndDlg, IDOK );
				return TRUE;
			}

			case IDCANCEL:
			{
				// Although there isn't a cancel button, this will be called when the close button is hit
				EndDialog( hWndDlg, IDCANCEL );
				return TRUE;
			}
			case IDC_PAGE_LIST:
			{
				if ( HIWORD(wParam) == LBN_SELCHANGE )
				{
					nSelection = ListBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PAGE_LIST));
					nIndex = ListBox_GetItemData(GetDlgItem(hWndDlg, IDC_PAGE_LIST), nSelection);
					if (nIndex != LB_ERR && nIndex < CPageDialog::NUM_PAGE_TYPES )
					{
						ShowPage( hWndDlg, (CPageDialog::PageType)nIndex );
					}
				}
				return TRUE;
			}
		}

	case WM_DESTROY:
		return TRUE;

	}


	return FALSE;
}

//*****************************************************************************
//
//*****************************************************************************
BOOL CConfigDialog::OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{
	// Initialise the list of pages
	FillPageList(hWndDlg);

	ShowPage( hWndDlg, CPageDialog::PAGE_SETTINGS );

	SetFocus(GetDlgItem(hWndDlg, IDC_PAGE_LIST));

	// We set the foucus, return false
	return FALSE;
}



//*****************************************************************************
//
//*****************************************************************************
void CConfigDialog::FillPageList(HWND hWndDlg)
{

	LONG i;
	HWND hWndList;
	LONG nIndex;
	LONG nSelection;

	hWndList = GetDlgItem(hWndDlg, IDC_PAGE_LIST);

	ListBox_ResetContent(hWndList);

	nSelection = 0;
	CPageDialog::PageType nCurrentPage = CPageDialog::PAGE_SETTINGS;
	if ( m_pPageDialog )
	{
		nCurrentPage = m_pPageDialog->GetPageType();
	}

	for (i = 0; i < CPageDialog::NUM_PAGE_TYPES; i++)
	{
		CPageDialog::PageType type = static_cast< CPageDialog::PageType >( i );

		nIndex = ListBox_InsertString(hWndList, -1, CPageDialog::GetPageName( type ) );

		if (nIndex != LB_ERR && nIndex != LB_ERRSPACE)
		{
			// Record the index if this is the current selection
			if ( nCurrentPage == i )
			{
				nSelection = nIndex;
			}

			// Set item data
			ListBox_SetItemData(hWndList, nIndex, i);
		}
	}

	ListBox_SetCurSel(hWndList, nSelection);

}

//*****************************************************************************
//
//*****************************************************************************
void	CConfigDialog::KillPage( )
{
	if ( m_pPageDialog != NULL )
	{
		m_pPageDialog->Destroy();
		m_pPageDialog = NULL;
	}
}

//*****************************************************************************
//
//*****************************************************************************
void	CConfigDialog::ShowPage( HWND hWndDlg, CPageDialog::PageType page )
{
	KillPage();

	m_pPageDialog = CPageDialog::Create( hWndDlg, 130, 0, page );	
}

