#ifndef __INPUTMANAGER_H__
#define __INPUTMANAGER_H__

#include "OSHLE/ultra_os.h"
#include "Utility/Unique.h"


class CInputManager : public CUnique< CInputManager >
{
	protected:
		CInputManger();

	public:
		virtual ~CInputManager() {}

		virtual HRESULT Initialise( HWND hWnd ) = 0;
		virtual void Finalise() = 0;

		virtual void Unaquire() = 0;

		virtual HRESULT GetState( OSContPad pPad[4] ) = 0;

		virtual void Configure(HWND hWndParent) = 0;

		// Nasty - should really be hidden in implementation
		virtual BOOL InputSelectDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) = 0;
		virtual BOOL InputConfigDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) = 0;

};

#endif // __INPUTMANAGER_H__
