#define SR_LOAD_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_LOAD_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_LOAD		//return FALSE;

BOOL SR_Emit_LB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Load_B_D(dwBase, dwRT);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LB);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// TODO: If the base is SP, and we have SP cached, use ESI instead:
		{
			// Use the alternative code

			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 3, false);
			
			// mov al, byte ptr [eax]
			pCode->EmitBYTE(0x8A);
			pCode->EmitBYTE(0x00);

			// EAX_CODE now holds read 16 bits!
			// movsx	eax, al
			pCode->EmitBYTE(0x0F);
			pCode->EmitBYTE(0xBE);		// 0xBF for word sign extension
			pCode->EmitBYTE(0xC0);

			StoreMIPSLo(pCode, dwRT, EAX_CODE);
			pCode->SARI(EAX_CODE, 31);
			StoreMIPSHi(pCode, dwRT, EAX_CODE);
		}

	}
		
	return TRUE;
}


BOOL SR_Emit_LBU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Load_B_D(dwBase, dwRT);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LBU);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// TODO: If the base is SP, and we have SP cached, use ESI instead:
		{
			// Use the alternative code

			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 3, false);
			
			// mov al, byte ptr [eax]
			pCode->EmitBYTE(0x8A);
			pCode->EmitBYTE(0x00);

			// EAX_CODE now holds read 16 bits!
			// and		eax, 0x00FF	- Mask off top bits!
			//ANDI(EAX_CODE, 0x00FF);		- One byte longer than ax form
			pCode->EmitBYTE(0x25);
			pCode->EmitDWORD(0x000000FF);

			StoreMIPSLo(pCode, dwRT, EAX_CODE);

			// Top bits always 0
			SetMIPSHi(pCode, dwRT, 0);
		}

	}
		
	return TRUE;
}


BOOL SR_Emit_LH(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Load_B_D(dwBase, dwRT);
	
	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LH);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// TODO: If the base is SP, and we have SP cached, use ESI instead:
		{
			// Use the alternative code

			//DWORD dwAddress = (u32)((s32)g_qwGPR[dwBase] + (s32)wOffset);
			//g_qwGPR[dwRT] = (s64)(s16)Read16Bits(dwAddress);

			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 2, false);
			
			// mov ax, word ptr [eax]
			pCode->EmitBYTE(0x66);
			pCode->EmitBYTE(0x8B);
			pCode->EmitBYTE(0x00);

			// EAX_CODE now holds read 16 bits!
			// movsx	eax, ax
			pCode->EmitBYTE(0x0F);
			pCode->EmitBYTE(0xBF);
			pCode->EmitBYTE(0xC0);

			StoreMIPSLo(pCode, dwRT, EAX_CODE);
			pCode->SARI(EAX_CODE, 31);		
			StoreMIPSHi(pCode, dwRT, EAX_CODE);
		}

	}

	return TRUE;
}

BOOL SR_Emit_LHU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Load_B_D(dwBase, dwRT);
	
	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LHU);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// TODO: If the base is SP, and we have SP cached, use ESI instead:
		{
			// Use the alternative code

			//DWORD dwAddress = (u32)((s32)g_qwGPR[dwBase] + (s32)wOffset);
			//g_qwGPR[dwRT] = (u64)(u16)Read16Bits(dwAddress);

			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 2, false);

			// mov ax, word ptr [eax]
			pCode->EmitBYTE(0x66);
			pCode->EmitBYTE(0x8B);
			pCode->EmitBYTE(0x00);

			// EAX_CODE now holds read 16 bits!
			// and		eax, 0xFFFF	- Mask off top bits!
			//ANDI(EAX_CODE, 0xFFFF);		- One byte longer than ax form
			pCode->EmitBYTE(0x25);
			pCode->EmitDWORD(0x0000FFFF);

			StoreMIPSLo(pCode, dwRT, EAX_CODE);

			// Top bits always 0
			SetMIPSHi(pCode, dwRT, 0);
		}

	}
	return TRUE;
}


BOOL SR_Emit_LW(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwBase = R4300_RS(dwOp);

	pCode->Stat_Load_B_D(dwBase, dwRT);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LW);
	}
	else
	{
		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		pCode->dwNumOptimised++;

		// If the base is SP, and we have SP cached, use ESI instead:
		if (dwBase == REG_sp && pCode->bSpCachedInESI)
		{
			if (nOffset < 128 && nOffset > -128)
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using s16 offset");
				// Use s16 form:
				// mov eax, dword ptr [esi + b]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x46);
				pCode->EmitBYTE((BYTE)nOffset);
			}
			else
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using long offset");
				// Use long form:
				// mov eax, dword ptr [esi + nnnnnnnn]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x86);
				pCode->EmitDWORD((DWORD)nOffset);
			}
			

			// EAX_CODE now holds read 32 bits!
			StoreMIPSLo(pCode, dwRT, EAX_CODE);
			pCode->SARI(EAX_CODE, 31);		
			StoreMIPSHi(pCode, dwRT, EAX_CODE);
		}
		else
		{
			// Use the alternative code

			//DWORD	dwAddress = (u32)((s32)g_qwGPR[dwBase] + nOffset);
			//g_qwGPR[dwRT] = (s64)(s32)Read32Bits(dwAddress);

			// Get base - we could cache this?
			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 0, false);

			// mov eax, dword ptr [eax]
			pCode->EmitBYTE(0x8B);
			pCode->EmitBYTE(0x00);

			// EAX_CODE now holds read 32 bits!
			StoreMIPSLo(pCode, dwRT, EAX_CODE);
			pCode->SARI(EAX_CODE, 31);		
			StoreMIPSHi(pCode, dwRT, EAX_CODE);

		}

	}

	return TRUE;
}


BOOL SR_Emit_LWC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
	const u32 dwBase = R4300_RS(dwOp);
	const u32 dwFT = R4300_FT(dwOp);

	pCode->Stat_Load_B(dwBase);
	pCode->Stat_Single_D(dwFT);

	if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LWC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		// Simulate SR_FP stuff
		SR_FP_LWC1(dwFT);

		/*
		DWORD dwAddress = (u32)((s32)g_qwGPR[dwBase] + (s32)wOffset);
		StoreFPR_Word(dwFT, Read32Bits(dwAddress));
		*/

		// If the base is SP, and we have SP cached, use ESI instead:
		if (dwBase == REG_sp && pCode->bSpCachedInESI)
		{
			if (nOffset < 128 && nOffset > -128)
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using s16 offset");
				// Use s16 form:
				// mov eax, dword ptr [esi + b]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x46);
				pCode->EmitBYTE((BYTE)nOffset);
			}
			else
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using long offset");
				// Use long form:
				// mov eax, dword ptr [esi + nnnnnnnn]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x86);
				pCode->EmitDWORD((DWORD)nOffset);
			}
			

			// EAX_CODE now holds read 32 bits!
			// StoreFPR_Word(dwFT, Read32Bits(dwAddress));
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFT], EAX_CODE );


		}
		else
		{
			SR_Emit_ReadWriteAddress(pCode, dwBase, nOffset, 0, false);

			// mov eax, dword ptr [eax]
			pCode->EmitBYTE(0x8B);
			pCode->EmitBYTE(0x00);

			// StoreFPR_Word(dwFT, Read32Bits(dwAddress));
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFT], EAX_CODE );
		}

	}
	return TRUE;
}



/*
00452D58 8B 40 0A             mov         eax,dword ptr [eax+0Ah]
00452D5B 8B 50 0A             mov         edx,dword ptr [eax+0Ah]
00452D5E 8B 80 EF BE AD DE    mov         eax,dword ptr [eax-21524111h]
00452D64 8B 90 EF BE AD DE    mov         edx,dword ptr [eax-21524111h]


00452D28 8B 46 0A             mov         eax,dword ptr [esi+0Ah]
00452D2B 8B 56 0A             mov         edx,dword ptr [esi+0Ah]

00453258 8B 86 EF BE AD DE    mov         eax,dword ptr [esi-21524111h]
0045325E 8B 96 EF BE AD DE    mov         edx,dword ptr [esi-21524111h]
00453264 8B 00                mov         eax,dword ptr [eax]
00453266 8B 50 04             mov         edx,dword ptr [eax+4]
*/

BOOL SR_Emit_LDC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_LOAD
return FALSE;
	const u32 dwBase = R4300_RS(dwOp);
	const u32 dwFT = R4300_FT(dwOp);

	pCode->Stat_Load_B(dwBase);
	pCode->Stat_Double_D(dwFT);

	// By StrmnNrmn: Lkb: Can you check if the SR_Emit_ReadWriteAddress will handle 64bit reads?
	//if (SR_LOAD_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_LDC1);
	}
	/*else
	{
		pCode->dwNumOptimised++;

		s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

		// Simulate SR_FP stuff
		SR_FP_LDC1(dwFT);

		/*
		DWORD dwAddress = (u32)((s32)g_qwGPR[dwBase] + (s32)wOffset);
		StoreFPR_Word(dwFT, Read32Bits(dwAddress));
		* /

		// If the base is SP, and we have SP cached, use ESI instead:
		if (dwBase == REG_sp && pCode->bSpCachedInESI)
		{

			if (nOffset < (128-4) && nOffset > -128)
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using s16 offset");
				// Use s16 form:
				// mov eax, dword ptr [esi + b]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x40 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitBYTE((BYTE)nOffset);

				// mov edx, dword ptr [esi + b]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x40 | (EDX_CODE<<3) | ESI_CODE);
				pCode->EmitBYTE((BYTE)(nOffset+4));

			}
			else
			// Assume long offset - because we need to +4
			{
				DPF(DEBUG_DYNREC, " Using cached reg in ESI - using long offset");
				// Use long form:
				// mov eax, dword ptr [esi + nnnnnnnn]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x80 | (EAX_CODE<<3) | ESI_CODE);
				pCode->EmitDWORD((DWORD)nOffset);

				// mov edx, dword ptr [esi + nnnnnnnn]
				pCode->EmitBYTE(0x8B);
				pCode->EmitBYTE(0x80 | (EDX_CODE<<3) | ESI_CODE);
				pCode->EmitDWORD((DWORD)(nOffset + 4));
			}
		

			// EAX_CODE now holds read 32 bits!
			// StoreFPR_Word(dwFT, Read32Bits(dwAddress));
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFT+0], EDX_CODE );
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFT+1], EAX_CODE );


		}
		else
		{
			// Get base (this could be cached!)
			LoadMIPSLo(pCode, EAX_CODE, dwBase);

			// Add offset - pCode ignores 0
			pCode->ADDI(EAX_CODE, nOffset);

			pCode->MOV(ECX_CODE, EAX_CODE);
			
			// Get top bits (offset into table) in ECX
			pCode->SHRI(EAX_CODE, 18);

			// call dword ptr [g_ReadAddressLookupTable + eax*4]
			pCode->EmitBYTE(0xFF);
			pCode->EmitBYTE(0x14);
			pCode->EmitBYTE(0x85);
			pCode->EmitDWORD((DWORD)g_ReadAddressLookupTable);		// Won't work if g_ReadAddressLookupTable recreated

			// mov edx, dword ptr [eax+4]
			pCode->EmitBYTE(0x8B);
			pCode->EmitBYTE(0x40 | (EDX_CODE<<3) | EAX_CODE);
			pCode->EmitBYTE(0x04);

			// mov eax, dword ptr [eax]
			pCode->EmitBYTE(0x8B);
			pCode->EmitBYTE(0x00);

			
			// StoreFPR_Word(dwFT, Read32Bits(dwAddress));
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFT+0], EDX_CODE );
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFT+1], EAX_CODE );
		}

	}*/
	return TRUE;
}







