#define SR_COP1_S_OPTIMISE_FLAG		pCode->dwOptimiseLevel < 1
//#define SR_COP1_S_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_COP1_S		//return FALSE;

BOOL SR_Emit_Cop1_S_ADD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S

	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S_S(dwFD, dwFS, dwFT);


	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_ADD);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs+ft
		SR_FP_ADD(dwFD, dwFS, dwFT, FP_SINGLE);

	}
	return TRUE;
}



BOOL SR_Emit_Cop1_S_SUB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S_S(dwFD, dwFS, dwFT);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_SUB);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs-ft
		SR_FP_SUB(dwFD, dwFS, dwFT, FP_SINGLE);
	}
	return TRUE;
}

BOOL SR_Emit_Cop1_S_MUL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S_S(dwFD, dwFS, dwFT);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_MUL);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Simulate SR_FP stuff
		// fd = fs*ft
		SR_FP_MUL(dwFD, dwFS, dwFT, FP_SINGLE);
		
	}
	return TRUE;
}


BOOL SR_Emit_Cop1_S_DIV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S_S(dwFD, dwFS, dwFT);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_DIV);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs/ft
		SR_FP_DIV(dwFD, dwFS, dwFT, FP_SINGLE);
	}
		
	return TRUE;
}

BOOL SR_Emit_Cop1_S_SQRT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S(dwFD, dwFS);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_SQRT);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Simulate SR_FP stuff
		// fd = sqrtf(fs)
		SR_FP_SQRT(dwFD, dwFS, FP_SINGLE);
		
	}
	return TRUE;
}

BOOL SR_Emit_Cop1_S_MOV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S(dwFD, dwFS);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_MOV);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = fs
		SR_FP_MOV(dwFD, dwFS, FP_SINGLE);
	}
		
	return TRUE;
}

BOOL SR_Emit_Cop1_S_NEG(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S(dwFD, dwFS);
	
	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_NEG);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fd = -fs
		SR_FP_NEG(dwFD, dwFS, FP_SINGLE);
	}
	
	return TRUE;
}





BOOL SR_Emit_Cop1_S_ABS(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_D_S(dwFD, dwFS);
	
	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_ABS);
	return TRUE;
}


BOOL SR_Emit_Cop1_S_ROUND_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_ROUND_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_TRUNC_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_TRUNC_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_CEIL_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_CEIL_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_FLOOR_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_FLOOR_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_ROUND_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_ROUND_W);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_TRUNC_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	//if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_TRUNC_W);
	}
/*	else
	{
		pCode->dwNumOptimised++;

		// TODO: This should really TRUNC
		// This does the same as R4300.cpp, but it's possibly wrong
		SR_FP_S_TRUNC_W(dwFD, dwFS);
	}
*/

	return TRUE;
}

BOOL SR_Emit_Cop1_S_CEIL_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_CEIL_W);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_FLOOR_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Word_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_FLOOR_W);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_CVT_D(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Double_D(dwFD);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_CVT_D);
	}
	else
	{
		pCode->dwNumOptimised++;

		SR_FP_S_CVT_D(dwFD, dwFS);
	}
	return TRUE;
}

BOOL SR_Emit_Cop1_S_CVT_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Word_D(dwFD);


	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_CVT_W);
	}
	else
	{
		pCode->dwNumOptimised++;

		SR_FP_S_CVT_W(dwFD, dwFS);
	}

	return TRUE;
}




BOOL SR_Emit_Cop1_S_CVT_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	pCode->Stat_Single_S(dwFS);
	pCode->Stat_Long_D(dwFD);

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_CVT_L);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_F(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_F);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_UN(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_UN);
	return TRUE;
}


BOOL SR_Emit_Cop1_S_UEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_UEQ);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_OLT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_OLT);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_ULT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_ULT);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_OLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_OLE);
	return TRUE;
}


BOOL SR_Emit_Cop1_S_ULE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_ULE);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_SF(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_SF);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_NGLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_NGLE);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_SEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_SEQ);
	return TRUE;
}

BOOL SR_Emit_Cop1_S_NGL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_NGL);
	return TRUE;
}


BOOL SR_Emit_Cop1_S_EQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	
	pCode->Stat_Single_S_S(dwFS, dwFT);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_EQ);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs == ft?
		SR_FP_C(dwFS, dwFT, FLAG_C_EQ, FP_SINGLE);
	}

	return TRUE;
}


BOOL SR_Emit_Cop1_S_LT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	
	pCode->Stat_Single_S_S(dwFS, dwFT);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_LT);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs < ft?
		SR_FP_C(dwFS, dwFT, FLAG_C_LT, FP_SINGLE);

	}

	return TRUE;
}


BOOL SR_Emit_Cop1_S_LE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFT = R4300_FT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);
	
	pCode->Stat_Single_S_S(dwFS, dwFT);

	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_LE);
	}
	else
	{
		pCode->dwNumOptimised++;

		// fs <= ft?
		SR_FP_C(dwFS, dwFT, FLAG_C_LE, FP_SINGLE);
	}

	return TRUE;
}

BOOL SR_Emit_Cop1_S_NGE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_NGE);
	return TRUE;
}



BOOL SR_Emit_Cop1_S_NGT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	pCode->Stat_Single_Unk();

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_S_NGT);
	return TRUE;
}






// Notice source is Word, dest is single!
BOOL SR_Emit_Cop1_W_CVT_S(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1_S
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwFD = R4300_FD(dwOp);

	//pCode->Stat_Word_S(dwFS);
	//pCode->Stat_Single_D(dwFD);
	pCode->Stat_Single_D_S(dwFD, dwFS);


	if (SR_COP1_S_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_W_CVT_S);
	}
	else
	{
		pCode->dwNumOptimised++;

		SR_FP_W_CVT_S(dwFD, dwFS);

	}
	return TRUE;
}