#define SR_COP1_OPTIMISE_FLAG		(pCode->dwOptimiseLevel < 1)
//#define SR_COP1_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_COP1		//return FALSE;

BOOL SR_Emit_Cop1_MFC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);

	pCode->Stat_D(dwRT);
	pCode->Stat_Single_S(dwFS);
	
	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_MFC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Simulate SR_FP stuff
		SR_FP_MFC1(dwFS);


		// MFC1 in the manual says this is a sign-extended result
		//g_qwGPR[dwRT] = (s64)(s32)LoadFPR_Word(dwFS);

		// Get value from fp reg
		pCode->MOV_REG_MEM(EAX_CODE, &g_qwCPR[1][dwFS]);

		StoreMIPSLo(pCode, dwRT, EAX_CODE);
		pCode->SARI(EAX_CODE, 31);		
		StoreMIPSHi(pCode, dwRT, EAX_CODE);
	}
	return TRUE;
}


BOOL SR_Emit_Cop1_MTC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1
	const u32 dwRT = R4300_RT(dwOp);
	const u32 dwFS = R4300_FS(dwOp);

	pCode->Stat_S(dwRT);
	pCode->Stat_Single_D(dwFS);

	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_MTC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Manual says top bits undefined after load
		//StoreFPR_Word(dwFS, (s32)g_qwGPR[dwRT]);

		// Simulate SR_FP stuff
		SR_FP_MTC1(dwFS);

		REGCODE iReg = GetMIPSCachedReg( dwRT );

		// Optimisation - avoid reg->reg copy by moving value directly!
		if (iReg != INVALID_CODE && IsMIPSValid( dwRT ))
		{
			DPF(DEBUG_DYNREC, "  ++ Using value direct from cahced reg...\\/");
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFS], iReg);
		}
		else
		{
			LoadMIPSLo(pCode, EAX_CODE, dwRT);
			pCode->MOV_MEM_REG(&g_qwCPR[1][dwFS], EAX_CODE);
		}

	}
	return TRUE;
}


BOOL SR_Emit_Cop1_CFC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwRT = R4300_RT(dwOp);

	pCode->Stat_D(dwRT);

	// Uses CCR reg
	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_CFC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Only defined for reg 0 or 31
		if (dwFS == 0 || dwFS == 31)
		{
			// Just do Lo load/store - high bits not valid
			//g_qwGPR[dwRT] = (s64)(s32)g_qwCCR[1][dwFS];

			REGCODE iCachedReg;

			iCachedReg = GetMIPSCachedReg( dwRT );
			if (iCachedReg != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Optimising for cached value");
				pCode->MOV_REG_MEM(iCachedReg, &g_qwCCR[1][dwFS]);	

				MarkMIPSAsDirty( dwRT, TRUE );
				MarkMIPSAsValid( dwRT, TRUE );
			}
			else
			{
				pCode->MOV_REG_MEM(EAX_CODE, &g_qwCCR[1][dwFS]);	
				
				StoreMIPSLo(pCode, dwRT, EAX_CODE);
			}
			
		}
		else
		{
			// Ignore!
		}

	}
	return TRUE;
}


BOOL SR_Emit_Cop1_CTC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_COP1
	const u32 dwFS = R4300_FS(dwOp);
	const u32 dwRT = R4300_RT(dwOp);

	pCode->Stat_S(dwRT);
	// USes CCR

	if (SR_COP1_OPTIMISE_FLAG)
	{
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_Cop1_CTC1);
	}
	else
	{
		pCode->dwNumOptimised++;

		// Only defined for reg 0 or 31
		if (dwFS == 0 || dwFS == 31)
		{
			// Just do Lo load/store - high bits not valid
			//g_qwCCR[1][dwFS] = g_qwGPR[dwRT];
			REGCODE iCachedReg;

			iCachedReg = GetMIPSCachedReg( dwRT );
			if (iCachedReg != INVALID_CODE)
			{
				EnsureCachedValidLo(pCode, dwRT);

				DPF(DEBUG_DYNREC, "  ++ Optimising for cached value");
				pCode->MOV_MEM_REG(&g_qwCCR[1][dwFS], iCachedReg);	
			}
			else
			{
				LoadMIPSLo(pCode, EAX_CODE, dwRT);
				pCode->MOV_MEM_REG(&g_qwCCR[1][dwFS], EAX_CODE);
			}
			
		}
		else
		{
			// Ignore!
		}

	}
	return TRUE;
}
