#define SR_BRANCH_OPTIMISE_FLAG		(pCode->dwOptimiseLevel < 1)
//#define SR_BRANCH_OPTIMISE_FLAG		1

#define TEST_DISABLE_SR_BRANCH		//return FALSE;


BOOL SR_Emit_J(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// No registers modified!

	*pdwFlags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	SetVar32(g_dwPC, pCode->dwStartPC + (pCode->dwNumOps*4));

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_J);
	return TRUE;
}

BOOL SR_Emit_JAL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	pCode->Stat_D(REG_ra);
	
	*pdwFlags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	SetVar32(g_dwPC, pCode->dwStartPC + (pCode->dwNumOps*4));

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_JAL);
	return TRUE;
}



BOOL SR_Emit_Special_JR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	const u32 dwRS = R4300_RS(dwOp);

	pCode->Stat_S(dwRS);

	*pdwFlags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	SetVar32(g_dwPC, pCode->dwStartPC + (pCode->dwNumOps*4));

	// We use this, rather than R4300_Special_JR because this op is hacked
	// to allow us to detect when the rom jumps to the game boot 
	// address (so that we can apply the patches).
	// The special version of this op patches the "normal" version of
	// the op back intot he jump talbe after the patches
	// have been applied
	SR_Emit_Generic_R4300(pCode, dwOp, R4300SpecialInstruction[OP_JR]);
	return TRUE;

}

BOOL SR_Emit_Special_JALR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	const u32 dwRS = R4300_RS(dwOp);
	const u32 dwRD = R4300_RD(dwOp);

	pCode->Stat_D_S(dwRD, dwRS);

	*pdwFlags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	SetVar32(g_dwPC, pCode->dwStartPC + (pCode->dwNumOps*4));

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_Special_JALR);
	return TRUE;
}




BOOL SR_Emit_BEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const u32 dwRS = R4300_RS(dwOp);
	const u32 dwRT = R4300_RT(dwOp);
	s32  nOffset = (s32)(s16)R4300_IMM(dwOp);

	if (nOffset == -1)
		return FALSE;

	*pdwFlags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S_S(dwRS, dwRT);

	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;

	
	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		SetVar32(g_dwPC, dwCurrPC);

		SR_Emit_Generic_R4300(pCode, dwOp, R4300_BEQ);

	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common for BEQs
			DPF(DEBUG_DYNREC, "!!Detected block-referential BEQ jump!");

			// Get the next op:
			*pdwFlags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*pdwFlags |= SR_FLAGS_HANDLE_BRANCH;

		// Perform the comparison - use cached regs if possible
		if (dwRS == dwRT)
		{
			DPF(DEBUG_DYNREC, "  ++ Optimizing for branch always taken...\\/");		
			// Branch is always taken
			SetVar32(g_dwNewPC, dwJumpPC);			// 10 bytes
			//CPU_Delay();		// Warning- this macro might change in future!
			SetVar32(g_nDelay, DO_DELAY);			// 10 bytes
	
		}
		else if (dwRT == REG_r0)	// dwRS rarely seems to be 0
		{
			DPF(DEBUG_DYNREC, "  ++ Comparing against constant 0...\\/");		

			REGCODE iReg = GetMIPSCachedReg( dwRS );
			if (iReg != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg...\\/");			
				// Make sure it's loaded
				EnsureCachedValidLo(pCode, dwRS);
				pCode->CMPI(iReg, 0);
			}
			else
			{
				LoadMIPSLo(pCode, EAX_CODE, dwRS);
				pCode->CMPI(EAX_CODE, 0);
			}
			pCode->JNE(10 + 10);
			SetVar32(g_dwNewPC, dwJumpPC);			// 10 bytes
			//CPU_Delay();		// Warning- this macro might change in future!
			SetVar32(g_nDelay, DO_DELAY);			// 10 bytes
			
		}
		else
		{
			REGCODE iRegS = GetMIPSCachedReg( dwRS );
			REGCODE iRegT = GetMIPSCachedReg( dwRT );

			if (iRegS != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg for RS...\\/");			
				EnsureCachedValidLo(pCode, dwRS);
			}
			else
			{
				LoadMIPSLo(pCode, EAX_CODE, dwRS);	
				iRegS = EAX_CODE;
			}

			if (iRegT != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg for RT...\\/");			
				EnsureCachedValidLo(pCode, dwRT);
			}
			else
			{
				LoadMIPSLo(pCode, EDX_CODE, dwRT);
				iRegT = EDX_CODE;
			}

			pCode->CMP(iRegS, iRegT);
			pCode->JNE(10 + 10);
			SetVar32(g_dwNewPC, dwJumpPC);			// 10 bytes
			//CPU_Delay();		// Warning- this macro might change in future!
			SetVar32(g_nDelay, DO_DELAY);			// 10 bytes
		}
		


	}

	return TRUE;
}

BOOL SR_Emit_BNE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const u32 dwRS = R4300_RS(dwOp);
	const u32 dwRT = R4300_RT(dwOp);
	const s32 nOffset = (s32)(s16)R4300_IMM(dwOp);

	
	if (nOffset == -1)
		return FALSE;

	*pdwFlags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S_S(dwRS, dwRT);
	
	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;
	
	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		SetVar32(g_dwPC, dwCurrPC);

		SR_Emit_Generic_R4300(pCode, dwOp, R4300_BNE);

	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common
			DPF(DEBUG_DYNREC, "!!Detected block-referential BNE jump!");

			// Get the next op:
			*pdwFlags |= SR_FLAGS_BRANCHES_TO_START;
		}


		*pdwFlags |= SR_FLAGS_HANDLE_BRANCH;

		// Perform the comparison - use cached regs if possible
		if (dwRT == REG_r0)	// dwRS rarely seems to be 0
		{
			DPF(DEBUG_DYNREC, "  ++ Comparing against constant 0...\\/");		

			REGCODE iReg = GetMIPSCachedReg( dwRS );
			if (iReg != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg...\\/");			
				// Make sure it's loaded
				EnsureCachedValidLo(pCode, dwRS);
				pCode->CMPI(iReg, 0);
			}
			else
			{
				LoadMIPSLo(pCode, EAX_CODE, dwRS);
				pCode->CMPI(EAX_CODE, 0);
			}
		}
		else
		{
			REGCODE iRegS = GetMIPSCachedReg( dwRS );
			REGCODE iRegT = GetMIPSCachedReg( dwRT );

			if (iRegS != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg for RS...\\/");			
				EnsureCachedValidLo(pCode, dwRS);
			}
			else
			{
				LoadMIPSLo(pCode, EAX_CODE, dwRS);	
				iRegS = EAX_CODE;
			}

			if (iRegT != INVALID_CODE)
			{
				DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg for RT...\\/");			
				EnsureCachedValidLo(pCode, dwRT);
			}
			else
			{
				LoadMIPSLo(pCode, EDX_CODE, dwRT);
				iRegT = EDX_CODE;
			}

			pCode->CMP(iRegS, iRegT);
		}
		
		pCode->JE(10 + 10);
		SetVar32(g_dwNewPC, dwJumpPC);			// 10 bytes
		//CPU_Delay();		// Warning- this macro might change in future!
		SetVar32(g_nDelay, DO_DELAY);			// 10 bytes

		// Jump here if branch not taken

	}

	return TRUE;
}






BOOL SR_Emit_BLEZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const u32 dwRS = R4300_RS(dwOp);
	s32  nOffset = (s32)(s16)R4300_IMM(dwOp);
	
	if (nOffset == -1)
		return FALSE;

	*pdwFlags |= SR_FLAGS_BRANCHES;

	pCode->Stat_S(dwRS);
	
	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;

	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		SetVar32(g_dwPC, dwCurrPC);

		SR_Emit_Generic_R4300(pCode, dwOp, R4300_BLEZ);

	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common
			DPF(DEBUG_DYNREC, "!!Detected block-referential BLEZ jump!");

			// Get the next op:
			*pdwFlags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*pdwFlags |= SR_FLAGS_HANDLE_BRANCH;

		// Perform the comparison - use cached regs if possible
		REGCODE iReg = GetMIPSCachedReg( dwRS );

		if (iReg != INVALID_CODE)
		{
			DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg for RS...\\/");			
			EnsureCachedValidLo(pCode, dwRS);
		}
		else
		{
			LoadMIPSLo(pCode, EAX_CODE, dwRS);	
			iReg = EAX_CODE;
		}


		pCode->CMPI(iReg, 0);
		
		pCode->JG(10 + 10);	// Jump if NOT LE
		SetVar32(g_dwNewPC, dwJumpPC);			// 10 bytes
		//CPU_Delay();		// Warning- this macro might change in future!
		SetVar32(g_nDelay, DO_DELAY);			// 10 bytes

		// Jump here if branch not taken

	}


	return TRUE;
}

BOOL SR_Emit_BGTZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const u32 dwRS = R4300_RS(dwOp);
	s32  nOffset = (s32)(s16)R4300_IMM(dwOp);
	
	if (nOffset == -1)
		return FALSE;
	
	*pdwFlags |= SR_FLAGS_BRANCHES;
	
	pCode->Stat_S(dwRS);
	
	
	DWORD dwCurrPC = pCode->dwStartPC + (pCode->dwNumOps*4);
	DWORD dwJumpPC = dwCurrPC + (nOffset<<2) + 4;

	pCode->dwBranchTarget = dwJumpPC;

	if (SR_BRANCH_OPTIMISE_FLAG)
	{
		// Set PC = StartPC + NumOps * 4
		SetVar32(g_dwPC, dwCurrPC);
		SR_Emit_Generic_R4300(pCode, dwOp, R4300_BGTZ);
	}
	else
	{
		pCode->dwNumOptimised++;
		
		if (dwJumpPC == pCode->dwStartPC)
		{
			// This is very common
			DPF(DEBUG_DYNREC, "!!Detected block-referential BGTZ jump!");

			// Get the next op:
			*pdwFlags |= SR_FLAGS_BRANCHES_TO_START;
		}

		*pdwFlags |= SR_FLAGS_HANDLE_BRANCH;

		// Perform the comparison - use cached regs if possible
		REGCODE iReg = GetMIPSCachedReg( dwRS );

		if (iReg != INVALID_CODE)
		{
			DPF(DEBUG_DYNREC, "  ++ Comparing inplace using cached reg for RS...\\/");			
			EnsureCachedValidLo(pCode, dwRS);
		}
		else
		{
			LoadMIPSLo(pCode, EAX_CODE, dwRS);	
			iReg = EAX_CODE;
		}


		pCode->CMPI(iReg, 0);
		
		pCode->JLE(10 + 10);	// Jump if NOT G
		SetVar32(g_dwNewPC, dwJumpPC);			// 10 bytes
		//CPU_Delay();		// Warning- this macro might change in future!
		SetVar32(g_nDelay, DO_DELAY);			// 10 bytes

		// Jump here if branch not taken

	}

	return TRUE;
}



BOOL SR_Emit_RegImm_BLTZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const u32 dwRS = R4300_RS(dwOp);
	const s16 wOffset = (s16)R4300_IMM(dwOp);

	if (wOffset == -1)
		return FALSE;

	pCode->Stat_S(dwRS);

	*pdwFlags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	SetVar32(g_dwPC, pCode->dwStartPC + (pCode->dwNumOps*4));

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_RegImm_BLTZ);
	return TRUE;
}

BOOL SR_Emit_RegImm_BGEZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags)
{
TEST_DISABLE_SR_BRANCH
	// Only emit this operation if SpeedHack will not be executed
	const u32 dwRS = R4300_RS(dwOp);
	const s16 wOffset = (s16)R4300_IMM(dwOp);

	if (wOffset == -1)
		return FALSE;

	pCode->Stat_S(dwRS);
	
	*pdwFlags |= SR_FLAGS_BRANCHES;

	// Set PC = StartPC + NumOps * 4
	SetVar32(g_dwPC, pCode->dwStartPC + (pCode->dwNumOps*4));

	SR_Emit_Generic_R4300(pCode, dwOp, R4300_RegImm_BGEZ);
	return TRUE;
}
