// DynarecCode.h: interface for the CDynarecCode class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DYNARECCODE_H__A08EE1AF_55F6_4EA0_BD36_FA1F711265D5__INCLUDED_)
#define AFX_DYNARECCODE_H__A08EE1AF_55F6_4EA0_BD36_FA1F711265D5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef void (* DynarecFunctionType)();

// Intel register codes. Odd ordering is for intel bytecode
enum REGCODE {
	INVALID_CODE = 0xFFFFFFFF,
	EAX_CODE = 0,
	ECX_CODE = 1,
	EDX_CODE = 2,
	EBX_CODE = 3,
	ESP_CODE = 4,
	EBP_CODE = 5,
	ESI_CODE = 6,
	EDI_CODE = 7
};



class CDynarecCode  
{
public:
	CDynarecCode(DWORD dwPC, DWORD dwOp);
	virtual ~CDynarecCode();


	void ResetStats();
	void DisplayRegStats();
public:
	union
	{
		DynarecFunctionType pF;			// Our compiled function
		BYTE *pCodeBuffer;
	};
	DWORD dwBuffSize;
	DWORD dwCurrentPos;			// CurrentWriting position in buffer

	DWORD dwStartPC;			// The starting PC of this code fragment
	DWORD dwEndPC;
	DWORD dwOriginalOp;			// The original opcode
	DWORD dwNumOps;				// Number of operations compiled into i386
	DWORD dwNumOptimised;		// Number of operations that have been optimised

	DWORD dwCount;				// The number of times the compiled code has been executed
	DWORD dwOptimiseLevel;		// The level of optimisation applied

	DWORD dwWarn;				// Set if one of the Emit instructions does not have enough space

	DWORD dwRegReads[32];		// #times used at src
	DWORD dwRegUpdates[32];		// #times used as dest
	DWORD dwRegBaseUse[32];		// #times used as base

	DWORD dwSRegReads[32];		// #times used at src
	DWORD dwSRegUpdates[32];	// #times used as dest
	
	DWORD dwDRegReads[32];		// #times used at src
	DWORD dwDRegUpdates[32];	// #times used as dest

	
	BOOL  bSpCachedInESI;		// Is sp cached in ESI?
	DWORD dwSetSpPostUpdate;	// Set Sp base counter after this update

	DWORD dwBranchTarget;		// Target address if we take the branch

	DWORD dwEntry;				// Entry into global array
	

	inline void EmitBYTE(BYTE byte)
	{
		pCodeBuffer[dwCurrentPos] = byte;
		dwCurrentPos++;
	}
	inline void EmitWORD(WORD word)
	{
		*(WORD *)(&pCodeBuffer[dwCurrentPos]) = word;
		dwCurrentPos += 2;
	}
	inline void EmitDWORD(DWORD dword)
	{
		*(DWORD *)(&pCodeBuffer[dwCurrentPos]) = dword;
		dwCurrentPos += 4;
	}
	///////////////////////////////////////////////////////////////////
	inline void CALL_EAX()
	{
		EmitWORD(0xd0ff);
	}

	inline void RET()
	{
		EmitBYTE(0xC3);
	}

	// I sometimes use this to force an exceptions so I can analyse the generated code
	inline void CRASH(DWORD x)
	{
		EmitWORD(0x05c7);
		EmitDWORD(0x00000000); 
		EmitDWORD(x); //c7 05 xx+0 xx xx xx ef be ad de
	}


	///////////////////////////////////////////////////////////////////

	inline void MOV(REGCODE reg1, REGCODE reg2)
	{
		if (reg1 != reg2)
		{
			EmitBYTE(0x8b);
			EmitBYTE(0xc0 | (reg1<<3) | reg2);
		}
	}
	inline void MOV_REG_MEM(REGCODE reg, void * mem)
	{
		/*if (reg == EAX_CODE)
			EmitBYTE(0xa1);
		else*/
		{
			EmitBYTE(0x8b);
			EmitBYTE((reg<<3) | 0x05);
		}
		
		EmitDWORD((DWORD)mem);
	}


	inline void MOV_MEM_REG(void * mem, REGCODE reg)
	{
		/*if (reg == EAX_CODE)
			EmitBYTE(0xa3);
		else*/
		{
			EmitBYTE(0x89);
			EmitBYTE((reg<<3) | 0x05);
		}
		EmitDWORD((DWORD)mem);
	}

	inline void MOVI(REGCODE reg, DWORD data)
	{
		EmitBYTE(0xB8 | reg);
		EmitDWORD(data);
	}

	inline void MOVI_MEM(void * mem, DWORD data)
	{
		EmitWORD(0x05C7);
		EmitDWORD((DWORD)mem);
		EmitDWORD(data);
	}


	///////////////////////////////////////////////////////////////////
	inline void PUSH(REGCODE reg)
	{
		EmitBYTE(0x50 | reg);
	}
	inline void POP(REGCODE reg)
	{
		EmitBYTE(0x58 | reg);
	}

	///////////////////////////////////////////////////////////////////
	inline void CMP(REGCODE reg1, REGCODE reg2)
	{
		EmitBYTE(0x3b);
		EmitBYTE(0xc0 | (reg1<<3) | reg2);
	}
	inline void TEST(REGCODE reg1, REGCODE reg2)
	{
		EmitBYTE(0x85);
		EmitBYTE(0xc0 | (reg1<<3) | reg2);
	}


	inline void CMPI(REGCODE reg, DWORD data)
	{
		EmitBYTE(0x81);
		EmitBYTE(0xf8 | reg);
		EmitDWORD(data);
	}

	inline void SETL(REGCODE reg)
	{
		EmitWORD(0x9c0f);
		EmitBYTE(0xc0 | reg);
	}
	inline void SETB(REGCODE reg)
	{
		EmitWORD(0x920f);
		EmitBYTE(0xc0 | reg);
	}

	///////////////////////////////////////////////////////////////////
	inline void JA(BYTE off)
	{
		EmitWORD((off<<8) | 0x77);
	}
	inline void JB(BYTE off)
	{
		EmitWORD((off<<8) | 0x72);
	}
	inline void JAE(BYTE off)
	{
		EmitWORD((off<<8) | 0x73);
	}
	inline void JE(BYTE off)
	{
		EmitWORD((off<<8) | 0x74);
	}
	inline void JNE(BYTE off)
	{
		EmitWORD((off<<8) | 0x75);
	}
	inline void JL(BYTE off)
	{
		EmitWORD((off<<8) | 0x7C);
	}
	inline void JGE(BYTE off)
	{
		EmitWORD((off<<8) | 0x7D);
	}
	inline void JLE(BYTE off)
	{
		EmitWORD((off<<8) | 0x7E);
	}
	inline void JG(BYTE off)
	{
		EmitWORD((off<<8) | 0x7F);
	}

	inline void JMP(BYTE off)
	{
		EmitWORD((off<<8) | 0xeb);
	}

	inline void JMP_DIRECT(DWORD off)
	{
		EmitBYTE(0xe9);
		EmitDWORD((DWORD)off);
	}



	///////////////////////////////////////////////////////////////////
	inline void AND(REGCODE reg1, REGCODE reg2)
	{
		if (reg1 != reg2)
		{
			EmitBYTE(0x23);
			EmitBYTE(0xc0 | (reg1<<3) | reg2);
		}
	}
	inline void OR(REGCODE reg1, REGCODE reg2)
	{
		if (reg1 != reg2)
		{
			EmitBYTE(0x0B);
			EmitBYTE(0xc0 | (reg1<<3) | reg2);
		}
	}

	inline void XOR(REGCODE reg1, REGCODE reg2)
	{
		EmitBYTE(0x33);
		EmitBYTE(0xc0 | (reg1<<3) | reg2);
	}


	inline void ANDI(REGCODE reg, DWORD data)
	{
		/*if (reg == EAX_CODE)
			EmitBYTE(0x25);
		else */
		{
			EmitBYTE(0x81);
			EmitBYTE(0xe0 | reg);
		}
		EmitDWORD(data);
	}
	inline void ORI(REGCODE reg, DWORD data)
	{
		/*if (reg == EAX_CODE)
			EmitBYTE(0x0D);
		else*/
		{
			EmitBYTE(0x81);
			EmitBYTE(0xc8 | reg);
		}
		EmitDWORD(data);
	}
	inline void XORI(REGCODE reg, DWORD data)
	{
		/*if (reg == EAX_CODE)
			EmitBYTE(0x35);
		else */
		{
			EmitBYTE(0x81);
			EmitBYTE(0xf0 | reg);
		}
		EmitDWORD(data);
	}



	inline void NOT(REGCODE reg1)
	{
		EmitBYTE(0xf7);
		EmitBYTE(0xd0 | reg1);
	}

	inline void SHLI(REGCODE reg, BYTE sa)
	{
		EmitBYTE(0xc1);
		EmitBYTE(0xe0 | reg);
		EmitBYTE(sa);
	}
	inline void SHRI(REGCODE reg, BYTE sa)
	{
		EmitBYTE(0xc1);
		EmitBYTE(0xe8 | reg);
		EmitBYTE(sa);
	}
	inline void SARI(REGCODE reg, BYTE sa)
	{
		EmitBYTE(0xc1);
		EmitBYTE(0xf8 | reg);
		EmitBYTE(sa);
	}


	///////////////////////////////////////////////////////////////////
	inline void ADD(REGCODE reg1, REGCODE reg2)
	{
		EmitBYTE(0x03);
		EmitBYTE(0xc0 | (reg1<<3) | reg2);
	}

	inline void SUB(REGCODE reg1, REGCODE reg2)
	{
		EmitBYTE(0x2b);
		EmitBYTE(0xc0 | (reg1<<3) | reg2);
	}


	inline void MUL(REGCODE reg) 
	{
		EmitBYTE(0xf7);
		EmitBYTE(0xe0 | reg);
	}
	inline void MUL_EAX_MEM(void * mem)
	{
		EmitBYTE(0xf7);
		EmitBYTE(0x25); 
		EmitDWORD((DWORD)mem);
	}


	inline void ADDI(REGCODE reg, LONG data) 
	{
		if (data == 0)
			return;

		/*if (reg == EAX_CODE)
			EmitBYTE(0x05);
		else */
		{
			EmitBYTE(0x81);
			EmitBYTE(0xc0 | reg);
		}
		EmitDWORD(data);
	}

	// Use short form (0x83d0) if data is just one byte!
	inline void ADCI(REGCODE reg, LONG data)
	{
		/*if (reg == EAX_CODE)
		{
			EmitBYTE(0x15);
			EmitDWORD(data)
		}
		else*/
		if (data <= 127 && data > -127)
		{
			EmitBYTE(0x83);
			EmitBYTE(0xd0 | reg);
			EmitBYTE((BYTE)(data));
		}
		else
		{
			EmitBYTE(0x81);
			EmitBYTE(0xd0 | reg);
			EmitDWORD(data);
		}
	}


	///////////////////////////////////////////////////////////////////
	inline void FSQRT()
	{
		EmitWORD(0xfad9);
	}
	inline void FCHS()
	{
		EmitWORD(0xe0d9);
	}


	//*****************************************************************************
	// Statistics
	//*****************************************************************************
	
	inline void Stat_D_S_S( u32 d, u32 s1, u32 s2)
	{
		dwRegUpdates[d]++;
		dwRegReads[s1]++;
		dwRegReads[s2]++;	 
	}

	inline void Stat_D_S( u32 d, u32 s)
	{
		dwRegUpdates[d]++;
		dwRegReads[s]++; 
	}

	inline void Stat_D( u32 d)
	{
		dwRegUpdates[d]++;
	}

	inline void Stat_S( u32 s)
	{
		dwRegReads[s]++;
	}

	inline void Stat_S_S( u32 s1, u32 s2)
	{
		dwRegReads[s1]++;
		dwRegReads[s2]++;
	}

	inline void Stat_Base( u32 b)
	{
		dwRegBaseUse[b]++; 
	}

	inline void Stat_Load_B_D( u32 b, u32 d)
	{
		dwRegBaseUse[b]++;
		dwRegUpdates[d]++;
	}

	inline void Stat_Load_B( u32 b)
	{
		dwRegBaseUse[b]++;
	}
	
	inline void Stat_Save_B_S( u32 b, u32 s)
	{
		dwRegBaseUse[b]++;
		dwRegReads[s]++;
	}

	inline void Stat_Save_B( u32 b)
	{
		dwRegBaseUse[b]++;
	}


	inline void Stat_Long_D(u32 d)
	{
	}
	inline void Stat_Word_D(u32 d)
	{
	}

	inline void Stat_Single_Unk()
	{
	}

	inline void Stat_Single_D_S_S(u32 d, u32 s1, u32 s2)
	{
		dwSRegUpdates[d]++;
		dwSRegReads[s1]++;
		dwSRegReads[s2]++;
	}

	inline void Stat_Single_D_S(u32 d, u32 s)
	{
		dwSRegUpdates[d]++;
		dwSRegReads[s]++;
	}

	inline void Stat_Single_S_S(u32 s1, u32 s2)
	{
		dwSRegReads[s1]++;
		dwSRegReads[s2]++;
	}
	
	inline void Stat_Single_D(u32 d)
	{
		dwSRegUpdates[d]++;
	}

	inline void Stat_Single_S(u32 s)
	{
		dwSRegReads[s]++;
	}

	inline void Stat_Double_Unk()
	{
	}

	inline void Stat_Double_D_S_S(u32 d, u32 s1, u32 s2)
	{
		dwDRegUpdates[d]++;
		dwDRegReads[s1]++;
		dwDRegReads[s2]++;	 
	}

	inline void Stat_Double_D_S(u32 d, u32 s)
	{
		dwDRegUpdates[d]++;
		dwDRegReads[s]++;
	}

	inline void Stat_Double_S_S(u32 s1, u32 s2)
	{
		dwDRegReads[s1]++;
		dwDRegReads[s2]++;
	}

	inline void Stat_Double_D(u32 d)
	{
		dwDRegUpdates[d]++;
	}

	inline void Stat_Double_S(u32 s)
	{
		dwDRegReads[s]++;
	}





};

#endif // !defined(AFX_DYNARECCODE_H__A08EE1AF_55F6_4EA0_BD36_FA1F711265D5__INCLUDED_)
