/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

static BOOL SR_Emit_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_DBG_BreakPoint(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SRHack_UnOpt(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SRHack_Opt(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SRHack_NoOpt(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_J(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_JAL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BNE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BLEZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BGTZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_ADDI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_ADDIU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SLTI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SLTIU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_ANDI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_ORI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_XORI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LUI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_CoPro0(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_CoPro1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BEQL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BNEL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BLEZL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_BGTZL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_DADDI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_DADDIU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LDL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LDR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_LB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LH(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LWL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LW(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LBU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LHU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LWR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LWU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_SB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SH(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SWL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SW(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SDL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SDR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SWR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_CACHE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_LL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LWC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LLD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LDC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LDC2(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_LD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_SC(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SWC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SCD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SDC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SDC2(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_SD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SLL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SRL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SRA(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SLLV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SRLV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SRAV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_JR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_JALR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SYSCALL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_BREAK(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SYNC(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_MFHI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_MTHI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_MFLO(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_MTLO(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSLLV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSRLV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSRAV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_MULT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_MULTU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DIV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DIVU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DMULT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DMULTU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DDIV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DDIVU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_ADD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_ADDU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SUB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SUBU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_AND(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_OR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_XOR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_NOR(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_SLT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_SLTU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DADD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DADDU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSUB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSUBU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_TGE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_TGEU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_TLT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_TLTU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_TEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_TNE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Special_DSLL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSRL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSRA(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSLL32(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSRL32(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Special_DSRA32(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);


static BOOL SR_Emit_RegImm_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BLTZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BGEZ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BLTZL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BGEZL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_RegImm_TGEI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_TGEIU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_TLTI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_TLTIU(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_TEQI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_TNEI(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_RegImm_BLTZAL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BGEZAL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BLTZALL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_RegImm_BGEZALL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);


static BOOL SR_Emit_Cop0_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop0_MFC0(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop0_MTC0(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop0_TLB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_MFC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_DMFC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_CFC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_MTC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_DMTC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_CTC1(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_BCInstr(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_SInstr(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_DInstr(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_WInstr(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_LInstr(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);


static BOOL SR_BC1_BC1F(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_BC1_BC1T(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_BC1_BC1FL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_BC1_BC1TL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);


static BOOL SR_Emit_Cop1_S_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_ADD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_SUB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_MUL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_DIV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_SQRT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_ABS(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_MOV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_NEG(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_S_ROUND_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_TRUNC_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_CEIL_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_FLOOR_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_ROUND_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_TRUNC_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_CEIL_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_FLOOR_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_S_CVT_D(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_CVT_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_CVT_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_S_F(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_UN(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_EQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_UEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_OLT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_ULT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_OLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_ULE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_S_SF(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_NGLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_SEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_NGL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_LT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_NGE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_LE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_S_NGT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_D_Unk(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_ADD(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_SUB(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_MUL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_DIV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_SQRT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_ABS(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_MOV(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_NEG(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_D_ROUND_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_TRUNC_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_CEIL_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_FLOOR_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_ROUND_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_TRUNC_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_CEIL_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_FLOOR_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_D_CVT_S(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_CVT_W(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_CVT_L(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_D_F(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_UN(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_EQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_UEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_OLT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_ULT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_OLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_ULE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);

static BOOL SR_Emit_Cop1_D_SF(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_NGLE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_SEQ(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_NGL(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_LT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_NGE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_LE(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);
static BOOL SR_Emit_Cop1_D_NGT(CDynarecCode *pCode, DWORD dwOp, DWORD * pdwFlags);



// Opcode Jump Table
SR_EmitInstructionType SR_EmitInstruction[64] = {
	SR_Emit_Special, SR_Emit_RegImm, SR_Emit_J, SR_Emit_JAL, SR_Emit_BEQ, SR_Emit_BNE, SR_Emit_BLEZ, SR_Emit_BGTZ,
	SR_Emit_ADDI, SR_Emit_ADDIU, SR_Emit_SLTI, SR_Emit_SLTIU, SR_Emit_ANDI, SR_Emit_ORI, SR_Emit_XORI, SR_Emit_LUI,
	SR_Emit_CoPro0, SR_Emit_CoPro1, SR_Emit_Unk, SR_Emit_Unk, SR_Emit_BEQL, SR_Emit_BNEL, SR_Emit_BLEZL, SR_Emit_BGTZL,
	SR_Emit_DADDI, SR_Emit_DADDIU, SR_Emit_LDL, SR_Emit_LDR, /*SR_Emit_Patch*/SR_Emit_Unk, SR_Emit_SRHack_UnOpt, SR_Emit_SRHack_Opt, SR_Emit_SRHack_NoOpt,
	SR_Emit_LB, SR_Emit_LH, SR_Emit_LWL, SR_Emit_LW, SR_Emit_LBU, SR_Emit_LHU, SR_Emit_LWR, SR_Emit_LWU,
	SR_Emit_SB, SR_Emit_SH, SR_Emit_SWL, SR_Emit_SW, SR_Emit_SDL, SR_Emit_SDR, SR_Emit_SWR, SR_Emit_CACHE,
	SR_Emit_LL, SR_Emit_LWC1, SR_Emit_Unk, SR_Emit_Unk, SR_Emit_LLD, SR_Emit_LDC1, SR_Emit_LDC2, SR_Emit_LD,
	SR_Emit_SC, SR_Emit_SWC1, SR_Emit_DBG_BreakPoint, SR_Emit_Unk, SR_Emit_SCD, SR_Emit_SDC1, SR_Emit_SDC2, SR_Emit_SD
};

// SpecialOpCode Jump Table
SR_EmitInstructionType SR_EmitSpecialInstruction[64] = {
	SR_Emit_Special_SLL, SR_Emit_Special_Unk, SR_Emit_Special_SRL, SR_Emit_Special_SRA, SR_Emit_Special_SLLV, SR_Emit_Special_Unk, SR_Emit_Special_SRLV, SR_Emit_Special_SRAV,
	SR_Emit_Special_JR, SR_Emit_Special_JALR, SR_Emit_Special_Unk, SR_Emit_Special_Unk, SR_Emit_Special_SYSCALL, SR_Emit_Special_BREAK, SR_Emit_Special_Unk, SR_Emit_Special_SYNC,
	SR_Emit_Special_MFHI, SR_Emit_Special_MTHI, SR_Emit_Special_MFLO, SR_Emit_Special_MTLO, SR_Emit_Special_DSLLV, SR_Emit_Special_Unk, SR_Emit_Special_DSRLV, SR_Emit_Special_DSRAV,
	SR_Emit_Special_MULT, SR_Emit_Special_MULTU, SR_Emit_Special_DIV, SR_Emit_Special_DIVU, SR_Emit_Special_DMULT, SR_Emit_Special_DMULTU, SR_Emit_Special_DDIV, SR_Emit_Special_DDIVU,
	SR_Emit_Special_ADD, SR_Emit_Special_ADDU, SR_Emit_Special_SUB, SR_Emit_Special_SUBU, SR_Emit_Special_AND, SR_Emit_Special_OR, SR_Emit_Special_XOR, SR_Emit_Special_NOR,
	SR_Emit_Special_Unk, SR_Emit_Special_Unk, SR_Emit_Special_SLT, SR_Emit_Special_SLTU, SR_Emit_Special_DADD, SR_Emit_Special_DADDU, SR_Emit_Special_DSUB, SR_Emit_Special_DSUBU,
	SR_Emit_Special_TGE, SR_Emit_Special_TGEU, SR_Emit_Special_TLT, SR_Emit_Special_TLTU, SR_Emit_Special_TEQ, SR_Emit_Special_Unk, SR_Emit_Special_TNE, SR_Emit_Special_Unk,
	SR_Emit_Special_DSLL, SR_Emit_Special_Unk, SR_Emit_Special_DSRL, SR_Emit_Special_DSRA, SR_Emit_Special_DSLL32, SR_Emit_Special_Unk, SR_Emit_Special_DSRL32, SR_Emit_Special_DSRA32
};

// RegImmOpCode Jump Table
SR_EmitInstructionType SR_EmitRegImmInstruction[32] = {
	SR_Emit_RegImm_BLTZ,   SR_Emit_RegImm_BGEZ,   SR_Emit_RegImm_BLTZL,   SR_Emit_RegImm_BGEZL,   SR_Emit_RegImm_Unk,  SR_Emit_RegImm_Unk, SR_Emit_RegImm_Unk,  SR_Emit_RegImm_Unk,
	SR_Emit_RegImm_TGEI,   SR_Emit_RegImm_TGEIU,  SR_Emit_RegImm_TLTI,    SR_Emit_RegImm_TLTIU,   SR_Emit_RegImm_TEQI, SR_Emit_RegImm_Unk, SR_Emit_RegImm_TNEI, SR_Emit_RegImm_Unk,
	SR_Emit_RegImm_BLTZAL, SR_Emit_RegImm_BGEZAL, SR_Emit_RegImm_BLTZALL, SR_Emit_RegImm_BGEZALL, SR_Emit_RegImm_Unk,  SR_Emit_RegImm_Unk, SR_Emit_RegImm_Unk,  SR_Emit_RegImm_Unk,
	SR_Emit_RegImm_Unk,    SR_Emit_RegImm_Unk,    SR_Emit_RegImm_Unk,     SR_Emit_RegImm_Unk,     SR_Emit_RegImm_Unk,  SR_Emit_RegImm_Unk, SR_Emit_RegImm_Unk,  SR_Emit_RegImm_Unk
};

// COP0 Jump Table
SR_EmitInstructionType SR_EmitCop0Instruction[32] = {
	SR_Emit_Cop0_MFC0, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_MTC0, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk,
	SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk,
	SR_Emit_Cop0_TLB, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk,
	SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk, SR_Emit_Cop0_Unk,
};


// COP1 Jump Table
SR_EmitInstructionType SR_EmitCop1Instruction[32] = {
	SR_Emit_Cop1_MFC1,    SR_Emit_Cop1_DMFC1,  SR_Emit_Cop1_CFC1, SR_Emit_Cop1_Unk, SR_Emit_Cop1_MTC1,   SR_Emit_Cop1_DMTC1,  SR_Emit_Cop1_CTC1, SR_Emit_Cop1_Unk,
	SR_Emit_Cop1_BCInstr, SR_Emit_Cop1_Unk,    SR_Emit_Cop1_Unk,  SR_Emit_Cop1_Unk, SR_Emit_Cop1_Unk,    SR_Emit_Cop1_Unk,    SR_Emit_Cop1_Unk,  SR_Emit_Cop1_Unk,
	SR_Emit_Cop1_SInstr,  SR_Emit_Cop1_DInstr, SR_Emit_Cop1_Unk,  SR_Emit_Cop1_Unk, SR_Emit_Cop1_WInstr, SR_Emit_Cop1_LInstr, SR_Emit_Cop1_Unk,  SR_Emit_Cop1_Unk,
	SR_Emit_Cop1_Unk,     SR_Emit_Cop1_Unk,    SR_Emit_Cop1_Unk,  SR_Emit_Cop1_Unk, SR_Emit_Cop1_Unk,    SR_Emit_Cop1_Unk,    SR_Emit_Cop1_Unk,  SR_Emit_Cop1_Unk
};

SR_EmitInstructionType SR_EmitCop1BC1Instruction[4] = {
	SR_BC1_BC1F, SR_BC1_BC1T, SR_BC1_BC1FL, SR_BC1_BC1TL
};


// Single Jump Table
SR_EmitInstructionType SR_EmitCop1SInstruction[64] = {
	SR_Emit_Cop1_S_ADD,     SR_Emit_Cop1_S_SUB,     SR_Emit_Cop1_S_MUL,    SR_Emit_Cop1_S_DIV,     SR_Emit_Cop1_S_SQRT,    SR_Emit_Cop1_S_ABS,     SR_Emit_Cop1_S_MOV,    SR_Emit_Cop1_S_NEG,
	SR_Emit_Cop1_S_ROUND_L, SR_Emit_Cop1_S_TRUNC_L,	SR_Emit_Cop1_S_CEIL_L, SR_Emit_Cop1_S_FLOOR_L, SR_Emit_Cop1_S_ROUND_W, SR_Emit_Cop1_S_TRUNC_W, SR_Emit_Cop1_S_CEIL_W, SR_Emit_Cop1_S_FLOOR_W,
	SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk, 
	SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk, 
	SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_CVT_D,   SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_CVT_W,   SR_Emit_Cop1_S_CVT_L,   SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk,
	SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,     SR_Emit_Cop1_S_Unk,    SR_Emit_Cop1_S_Unk, 
	SR_Emit_Cop1_S_F,       SR_Emit_Cop1_S_UN,      SR_Emit_Cop1_S_EQ,     SR_Emit_Cop1_S_UEQ,     SR_Emit_Cop1_S_OLT,     SR_Emit_Cop1_S_ULT,     SR_Emit_Cop1_S_OLE,    SR_Emit_Cop1_S_ULE,
	SR_Emit_Cop1_S_SF,      SR_Emit_Cop1_S_NGLE,    SR_Emit_Cop1_S_SEQ,    SR_Emit_Cop1_S_NGL,     SR_Emit_Cop1_S_LT,      SR_Emit_Cop1_S_NGE,     SR_Emit_Cop1_S_LE,     SR_Emit_Cop1_S_NGT
};

// Double Jump Table
SR_EmitInstructionType SR_EmitCop1DInstruction[64] = {
	SR_Emit_Cop1_D_ADD,     SR_Emit_Cop1_D_SUB,     SR_Emit_Cop1_D_MUL, SR_Emit_Cop1_D_DIV, SR_Emit_Cop1_D_SQRT, SR_Emit_Cop1_D_ABS, SR_Emit_Cop1_D_MOV, SR_Emit_Cop1_D_NEG,
	SR_Emit_Cop1_D_ROUND_L, SR_Emit_Cop1_D_TRUNC_L,	SR_Emit_Cop1_D_CEIL_L, SR_Emit_Cop1_D_FLOOR_L, SR_Emit_Cop1_D_ROUND_W, SR_Emit_Cop1_D_TRUNC_W, SR_Emit_Cop1_D_CEIL_W, SR_Emit_Cop1_D_FLOOR_W,
	SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, 
	SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, 
	SR_Emit_Cop1_D_CVT_S,   SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_CVT_W, SR_Emit_Cop1_D_CVT_L, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk,
	SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk,     SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, SR_Emit_Cop1_D_Unk, 
	SR_Emit_Cop1_D_F,       SR_Emit_Cop1_D_UN,      SR_Emit_Cop1_D_EQ, SR_Emit_Cop1_D_UEQ, SR_Emit_Cop1_D_OLT, SR_Emit_Cop1_D_ULT, SR_Emit_Cop1_D_OLE, SR_Emit_Cop1_D_ULE,
	SR_Emit_Cop1_D_SF,      SR_Emit_Cop1_D_NGLE,    SR_Emit_Cop1_D_SEQ, SR_Emit_Cop1_D_NGL, SR_Emit_Cop1_D_LT, SR_Emit_Cop1_D_NGE, SR_Emit_Cop1_D_LE, SR_Emit_Cop1_D_NGT
};
