/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

#include "Debug.h"
#include "Dump.h"
#include "DBGConsole.h"


#ifdef DAEDALUS_LOG

BOOL	g_bLog = FALSE;

static DWORD	g_dwDebugWatch	= DEBUG_MEMORY_PIF;
static HANDLE	g_hOutputLog	= INVALID_HANDLE_VALUE;

HRESULT Debug_InitLogging()
{
	TCHAR szLogFileName[MAX_PATH+1];

	Dump_GetDumpDirectory(szLogFileName, TEXT(""));

	PathAppend(szLogFileName, TEXT("daedalus.txt"));

	g_hOutputLog = Debug_CreateDumpFile(szLogFileName);
	if (g_hOutputLog == INVALID_HANDLE_VALUE)
	{ 
		return E_FAIL;
	}

	return S_OK;
}

void Debug_FinishLogging()
{
	Debug_CloseDumpFile(g_hOutputLog);
}


void __cdecl Debug_Printf(DWORD dwDebugFlags, LPCTSTR szFormat, ...)
{
	if (g_bLog && (dwDebugFlags & g_dwDebugWatch))
	{
	    va_list va;

		va_start(va, szFormat);
		Debug_DumpLine(g_hOutputLog, szFormat, va);
		va_end(va);
	}
}
#endif // DAEDALUS_LOG



HANDLE Debug_CreateDumpFile(LPCTSTR szFileName)
{
	HANDLE hFile;
	DBGConsole_Msg(0, "Creating Dump file '%s'", szFileName);

	hFile = CreateFile(szFileName,		// open the file 
			GENERIC_WRITE,              // open for writing 
			0,                          // do not share 
			NULL,                       // no security 
			CREATE_ALWAYS,              // replace any existing file
			FILE_ATTRIBUTE_NORMAL,      // normal file 
			NULL);                      // no attr. template 

	return hFile;
}

void Debug_CloseDumpFile(HANDLE  & hFile)
{
	CloseHandle(hFile);
	hFile = INVALID_HANDLE_VALUE;
}

void Debug_DumpLine(HANDLE hFile, LPCTSTR szFormat, va_list va)
{
	DWORD dwNumWritten;
    TCHAR szBuffer[1000];

	// For float conversions, don't use wvsprintf
	vsprintf(szBuffer, szFormat, va);
	lstrcat(szBuffer, "\r\n");	
	WriteFile(hFile, szBuffer, lstrlen(szBuffer), &dwNumWritten, NULL);

}
