/*

  Copyright (C) 2001 StrmnNrmn

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __DAEDALUSASSERT_H__
#define __DAEDALUSASSERT_H__

// Ideas for the ignored assert taken from Game Programming Gems I


#ifdef _DEBUG

int DaedalusAssert( const CHAR * msg, const CHAR * file, UINT line );

#define DAEDALUS_ASSERT( e, msg )								\
{																\
	static bool ignore = false;									\
	if ( !e && !ignore )										\
	{															\
		int i = DaedalusAssert( msg, __FILE__, __LINE__ );		\
		if ( i == 1 )											\
		{														\
			__asm { int 3 }	/* User breakpoint */				\
		}														\
		else if ( i == 0 )										\
		{														\
			ignore = true;	/* Ignore throughout session */		\
		}														\
	}															\
}

#else
#define DAEDALUS_ASSERT( e, msg )
#endif

#endif // __DAEDALUSASSERT_H__