/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __R4300_REGS_H__
#define __R4300_REGS_H__

#include <windows.h>

#include "DaedalusTypes.h"

#pragma pack(push, 1)
struct TLBEntry
{
	u32 pagemask, hi, pfne, pfno;

	// For speed/convenience
	u32 mask, mask2;			// Mask, Mask/2
	u32 vpnmask, vpn2mask;	// Vpn Mask, VPN/2 Mask
	u32 pfnohi, pfnehi;		// Even/Odd highbits
	u32 g, checkbit;

	u32 addrcheck;			// vpn2 & vpnmask
	u32 lastaccessed;			// for least recently used algorithm

	u32 padding1, padding2; // ensures 64-byte size and thus alignment
};

typedef u64 register_set[32];

#ifndef DAEDALUS_RELEASE_BUILD
extern u32	g_dwPC;
extern u64	g_qwMultHI;
extern u64	g_qwMultLO;
extern u64	g_qwFCR0;
extern u64	g_qwFCR1;
extern u32	g_bLLbit;

extern u32	g_dwNewPC;
extern u64	g_qwGPR[32];
extern u64	g_qwCPR[3][32];
extern u64	g_qwCCR[3][32];
extern TLBEntry g_TLBs[32];
extern u32		g_nDelay;
extern u8		*g_pPCMemBase;

#define g_qwCPR0 (g_qwCPR[0])
#define g_qwCPR1 (g_qwCPR[1])
#define g_qwCCR1 (g_qwCCR[1])

#else /* DAEDALUS_RELEASE_BUILD */

// types are layed out in decreasing order of size
ALIGNED_TYPE(struct registers_struct_t, PAGE_ALIGN)
{
	TLBEntry	 _g_TLBs[32];
	register_set _g_qwGPR;
	register_set _g_qwCPR0;
	register_set _g_qwCPR1;
	register_set _g_qwCCR1;
	u64			 _g_qwMultLO;
	u64			 _g_qwMultHI;
	u32			 _g_dwPC;
	u32			 _g_dwNewPC;
	u32			 _g_nDelay;
	u8*			 _g_pPCMemBase;
	u32			 _g_bLLbit;
};

ALIGNED_EXTERN(registers_struct_t, registers_struct, PAGE_ALIGN);

#define g_TLBs (registers_struct._g_TLBs)
#define g_dwPC (registers_struct._g_dwPC)
#define g_dwNewPC (registers_struct._g_dwNewPC)
#define g_nDelay (registers_struct._g_nDelay)
#define g_qwGPR (registers_struct._g_qwGPR)
#define g_qwCPR0 (registers_struct._g_qwCPR0)
#define g_qwCPR1 (registers_struct._g_qwCPR1)
#define g_qwCCR1 (registers_struct._g_qwCCR1)
#define g_qwMultLO (registers_struct._g_qwMultLO)
#define g_qwMultHI (registers_struct._g_qwMultHI)
#define g_nDelay (registers_struct._g_nDelay)
#define g_pPCMemBase (registers_struct._g_pPCMemBase)
#define g_bLLbit (registers_struct._g_bLLbit)

#define g_qwCPR ((register_set*)registers_struct._g_qwCPR0)
#define g_qwCCR ((register_set*)registers_struct._g_qwCPR1) // CPR1 is immediately before CCR1

#define g_qwFCR0 (g_qwCCR1[0])
#define g_qwFCR1 (g_qwCCR1[1])

#endif

#pragma pack(pop, 1)

#endif
