unit nes_ppu;

interface
  uses windows,sysutils,nes,fastdib,global;

    function Sprite0y:integer;
    procedure RefreshScreen (Y1, Y2 : integer);
    procedure RefreshBackGround(Y1, Y2 : integer);
    procedure RefreshSprite(Y1, Y2 : integer);
    procedure Tvmode(Bmp:Tfastdib;Amount:Integer);
implementation
uses main;

function FRGB(r,g,b:Byte):TFColor;
begin
  Result.b:=b;
  Result.g:=g;
  Result.r:=r;
end;

function IntToByte(i:Integer):Byte;
begin
  if      i>255 then Result:=255
  else if i<0   then Result:=0
  else               Result:=i;
end;

function TrimInt(i,Min,Max:Integer):Integer;
begin
  if      i>Max then Result:=Max
  else if i<Min then Result:=Min
  else               Result:=i;
end;



procedure Tvmode(Bmp:Tfastdib;Amount:Integer);
var
Lin1,
Lin2:   PLine24;
pc:     PFColor;
cx,x,y: Integer;
Buf:    array[0..3]of Tfcolor;
begin

  pc := pointer(Bmp.Bits);

  for y:=0 to Bmp.Height-1 do
  begin
    Lin1:=Bmp.Pixels24[TrimInt(y+Amount,0,Bmp.Height-1)];
    Lin2:=Bmp.Pixels24[TrimInt(y-Amount,0,Bmp.Height-1)];
    for x:=0 to Bmp.Width-1 do
    begin
      cx:=TrimInt(x+Amount,0,Bmp.Width-1);

      Buf[0] := Lin1[cx];
      Buf[1]:=Lin2[cx];

      cx:=TrimInt(x-Amount,0,Bmp.Width-1);
      Buf[2]:=Lin1[cx];
      Buf[3]:=Lin2[cx];
      pc.b:=(Buf[0].b+Buf[1].b+Buf[2].b+Buf[3].b)shr 2;
      pc.g:=(Buf[0].g+Buf[1].g+Buf[2].g+Buf[3].g)shr 2;
      pc.r:=(Buf[0].r+Buf[1].r+Buf[2].r+Buf[3].r)shr 2;
     asm inc pc end;
    end;
    pc:=Ptr(Integer(pc)+Bmp.Gap);
  end;
end;


function Sprite0y:integer;
var y:integer;
begin
	y:=SRAM[0];
	result := y+8;
end;


function ScreenON:integer;
begin
result := (PPU[1] and $08);
end;

function BGAdrHI:integer;
begin
result := (PPU[0]and $10);
end;

function VRAMADR(V:integer):pointer;
begin
result :=  @VPage[(V) shr 10][(V)];
end;

function PAL(c,cc:integer):integer;
begin
result := ((c)+cc);
end;


procedure RefreshScreen(Y1, Y2 : integer);
var
PP:Pbytearray;

procedure fill_black;
var i:integer;
begin
    for i := Y1 to Y2 do
    begin
    PP := nesBackBuffer.ScanLines[i];
    FillChar(PP^, nesBackBuffer.Width, BLACK_COLOR);
    end;
end;

begin
   asm inc Y2   end;

    if showbg then
    begin
    RefreshBackGround(Y1,Y2);
    end
    else
    begin
    fill_black;
    end;

    if showsp = true then
    begin
    if (PPU[1] and $10)<>0 then
    RefreshSprite(Y1,Y2)
    end;


end;


procedure RefreshBackGround(Y1,Y2:integer);
var
  vadr:integer;
  iPP,
  Line : integer;
  cc, c1, c2 : byte;
  line1:integer;
  P: Pbytearray;
  nametbl,
  x, y, X1, vofs,h , ntbl : integer;
  no, atr:byte;
  i ,ii,_h: integer;
begin
     i := 0;
     if (PPU[1] and $8)=0 then
     begin
     for _h := Y1 to Y2 do
     begin
     line := _h;
     FillChar(PP[line]^,nesBackBuffer.Width, BLACK_COLOR);
     end;
     end
     else
     begin
     asm mov vofs,0 end;
     if (PPU[0] and $10)<>0 then begin asm mov vofs,$1000 end; end;
     y := Y1 + ScrollY;
     h := 8 - (y and 7);
     inc(vofs, (y and 7));
     y := y shr 3;
     ntbl := $2000 + (PPU[0] and $3) * $400;
     Line := Y1;
     iPP := 0;
     x := 0;
     repeat
     if (y>=30) then
     begin
     dec(y, 30);
     ntbl := ntbl xor $800;
     end;

     nametbl := ntbl;
     for X1 := 0 to 31 do
     begin
     no := VRAM[nametbl + x + y * 32];
     atr := VRAM[nametbl + $03C0 + ( x shr 2 ) + ( y shr 2 ) * 8];
     cc := ((atr shr ((x and 2) + (y and 2) * 2)) and 3) * 4;
     vadr := no * 16 + vofs;
     for i:= 0 to (h-1)  do
     begin
     //P := PP[Line+i];//BackBuffer.scanlines[Line + i];
     c1 := ((Ord(VPage[vadr shr 10][vadr]) shr 1) and $55) or (Ord(VPage[(vadr + 8) shr 10][vadr + 8]) and $AA);
     c2 := (Ord(VPage[vadr shr 10][vadr]) and $55) or ((Ord(VPage[(vadr + 8) shr 10][vadr + 8]) shl 1) and $AA);
     PP[Line + i][ipp]   := VRAM[$3F00+ ((c1 shr 6) and 3) + cc];
     PP[Line + i][ipp+1] := VRAM[$3F00+ ((c2 shr 6) and 3) + cc];
     PP[Line + i][ipp+2] := VRAM[$3F00+ ((c1 shr 4) and 3) + cc];
     PP[Line + i][ipp+3] := VRAM[$3F00+ ((c2 shr 4) and 3) + cc];
     PP[Line + i][ipp+4] := VRAM[$3F00+ ((c1 shr 2) and 3) + cc];
     PP[Line + i][ipp+5] := VRAM[$3F00+ ((c2 shr 2) and 3) + cc];
     PP[Line + i][ipp+6] := VRAM[$3F00+ (c1 and 3) + cc];
     PP[Line + i][ipp+7] := VRAM[$3F00+ (c2 and 3) + cc];
     inc(vadr);
     end;
     inc(x);
     if x=32 then
     begin
     x := 0;
     nametbl := ntbl xor $400;
     end;
     inc(iPP, 8);
     end;
     inc(Line, h);
     iPP := 0;
     vofs := vofs and not(7);
     h := Y2 - Line;
     if (h>8) then
     h := 8;
     inc(y);
     x := (ScrollX  shr 3);
     until (line >= Y2);
     end;
end;



procedure RefreshSprite(Y1, Y2 : integer);
var
  n, vofs : integer;
  HH : byte;
  iPP, C : integer;
  P:Pbytearray;
  x, y, no, atr, CC, J, c1, c2 : integer;
  h, t, incr, vadr : integer;
begin
  asm mov vofs ,0 end;
  if (PPU[0] and $20)<>0 then { Sprite 16 }
    asm mov HH , 16 end
  else
  begin
   asm mov HH , 8 end;
    if (PPU[0] and $08)<>0 then { Sprite patterm address }
   asm mov vofs,$1000 end;
   end;
  asm mov n , $00FC end;
//   n := $00FC;
   repeat
   sprite := @SRAM[n];
   y := sprite.y;
    if not((y>Y2) or (y<(Y1-HH))) then
    begin
      x   := sprite.x;
      no  := sprite.no;
      atr := sprite.atr;
      cc  := (atr and $3) * 4 + 16;
      if (PPU[0] and $20)<>0 then { Sprite 16 }
        vadr := ((no and $1) shl 12) + (no shr 1)* 32
      else
   vadr := no * 16 + vofs;
     // C := vadr;
      asm
      push edi
      //emss
      mov edi,vadr
      mov C,edi
      pop edi
      //db $0F,$6F,$C1
      end;
     // iPP := x;
      asm
      push edi
      //emss
      mov edi,x
      mov ipp,edi
      pop edi
      //db $0F,$6F,$C1
      end;
      asm mov incr , 1 end;
      //incr := 1;
      if (atr and V_FLIP)<>0 then
      begin

        asm
        //emss
        mov incr, -1
      //  incr := -1;
        add C, 7;
        //db $0F,$6F,$C1
        end;
      //  inc(C,7);

        if (PPU[0] and $20)<>0 then { Sprite 16 }
          inc(C, 16);
      end;
//t := Y1 - y;
      asm
      push edi
      //emss
      mov edi,Y1
      sub edi,y
      mov t,edi
      pop edi
      //db $0F,$6F,$C1
      end;

      if t>0 then
      begin
        inc(C, t*incr);
      //iPP := x;
      asm
      push edi
      //emss
      mov edi,x
      mov ipp,edi
      pop edi
      //db $0F,$6F,$C1
      end;
        if (t>8) then
          inc(C, incr*8);
      end
      else
      asm
      //emss
      mov t, 0
      //db $0F,$6F,$C1
      end;
      // t := 0;
      // h := Y2 - y + 1;
      asm
      push edi
      push edx
      //emss
      mov edi,Y2
      mov edx,y
      sub edi,edx
      inc edi
      mov h,edi
      pop edi
      pop edx
      //db $0F,$6F,$C1
      end;

      if (h>HH) then h := HH;
      repeat
      //P := PP[y+t];//BackBuffer.ScanLines[y+t];
       if (t=8) then  inc(C, incr*8);

        c1 := ((Ord(VPage[C shr 10][C]) shr 1) and $55) or (Ord(VPage[(C + 8) shr 10][C + 8]) and $AA);
        c2 := (Ord(VPage[C shr 10][C]) and $55) or ((Ord(VPage[(C + 8) shr 10][C + 8]) shl 1) and $AA);
        J := Ord(VPage[C shr 10][C]) or Ord(VPage[(C + 8) shr 10][C + 8]);
        if J<>0 then
        if (atr and H_FLIP)<>0 then
        begin
if (J and $80)<>0 then PP[y+t][iPP + 7] := VRAM[$3F00 + ((c1 shr 6) and 3) + cc];
if (J and $40)<>0 then PP[y+t][iPP + 6] := VRAM[$3F00 + ((c2 shr 6) and 3) + cc];
if (J and $20)<>0 then PP[y+t][iPP + 5] := VRAM[$3F00 + ((c1 shr 4) and 3) + cc];
if (J and $10)<>0 then PP[y+t][iPP + 4] := VRAM[$3F00 + ((c2 shr 4) and 3) + cc];
if (J  and $8)<>0 then PP[y+t][iPP + 3] := VRAM[$3F00 + ((c1 shr 2) and 3) + cc];
if (J  and $4)<>0 then PP[y+t][iPP + 2] := VRAM[$3F00 + ((c2 shr 2) and 3) + cc];
if (J  and $2)<>0 then PP[y+t][iPP + 1] := VRAM[$3F00 + (c1 and 3) + cc];
if (J  and $1)<>0 then PP[y+t][iPP + 0] := VRAM[$3F00 + (c2 and 3) + cc];
        end
        else
        begin
if (J and $80)<>0 then PP[y+t][iPP + 0] := VRAM[$3F00 + ((c1 shr 6) and 3) + cc];
if (J and $40)<>0 then PP[y+t][iPP + 1] := VRAM[$3F00 + ((c2 shr 6) and 3) + cc];
if (J and $20)<>0 then PP[y+t][iPP + 2] := VRAM[$3F00 + ((c1 shr 4) and 3) + cc];
if (J and $10)<>0 then PP[y+t][iPP + 3] := VRAM[$3F00 + ((c2 shr 4) and 3) + cc];
if (J and $8)<>0 then PP[y+t][iPP + 4] := VRAM[$3F00 + ((c1 shr 2) and 3) + cc];
if (J and $4)<>0 then PP[y+t][iPP + 5] := VRAM[$3F00 + ((c2 shr 2) and 3) + cc];
if (J and $2)<>0 then PP[y+t][iPP + 6] := VRAM[$3F00 + (c1 and 3) + cc];
if (J and $1)<>0 then PP[y+t][iPP + 7] := VRAM[$3F00 + (c2 and 3) + cc];
        end;
        asm inc t end;
        inc(C, incr);
        until t>=h;
        end;
        dec(n, $04);

        until n<$0000;

end;

end.
