unit nes;

interface
uses c6502,snd,Windows,fastdib, Messages,sysUtils,mmsystem,global;

    function MemoryReadOpcode(Addr : word) : byte;
    function MemoryReadByte(Addr : word) : byte;
    procedure MemoryWrite (Addr : word; value : byte);
    function cpuLoop : byte;
    function  nesLoad_file(filename:pchar): boolean;
    function  InitNES: boolean;
    procedure ResetNES;
    procedure TrashNES;
    procedure IOWrite(A : word; V : byte);
    function  IORead(A : word): byte;
    procedure CheckKb;
    procedure Last_Blit;
    procedure x_init_x;
    function ReadBit(v, p : byte): boolean;
    procedure WriteBit(var v : byte; p : byte; bit : boolean);
    procedure freerom;
    procedure Load_State;
    procedure Save_State;
    procedure Set_Pal(no:integer);


implementation
uses main,nes_mmc,nes_ppu,emulate;


procedure Set_Pal(no:integer);
var
i,r,g,b:integer;
begin
if no = 0 then
begin
  for i := 0 to 63 do
  begin
    r:=getrvalue(__pal_[i]);
    g:=getgvalue(__pal_[i]);
    b:=getbvalue(__pal_[i]);
    nesBackBuffer.Colors[i].r := r+20;//_Pal_[i, 1];
    nesBackBuffer.Colors[i].g := g+20;//_Pal_[i, 2];
    nesBackBuffer.Colors[i].b := b+20;//_Pal_[i, 3];
  end;
end;

if no = 1 then
begin
  for i := 0 to 63 do
  begin
    nesBackBuffer.Colors[i].r := _Pal1[i, 1];
    nesBackBuffer.Colors[i].g := _Pal1[i, 2];
    nesBackBuffer.Colors[i].b := _Pal1[i, 3];
  end;
end;

if no = 2 then
begin
  for i := 0 to 63 do
  begin
    nesBackBuffer.Colors[i].r := _Pal2[i, 1];
    nesBackBuffer.Colors[i].g := _Pal2[i, 2];
    nesBackBuffer.Colors[i].b := _Pal2[i, 3];
  end;
end;

end;


function ReadBit(v, p : byte): boolean;
begin
     Result := ((v shr p) and 1) = 1;
end;

procedure WriteBit(var v : byte; p : byte; bit : boolean);
begin
  if bit then
    v := v or (1 shl p)
  else
    v := v and not(1 shl p);
end;

procedure freerom;
begin
Rom_On := false;
trashnes;
end;

procedure initCpu;
begin
  {if smooth = true then
  CPUPeriod := 30//getcpuspeed;
  else} CPUPeriod := 100;

  { inizializza cpu }
  with ccpu do
  begin
    A := 0;
    P := 0;
    X := 0;
    Y := 0;
    S := 0;
    PC.w  := 0;
    iPeriod  := CPUPeriod;
    ICount   := 0;
    IRequest := 0;
    AfterCLI := 0;
    IBackup  := 0;
    //void *User;
    TrapBadOps := 0;
    Trap  := 0;
    Trace := 0;
  end;
end;



procedure ResetNES;
begin
  UPeriod := 2;
  UCount  := 0;
  Joypad1 := 0;
  Joypad2 := 0;
  Joypad1Read := 0;
  Joypad2Read := 0;
  PPU[0] := 0;
  PPU[1] := 0;
  PPU[2] := 0;
  PPU[3] := 0;
  VAddr  := 0;
  PPUADDR_FirstRead  := true;
  PPUSCROLL_Toggle := false;
  scanline := 0;
  CPUinstr := 0;
  Reset6502(ccpu);
end;

procedure TrashNES;
var
  i : integer;
  BatteryName : string;
  BatteryFile : file;
begin
  if (ROMType and ROM_WRAM)<>0 then
  begin
    { Save backed memory }
    BatteryName := Copy(nesRomname, 1, Pos('.', nesRomname)) + 'sav';
   // Terminal.Lines.Add('Saving backed memory file "' + ExtractFilename(BatteryName) + '".');
    AssignFile(BatteryFile, BatteryName);
    ReWrite(BatteryFile, 1);
    BlockWrite(BatteryFile, WRAM, SizeOf(WRAM), i);
    CloseFile(BatteryFile);
  end;
  { azzero memoria }
  FillChar(VRAM, SizeOf(VRAM), $00);
  FillChar(SRAM, SizeOf(SRAM), $00);
  FillChar(WRAM, SizeOf(WRAM), $00);
  FillChar(RAM, SizeOf(RAM), $00);
  for i:=Low(Page) to High(Page) do
    Page[i] := nil;
  for i:=Low(VPage) to High(VPage) do
    VPage[i] := nil;
  if Assigned(PROM) then
  begin
    FreeMem(PROM);
    PROM := nil;
  end;
  if Assigned(VROM) then
  begin
    FreeMem(VROM);
    VROM := nil;
  end;
end;

function InitNES: boolean;
var
  j : integer;
  BatteryName : string;
  BatteryFile : file;
begin
  if (ROMType and ROM_WRAM)<>0 then
  begin
    Page[3] := @WRAM;
    BatteryName := Copy(nesRomname, 1, Pos('.', nesRomname)) + 'sav';
    if FileExists(BatteryName) then
    begin
      AssignFile(BatteryFile, BatteryName);
      Reset(BatteryFile, 1);
      BlockRead(BatteryFile, WRAM, SizeOf(WRAM), j);
      CloseFile(BatteryFile);
    end;
  end;
  Page[0] := @RAM;
  Result := MMCInit(MMCType);
end;

function nesLoad_File(filename : pchar) : boolean;
var
  F : file;
  i, j,
  PRGBytes,
  CHRBytes,
  CartSize : integer;
begin
  nesRomname := pchar(ExtractFilename(filename));
  AssignFile(F, filename);
  Reset(F, 1);
  BlockRead(F, nesromheader, SizeOf(nesromheader), i);
  if (nesromheader.RomType <> 'NES') then
  begin
  Messagebox(mhwnd,'Unknown file format','Error',MB_OK);
  Result := false;
  Exit;
  end;
  ROMSize  := Ord(nesromheader.PRGROM);
  VROMSize := Ord(nesromheader.CHRRAM);
  ROMType  := Ord(nesromheader.ROMctrl1);
  MMCType  := (Ord(nesromheader.ROMctrl1) shr 4);
  CartSize := ROMSize shl 4 + VROMSize * 8;
  if nesromheader.Expansion[0]=#0 then
  MMCType := MMCType or (Ord(nesromheader.ROMctrl2) and $F0);
  Mirroring := (Ord(nesromheader.ROMctrl1) and ROM_MIRROR);
  MirrorXor := $400 shl Mirroring; { Horizontal : $400; Vertical : $800}
  PRGBytes := $4000 * ROMSize;
  CHRBytes := $2000 * VROMSize;
  GetMem(PROM, PRGBytes + 1);
  GetMem(VROM, CHRBytes + 1);
  BlockRead(F, PROM^, PRGBytes, j);
  BlockRead(F, VROM^, CHRbytes, j);
  CloseFile(F);
  Result := true;
end;





procedure CheckKeyboard(x:integer; bit:integer);  // auch im Hintergrund
var y: Cardinal;
data:Tkeyboardstate;
procedure Poll;
begin
end;
begin
  if (GetKeystate(x) = -128) or (GetKeystate(x)  = -127) then
  WriteBit(Joypad1, bit, true)
  else
  WriteBit(Joypad1, bit, false);
end;


procedure CheckKb;
begin
  Joypad1 := 0;
  CheckKeyboard(BUTTON1_Right,7);
  CheckKeyboard(BUTTON1_Left,6);
  CheckKeyboard(BUTTON1_Down,5);
  CheckKeyboard(BUTTON1_Up,4);
  CheckKeyboard(BUTTON1_Start,3);
  CheckKeyboard(BUTTON1_Select,2);
  CheckKeyboard(BUTTON1_B,1);
  CheckKeyboard(BUTTON1_A,0);

end; 



procedure Last_Blit;
var i:integer;
d:hdc;
b:hbrush;
p:hpen;

begin
  d:=GetDC(mhwnd);
  nesBackBuffer.Draw(d,0,0);
  if showfps = true then
  begin
  textout(d,1,1,pchar('fps:'+inttostr(trunc(dwframes))),4+length(inttostr(trunc(dwframes))));
  end;
  ReleaseDC(mhwnd,d);
end;



procedure x_init_x;
var
  i,r,g,b: Integer;
begin
  initcpu;
  PROM := nil;
  VROM := nil;
  set_pal(1);
  for i := 0 to 239 do
  begin
  PP[i] := nesbackbuffer.scanlines[i];
  end;
end;


function MemoryReadByte(Addr: Word): Byte;
begin
  case (Addr shr 13) of
    0 : { $0000 -- RAM }
        Result := RAM[Addr and $7FF];
    1,  { $2000 -- PPU }
    2 : { $4000 -- PSG }
        Result := IORead(Addr);
    3 : { $6000 -- WRAM }
        Result := WRAM[Addr and $1FFF];
  else
    { $8000 -- ROM }
    Result := Ord(Page[Addr shr 13][Addr]);
  end;
end;

procedure MemoryWrite(Addr: Word; value: Byte);
begin
 // GameImage^[Addr] := value;
  case (Addr shr 13) of
    0 : { $0000 -- RAM }
        RAM[Addr and $7FF] := value;
    1,  { $2000 -- PPU }
    2 : { $4000 -- PSG }
        IOWrite(Addr, value);
    3 : { $6000 -- WRAM }
        WRAM[Addr and $1FFF] := value;
  else
    { $8000 -- ROM }
    currentwrite(Addr, value);
  end;
end;

function MemoryReadOpcode(Addr: Word): Byte;
begin
       Result := Ord(Page[Addr shr 13][Addr]);
end;

function  IORead(A : word): byte;
begin
  case A of
    { PPU }
    $2002 : begin { PPU Status }
              Result := PPU[2];
              PPU[2] := PPU[2] and not(PPU_InVBlank or PPU_SpHit);
            end;
    $2007 : begin
              if PPUADDR_FirstRead then
              begin
                PPUADDR_FirstRead := false;
                Result := NO_DATA;
                Exit;
              end;
              VAddr := VAddr and $3FFF;
              if (VAddr<$2000) then
                Result := Ord(VPage[VAddr shr 10][VAddr])
              else
                Result := VRAM[VAddr];
              if (PPU[0] and $04)<>0 then { INC32 }
                inc(VAddr, 32)
              else
                inc(VAddr);
            end;
    { PGS }
    $4000..$4015 :
            begin
              Result := PSG[A - $4000];
            end;
    { Joypad }
    $4016 : begin
              Result := ((Joypad1 shr Joypad1Read) and $01);
              Joypad1Read := (Joypad1Read + 1) and $07;
            end;
     $4017 : begin
              Result := (Joypad2 shr Joypad2Read) and $01;
              Joypad2Read := (Joypad2Read + 1) and $07;
            end;
    else
    begin
       Result := NO_DATA;
    end;
  end;
end; { IORead }


const	BASE_FREQ  = 3700000;
procedure ajust_vol;
begin
{var
j:char;
begin
tmp:=itofix((PSG[io.psg_ch][4]&15)*
((PSG[ch][5]and 15)+(PSG[ch][5]shr 4))*
((psg_volume and 15)+(io.psg_volume>>4)))/(6*32*32),tmp2=0;
for (j=0;j<32;j++,tmp2+=tmp)
snd_vol[io.psg_ch][j]=/*(signed char)(j-16)/*/fixtoi(tmp2);}
end;




procedure IOWrite(A : word; V : byte);
var
  ch,i : integer;

begin

  case A of
    $2000 : PPU[0] := V;
    $2001 : PPU[1] := V;
    $2003 : PPU[3] := V;
    $2004 : begin
              SRAM[PPU[3]] := V;
              inc(PPU[3]);
            end;
    $2005 : begin
              if not(PPUSCROLL_Toggle) then
                PPUSCROLL_X2 := V
              else if V<=239 then
                PPUSCROLL_Y2 := V;
              PPUSCROLL_Toggle := not(PPUSCROLL_Toggle);
              PPUSCROLL_Change := true
            end;
    $2006 : begin
              VAddr := (VAddr shl 8) or V;
              PPUADDR_FirstRead := true;
            end;
    $2007 : begin
              if (PPU[2] and PPU_WriteIgnore)=0 then
              begin
                VAddr := VAddr and $3FFF;
                VRAM[VAddr] := V;
              if ((VAddr and $3000)=$2000) then { Mirroring }
              begin
              VRAM[(VAddr xor MirrorXor) and $2FFF] := V;
              end;

    if (VAddr=$3F10) then
    begin
    VRAM[$3F00] := V;  VRAM[$3F04] := V;
    VRAM[$3F08] := V;  VRAM[$3F0C] := V;
    VRAM[$3F14] := V;  VRAM[$3F18] := V;
    VRAM[$3F1C] := V;
    end;


                if (PPU[0] and $04)<>0 then { INC32 }
                  inc(VAddr, 32)
                else
                  inc(VAddr);
              end;
              PPUADDR_FirstRead := false;
            end;
    { PSG }
    $4000,
    $4004,
    $4008,
    $400C : begin
              PSG[A - $4000] := V;
          //    SetVolume(A div 4,(V and 7)shl 5);
            end;
    $4001,
    $4005,
    $4009,
    $400D : begin
              A := A - $4000;
              PSG[A] := V;
              //SetVolume
              //SetVolume(A div 4,(V and 7)shl 5);
            end;
    $4002,
    $4006,
    $400A,
    $400E : begin { Freq. Low }
            PSG[A - $4000] := V;
          //  SetVolume(A div 4,(V and 7)shl 5);
            end;
    $4003,
    $4007,
    $400B,
    $400F : begin { Freq. High }
          A := A - $4000;
          PSG[A] := V;
         ch := A div 4;
	 if (PSG[A-3] and $20)<> 0 then
         begin
	 PSG[$15]:=PSG[$15] or (1shl ch);
	 len := V shr 4;
	 if (V and 8)<>0 then
         begin
	 if (len=0)then len:=128;
	 end else len:=lentbl[len]
	 end else len := 0;
	 sndlen[ch]:=len;
	 //_freq:=((V and 7)shl 8) or PSG[A-1];
	 //_freq:=PSG_BASE div (_freq+1);
	//SetFreq(ch,_freq);
        //setVolume(ch,(PSG[A-2]and 7)shl 5);
         end;
    $4010,
    $4011,
    $4012,
    $4013 : begin { PCM }
              PSG[A - $4000] := V;
//           Sound(ch,_freq,(PSG[A-2]and 7)shl 5);
            end;
    { DMA }
    $4014 : begin
              if V<$80 then
                CopyMemory(@SRAM, @RAM[(V and 7) shl 8], 256)
              else
                CopyMemory(@SRAM, PChar(Page[V shr 5][V shl 8]), 256)
            end;
    $4015 : begin
              for ch:=0 to 3 do
                if ((V shr ch) and 1)<>0 then
                begin { Enable sound }

                end
                else
                begin { disable sound }

                end;
              PSG[$15] := V;
            end;
    { Joypad }
    $4016 : begin
              if ((PSG[$16] and 1) and not(V and 1))<>0 then
              begin
                Joypad1Read := 0;
                Joypad2Read := 0;
              end;
              PSG[$16] := V;
            end;
    $4017 : begin
              PSG[$17] := V;
            end;
    else
    begin
    end;
  end;
end;


function ProcessMessage(var Msg: TMsg): Boolean;
var
  Handled: Boolean;
begin
  Result := False;
  if PeekMessage(Msg, 0, 0, 0, PM_REMOVE) then
  begin
    Result := True;
    if Msg.Message <> WM_QUIT then
    begin
      Handled := False;
        TranslateMessage(Msg);
        DispatchMessage(Msg);
      end;
  end;
end;

procedure ProcessMessages;
var
  Msg: TMsg;
begin
  while ProcessMessage(Msg) do {loop};
end;

procedure sndLoop;
var i,ch:integer;
begin
dec(sndcount);
if (sndcount<=0) then
begin
sndcount:=sndPeriod;
for ch:=0 to 4-1 do
begin
if (sndlen[ch] <> 0)then
begin
dec(sndlen[ch]);
if (sndlen[ch]=0) then
begin
PSG[$15] :=PSG[$15] and PSG[$15] xor (1 shl ch);
end;
end;
end;
end;
end;


function Vblank_On :boolean;
begin
if (PPU[0] and $80)<> 0 then result := true
else result := false;
end;

function cpuLoop : byte;
var i:integer;
begin
ScanLine := (ScanLine + 1) mod SLPF;
  Result := _n_;
  sndLoop;
  if (ScanLine = MINL) then
  begin
    PPU[2]:= PPU[2] and (PPU_InVBlank);
    PrevLine := MINL;
    HitY := Sprite0y;
  end
  else if (ScanLine = MAXL) then
  begin
    if UCount<>0 then
      asm dec UCount end
    else
    begin
      RefreshScreen(PrevLine, ScanLine);
      PrevLine := ScanLine + 1;
      UCount := Uperiod;
      last_blit;
    end;
  end;
  if (ScanLine>=MINL) and (ScanLine<=MAXL) then
  begin
    if PPUSCROLL_Change then
    begin
      if UCount=0 then
      RefreshScreen(PrevLine, ScanLine - 1);
      ScrollX := PPUSCROLL_X2;
      ScrollY := PPUSCROLL_Y2;
      PrevLine := ScanLine;
      PPUSCROLL_Change := false;
    end;
    if ((PPU[1] and $10)<>0) and (ScanLine=HitY) then
    begin
      PPU[2] := PPU[2] or PPU_SpHit;
      if (PPU[0] and $40)<>0 then { Sprite Hit ON }
        _n_ := INT_NMI;
    end;
  end
  else
  if ScanLine=240 then
  begin

    CheckKb;
    PPU[2] := (PPU[2] and not(PPU_SpHit)) or PPU_InVBlank;
    PSG[$16] := PSG[$16] and $FD;
    if VBlank_on = true then Result := INT_NMI;
    ProcessMessages;
    SetWindowText(mhwnd,pchar('Blur - '+nesromname+'  Fps: ' + fps));
    if not Rom_On then   Result := INT_QUIT;
  end;

end;

procedure Save_State;
var
  i : integer;
  SaveName : string;
  SaveFile : file;
begin
    SaveName := Copy(nesRomname, 1, Pos('.', nesRomname)) + 'st';
    AssignFile(SaveFile,SaveName);
    ReWrite(SaveFile, 1);
    BlockWrite(SaveFile, RAM, SizeOf(RAM), i);
    BlockWrite(SaveFile, SRAM, SizeOf(SRAM), i);
    BlockWrite(SaveFile, VRAM, SizeOf(VRAM), i);

    CloseFile(SaveFile);
end;


procedure Load_State;
var
  i : integer;
  LoadName : string;
  LoadFile : file;
begin
    LoadName := Copy(nesRomname, 1, Pos('.', nesRomname)) + 'st';
    AssignFile(LoadFile,LoadName);
    Reset(LoadFile, 1);
    BlockRead(LoadFile, RAM, SizeOf(RAM), i);
    BlockRead(LoadFile, SRAM, SizeOf(SRAM), i);
    BlockRead(LoadFile, VRAM, SizeOf(VRAM), i);
    CloseFile(LoadFile);
end;


end.

