unit rdp;

interface
uses global;

type   Pt_vtx =  ^t_vtx;
       t_vtx = record
  x, y, z:real;
  flags:int64;
  s, t:real;
  r, g, b, a:int64;
end;

// first by Jeff
type   Pt_ImageInfo =  ^t_ImageInfo;
       t_ImageInfo = record

	fmt,			// frame format (3 bits)
	size,		// bits per pixel (2 bits)
	width,		// width of frame in pixels (12 bits)
	addr:int64;		// RDRAM pointer to Image
	LoadAddr:Plongarray;
	vaddr:int64;
end;


type  Pt_tile =  ^t_tile;
      t_tile = record

// SETTILE
format,size,
line,tmem,
palette,clampt,
mirrort,maskt,
shiftt,clamps,
mirrors,masks,
shifts:int64;
 Width:int64;
 Height:int64;
 Texture_on:int64;
 SScale:real;
 TScale:real;

// SETTILESIZE / LOADBLOCK
  uls,  ult,
  lrs,  lrt,
  dxt:int64;
end;

const INVALID_TASK  =  -1;
const GFX_TASK      =  1;
const  AUDIO_TASK   =   2;
        type scissor_ = record
        ulx,
        uly,
        lrx,
        lry,
        interlace_mode:int64;
        end;
        type light__ = record

         rgba:int64;
         rgba_copy:int64;
         dir:array[0..3]of int64;
         dummy:int64;
        end;
        type light_ = array[0..8]of light__;
        type lookat_x_ = light_;
        type lookat_y_ = light_;

        type clip_ = record
        nx,
        ny,
        px,
        py:int64;
        end;

        type texture__ =  record
        mipmap_level:int64;
        on1:int64;
        scale_t:real;
        scale_s:real;
        end;
        texture_ = array[0..8]of texture__;


type Prdp_reg_ =  ^rdp_reg_;
     rdp_reg_ = record

       // general

        cmd0, cmd1:int64;
        start, stop, curr:int64;
        td:array[0..8]of t_tile;

       // color register
          fillcolor,    // memory interface: 32bit
          primcolor,    // color combiner: rgba
          envcolor,     // color combiner: rgba
          fogcolor,     // blender: rgba
          blendcolor:int64;   // blender: rgba

       // This is the frame buffer location to draw into
       // Used by rdp_setcolorimage;
          colorimg_fmt:int64;         // Frame Format (3 bits)
          colorimg_size:int64;        // Bits per pixel (2 bits)
         colorimg_width:int64;       // width of frame in pixels (12 bits)
          colorimg_addr:int64;        // RDRAM pointer to Image (32 bits)

       // This is the frame buffer location to draw into
       // Used by rdp_settextureimage;
		 TextureImage:t_ImageInfo;
// FiRES: muesste theoretisch fuer jedes der geladenen Texturen indiv.
		m_TScale:real;
		m_SScale:real;
		m_CurTile:Pt_tile;
       // This is the location of an 8 bit TLUT
       // Used by rdp_loadtlut;
         tlut_8_fmt:int64;  // TLUT Format (3 bits)
         tlut_8_size:int64; // Bits per pixel (2 bits)
         tlut_8_addr:int64; // RDRAM pointer to TLUT (32 bits)

       // This is the location of an 4 bit TLUT
       // Used by rdp_loadtlut;
        tlut_4_fmt:array[0..16]of int64;  // TLUT Format (3 bits)
        tlut_4_size:array[0..16]of int64; // Bits per pixel (2 bits)
        tlut_4_addr:array[0..16]of int64; // RDRAM pointer to TLUT (32 bits)


        pc:array[0..10]of int64;
        pc_i:int64;

        task:integer;
        size:integer;
        texture:texture_;
        geometrymode:int64;
        mode_h:int64;
        mode_l:int64;
        lights:int64;
        segment:array[0..16]of int64;

        vp:array[0..8]of int64;

         mtx_proj:array[0..4,0..4]of real;
         mtx_model:array[0..10,0..4,0..4]of real;
                 scissor:scissor_;
             light:light_;
             lookat_y:light__;
            lookat_x:light__;
             clip:clip_;
         vtx:array[0..32]of t_vtx;
        halt:integer;

end;


procedure    rdp_dl_check;                 (* executes a displaylist @ address a *)
function segoffset2addr(so:int64):int64;   (* calcs the real addr out of seg and offset *)
//procedure matrix_mult(r:array of array of real; m1:array of array of real;  m2:array of array of real);
//procedure vertex_mult(r:array of real; v:array of real; m:array of array of real);





(* rdp instructions (audio  and  graphics) *)

procedure rdp_fixme;
procedure rdp_spnoop;





(* rdp audio instructions *)

procedure rdp_adpcm;
procedure rdp_clearbuff;
procedure rdp_envmixer;
procedure rdp_loadbuff;
procedure rdp_resample;
procedure rdp_savebuff;
procedure rdp_segment;
procedure rdp_setbuff;
procedure rdp_setvol;
procedure rdp_dmemmove;
procedure rdp_loadadpcm;
procedure rdp_mixer;
procedure rdp_interleave;
procedure rdp_polef;
procedure rdp_setloop;





(* rdp graphics instructions *)

procedure rdp_matrix;
procedure rdp_reserved0;
procedure rdp_movemem;
procedure rdp_vertex;
procedure rdp_reserved1;
procedure rdp_displaylist;
procedure rdp_reserved2;
procedure rdp_reserved3;
procedure rdp_sprite2d;
procedure rdp_tri1;
procedure rdp_culldl;
procedure rdp_popmatrix;
procedure rdp_moveword;
procedure rdp_texturemode;
procedure rdp_setothermode_h;
procedure rdp_setothermode_l;
procedure rdp_enddl;
procedure rdp_setgeometrymode;
procedure rdp_cleargeometrymode;
procedure rdp_line3d;
procedure rdp_rdphalf_1;
procedure rdp_rdphalf_2;
procedure rdp_rdphalf_cont;
procedure rdp_tri2;
procedure rdp_noop;
procedure rdp_texrect;
procedure rdp_texrectflip;
procedure rdp_loadsync;
procedure rdp_pipesync;
procedure rdp_tilesync;
procedure rdp_fullsync;
procedure rdp_setkeygb;
procedure rdp_setkeyr;
procedure rdp_setconvert;
procedure rdp_setscissor;
procedure rdp_setprimdepth;
procedure rdp_setothermode;
procedure rdp_loadtlut;
procedure rdp_settilesize;
procedure rdp_loadblock;
procedure rdp_loadtile;
procedure rdp_settile;
procedure rdp_fillrect;
procedure rdp_setfillcolor;
procedure rdp_setfogcolor;
procedure rdp_setblendcolor;
procedure rdp_setprimcolor;
procedure rdp_setenvcolor;
procedure rdp_setcombine;
procedure rdp_settextureimage;
procedure rdp_setdepthimage;
procedure rdp_setcolorimage;
procedure rdp_trifill;
procedure rdp_trishade;
procedure rdp_tritxtr;
procedure rdp_trishadetxtr;
procedure rdp_trifillz;
procedure rdp_trishadez;
procedure rdp_tritxtrz;
procedure rdp_trishadetxtrz;





(* rdp audio instruction function pointer *)

var aud_instruction:array[0..256-1]of procedure =
(
    (**
    * Just 16 commands are used (as far as i know)
    **)
        rdp_spnoop,             rdp_adpcm,              rdp_clearbuff,          rdp_envmixer,
        rdp_loadbuff,           rdp_resample,           rdp_savebuff,           rdp_segment,
        rdp_setbuff,            rdp_setvol,             rdp_dmemmove,           rdp_loadadpcm,
        rdp_mixer,              rdp_interleave,         rdp_polef,              rdp_setloop,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme
);





(* rdp graphics instruction function pointer *)

gfx_instruction:array[0..256-1]of procedure =
(
    (**
    * DMA commands:
    * The next 64 commands (just 10 are used) are not executed by the RDP.
    * They are "emulated" by the RSP!
    * But in the display lists they appear with these bit combinations.
    * We will need this if we execute the display lists directly in future.
    * These commands include a pointer to mem in rdmem which is loaded via DMA.
    **)
        rdp_spnoop,             rdp_matrix,             rdp_reserved0,          rdp_movemem,
        rdp_vertex,             rdp_reserved1,          rdp_displaylist,        rdp_reserved2,
        rdp_reserved3,          rdp_sprite2d,           rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
    (**
    * The next 64 commands are not used (as far as i know).
    **)
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
    (**
    * IMMEDIATE commands:
    * The next 64 commands (just 14 are used) are not executed by the RDP.
    * They are like the commands above except that they do not carry a pointer.
    * All data they need is in the command itself.
    * So no DMA transfer is needed.
    **)
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_tri2,               rdp_rdphalf_cont,       rdp_rdphalf_2,
        rdp_rdphalf_1,          rdp_line3d,             rdp_cleargeometrymode,  rdp_setgeometrymode,
        rdp_enddl,              rdp_setothermode_l,     rdp_setothermode_h,     rdp_texturemode,
        rdp_moveword,           rdp_popmatrix,          rdp_culldl,             rdp_tri1,
    (**
    * RDP commands:
    * These 64 commands are the real RDP commands.
    * I've never seen the TRI commands. They might also be generated by the RSP.
    **)
        rdp_noop,               rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_trifill,            rdp_trifillz,           rdp_tritxtr,            rdp_tritxtrz,
        rdp_trishade,           rdp_trishadez,          rdp_trishadetxtr,       rdp_trishadetxtrz,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_fixme,              rdp_fixme,              rdp_fixme,              rdp_fixme,
        rdp_texrect,            rdp_texrectflip,        rdp_loadsync,           rdp_pipesync,
        rdp_tilesync,           rdp_fullsync,           rdp_setkeygb,           rdp_setkeyr,
        rdp_setconvert,         rdp_setscissor,         rdp_setprimdepth,       rdp_setothermode,
        rdp_loadtlut,           rdp_fixme,              rdp_settilesize,        rdp_loadblock,
        rdp_loadtile,           rdp_settile,            rdp_fillrect,           rdp_setfillcolor,
        rdp_setfogcolor,        rdp_setblendcolor,      rdp_setprimcolor,       rdp_setenvcolor,
        rdp_setcombine,         rdp_settextureimage,    rdp_setdepthimage,      rdp_setcolorimage
);






var rdp_reg : rdp_reg_;
a0, b0, c0, d0, Aa0, Ab0, Ac0, Ad0,
		a1, b1, c1, d1,	Aa1, Ab1, Ac1, Ad1:int64;
 scMode0, scMode1:int64; // new june 14
 Mode:array[0..31]of pchar = ( 'G_CCMUX_COMBINED' ,          'G_CCMUX_TEXEL0' ,
						  'G_CCMUX_TEXEL1' ,          'G_CCMUX_PRIMITIVE' ,
						  'G_CCMUX_SHADE' ,           'G_CCMUX_ENVIRONMENT' ,
						  'G_CCMUX_CENTER' ,	      'G_CCMUX_COMBINED_ALPHA' ,
						  'G_CCMUX_TEXEL0_ALPHA' ,    'G_CCMUX_TEXEL1_ALPHA' ,
						  'G_CCMUX_PRIMITIVE_ALPHA' , 'G_CCMUX_SHADE_ALPHA' ,
						  'G_CCMUX_ENV_ALPHA' ,       'G_CCMUX_LOD_FRACTION' ,
						  'G_CCMUX_PRIM_LOD_FRAC' ,   'G_CCMUX_K5' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_UNDEFINED' ,
						  'G_CCMUX_UNDEFINED' ,       'G_CCMUX_0' );

	Alpha:array[0..7]of pchar = ( 'G_ACMUX_COMBINED' ,		'G_ACMUX_TEXEL0' ,
						  'G_ACMUX_TEXEL1' ,		'G_ACMUX_PRIMITIVE' ,
						  'G_ACMUX_SHADE' ,			'G_ACMUX_ENVIRONMENT' ,
						  'G_ACMUX_PRIM_LOD_FRAC' , 'G_ACMUX_0');


 Center1:integer;
 Textures1:integer;
 Shade1:integer;
 ShadeSmooth1:integer;
 AlphaShade1:integer;
 AlphaShadeSmooth1:integer;

 Center2:integer;
 Textures2:integer;
 Shade2:integer;
 ShadeSmooth2:integer;
 AlphaShade2:integer;
 AlphaShadeSmooth2:integer;

 Center3:integer;
 Textures3:integer;
 Shade3:integer;
 ShadeSmooth3:integer;
 AlphaShade3:integer;
 AlphaShadeSmooth3:integer;

 Center4:integer;
 Textures4:integer;
 Shade4:integer;
 ShadeSmooth4:integer;
 AlphaShade4:integer;
 AlphaShadeSmooth4:integer;
FrameCounter:longint;

procedure rdp_step;
procedure rdp_reset;
procedure rdp_dis;
procedure rdp_go;

implementation
uses rsp,emulate,cpu,unit1;
procedure rdp_go;
begin

end; (* procedure rdp_go; *)




procedure rdp_dis;
begin

end; (* procedure rdp_dis; *)




procedure rdp_reset;
begin
 rdp_reg.pc_i := 0;
 rdp_reg.halt := 1;
 rdp_reg.m_CurTile := @rdp_reg.td[0];
end; (* procedure rdp_reset; *)





procedure rdp_step;
var
 a:int64;
begin

	a := rdp_reg.pc[rdp_reg.pc_i];
(*	do
	begin
        a = rdp_reg.pc[rdp_reg.pc_i];
		if (a > $3fffff)
		begin
			rdp_reg.halt=1;
			return;
		end;
*)
        rdp_reg.cmd0 := rd_ram[(a shr 2)+0];
        rdp_reg.cmd1 := rd_ram[(a shr 2)+1];

        rdp_reg.pc[rdp_reg.pc_i] := a + 8;
        dpc_reg[2] := rdp_reg.pc[rdp_reg.pc_i];
        rdp_reg.curr := dpc_reg[2];   (* point to next instruction *)

        case (rdp_reg.task)of
        AUDIO_TASK:
        begin
    (* if audio is not compiled in we simulate the BREAK instr immediately *)
                //aud_instruction[rdp_reg.cmd0 shr 24];
                rdp_reg.size :=rdp_reg.size - 8;
                if(rdp_reg.size = 0) then
                begin
           	rdp_fullsync;
                rsp_reg.code := $0000000d;
                rsp_dis($0000000d);   (* RSP BREAK instruction *)
                rdp_reg.halt := 1;
//                 seems not to work with this
//                        reg.do_or_check_sthg = RS4300I_DO_AI_INTERRUPT;
//
                end;
             end;

            GFX_TASK:
            begin
                gfx_instruction[rdp_reg.cmd0 shr 24];
            end;
        end;
//	end;
//	while(!rdp_reg.halt);
end; (* procedure rdp_step; *)

procedure rdp_dl_check;
var
ExecuteDList:pointer;
a:int64;
begin


	rdp_dl_check;
	if (rdp_reg.task = INVALID_TASK) then
	begin
        exit;
	end;
	repeat

        a := rdp_reg.pc[rdp_reg.pc_i];

        rdp_reg.cmd0 := rd_ram[(a shr 2)+0];
        rdp_reg.cmd1 := rd_ram[(a shr 2)+1];
        rdp_reg.pc[rdp_reg.pc_i] := a + 8;
        dpc_reg[2] := rdp_reg.pc[rdp_reg.pc_i];
        rdp_reg.curr := dpc_reg[2];   (* point to next instruction *)

        case rdp_reg.task of
        AUDIO_TASK:
        begin
    (* if audio is not compiled in we simulate the BREAK instr immediately *)
        aud_instruction[rdp_reg.cmd0 shr 24];
        rdp_reg.size :=rdp_reg.size  - 8;
        if(rdp_reg.size = 0) then
         begin
         rsp_reg.code := $0000000d;
         rsp_dis($0000000d);   (* RSP BREAK instruction *)
         rdp_reg.halt := 1;
         end;
       end;
       GFX_TASK:
       begin
       gfx_instruction[rdp_reg.cmd0 shr 24];
       end;
       end;
       until (rdp_reg.halt = 0 );

end; (* procedure rdp_step; *)


var Draw2d:boolean;
procedure rdp_dl_check2;
var
pep:integer;
us, uds, dss:int64;
begin
if (FrameCounter >= 136) then
begin
pep := 0;
end;
    us  := sp_dmem[$fd4 shr 2];  (* ucode size *)
    uds := sp_dmem[$fdc shr 2];  (* ucode data size *)
    dss := sp_dmem[$fe4 shr 2];  (* dram stack size *)

      case (sp_dmem[$fc0 shr 2]) of
      1:  begin                           (* Graphic Task *)
      rdp_reg.task := GFX_TASK;
      if(us <> $1000) then
      begin
      rdp_reg.task := INVALID_TASK;
      end;

      if(uds <> $800) then
      begin
      rdp_reg.task := INVALID_TASK;
      end;

      if(dss < 640) then
      begin
      rdp_reg.task := INVALID_TASK;
      end;

      //ClearVisual;
      Draw2d := FALSE;
      end;

      2:
      begin                             (* Audio Task *)
      rdp_reg.task := AUDIO_TASK;
      if(us > $1000) then
      begin
      rdp_reg.task := INVALID_TASK;
      end;
      if(uds > $800) then
      begin
      rdp_reg.task := INVALID_TASK;
      end;

      if(dss <> 0) then
      begin
      rdp_reg.task := INVALID_TASK;
      end;
      end;

      else
          exit;
     end; (* switch(mem.sp_dmem[$fc0shr2]) *)



    (* for audio and graphic task *)

        if(rdp_reg.task = INVALID_TASK) then
        begin

        end
        else
        begin
        dpc_reg[2] :=sp_dmem[$ff0 shr 2];
        rdp_reg.curr := dpc_reg[2];
        rdp_reg.pc[0] := rdp_reg.curr;
        rdp_reg.size := sp_dmem[$ff4 shr 2];  (* we need this in audio task *)
        rdp_reg.pc_i := 0;
        rdp_reg.halt := 0;
        end;

end; (* procedure rdp_dl_check; *)



procedure rdp_go2;
begin
exit;
end; (* procedure rdp_go; *)





procedure rdp_dis2;
begin

end; (* procedure rdp_dis; *)





procedure rdp_reset2;
begin
        rdp_reg.pc_i := 0;
        rdp_reg.halt := 1;
	rdp_reg.m_CurTile :=  @rdp_reg.td[0];
end; (* procedure rdp_reset; *)






procedure rdp_step2;
var
a:int64;
begin
{	a := rdp_reg.pc[rdp_reg.pc_i];
(*	do
	begin
        a = rdp_reg.pc[rdp_reg.pc_i];
		if (a > $3fffff)
		begin
			rdp_reg.halt=1;
			return;
		end;
*)
        rdp_reg.cmd0 := (mem.rd_ram[(a shr 2)+0]);
        rdp_reg.cmd1 := (rd_ram[(a shr 2)+1]);

        rdp_reg.curr := mem.dpc_reg[2] = \
        rdp_reg.pc[rdp_reg.pc_i] = a + 8;   (* point to next instruction *)

        switch(rdp_reg.task)
        begin
            case AUDIO_TASK:
    (* if audio is not compiled in we simulate the BREAK instr immediately *)
//#ifdef AUDIO
                aud_instruction[rdp_reg.cmd0shr24];
//#endif
                rdp_reg.size -= 8;
                if(rdp_reg.size == 0)
                begin

                        PRINT_RDP_MNEMONIC("RDP stops here - RSP BREAK will be simulated\n");
						rdp_fullsync;
                        rsp_reg.code = $0000000d;
                        rsp_dis($0000000d);   (* RSP BREAK instruction *)
                        rdp_reg.halt = 1;
//                 seems not to work with this
//                        reg.do_or_check_sthg = RS4300I_DO_AI_INTERRUPT;
//                
                end;
                break;

            case GFX_TASK:
                gfx_instruction[rdp_reg.cmd0shr24];
                break;
        end;
//	end;
//	while(!rdp_reg.halt);}
end; (* procedure rdp_step; *)

procedure rdp_dl_check3;
var
ExecuteDList:pointer;
begin
{        uWORD    a;

	rdp_dl_check;
	if (rdp_reg.task == INVALID_TASK)
	begin
		return;
	end;
	do
	begin
        a = rdp_reg.pc[rdp_reg.pc_i];

        rdp_reg.cmd0 = rd_ram[(ashr2)+0];
        rdp_reg.cmd1 = rd_ram[(ashr2)+1];


        rdp_reg.curr = dpc_reg[2] = \
        rdp_reg.pc[rdp_reg.pc_i] = a + 8;   (* point to next instruction *)

        switch(rdp_reg.task)
        begin
            case AUDIO_TASK:
    (* if audio is not compiled in we simulate the BREAK instr immediately *)
//#ifdef AUDIO
                aud_instruction[rdp_reg.cmd0shr24];
//#endif
                rdp_reg.size -= 8;
                if(rdp_reg.size == 0)
                begin

                        PRINT_RDP_MNEMONIC("RDP stops here - RSP BREAK will be simulated\n");
						rdp_fullsync;
                        rsp_reg.code = $0000000d;
                        rsp_dis($0000000d);   (* RSP BREAK instruction *)
                        rdp_reg.halt = 1;
//                 seems not to work with this
//                        reg.do_or_check_sthg = RS4300I_DO_AI_INTERRUPT;
//
                end;
                break;

            case GFX_TASK:
                gfx_instruction[rdp_reg.cmd0shr24];
                break;
        end;
	end; while(!rdp_reg.halt);
 }
end; (* procedure rdp_step; *)


(******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) - helper routines                          *
*                                                                              *
\******************************************************************************)
var
adr_test:Plongarray;
function segoffset2addr(so:int64):int64;
begin
	result := ( (rdp_reg.segment[ (so shr 24)  and  $0f] + (so  and  $00ffffff)  and  $003fffff) );
end; (* uWORD segoffset2addr(uWORD so) *)





(******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) - routines (graphics and audio)     *
*                                                                              *
\******************************************************************************)



procedure rdp_fixme;
begin

end; (* procedure rdp_fixme; *)


procedure rdp_spnoop;
begin

end; (* procedure rdp_spnoop; *)


(******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) - graphic routines                  *
*                                                                              *
\******************************************************************************)



(**
*
* Most matrix stuff was first done by Jeff.
* Great work, Jeff! (Niki)
*
**)

procedure rdp_matrix;
var
a, command :int64;
 m:array[0..4,0..4]of real;
 mtx: ^real;
 i,j:integer;
begin
 i:=0;
 j:=0;

   a := segoffset2addr(rdp_reg.cmd1);
   command := ((rdp_reg.cmd0 shr 16)  and  $ff);
   a := a shr 1;   // we have half uWORDs

	mtx :=  @m[0][0];
	repeat
        for j := 0 to 4 do
	begin
	m[i shr 2][j] := trunc((((rd_ram[(a + i + j)xor 1])  shl  16) or rd_ram[(a + i + j + 16)xor 1]) / 65536.0);
  	end;
        inc(i,4);
        until (i >= 16);

        case (command) of
        0:
        begin
        (* modelview  mul  nopush *)
        //glMatrixMode(GL_MODELVIEW);
        //glMultMatrixf(mtx);
        end;

        1, (* projection mul  nopush *)
        5:
        begin (* projection mul  push   *) (* the same, because there is just 1 proj matrix *)
       	//glMatrixMode(GL_PROJECTION);
       	//glMultMatrixf(mtx);
       	//glMatrixMode(GL_MODELVIEW);
        end;

        2:
        begin
        (* modelview  load nopush *)
        (*
         * we can use memcopy here because we have native float values here
         * ^. endian does not matter
         *)
	 //glMatrixMode(GL_MODELVIEW);
	 //glLoadMatrixf(mtx);
         end;

         3, (* projection load nopush *)
         7:begin (* projection load push   *) (* the same, because there is just 1 proj matrix *) (* thanks Gil *)
	//glMatrixMode(GL_PROJECTION);
	//glLoadMatrixf(mtx);
	//glMatrixMode(GL_MODELVIEW);
          end;

          4:
          begin (* modelview  mul  push   *)
	  //			glMatrixMode(GL_MODELVIEW);
	  //			glPushMatrix;
          //      glMultMatrixf(mtx);
          end;

          6:begin (* modelview  load push   *)
	   //		glMatrixMode(GL_MODELVIEW);
	   //			glPushMatrix;
           //     glLoadMatrixf(mtx);
            end;


        end; (* switch(command) *)

        //CPU_HALT


end; (* procedure rdp_matrix; *)





procedure rdp_reserved0;
begin

end; (* procedure rdp_reserved0; *)





procedure rdp_movemem;
var
 a:int64;
 lindx:integer;
begin





    (* we do 'shr 1' here because we just need sHWORD's *)
        a := segoffset2addr(rdp_reg.cmd1) shr 1;

        case ((rdp_reg.cmd0 shr 16)  and  $ff) of
         $80:
         begin
                rdp_reg.vp[0] := (rd_ram[(a+0)xor 1] div 4);
                rdp_reg.vp[1] := (rd_ram[(a+1)xor 1] div 4);
                rdp_reg.vp[2] := (rd_ram[(a+2)xor 1] div 4);
                rdp_reg.vp[3] := (rd_ram[(a+3)xor 1] div 4);
                rdp_reg.vp[4] := (rd_ram[(a+4)xor 1] div 4);
                rdp_reg.vp[5] := (rd_ram[(a+5)xor 1] div 4);
                rdp_reg.vp[6] := (rd_ram[(a+6)xor 1] div 4);
                rdp_reg.vp[7] := (rd_ram[(a+7)xor 1] div 4);
                end;

            $82:
            begin
	        a := segoffset2addr(rdp_reg.cmd1);// shr 1;
                rdp_reg.lookat_x.rgba      := rd_ram[ (a shr 2)+ 0   ];
                rdp_reg.lookat_x.rgba_copy := rd_ram[ (a shr 2)+ 1   ];
                rdp_reg.lookat_x.dir[0]    := rd_ram[( a    + 8)xor 3];
                rdp_reg.lookat_x.dir[1]    := rd_ram[( a    + 9)xor 3];
                rdp_reg.lookat_x.dir[2]    := rd_ram[( a    +10)xor 3];
                rdp_reg.lookat_x.dummy     := rd_ram[( a    +11)xor 3];
            end;

            $84:
            begin
            a := segoffset2addr(rdp_reg.cmd1);// shr 1;
                rdp_reg.lookat_y.rgba      := rd_ram[ (a shr 2)+ 0   ];
                rdp_reg.lookat_y.rgba_copy := rd_ram[ (a shr 2)+ 1   ];
                rdp_reg.lookat_y.dir[0]    := rd_ram[( a    + 8)xor 3];
                rdp_reg.lookat_y.dir[1]    := rd_ram[( a    + 9)xor 3];
                rdp_reg.lookat_y.dir[2]    := rd_ram[( a    +10)xor 3];
                rdp_reg.lookat_y.dummy     := rd_ram[( a    +11)xor 3];

            end;

           $86,
           $88,
           $8a,
           $8c,
           $8e,
           $90,
           $92,
           $94:
   	 begin
         lindx := ((rdp_reg.cmd0 shr 17)  and  $7f) - $43;
         a := segoffset2addr(rdp_reg.cmd1);// shr 1;
         rdp_reg.light[lindx].rgba     := rd_ram[ (a shr 2)+ 0   ];
                rdp_reg.light[lindx].rgba_copy := rd_ram[ (a shr 2)+ 1   ];
                rdp_reg.light[lindx].dir[0]    := rd_ram[( a    + 8) xor 3];
                rdp_reg.light[lindx].dir[1]    := rd_ram[( a    + 9) xor 3];
                rdp_reg.light[lindx].dir[2]    := rd_ram[( a    +10) xor 3];
                rdp_reg.light[lindx].dummy     := rd_ram[( a    +11) xor 3];

//				SET_Light(lindx);
	   end;

            $98:
            begin

            end;

             $9a:
             begin

             end;

             $9c:
             begin

             end;

             $9e:
             begin
             end;


        end; (* switch((rdp_reg.cmd0 shr 8)  and  $ffff) *)


end; (* procedure rdp_movemem; *)

var vertex_number_relation:integer;

procedure rdp_vertex;
begin
        uWORD   a = segoffset2addr(rdp_reg.cmd1)  and  $003fffff;
        uHWORD  len;
        int     v0, i, n;

		float TScaleT, TScaleS, width, height;

		PRINT_RDP_INFO("VERTEX")

// GiL stuff :)
		v0 = (rdp_reg.cmd0 shr 16)  and  $f;
		len = (uHWORD)(rdp_reg.cmd0  and  $ffff);
		n = ((len  and  $1ff)+1) / $10;
		vertex_number_relation = ((len shr 9)  and  $7f) / n;
		if (vertex_number_relation == 2)
			v0 = ((rdp_reg.cmd0 shr 16)  and  $2f) shr $1;

		(* sanity check the values, so that we don't risk to write into unknown memory *)
		if ((v0 + n) > 32) n = 32 - v0;
// End Gil

		rdp_reg.m_CurTile= and rdp_reg.td[0];

		width=(float)((short)rdp_reg.m_CurTile^.lrs shr rdp_reg.m_CurTile^.shifts);
		width=width - (float)((short)rdp_reg.m_CurTile^.uls shr rdp_reg.m_CurTile^.shifts);
		if(width==0) width=1.f;

		height=(float)((short)rdp_reg.m_CurTile^.lrt shr rdp_reg.m_CurTile^.shiftt);
		height=height - (float)((short)rdp_reg.m_CurTile^.ult shr rdp_reg.m_CurTile^.shiftt);
		if(height==0) height=1.f;

		TScaleS = rdp_reg.m_CurTile^.SScale / width;
		TScaleT = rdp_reg.m_CurTile^.TScale / height;

		if (Center1 != 0) 
		begin
			TScaleS = TScaleS / 2;
			TScaleT = TScaleT / 2;
		end;


        for(i = 0; i < (n shl 4); i+=16)
        begin
			rdp_reg.vtx[v0].x     = (float) ((sHWORD *)mem.rd_ram[(((a+i) shr 1) + 0) xor 1];
			rdp_reg.vtx[v0].y     = (float) ((sHWORD *)mem.rd_ram[(((a+i) shr 1) + 1) xor 1];
			rdp_reg.vtx[v0].z     = (float) ((sHWORD *)mem.rd_ram[(((a+i) shr 1) + 2) xor 1];
			rdp_reg.vtx[v0].flags =			((uHWORD *)mem.rd_ram[(((a+i) shr 1) + 3) xor 1];
			rdp_reg.vtx[v0].s     = ((float)((sHWORD *)mem.rd_ram[(((a+i) shr 1) + 4) xor 1]) * TScaleS;
			rdp_reg.vtx[v0].t     = ((float)((sHWORD *)mem.rd_ram[(((a+i) shr 1) + 5) xor 1]) * TScaleT;
			rdp_reg.vtx[v0].r     = ((uBYTE  *)mem.rd_ram[(a+i+12) xor 3];
			rdp_reg.vtx[v0].g     = ((uBYTE  *)mem.rd_ram[(a+i+13) xor 3];
			rdp_reg.vtx[v0].b     = ((uBYTE  *)mem.rd_ram[(a+i+14) xor 3];
			rdp_reg.vtx[v0].a     = ((uBYTE  *)mem.rd_ram[(a+i+15) xor 3];
(*
			if ((rdp_reg.m_CurTile^.clamps != 0)  and  (rdp_reg.vtx[v0].s > 1))
				rdp_reg.vtx[v0].s     = 1;
			if ((rdp_reg.m_CurTile^.clampt != 0)  and  (rdp_reg.vtx[v0].t > 1))
				rdp_reg.vtx[v0].t     = 1;
*)
			v0++;
		end;
end; (* procedure rdp_vertex; *) 




procedure rdp_reserved1;
begin

end; (* procedure rdp_reserved1; *)





procedure rdp_displaylist;
begin

        uWORD addr = segoffset2addr(rdp_reg.cmd1)  and  $003fffff;
        uWORD push = (rdp_reg.cmd0 shr 16)  and  $ff;


        switch(push)
        begin
            case 0:   (* push: we do a call of the dl *)
                rdp_reg.pc_i++;
                if(rdp_reg.pc_i > 9)
                begin
                        PRINT_RDP_WARNING("DL STACK OVERFLOW (too much (>9) DISPLAYLIST calls\n"
                                          "will not call dl!!! - ignored")
                        return;
                end;

                PRINT_RDP_MNEMONIC("call dl#%d; addr=$%08lx (seg#%d, offset=$%lx)\n",
                        rdp_reg.pc_i,
                        addr,
                        (rdp_reg.cmd1 shr 24)  and  $0f,
                        rdp_reg.cmd1  and  $00ffffff );

                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            case 1:   (* no push: we jump to the dl *)
//puts("DISPLAYLIST: no push");
                PRINT_RDP_MNEMONIC("jump dl#%d; addr=$%08lx (seg#%d, offset=$%lx)\n",
                        rdp_reg.pc_i,
                        addr,
                        (rdp_reg.cmd1 shr 24)  and  $0f,
                        rdp_reg.cmd1  and  $00ffffff );
                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            default:
                PRINT_RDP_WARNING("DISPLAYLIST - parameter not supported");
                CPU_HALT
                break;

        end; (* switch(push) *)
end; (* procedure rdp_displaylist; *)






procedure rdp_reserved2;
begin

end; (* procedure rdp_reserved2; *)





procedure rdp_reserved3;
begin

end; (* procedure rdp_reserved3; *)





procedure rdp_sprite2d;
begin

(*        char *format[]   = begin "RGBA", "YUV", "CI", "IA", "I", "?", "?", "?" end;
        char *size[]     = begin "4bit", "8bit", "16bit", "32bit" end;

        uWORD    a               = segoffset2addr(rdp_reg.cmd1);
        uWORD    dst_p;  /(** dest pointer
        uWORD    dst_w;  /(** dest with (normally 320 or 640)
        uWORD    dst_b;  /(** dest depth (16bit: 2; 32bit: 3)

        uWORD    src             = ((uWORD *) mem.rd_ram[((ashr2)+ 0) xor 0];
        uWORD    src_ci          = ((uWORD *) mem.rd_ram[((ashr2)+ 1) xor 0];
        uHWORD   src_w           = ((uHWORD *)mem.rd_ram[((ashr1)+ 4) xor 1];
        uHWORD   sprite_w        = ((uHWORD *)mem.rd_ram[((ashr1)+ 5) xor 1];
        uHWORD   sprite_h        = ((uHWORD *)mem.rd_ram[((ashr1)+ 6) xor 1];
        uBYTE    src_type        = ((uBYTE *) mem.rd_ram[( a    +14) xor 3];   /(** rgba, ci, ai, a, i
        uBYTE    src_bits        = ((uBYTE *) mem.rd_ram[( a    +15) xor 3];   /(** 4, 8, 16, 32
        float   scale_x         = ((float)((uHWORD *)mem.rd_ram[((ashr1)+ 8) xor 1]) / 1024.f;   /(** s5.10
        float   scale_y         = ((float)((uHWORD *)mem.rd_ram[((ashr1)+ 9) xor 1]) / 1024.f;   /(** s5.10
        uBYTE    flip_x          = ((uBYTE *) mem.rd_ram[( a    +20) xor 3];
        uBYTE    flip_y          = ((uBYTE *) mem.rd_ram[( a    +21) xor 3];
        uHWORD   src_ox          = ((uHWORD *)mem.rd_ram[((ashr1)+11) xor 1];
        uHWORD   src_oy          = ((uHWORD *)mem.rd_ram[((ashr1)+12) xor 1];
        uHWORD   dst_ox          = ((uHWORD *)mem.rd_ram[((ashr1)+13) xor 1];
        uHWORD   dst_oy          = ((uHWORD *)mem.rd_ram[((ashr1)+14) xor 1];
        dst_b = vi_reg[0]  and  $03;
        if(dst_b != 2  and  and  dst_b != 3)
        begin
                PRINT_RDP_NOT_IMPLEMENTED("SPRITE2D: dest screen has unsupported depth\n")
                CPU_HALT
                return;
        end;
        dst_w = vi_reg[2];
        dst_p = vi_reg[1];
        dst_p  and = $003fffff;

        PRINT_RDP_INFO("SPRITE2D: ")
        PRINT_RDP_MNEMONIC("	addr=$%08lx (seg#%d, offset=$%lx):\n"
                           "        src     : $%08lx\n"
                           "        src_ci  : $%08lx\n"
                           "        src_w   : $%04lx (%d)\n"
                           "        sprite_w: $%04lx (%d)\n"
                           "        sprite_h: $%04lx (%d)\n"
                           "        src_type: $%02lx   (%s)\n"
                           "        src_bits: $%02lx   (%s)\n"
                           "        scale_x : %f\n"
                           "        scale_y : %f\n"
                           "        flip_x  : $%02lx\n"
                           "        flip_y  : $%02lx\n"
                           "        src_ox  : $%04lx (%d)\n"
                           "        src_oy  : $%04lx (%d)\n"
                           "        dst_ox  : $%04lx (%d)\n"
                           "        dst_oy  : $%04lx (%d)\n",
                           a, (rdp_reg.cmd1 shr 24)  and  $0f, rdp_reg.cmd1  and  $00ffffff,
                           src, src_ci, src_w, src_w,
                           sprite_w, sprite_w, sprite_h, sprite_h, src_type, format[src_type], src_bits, size[src_bits],
                           scale_x, scale_y,
                           flip_x, flip_y,
                           src_ox, src_ox, src_oy, src_oy,
                           dst_ox, dst_ox, dst_oy, dst_oy);
        PRINT_RDP_WARNING("scale and flip are ignored")



        /(** BUG? the following might be just used with the TEXRECT and FILLRECT commands
        /(** - i don't know
        if(!(rdp_reg.mode_h  and  $00200000))
        begin
            /(** if we are not in copy or fill mode (we are in 1 or 2 cycle mode)
            (** we must not draw the bottom and right edges
                //xl--;
                //yl--;
        end;

/(**
        draw2d(src, src_ci, src_type, src_bits, src_w, src_ox, src_oy,
                sprite_w, sprite_h, flip_x, flip_y,
                dst_p, 0, dst_b, dst_w, dst_ox, dst_oy );

*)
end; // procedure rdp_sprite2d;





procedure rdp_tri1;
begin
        int   vn[3], f, div;
		uWORD cmd0 = rdp_reg.cmd0;
		uWORD cmd1 = rdp_reg.cmd1;

        PRINT_RDP_INFO("TRI1")

        div = 10 / ((vertex_number_relation*vertex_number_relation)+1);


        vn[0] = ((rdp_reg.cmd1 shr 16)  and  $ff) / div;
        vn[1] = ((rdp_reg.cmd1 shr  8)  and  $ff) / div;
        vn[2] = ( rdp_reg.cmd1         and  $ff) / div;

        f     =  (rdp_reg.cmd1 shr 24)  and  $ff;

        DrawVisualTriangle(vn);
         
end; (* procedure rdp_tri1; *)
int triUseprim;
procedure rdp_tri2;
begin
        int vn[6], div;

        div = 10 / ((vertex_number_relation*vertex_number_relation)+1);

		PRINT_RDP_INFO("TRI2")
        vn[0] = ((rdp_reg.cmd0 shr 16)  and  $ff) / div;
        vn[1] = ((rdp_reg.cmd0 shr  8)  and  $ff) / div;
        vn[2] = ( rdp_reg.cmd0         and  $ff) / div;
        vn[3] = ((rdp_reg.cmd1 shr 16)  and  $ff) / div;
        vn[4] = ((rdp_reg.cmd1 shr  8)  and  $ff) / div;
        vn[5] = ( rdp_reg.cmd1         and  $ff) / div;
		triUseprim = 1;
		DrawVisualTriangle(vn);
		DrawVisualTriangle(vn+3);
		triUseprim = 0;
end; (* procedure rdp_tri2; *)




procedure rdp_culldl;
begin
        PRINT_RDP_NOT_IMPLEMENTED("CULLDL")

        CPU_HALT

end; (* procedure rdp_culldl; *)





procedure rdp_popmatrix;
begin
    (* Compleately from Gil - thanks *)
        uWORD            param;

	

        PRINT_RDP_INFO("POPMATRIX ")

        param = rdp_reg.cmd1;

        switch(param)
        begin
            case 0: /(** modelview pop 
					glMatrixMode(GL_MODELVIEW);
					glPopMatrix;
                break;

            case 1: /(** projection pop 
                    /(** only 1 projection matrix . Not possible! 
                break;
        end;

end; (* procedure rdp_popmatrix; *)





procedure rdp_moveword;
begin

        switch(rdp_reg.cmd0  and  $ff)
        begin
            case $00:
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD MATRIX")
                CPU_HALT
                break;

            case $02:
                rdp_reg.lights = (rdp_reg.cmd1 - $80000000) / 32 - 1;
                PRINT_RDP_INFO("MOVEWORD NUMLIGHT: ")
                PRINT_RDP_MNEMONIC("	lights: %d\n", rdp_reg.lights);
                break;

            case $04:
                PRINT_RDP_INFO("MOVEWORD CLIP: ")
                switch((rdp_reg.cmd0 shr 8)  and  $ffff)
                begin
                    case $0004:
                        PRINT_RDP_MNEMONIC("	-x = ");
                        rdp_reg.clip.nx = rdp_reg.cmd1;
                        break;

                    case $000c:
                        PRINT_RDP_MNEMONIC("	-y = ");
                        rdp_reg.clip.ny = rdp_reg.cmd1;
                        break;

                    case $0014:
                        PRINT_RDP_MNEMONIC("	+x = ");
                        rdp_reg.clip.px = rdp_reg.cmd1;
                        break;

                    case $001c:
                        PRINT_RDP_MNEMONIC("	+y = ");
                        rdp_reg.clip.py = rdp_reg.cmd1;
                        break;

                    default:
                        PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD CLIP - wrong offset")
                        CPU_HALT

                end; (* switch((rdp_reg.cmd0 shr 8)  and  $ffff) *)

                PRINT_RDP_MNEMONIC("	%d\n", (sWORD)(sHWORD)rdp_reg.cmd1);
                PRINT_RDP_WARNING("ignored");
                break;

            case $06:
                PRINT_RDP_INFO("MOVEWORD SEGMENT: ")
                PRINT_RDP_MNEMONIC("	$%08lx ^. seg#%d\n", rdp_reg.cmd1, (rdp_reg.cmd0 shr 10)  and  $f);
                rdp_reg.segment[(rdp_reg.cmd0 shr 10)  and  $f] = rdp_reg.cmd1;
                break;

            case $08:
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD FOG")
                CPU_HALT
                break;

            case $0a:
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD LIGHTCOL")
                CPU_HALT
                break;

            case $0c:
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD POINTS")
                CPU_HALT
                break;

            case $0e:
                PRINT_RDP_INFO("MOVEWORD PERSPNORM: ")
                PRINT_RDP_MNEMONIC("	factor: %d ($%lx)\n", rdp_reg.cmd1, rdp_reg.cmd1);
            (**
            *
            * We don't need this. This is to make multipltiplication for s15.16 values 
            * more precise. We use float values. They are precise enough!
            *
            **)
(*
                perspective_normal = ((float)rdp_reg.cmd1) / 65536.0;
*)
                break;

            default:
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD ?")
                CPU_HALT

        end; (* switch(rdp_reg.cmd0  and  $ff) *)

end; (* procedure rdp_moveword; *)





procedure rdp_texturemode;
begin
        int tile = (rdp_reg.cmd0 shr 8)   and  $07;				/(** tile
		uWORD mipmap_level = (rdp_reg.cmd0 shr 11)  and  $07;	/(** mipmap_level   - not used yet
		uWORD on = (rdp_reg.cmd0  and  $ff);			/(** 1: on - 0:off

		sHWORD s = ((rdp_reg.cmd1 shr 16)  and  $ffff);
		sHWORD t =  (rdp_reg.cmd1  and  $ffff);

		t_tile *tmp_tile =  and rdp_reg.td[tile];
		tmp_tile^.Texture_on = on;

/(** Skale S and T 
		if(s<=1) tmp_tile^.SScale=1.f;
		else tmp_tile^.SScale=(float )s/65535.f;

		if(t<=1) tmp_tile^.TScale=1.f;
		else  tmp_tile^.TScale=(float )t/65535.f;

		tmp_tile^.TScale/=32.f;
		tmp_tile^.SScale/=32.f;


        PRINT_RDP_INFO("TEXTUREMODE");
(*      PRINT_RDP_MNEMONIC("	tile: %ld; scale_s: %9.6f; scale_t: %9.6f; mipmap_level: %ld; on: %ld\n",
                tile,
                rdp_reg.texture[tile].scale_s,
                rdp_reg.texture[tile].scale_t,
                rdp_reg.texture[tile].mipmap_level,
                rdp_reg.texture[tile].on );
*)        
end; (* procedure rdp_texture; *)





procedure rdp_setothermode_h;
begin
        char *ad[] = begin "pattern", "notpattern", "noise", "disable" end;
        char *rd[] = begin "magicsq", "bayer", "noise", "?" end;
        char *ck[] = begin "none", "key" end;
        char *tc[] = begin "conv", "?", "?", "?", "?", "filtconv", "filt", "?" end;
        char *tf[] = begin "point", "?", "bilerp", "average" end;
        char *tt[] = begin "none", "?", "rgba16", "ia16" end;
        char *tl[] = begin "tile", "lod" end;
        char *td[] = begin "clamp", "sharpen", "detail", "?" end;
        char *tp[] = begin "none", "persp" end;
        char *ct[] = begin "1cycle", "2cycle", "copy", "fill" end;
        char *cd[] = begin "disable(hw>1)", "enable(hw>1)", "disable(hw1)", "enable(hw1)" end;
        char *pm[] = begin "nprimitive", "1primitive" end;

        switch((rdp_reg.cmd0 shr 8)  and  $ff)
        begin
            case $00:
                PRINT_RDP_WARNING("SETOTHERMODE_H BLENDMASK - ignored")
                CPU_HALT
                break;

            case $04:
                PRINT_RDP_INFO("SETOTHERMODE_H ALPHADITHER: ")
                PRINT_RDP_MNEMONIC("	%s\n", ad[(rdp_reg.cmd1shr$04)  and  $3]);
                rdp_reg.mode_h  and = ~$00000030;
                rdp_reg.cmd1    and =  $00000030;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $06:
                PRINT_RDP_INFO("SETOTHERMODE_H RGBDITHER: ")
                PRINT_RDP_MNEMONIC("	%s\n", rd[(rdp_reg.cmd1shr$06)  and  $3]);
                rdp_reg.mode_h  and = ~$000000c0;
                rdp_reg.cmd1    and =  $000000c0;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $08:
                PRINT_RDP_INFO("SETOTHERMODE_H COMBINEKEY: ")
                PRINT_RDP_MNEMONIC("	%s\n", ck[(rdp_reg.cmd1shr$08)  and  $1]);
                rdp_reg.mode_h  and = ~$00000100;
                rdp_reg.cmd1    and =  $00000100;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $09:
                PRINT_RDP_INFO("SETOTHERMODE_H TEXTURECONVERT: ")
                PRINT_RDP_MNEMONIC("	%s\n", tc[(rdp_reg.cmd1shr$09)  and  $7]);
                rdp_reg.mode_h  and = ~$00000e00;
                rdp_reg.cmd1    and =  $00000e00;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $0c:
                PRINT_RDP_INFO("SETOTHERMODE_H TEXTUREFILTER: ")
                PRINT_RDP_MNEMONIC("	%s\n", tf[(rdp_reg.cmd1shr$0c)  and  $3]);
                rdp_reg.mode_h  and = ~$00003000;
                rdp_reg.cmd1    and =  $00003000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $0e:
                PRINT_RDP_INFO("SETOTHERMODE_H TEXTURELUT: ")
                PRINT_RDP_MNEMONIC("	%s\n", tt[(rdp_reg.cmd1shr$0e)  and  $3]);
                rdp_reg.mode_h  and = ~$0000c000;
                rdp_reg.cmd1    and =  $0000c000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $10:
                PRINT_RDP_INFO("SETOTHERMODE_H TEXTURELOD: ")
                PRINT_RDP_MNEMONIC("	%s\n", tl[(rdp_reg.cmd1shr$10)  and  $1]);
                rdp_reg.mode_h  and = ~$00010000;
                rdp_reg.cmd1    and =  $00010000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $11:
                PRINT_RDP_INFO("SETOTHERMODE_H TEXTUREDETAIL: ")
                PRINT_RDP_MNEMONIC("	%s\n", td[(rdp_reg.cmd1shr$11)  and  $3]);
                rdp_reg.mode_h  and = ~$00060000;
                rdp_reg.cmd1    and =  $00060000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $13:
                PRINT_RDP_INFO("SETOTHERMODE_H TEXTUREPERSP: ")
                PRINT_RDP_MNEMONIC("	%s\n", tp[(rdp_reg.cmd1shr$13)  and  $1]);
                rdp_reg.mode_h  and = ~$00080000;
                rdp_reg.cmd1    and =  $00080000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $14:
                PRINT_RDP_INFO("SETOTHERMODE_H CYCLETYPE: ")
                PRINT_RDP_MNEMONIC("	%s\n", ct[(rdp_reg.cmd1shr$14)  and  $3]);
                rdp_reg.mode_h  and = ~$00300000;
                rdp_reg.cmd1    and =  $00300000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $16:
                PRINT_RDP_INFO("SETOTHERMODE_H COLORDITHER: ")
                PRINT_RDP_MNEMONIC("	%s\n", cd[(rdp_reg.cmd1shr$16)  and  $1]);
                rdp_reg.mode_h  and = ~$00400000;
                rdp_reg.cmd1    and =  $00400000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case $17:
                PRINT_RDP_INFO("SETOTHERMODE_H PIPELINEMODE: ")
                PRINT_RDP_MNEMONIC("	%s\n", pm[(rdp_reg.cmd1shr$17)  and  $1]);
                rdp_reg.mode_h  and = ~$00800000;
                rdp_reg.cmd1    and =  $00800000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            default:
                PRINT_RDP_NOT_IMPLEMENTED("SETOTHERMODE_H ?")
                CPU_HALT

        end; (* switch((rdp_reg.cmd0 shr 8)  and  $ff) *)


end; (* procedure rdp_setothermode_h; *)





procedure rdp_setothermode_l;
begin
        char *ac[] = begin "none", "threshold", "?", "diter" end;
        char *zs[] = begin "pixel", "prim" end;
        char *a1[] =
                begin
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)"
                end;
        char *b1[] =
                begin
                        "        bl_clr_in (1)",
                        "        bl_clr_mem (1)",
                        "        bl_clr_bl (1)",
                        "        bl_clr_fog (1)"
                end;
        char *c1[] =
                begin
                        "        bl_a_in (1)",
                        "        bl_a_fog (1)",
                        "        bl_a_shade (1)",
                        "        bl_0 (1)"
                end;
        char *d1[] =
                begin
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)" 
                end;
        char *a2[] =
                begin
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)"
                end;
        char *b2[] =
                begin
                        "        bl_clr_in (2)",
                        "        bl_clr_mem (2)",
                        "        bl_clr_bl (2)",
                        "        bl_clr_fog (2)"
                end;
        char *c2[] =
                begin
                        "        bl_a_in (2)",
                        "        bl_a_fog (2)",
                        "        bl_a_shade (2)",
                        "        bl_0 (2)"
                end;
        char *d2[] =
                begin
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)" 
                end;

        switch((rdp_reg.cmd0 shr 8)  and  $ff)
        begin
            case $00:
                PRINT_RDP_INFO("SETOTHERMODE_L ALPHACOMPARE: ")
                PRINT_RDP_MNEMONIC("	%s\n", ac[(rdp_reg.cmd1shr$00)  and  $3]);
                rdp_reg.mode_l  and = ~$00000003;
                rdp_reg.cmd1    and =  $00000003;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case $02:
                PRINT_RDP_INFO("SETOTHERMODE_L ZSRCSEL: ")
                PRINT_RDP_MNEMONIC("	%s\n", zs[(rdp_reg.cmd1shr$02)  and  $1]);
                rdp_reg.mode_l  and = ~$00000004;
                rdp_reg.cmd1    and =  $00000004;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case $03:
                PRINT_RDP_INFO("SETOTHERMODE_L RENDERMODE: ")
                PRINT_RDP_MNEMONIC("	$%08lx:\n", rdp_reg.cmd1  and  $fffffff8,
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n",
                        rdp_reg.cmd1  and  $fffffff8,
                        (rdp_reg.cmd1  and  $00000008) ? "        anti alias\n" : "",
                        (rdp_reg.cmd1  and  $00000010) ? "        z_cmp\n" : "",
                        (rdp_reg.cmd1  and  $00000020) ? "        z_upd\n" : "",
                        (rdp_reg.cmd1  and  $00000040) ? "        im_rd\n" : "",
                        (rdp_reg.cmd1  and  $00000080) ? "        clr_on_cvg\n" : "",
                        (rdp_reg.cmd1  and  $00000100) ? "        cvg_dst_warp\n" : "",
                        (rdp_reg.cmd1  and  $00000200) ? "        cvg_dst_full\n" : "",
                        (rdp_reg.cmd1  and  $00000400) ? "        z_inter\n" : "",
                        (rdp_reg.cmd1  and  $00000800) ? "        z_xlu\n" : "",
                        (rdp_reg.cmd1  and  $00001000) ? "        cvg_x_alpha\n" : "",
                        (rdp_reg.cmd1  and  $00002000) ? "        alpha_cvg_sel\n" : "",
                        (rdp_reg.cmd1  and  $00004000) ? "        force_bl\n" : "",
                        (rdp_reg.cmd1  and  $00008000) ? "        tex_edge?\n" : "",
                        a2[(rdp_reg.cmd1shr16)  and  $3],
                        a1[(rdp_reg.cmd1shr18)  and  $3],
                        b2[(rdp_reg.cmd1shr20)  and  $3],
                        b1[(rdp_reg.cmd1shr22)  and  $3],
                        c2[(rdp_reg.cmd1shr24)  and  $3],
                        c1[(rdp_reg.cmd1shr26)  and  $3],
                        d2[(rdp_reg.cmd1shr28)  and  $3],
                        d1[(rdp_reg.cmd1shr30)  and  $3]
                        );

                rdp_reg.mode_l  and = ~$fffffff8;
                rdp_reg.cmd1    and =  $fffffff8;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case $16:
                PRINT_RDP_NOT_IMPLEMENTED("SETOTHERMODE_L BLENDER")
                break;

            default:
                PRINT_RDP_NOT_IMPLEMENTED("SETOTHERMODE_L ?")
                CPU_HALT

        end; (* switch((rdp_reg.cmd0 shr 8)  and  $ff) *)


end; (* procedure rdp_setothermode_l; *)




extern float test_t;
procedure rdp_enddl;
begin

        PRINT_RDP_INFO("ENDDL: ")
        PRINT_RDP_MNEMONIC("return from dl#%d\n", rdp_reg.pc_i);

        if(rdp_reg.pc_i < 0)
        begin
                PRINT_RDP_WARNING("DL STACK UNDERRUN (too much ENDDL calls)\n"
                                  "will not return from dl!!! - ignored")
                return;
        end;

        if(rdp_reg.pc_i == 0)
        begin
                PRINT_RDP_MNEMONIC("RDP stops here - RSP BREAK will be simulated\n");
				test_t = 3;
                FlushVisualRenderBuffer;

                rsp_reg.code = $0000000d;
                rsp_dis($0000000d);   (* RSP BREAK instruction *)
                rdp_reg.halt = 1;
        end;

        rdp_reg.pc_i--;
end; (* procedure rdp_enddl; *)


procedure rdp_setgeometrymode;
begin
        PRINT_RDP_INFO("SETGEOMETRYMODE ")
        PRINT_RDP_MNEMONIC(
                "+$%08lx:\n"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s",
                rdp_reg.cmd1,
                (rdp_reg.cmd1  and  $00000001) ? "        zbuffer\n" : "",
                (rdp_reg.cmd1  and  $00000002) ? "        texture\n" : "",
                (rdp_reg.cmd1  and  $00000004) ? "        shade\n" : "",
                (rdp_reg.cmd1  and  $00000200) ? "        shade smooth\n" : "",
                (rdp_reg.cmd1  and  $00001000) ? "        cull front\n" : "",
                (rdp_reg.cmd1  and  $00002000) ? "        cull back\n" : "",
                (rdp_reg.cmd1  and  $00010000) ? "        fog\n" : "",
                (rdp_reg.cmd1  and  $00020000) ? "        lightning\n" : "",
                (rdp_reg.cmd1  and  $00040000) ? "        texture gen\n" : "",
                (rdp_reg.cmd1  and  $00080000) ? "        texture gen lin\n" : "",
                (rdp_reg.cmd1  and  $00100000) ? "        lod\n" : ""
                );

/(** stuff by GiL
        rdp_reg.geometrymode |= rdp_reg.cmd1;
		if (rdp_reg.cmd1  and  $00000001) glEnable(GL_DEPTH_TEST);
//		if (rdp_reg.cmd1  and  $00000002) Textures = 1;
//		if (rdp_reg.cmd1  and  $00000004) Shade = 1;
//		if (rdp_reg.cmd1  and  $00000200) ShadeSmooth = 1;

		switch(rdp_reg.geometrymode  and  $00003000) /(** Must be geometrymode, and not cmd1 as far as I can see 
		begin
			case $1000 : glCullFace(GL_FRONT);			 glEnable(GL_CULL_FACE); break;
			case $2000 : glCullFace(GL_BACK);			 glEnable(GL_CULL_FACE); break;
			case $3000 : glCullFace(GL_FRONT_AND_BACK); glEnable(GL_CULL_FACE); break;
			default:      glDisable(GL_CULL_FACE);
		end;
end; (* procedure rdp_setgeometrymode; *)





procedure rdp_cleargeometrymode;
begin
        PRINT_RDP_INFO("CLEARGEOMETRYMODE ")
        PRINT_RDP_MNEMONIC(
                "-$%08lx\n"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s",
                rdp_reg.cmd1,
                (rdp_reg.cmd1  and  $00000001) ? "        zbuffer\n" : "",
                (rdp_reg.cmd1  and  $00000002) ? "        texture\n" : "",
                (rdp_reg.cmd1  and  $00000004) ? "        shade\n" : "",
                (rdp_reg.cmd1  and  $00000200) ? "        shade smooth\n" : "",
                (rdp_reg.cmd1  and  $00001000) ? "        cull front\n" : "",
                (rdp_reg.cmd1  and  $00002000) ? "        cull back\n" : "",
                (rdp_reg.cmd1  and  $00010000) ? "        fog\n" : "",
                (rdp_reg.cmd1  and  $00020000) ? "        lightning\n" : "",
                (rdp_reg.cmd1  and  $00040000) ? "        texture gen\n" : "",
                (rdp_reg.cmd1  and  $00080000) ? "        texture gen lin\n" : "",
                (rdp_reg.cmd1  and  $00100000) ? "        lod\n" : ""
                );

        rdp_reg.geometrymode  and = ~rdp_reg.cmd1;

		if (rdp_reg.cmd1  and  $00000001) glDisable(GL_DEPTH_TEST);

		switch(rdp_reg.geometrymode  and  $00003000) /(** Must be geometrymode, andnot cmd1 as far as I can see 
		begin
			case $1000 : glCullFace(GL_FRONT); glEnable(GL_CULL_FACE); break;
			case $2000 : glCullFace(GL_BACK);  glEnable(GL_CULL_FACE); break;
			case $3000 : glCullFace(GL_FRONT_AND_BACK); glEnable(GL_CULL_FACE); break;
			default:      glDisable(GL_CULL_FACE);
		end;
end; (* procedure rdp_cleargeometrymode; *)





procedure rdp_line3d;
begin
        PRINT_RDP_NOT_IMPLEMENTED("LINE3D")

        CPU_HALT

end; (* procedure rdp_line3d; *)





procedure rdp_rdphalf_1;
begin
        PRINT_RDP_NOT_IMPLEMENTED("RDPHALF_1")

        CPU_HALT

end; (* procedure rdp_rdphalf_1; *)





procedure rdp_rdphalf_2;
begin
        PRINT_RDP_NOT_IMPLEMENTED("RDPHALF_2")

        CPU_HALT

end; (* procedure rdp_rdphalf_2; *)





procedure rdp_rdphalf_cont;
begin
        PRINT_RDP_NOT_IMPLEMENTED("RDPHALF_CONT")

        CPU_HALT

end; (* procedure rdp_rdphalf_cont; *)





procedure rdp_noop;
begin
        PRINT_RDP_INFO("NOOP\n")

end; (* procedure rdp_noop; *)


procedure rdp_texrect;
begin
        uWORD    a = rdp_reg.pc[rdp_reg.pc_i];
        uWORD    cmd2 = rd_ram[(ashr2)+1];
        uWORD    cmd3 = rd_ram[(ashr2)+3];

        uHWORD   xh     = (rdp_reg.cmd0  and  $00fff000) shr 14; //1.
        uHWORD   yh     = (rdp_reg.cmd0  and  $00000fff) shr 2;  //2.
        uHWORD   xl     = (rdp_reg.cmd1  and  $00fff000) shr 14; //4
        uHWORD   yl     = (rdp_reg.cmd1  and  $00000fff) shr 2;  //5
        int     tile   = (rdp_reg.cmd1  and  $07000000) shr 24;  //3

        uHWORD   s      = (cmd2  and  $ffff0000) shr 16;  //6
        uHWORD   t      = cmd2  and  $0000ffff; // 7

        float   f_s    = ((float)((cmd2  and  $ffff0000) shr 16) / 31.f);
        float   f_t    = ((float)(cmd2  and  $0000ffff) / 31.f);                  (* is this correct jeff? *)

        sHWORD  dsdx   = (cmd3  and  $ffff0000) shr 16; // 8
        sHWORD  dsdy   = cmd3  and  $0000ffff; // 9
        float   f_dsdx = (float)((dsdx  and  $fc00) + (dsdx  and  $02ff) / 1023.f);
        float   f_dsdy = (float)((dsdy  and  $fc00) + (dsdy  and  $02ff) / 1023.f);

//        float   f_dsdx = (((float)((cmd3  and  $ffff0000) shr 16)) / 1023.f);
//        float   f_dsdy = (((float)(cmd3  and  $0000ffff)) / 1023.f);


	    DrawTexRectangle((float)xl-.4,
						 (float)yl-.4, 
						 (float)xh+.45, 
						 (float)yh+.45, f_s, f_t);



        PRINT_RDP_INFO("rdp_texrect;")

        PRINT_RDP_MNEMONIC("xh=%4hu; yh=%4hu; tile=%u; xl=%4hu; yl=%4hu; s=%+9.4f; t=%+9.4f; dsdx=%+7.4f; dtdy=%+7.4f\n",
               xh, yh, tile, xl, yl, f_s, f_t, f_dsdx, f_dsdy);
        PRINT_RDP_WARNING("some parameter are ignored")



    /(** so rdp_rdphalf_1 and rdp_rdphalf_2 are never reached 
        dpc_reg[2] = a + 16;
        rdp_reg.pc[rdp_reg.pc_i] += 16;

end; (* procedure rdp_texrect; *)


procedure rdp_texrectflip;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TEXRECTFLIP")

        CPU_HALT

end; (* procedure rdp_texrectflip; *)





procedure rdp_loadsync;
begin
        PRINT_RDP_INFO("LOADSYNC - ignored")
        PRINT_RDP_WARNING("ignored")

end; (* procedure rdp_loadsync; *)





procedure rdp_pipesync;
begin
        PRINT_RDP_INFO("PIPESYNC - ignored")
        PRINT_RDP_WARNING("ignored")

end; (* procedure rdp_pipesync; *)





procedure rdp_tilesync;
begin
        PRINT_RDP_INFO("TILESYNC - ignored")
        PRINT_RDP_WARNING("ignored")

end; (* procedure rdp_tilesync; *)





procedure rdp_fullsync;
begin
        PRINT_RDP_INFO("FULLSYNC")

        reg.do_or_check_sthg = RS4300I_DO_DP_INTERRUPT;
        //dpc_reg[2] = 0;

        //CPU_HALT

end; (* procedure rdp_fullsync; *)





procedure rdp_setkeygb;
begin
        PRINT_RDP_NOT_IMPLEMENTED("SETKEYGB")

        CPU_HALT

end; (* procedure rdp_setkeygb; *)





procedure rdp_setkeyr;
begin
        PRINT_RDP_NOT_IMPLEMENTED("SETKEYR")

        CPU_HALT

end; (* procedure rdp_setkeyr; *)





procedure rdp_setconvert;
begin
        PRINT_RDP_NOT_IMPLEMENTED("SETCONVERT")

        CPU_HALT

end; (* procedure rdp_setconvert; *)





procedure rdp_setscissor;
begin
        rdp_reg.scissor.ulx             = (rdp_reg.cmd0  and  $00fff000) shr 14;
        rdp_reg.scissor.uly             = (rdp_reg.cmd0  and  $00000fff) shr 2;
        rdp_reg.scissor.interlace_mode  = (rdp_reg.cmd1  and  $03000000) shr 24;
        rdp_reg.scissor.lrx             = (rdp_reg.cmd1  and  $00fff000) shr 14;
        rdp_reg.scissor.lry             = (rdp_reg.cmd1  and  $00000fff) shr 2;

    (* It seems that most demo coders thought that SETSCISSOR uses:
          x, y, width, height
       arguments. That is NOT correct. SETSCISSOR uses:
          ulx, uly, lrx, lry
       args!!! *)

        PRINT_RDP_WARNING("interlace_mode is ignored")

        SetVisualClipRectangle(rdp_reg.scissor.ulx, rdp_reg.scissor.uly, rdp_reg.scissor.lrx, rdp_reg.scissor.lry);

end; (* procedure rdp_setscissor; *)





procedure rdp_setprimdepth;
begin
        PRINT_RDP_NOT_IMPLEMENTED("SETPRIMDEPTH")

        CPU_HALT

end; (* procedure rdp_setprimdepth; *)





procedure rdp_setothermode;
begin
        PRINT_RDP_INFO("SETOTHERMODE")
        PRINT_RDP_WARNING("this should clear/init SETOTHERMODE_[HL] - is not done")

end; (* procedure rdp_setothermode; *)





procedure rdp_loadtlut;
begin
        uWORD  tile   = (rdp_reg.cmd1 shr 24)  and  $07;
        uHWORD count  = ((uHWORD)(rdp_reg.cmd1 shr 14)  and  $03ff);


        PRINT_RDP_INFO("LOADTLUT ")
        PRINT_RDP_MNEMONIC("	tile=%ld (^.tmem=%lx), count=%hx\n", 
               tile,
               rdp_reg.td[tile].tmem,
               count
               );

        rdp_reg.tlut_8_fmt  = rdp_reg.TextureImage.fmt;
        rdp_reg.tlut_8_size = rdp_reg.TextureImage.size;
        rdp_reg.tlut_8_addr = rdp_reg.TextureImage.addr;

        rdp_reg.tlut_4_fmt[rdp_reg.td[tile].palette]  = rdp_reg.TextureImage.fmt; 
        rdp_reg.tlut_4_size[rdp_reg.td[tile].palette] = rdp_reg.TextureImage.size;
        rdp_reg.tlut_4_addr[rdp_reg.td[tile].palette] = rdp_reg.TextureImage.addr;


end; (* procedure rdp_loadtlut; *)





procedure rdp_settilesize;
begin
        uWORD tile = (rdp_reg.cmd1 shr 24)  and  $07;
		t_tile *tmpTile =  and rdp_reg.td[tile];

        tmpTile^.uls = (uHWORD)((rdp_reg.cmd0 shr 12)  and  $0fff);
        tmpTile^.ult = (uHWORD)( rdp_reg.cmd0         and  $0fff);
        tmpTile^.lrs = (uHWORD)((rdp_reg.cmd1 shr 12)  and  $0fff);
        tmpTile^.lrt = (uHWORD)( rdp_reg.cmd1         and  $0fff);

        tmpTile^.uls = (tmpTile^.uls shr 2);
        tmpTile^.ult = (tmpTile^.ult shr 2);
        tmpTile^.lrs = (tmpTile^.lrs shr 2) + 1;
        tmpTile^.lrt = (tmpTile^.lrt shr 2) + 1;


		if(tmpTile^.lrs == tmpTile^.uls) tmpTile^.lrs++;
		if(tmpTile^.lrt == tmpTile^.ult) tmpTile^.lrt++;

		rdp_reg.m_CurTile=tmpTile;

		tmpTile^.Width = tmpTile^.lrs - tmpTile^.uls;
		tmpTile^.Height= tmpTile^.lrt - tmpTile^.ult;

//	WORD size=Width*Height*tmpTile^.size;
//	if(size==0) size=(Width*Height)/2;

        PRINT_RDP_INFO("SETTILESIZE ")
        PRINT_RDP_MNEMONIC("	uls=%hu; ult=%hu; lrs=%hu; lrt=%hu; tile=%lu\n",
                rdp_reg.td[tile].uls,
                rdp_reg.td[tile].ult,
                rdp_reg.td[tile].lrs,
                rdp_reg.td[tile].lrt,
                tile
                );

end; (* procedure rdp_settilesize; *)





procedure rdp_loadblock;
begin
		t_tile *tmpTile;
        uWORD TILE = (uWORD)((rdp_reg.cmd1 shr 24)  and  $07);

        uHWORD uls = (uHWORD)((rdp_reg.cmd0 shr 12)  and  $0fff);
        uHWORD ult = (uHWORD)( rdp_reg.cmd0         and  $0fff);
        uHWORD lrs = (uHWORD)((rdp_reg.cmd1 shr 12)  and  $0fff);
        uHWORD dxt = (uHWORD)( rdp_reg.cmd1         and  $0fff);
		uHWORD lrt = dxt;

		uHWORD width = (dxtshr11);
		uHWORD bytes = lrs;

		uDWORD Offset;

		tmpTile =  and rdp_reg.td[TILE];
		if(dxt and $7ff) width++;
			lrs++;

/(** MAKE IT BETTER
		switch(tmpTile^.size)
		begin
			case 0:
				widthshr=1;
				bytesshr=1;
				break;
			case 1:
				break;
			case 2:
				width shl =1;
				bytes shl =1;
				break;
			case 3:
				width shl =2;
				bytes shl =2;
				break;
		end;

		width shl =1;
		if(tmpTile^.size==0) lrs shl =2;
		if(tmpTile^.size==1) lrs shl =1;
/(** MAKE IT BETTER - end

// **  I doesnt know if we need this Offset (FiRES)
	uls/=4;
	lrs/=4;
	ult/=4;
	lrt/=4;

//	Offset = (width*tmpTile^.size)+lrs;
//	rdp_reg.TextureImage.addr = rdp_reg.TextureImage.addr + Offset;


//	rdp_reg.TextureImage.LoadAddr =  and mem.rd_ram[rdp_reg.TextureImage.addr];
/(** Generate an ID to identify Block/Texture
	PRINT_RDP_INFO("LOADBLOCK ")
(*	PRINT_RDP_MNEMONIC("	uls=%hu; ult=%hu; lrs=%hu; (real line width)dxt=%hu(*64bit); tile=%lu (^.tmem=%hx)\n",
			rdp_reg.td[TILE].uls,
			rdp_reg.td[TILE].ult,
			rdp_reg.td[TILE].lrs,
			rdp_reg.td[TILE].dxt,
			TILE,
			rdp_reg.td[TILE].tmem
			);
*)
end; (* procedure rdp_loadblock; *)





procedure rdp_loadtile;
begin
    int CURR_TILE = (rdp_reg.cmd1  and  $07000000) shr 24;
    int uls = (rdp_reg.cmd0  and  $00fff000) shr 12;
	int	ult =  rdp_reg.cmd0  and  $00000fff;
	int	lrs = (rdp_reg.cmd1  and  $00fff000) shr 12;
	int	lrt =  rdp_reg.cmd1  and  $00000fff;
	uWORD width, height, size;
	uDWORD Offset;


	t_tile *tmpTile= and rdp_reg.td[CURR_TILE];

	uls = uls shr 2;
	lrs = lrs shr 2;
	ult = ult shr 2;
	lrt = lrt shr 2;

	if(lrs  and  1) lrs++;
	if(lrt  and  1) lrt++;

	width=(lrs-uls);
	height=(lrt-ult);
	size=rdp_reg.TextureImage.size;

	switch(rdp_reg.TextureImage.size)
	begin
	case 0:
		size=1;
		widthshr=1;
		rdp_reg.TextureImage.widthshr=1;
		break;
	case 1:
		size=1;
		break;
	case 2:
		size=2;
		break;
	case 3:
		size=4;
		break;
	end;

	tmpTile^.Width = width;
	tmpTile^.Height = height;


	Offset := (ult*(width*size)+uls);

	inc(rdp_reg.TextureImage.addr , Offset);



end; (* procedure rdp_loadtile; *)





procedure rdp_settile;
begin
        char *format[]   = begin "RGBA", "YUV", "CI", "IA", "I", "?", "?", "?" end;
        char *size[]     = begin "4bit", "8bit", "16bit", "32bit" end;
        char *cm[]       = begin "NOMIRROR/WARP(NOCLAMP)", "MIRROR", "CLAMP", "MIRROR and CLAMP" end;

        uWORD tile = (uWORD)((rdp_reg.cmd1 shr 24)  and  $07);
		t_tile *tmpTile =  and rdp_reg.td[tile];

        tmpTile^.format  := (uBYTE) ((rdp_reg.cmd0 shr 21)  and  $07);
        tmpTile^.size    := (uBYTE) ((rdp_reg.cmd0 shr 19)  and  $02);
        tmpTile^.line    := (uHWORD)((rdp_reg.cmd0 shr  9)  and  $01ff);
        tmpTile^.tmem    := (uHWORD)( rdp_reg.cmd0         and  $01ff);
        tmpTile^.palette := (uBYTE) ((rdp_reg.cmd1 shr 20)  and  $0f);
        tmpTile^.clampt  := (uBYTE) ((rdp_reg.cmd1 shr 19)  and  $01);
        tmpTile^.mirrort := (uBYTE) ((rdp_reg.cmd1 shr 18)  and  $01);
        tmpTile^.maskt   := (uBYTE) ((rdp_reg.cmd1 shr 14)  and  $0f);
        tmpTile^.shiftt  := (uBYTE) ((rdp_reg.cmd1 shr 10)  and  $0f);
        tmpTile^.clamps  := (uBYTE) ((rdp_reg.cmd1 shr  9)  and  $01);
        tmpTile^.mirrors := (uBYTE) ((rdp_reg.cmd1 shr  8)  and  $01);
        tmpTile^.masks   := (uBYTE) ((rdp_reg.cmd1 shr  4)  and  $0f);
        tmpTile^.shifts  := (uBYTE) ( rdp_reg.cmd1         and  $0f);

//		Textures = 1;

		if(tile <> 7) then
		begin
			rdp_reg.m_CurTile:=tmpTile;
		end;


end; (* procedure rdp_settile; *)





procedure rdp_fillrect;
var
   ulx, uly, lrx, lry:int64;
   color:int64;
begin

        lrx := (rdp_reg.cmd0  and  $00ffc000) shr 14;
        lry := (rdp_reg.cmd0  and  $00000ffc) shr 2;
        ulx := (rdp_reg.cmd1  and  $00ffc000) shr 14;
        uly := (rdp_reg.cmd1  and  $00000ffc) shr 2;


    (* modes: copy mode is not used (not allowed?) *)
        if((rdp_reg.mode_h  and  $00200000)=0) then
        begin
            (* if we are not in 1 or 2 cycle mode (not in copy or fill mode) *)
            (* we must not draw the bottom and right edges                   *)
                dec(lrx);
                dec(lry);
                color := rdp_reg.blendcolor;
        end;
        else
        begin
                color := rdp_reg.fillcolor;
        end;

        SetVisualColor(color);

        DrawVisualRectangle(ulx, uly, lrx, lry);


end; (* procedure rdp_fillrect; *)





procedure rdp_setfillcolor;
begin
        rdp_reg.fillcolor := rdp_reg.cmd1;

end; (* procedure rdp_setfillcolor; *)





procedure rdp_setfogcolor;
begin
        rdp_reg.fogcolor := rdp_reg.cmd1;

end; (* procedure rdp_setfogcolor; *)





procedure rdp_setblendcolor;
begin
        rdp_reg.blendcolor := rdp_reg.cmd1;
end; (* procedure rdp_setblendcolor; *)





procedure rdp_setprimcolor;
begin
        rdp_reg.primcolor := rdp_reg.cmd1;

end; (* procedure rdp_setprimcolor; *)





procedure rdp_setenvcolor;
begin
        rdp_reg.envcolor := rdp_reg.cmd1;
end; (* procedure rdp_setenvcolor; *)





procedure rdp_setcombine; // changed june 14
begin
	scMode0 := (rdp_reg.cmd0  and  $00ffffff); // new june 14
	scMode1 := (rdp_reg.cmd1  and  $ffffffff);

	a0  := ((rdp_reg.cmd0 shr 20)  and  $f);
	c0  := ((rdp_reg.cmd0 shr 15)  and  $1f);
	Aa0 := ((rdp_reg.cmd0 shr 12)  and  $7);
	Ac0 := ((rdp_reg.cmd0 shr 9)   and  $7);

	a1  := ((rdp_reg.cmd0 shr 5)   and  $f);
	c1  := ((rdp_reg.cmd0 shr 0)   and  $1f);
	b0  := ((rdp_reg.cmd1 shr 28)  and  $F);
	d0  := ((rdp_reg.cmd1 shr 15)  and  $7);

	Ab0 := ((rdp_reg.cmd1 shr 12)  and  $7);
	Ad0 := ((rdp_reg.cmd1 shr 9)   and  $7);
	b1  := ((rdp_reg.cmd1 shr 24)  and  $f);
	Aa1 := ((rdp_reg.cmd1 shr 21)  and  $7);

	Ac1 := ((rdp_reg.cmd0 shr 18)  and  $7);
	d1  := ((rdp_reg.cmd0 shr 6)   and  $7);
	Ab1 := ((rdp_reg.cmd0 shr 3)   and  $7);
	Ad1 := ((rdp_reg.cmd0 shr 0)   and  $7);

	Center1 := 0;
	Textures1 := 0;
	Shade1 := 0;
	ShadeSmooth1 := 0;
	AlphaShade1 := 0;
	AlphaShadeSmooth1 := 0;

	Textures2 := 0;
	Shade2 := 0;
	ShadeSmooth2 := 0;
	AlphaShade2 := 0;
	AlphaShadeSmooth2 := 0;

	Textures3 := 0;
	Shade3 := 0;
	ShadeSmooth3 := 0;
	AlphaShade3 := 0;
	AlphaShadeSmooth3 := 0;

	Textures4 := 0;
	Shade4 := 0;
	ShadeSmooth4 := 0;
	AlphaShade4 := 0;
	AlphaShadeSmooth4 := 0;


	case (a0) of
	begin
        G_CCMUX_COMBINED:exit;	// 0

	G_CCMUX_TEXEL0:begin  	// 1
		Textures1 := 1;
		end;
	 G_CCMUX_TEXEL1:begin	// 2
		Textures1 := 1;
		end;
	 G_CCMUX_PRIMITIVE:begin	// 3
		Shade1 := 1;
		end;
	 G_CCMUX_SHADE: begin		// 4
		ShadeSmooth1 = 2;
		end;
	 G_CCMUX_ENVIRONMENT:begin	// 5
		end;
	 G_CCMUX_CENTER:begin	// 6
		Center1 := 1;
		end;
	 G_CCMUX_COMBINED_ALPHA:begin	// 7
		end;
	 G_CCMUX_TEXEL0_ALPHA:begin	// 8
		Textures1 := 1;
		end;
	 G_CCMUX_TEXEL1_ALPHA:begin	// 9
		Textures1 := 1;
		end;
	 G_CCMUX_PRIMITIVE_ALPHA:begin	// 10
		AlphaShade1 = 1;
		end;
	 G_CCMUX_SHADE_ALPHA:begin	// 11
		AlphaShadeSmooth1 = 2;
		end;
	 G_CCMUX_ENV_ALPHA:begin		// 12
//		Shade = 1;
		end;
	 G_CCMUX_LOD_FRACTION:begin	// 13
		end;
	 G_CCMUX_PRIM_LOD_FRAC:begin	// 14
		end;
	 G_CCMUX_K5:begin			// 15
		end;
	 G_CCMUX_0:begin				// 31
		end;
	end;
//Textures1 = 1;
//Shade1 = 0;
//ShadeSmooth1 = 0;
//Textures2 = 1;
//Shade2 = 0;
//ShadeSmooth2 = 0;
//Textures3 = 0;
//Shade3 = 0;
//ShadeSmooth3 = 0;
//Textures4 = 1;
//Shade4 = 0;
//ShadeSmooth4 = 0;

end; (* procedure rdp_setcombine; *)





procedure rdp_settextureimage;
var
format:array[0..7]of pchar;
size:array[0..3]of pchar;
begin

        format[0] := 'RGBA';
        format[0] := 'YUV';
        format[0] := 'CI';
        format[0] := 'IA';
        format[0] := 'I';
        format[0] := '?';
        format[0] := '?';
        format[0] := '?';
        size[0] := '4bit';
        size[0] := '8bit';
        size[0] := '16bit';
        size[0] := '32bit';


        rdp_reg.TextureImage.fmt	  := ((rdp_reg.cmd0 shr 21)  and  $07);
        rdp_reg.TextureImage.size	  := ((rdp_reg.cmd0 shr 19)  and  $03);
        rdp_reg.TextureImage.width	  := (1 + (rdp_reg.cmd0  and  $00000fff));
        rdp_reg.TextureImage.addr	  := segoffset2addr(rdp_reg.cmd1)  and  $003fffff;
 	rdp_reg.TextureImage.vaddr	  := rdp_reg.cmd0;
end; (* procedure rdp_settextureimage; *)


procedure rdp_setdepthimage;
begin

end; (* procedure rdp_setdepthimage; *)



procedure rdp_setcolorimage;
begin
        char *format[]   = begin "RGBA", "YUV", "CI", "IA", "I", "?", "?", "?" end;
        char *size[]     = begin "4bit", "8bit", "16bit", "32bit" end;

        rdp_reg.colorimg_fmt   = (uBYTE)((rdp_reg.cmd0  and  $00e00000) shr 21);
        rdp_reg.colorimg_size  = (uBYTE)((rdp_reg.cmd0  and  $00180000) shr 19);
        rdp_reg.colorimg_width = (uHWORD)(1 + (rdp_reg.cmd0  and  $00000fff));
        rdp_reg.colorimg_addr  = rdp_reg.cmd1;

        PRINT_RDP_INFO("SETCOLORIMAGE ")
        PRINT_RDP_MNEMONIC("	format=%s; size=%s; width=%hu; addr=$%lx\n",
                           format[rdp_reg.colorimg_fmt],
                           size[rdp_reg.colorimg_size],
                           rdp_reg.colorimg_width,
                           rdp_reg.colorimg_addr);
			test_t = 3;
//  	   FlushVisualRenderBuffer;
//         SetVisualRenderBuffer(
//                        rdp_reg.colorimg_fmt, rdp_reg.colorimg_size,
//                        rdp_reg.colorimg_width, rdp_reg.colorimg_addr + (uBYTE *)mem.rd_ram);


end; (* procedure rdp_setcolorimage; *)





procedure rdp_trifill;
begin

end; (* procedure rdp_trifill; *)





procedure rdp_trishade;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADE")

        CPU_HALT

end; (* procedure rdp_trishade; *)





procedure rdp_tritxtr;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRITXTR")

        CPU_HALT

end; (* procedure rdp_tritxtr; *)





procedure rdp_trishadetxtr;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADETXTR")

        CPU_HALT

end; (* procedure rdp_trishadetxtr; *)





procedure rdp_trifillz;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRIFILLZ")

        CPU_HALT

end; (* procedure rdp_trifillz; *)





procedure rdp_trishadez;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADEZ")

        CPU_HALT

end; (* procedure rdp_trishadez; *)





procedure rdp_tritxtrz;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRITXTRZ")

        CPU_HALT

end; (* procedure rdp_tritxtrz; *)





procedure rdp_trishadetxtrz;
begin
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADETXTRZ")

        CPU_HALT

end; (* procedure rdp_trishadetxtrz; *)










(******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) - audio routines                    *
*                                                                              *
\******************************************************************************)



procedure rdp_adpcm;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_ADPCM")

end; (* procedure rdp_adpcm; *)





procedure rdp_clearbuff;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_CLEARBUFF")

end; (* procedure rdp_clearbuff; *)





procedure rdp_envmixer;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_ENVMIXER")

end; (* procedure rdp_envmixer; *)





procedure rdp_loadbuff;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_LOADBUFF")

end; (* procedure rdp_loadbuff; *)





procedure rdp_resample;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_RESAMPLE")

end; (* procedure rdp_resample; *)





procedure rdp_savebuff;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_SAVEBUFF")

end; (* procedure rdp_savebuff; *)





procedure rdp_segment;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_SEGMENT")

end; (* procedure rdp_segment; *)





procedure rdp_setbuff;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_SETBUFF")

end; (* procedure rdp_setbuff; *)





procedure rdp_setvol;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_SETVOL")

end; (* procedure rdp_setvol; *)





procedure rdp_dmemmove;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_DMEMMOVE")

end; (* procedure rdp_dmemmove; *)





procedure rdp_loadadpcm;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_LOADADPCM")

end; (* procedure rdp_loadadpcm; *)





procedure rdp_mixer;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_MIXER")

end; (* procedure rdp_mixer; *)





procedure rdp_interleave;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_INTERLEAVE")

end; (* procedure rdp_interleave; *)





procedure rdp_polef;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_POLEF")

end; (* procedure rdp_polef; *)





procedure rdp_setloop;
begin
        PRINT_RDP_AUDIO_NOT_IMPLEMENTED("RDP_SETLOOP")

end; (* procedure rdp_setloop; *)


end.
