unit cpu;

interface
uses
  Windows, SysUtils,global,main,classes;
procedure debugopen;
procedure debugwrite(text:string);
procedure debugclose(filename:string);

procedure r4300i_unknown; register; // unknown opcode
procedure r4300i_special; register; //done
procedure r4300i_regimm; register; //done
procedure r4300i_j; register; //done
procedure r4300i_jal; register; //done
procedure r4300i_beq; register; //done
procedure r4300i_bne; register; //done
procedure r4300i_blez; register; //done
procedure r4300i_bgtz; register; //done
procedure r4300i_addi; register; //done
procedure r4300i_addiu; register; //done
procedure r4300i_slti; register; //done
procedure r4300i_sltiu; register; //done
procedure r4300i_andi; register; //done
procedure r4300i_ori; register; //done
procedure r4300i_xori; register; //done
procedure r4300i_lui; register; //done
procedure r4300i_cop0; register; //done
procedure r4300i_cop1; register; //0%
procedure r4300i_cop2; register; //0%
procedure r4300i_beql; register; //done
procedure r4300i_bnel; register; //done
procedure r4300i_blezl; register; //done
procedure r4300i_bgtzl; register; //done
procedure r4300i_daddi; register; //done
procedure r4300i_daddiu; register; //done
procedure r4300i_ldl; register; //done
procedure r4300i_ldr; register;
procedure r4300i_lb; register;  //done
procedure r4300i_lh; register;  //done
procedure r4300i_lwl; register; //done
procedure r4300i_lw; register;  //done
procedure r4300i_lbu; register; //done
procedure r4300i_lhu; register; //done
procedure r4300i_lwr; register; //done
procedure r4300i_lwu; register; //done
procedure r4300i_sb; register;  //done
procedure r4300i_sh; register;  //done
procedure r4300i_swl; register; //done
procedure r4300i_sw; register;  //done
procedure r4300i_sdl; register;
procedure r4300i_sdr; register;
procedure r4300i_swr; register;
procedure r4300i_cache; register;//done
procedure r4300i_ll; register;
procedure r4300i_lwc1; register;
procedure r4300i_lwc2; register;
procedure r4300i_lld; register;
procedure r4300i_ldc1; register;
procedure r4300i_ldc2; register;
procedure r4300i_ld; register;
procedure r4300i_sc; register;
procedure r4300i_swc1; register;
procedure r4300i_swc2; register;
procedure r4300i_scd; register;
procedure r4300i_sdc1; register;
procedure r4300i_sdc2; register;
procedure r4300i_sd; register;
// SPECIAL OPCODES
procedure r4300i_special_sll; register;//done
procedure r4300i_special_srl; register;//done
procedure r4300i_special_sra; register;//done
procedure r4300i_special_sllv; register;//done
procedure r4300i_special_srlv; register;//done
procedure r4300i_special_srav; register;//done
procedure r4300i_special_jr; register;//done
procedure r4300i_special_jalr; register; //done
procedure r4300i_special_syscall; register;//done
procedure r4300i_special_break; register; //done
procedure r4300i_special_sync; register; //done
procedure r4300i_special_mfhi; register; //done
procedure r4300i_special_mthi; register; //done
procedure r4300i_special_mflo; register; //done
procedure r4300i_special_mtlo; register;  //done
procedure r4300i_special_dsllv; register; //done
procedure r4300i_special_dsrlv; register; //done
procedure r4300i_special_dsrav; register; //done
procedure r4300i_special_mult; register; //done
procedure r4300i_special_multu; register; //done
procedure r4300i_special_div0; register; //done
procedure r4300i_special_divu; register;  //done
procedure r4300i_special_dmult; register;   //done
procedure r4300i_special_dmultu; register; //done
procedure r4300i_special_ddiv; register; //done
procedure r4300i_special_ddivu; register;  //done
procedure r4300i_special_add; register;   //done
procedure r4300i_special_addu; register;  //done
procedure r4300i_special_sub; register;  //done
procedure r4300i_special_subu; register;  //done
procedure r4300i_special_and0; register; //done
procedure r4300i_special_or0; register; //done
procedure r4300i_special_xor0; register; //done
procedure r4300i_special_nor; register; //done
procedure r4300i_special_slt; register;  //done
procedure r4300i_special_sltu; register; //done
procedure r4300i_special_dadd; register; //done
procedure r4300i_special_daddu; register; //done
procedure r4300i_special_dsub; register;  //done
procedure r4300i_special_dsubu; register; //done
procedure r4300i_special_tge; register;   //done
procedure r4300i_special_tgeu; register;   //done
procedure r4300i_special_tlt; register;    //done
procedure r4300i_special_tltu; register;  //done
procedure r4300i_special_teq; register;   //done
procedure r4300i_special_tne; register;  //done
procedure r4300i_special_dsll; register;  //done
procedure r4300i_special_dsrl; register;  //done
procedure r4300i_special_dsra; register;  //done
procedure r4300i_special_dsll32; register; //done
procedure r4300i_special_dsrl32; register; //done
procedure r4300i_special_dsra32; register;  //done
//REGIMM OPCODES
procedure r4300i_regimm_bgez; register;  //done
procedure r4300i_regimm_bltz; register;//done
procedure r4300i_regimm_bltzl; register;//done
procedure r4300i_regimm_bgezl; register;//done
procedure r4300i_regimm_tgei; register; //done
procedure r4300i_regimm_tgeiu; register; //done
procedure r4300i_regimm_tlti; register; //done
procedure r4300i_regimm_tltiu; register; //done
procedure r4300i_regimm_teqi; register; //done
procedure r4300i_regimm_tnei; register; //done
procedure r4300i_regimm_bltzal; register;//done
procedure r4300i_regimm_bgezal; register;//done
procedure r4300i_regimm_bltzall; register;//done
procedure r4300i_regimm_bgezall; register;//done
//COPx OPCODES
procedure rs4300i_cop0_rs_mf; register; //done
procedure rs4300i_cop0_rs_dmf; register; //done
procedure rs4300i_cop0_rs_cf; register; //done
procedure rs4300i_cop0_rs_mt; register;  //done
procedure rs4300i_cop0_rs_dmt; register;  //done
procedure rs4300i_cop0_rs_ct; register;  //done
procedure rs4300i_cop0_rs_bc; register;  //done
procedure rs4300i_cop0_rs_co; register;   //done
procedure rs4300i_cop0_rt_bcf; register;  //done
procedure rs4300i_cop0_rt_bct; register;  //done
procedure rs4300i_cop0_rt_bcfl; register;  //done
procedure rs4300i_cop0_rt_bctl; register;  //done
procedure rs4300i_cop0_tlbr; register;    //done
procedure rs4300i_cop0_tlbwi; register;   //done
procedure rs4300i_cop0_tlbwr; register;  //done
procedure rs4300i_cop0_tlbp; register; //done
procedure rs4300i_cop0_eret; register;  //done
procedure rs4300i_cop1_rs_mf; register;
procedure rs4300i_cop1_rs_dmf; register;
procedure rs4300i_cop1_rs_cf; register;
procedure rs4300i_cop1_rs_mt; register;
procedure rs4300i_cop1_rs_dmt; register;
procedure rs4300i_cop1_rs_ct; register;
procedure rs4300i_cop1_rs_bc; register;
procedure rs4300i_cop1_rs_co; register;
procedure rs4300i_cop1_rt_bcf; register;
procedure rs4300i_cop1_rt_bct; register;
procedure rs4300i_cop1_rt_bcfl; register;
procedure rs4300i_cop1_rt_bctl; register;
procedure rs4300i_cop1_add; register;
procedure rs4300i_cop1_sub; register;
procedure rs4300i_cop1_mul; register;
procedure rs4300i_cop1_div; register;
procedure rs4300i_cop1_sqrt; register;
procedure rs4300i_cop1_abs; register;
procedure rs4300i_cop1_mov; register;
procedure rs4300i_cop1_neg; register;
procedure rs4300i_cop1_roundl; register;
procedure rs4300i_cop1_truncl; register;
procedure rs4300i_cop1_ceill; register;
procedure rs4300i_cop1_floorl; register;
procedure rs4300i_cop1_roundw; register;
procedure rs4300i_cop1_truncw; register;
procedure rs4300i_cop1_ceilw; register;
procedure rs4300i_cop1_floorw; register;
procedure rs4300i_cop1_cvts; register;
procedure rs4300i_cop1_cvtd; register;
procedure rs4300i_cop1_cvtw; register;
procedure rs4300i_cop1_cvtl; register;
procedure rs4300i_cop1_c; register;
procedure rs4300i_cop2_rs_not_implemented; register;
procedure r4300i_NOP; register; //done



Const
   minstruction : array[0..63] of procedure =
       (r4300i_special,        r4300i_regimm,
        r4300i_j,         r4300i_jal,
        r4300i_beq, r4300i_bne,
        r4300i_blez, r4300i_bgtz,
        r4300i_addi, r4300i_addiu,
        r4300i_slti, r4300i_sltiu,
        r4300i_andi, r4300i_ori,
         r4300i_xori, r4300i_lui,
        r4300i_cop0, r4300i_cop1,
        r4300i_cop2 ,r4300i_unknown,
         r4300i_beql ,r4300i_bnel,
         r4300i_blezl, r4300i_bgtzl,
        r4300i_daddi, r4300i_daddiu, r4300i_ldl, r4300i_ldr, r4300i_unknown, r4300i_unknown, r4300i_unknown, r4300i_unknown,
        r4300i_lb, r4300i_lh, r4300i_lwl, r4300i_lw, r4300i_lbu, r4300i_lhu, r4300i_lwr, r4300i_lwu,
        r4300i_sb, r4300i_sh, r4300i_swl, r4300i_sw, r4300i_sdl, r4300i_sdr, r4300i_swr, r4300i_cache,
        r4300i_ll, r4300i_lwc1, r4300i_lwc2,r4300i_unknown, r4300i_lld, r4300i_ldc1, r4300i_ldc2, r4300i_ld,
        r4300i_sc, r4300i_swc1, r4300i_swc2,r4300i_unknown, r4300i_scd, r4300i_sdc1, r4300i_sdc2, r4300i_sd );

        Opcodes_string : array[0..63] of String =
       ('special','regimm ','j      ','jal    ','beq    ','bne    ','blez   ','bgtz   ',
        'addi   ','addiu  ','slti   ','sltiu  ','andi   ','ori    ','xori   ','lui    ',
        'cop0   ','cop1   ','cop2   ','reserved'       ,'beql   ','bnel   ','blezl  ','bgtzl  ',
        'daddi  ','daddiu ','ldl    ','ldr    ','reserved'       ,'reserved'       ,'reserved'       ,'reserved'       ,
        'lb     ','lh     ','lwl    ','lw     ','lbu    ','lhu    ','lwr    ','lwu    ',
        'sb     ','sh     ','swl    ','sw     ','sdl    ','sdr    ','swr    ','cache  ',
        'll     ','lwc1   ','lwc2   ','reserved'       ,'lld    ','ldc1   ','ldc2   ','ld     ',
        'sc     ','swc1   ','swc2   ','reserved'       ,'scd    ','sdc1   ','sdc2   ','sd     ');

        Special_opcodes: array[0..63] of procedure =
        (r4300i_special_sll, nil, r4300i_special_srl, r4300i_special_sra, r4300i_special_sllv, r4300i_unknown, r4300i_special_srlv, r4300i_special_srav,
         r4300i_special_jr, r4300i_special_jalr,r4300i_unknown ,nil ,r4300i_special_syscall , r4300i_special_break, r4300i_unknown,r4300i_special_sync,
         r4300i_special_mfhi, r4300i_special_mthi, r4300i_special_mflo, r4300i_special_mtlo, r4300i_special_dsllv, r4300i_unknown, r4300i_special_dsrlv, r4300i_special_dsrav,
         r4300i_special_mult, r4300i_special_multu,nil {r4300i_special_div0} , r4300i_special_divu, r4300i_special_dmult, r4300i_special_dmultu , r4300i_special_ddiv, r4300i_special_ddivu,
         r4300i_special_add, r4300i_special_addu, r4300i_special_sub, r4300i_special_subu, r4300i_special_and0 {and}, r4300i_special_or0{or}, r4300i_special_xor0 {xor} , r4300i_special_nor,
         r4300i_unknown, r4300i_unknown, r4300i_special_slt, r4300i_special_sltu, r4300i_special_dadd, r4300i_special_daddu, r4300i_special_dsub, r4300i_special_dsubu,
         r4300i_special_tge, r4300i_special_tgeu, r4300i_special_tlt, r4300i_special_tltu, r4300i_special_teq, r4300i_unknown, r4300i_special_tne, r4300i_unknown,
         r4300i_special_dsll,r4300i_unknown, r4300i_special_dsrl, r4300i_special_dsra, r4300i_special_dsll32, r4300i_unknown, r4300i_special_dsrl32, r4300i_special_dsra32);

        Special_opcodes_string: array[0..64] of String =
        ('sll    ',#0       ,'srl    ','sra    ','sllv   ',#0       ,'srlv   ','srav   ',
         'jr     ','jalr   ',#0       ,#0       ,'syscall','break  ',#0       ,'sync   ',
         'mfhi   ','mthi   ','mflo   ','mtlo   ','dsllv  ',#0       ,'dsrlv  ','dsrav  ',
         'mult   ','multu  ','div    ','divu   ','dmult  ','dmultu ','ddiv   ','ddivu  ',
         'add    ','addu   ','sub    ','subu   ','and    ','or     ','xor    ','nor    ',
         #0       ,#0       ,'slt    ','sltu   ','dadd   ','daddu  ','dsub   ','dsubu  ',
         'tge    ','tgeu   ','tlt    ','tltu   ','teq    ',#0       ,'tne    ',#0       ,
         'dsll   ',#0       ,'dsrl   ','dsra   ','dsll32 ',#0       ,'dsrl32 ','dsra32 ','nop    ');



regimm_instruction:array[0..32-1] of procedure =
(
	r4300i_regimm_bltz,        r4300i_regimm_bgez,        r4300i_regimm_bltzl,
        r4300i_regimm_bgezl,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,	r4300i_regimm_tgei,
        r4300i_regimm_tgeiu,        r4300i_regimm_tlti,        r4300i_regimm_tltiu,
        r4300i_regimm_teqi,        r4300i_unknown,        r4300i_regimm_tnei,
        r4300i_unknown,        r4300i_regimm_bltzal,        r4300i_regimm_bgezal,
        r4300i_regimm_bltzall,        r4300i_regimm_bgezall,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
	r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,r4300i_unknown,r4300i_unknown,r4300i_unknown,r4300i_unknown);

cop0_rs_instruction:array[0..32-1]of procedure =
(
        rs4300i_cop0_rs_mf,        rs4300i_cop0_rs_dmf,       rs4300i_cop0_rs_cf,       r4300i_unknown,
        rs4300i_cop0_rs_mt,        rs4300i_cop0_rs_dmt,       rs4300i_cop0_rs_ct,       r4300i_unknown,
        rs4300i_cop0_rs_bc,        r4300i_unknown,            r4300i_unknown,           r4300i_unknown,
        r4300i_unknown,            r4300i_unknown,            r4300i_unknown,           r4300i_unknown,
        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,       rs4300i_cop0_rs_co,
        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,       rs4300i_cop0_rs_co,
        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,       rs4300i_cop0_rs_co,
        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,        rs4300i_cop0_rs_co,       rs4300i_cop0_rs_co
);




cop0_rt_instruction:array[0..32-1]of procedure =
(
        rs4300i_cop0_rt_bcf,        rs4300i_cop0_rt_bct,
        rs4300i_cop0_rt_bcfl,        rs4300i_cop0_rt_bctl,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown
);




cop0_instruction:array[0..64-1]of  procedure =
(
        r4300i_unknown,        rs4300i_cop0_tlbr,        rs4300i_cop0_tlbwi,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        rs4300i_cop0_tlbwr,        r4300i_unknown,
        rs4300i_cop0_tlbp,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        rs4300i_cop0_eret,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown
);





cop1_rs_instruction:array[0..32-1]of procedure =
(
        rs4300i_cop1_rs_mf,        rs4300i_cop1_rs_dmf,        rs4300i_cop1_rs_cf,        r4300i_unknown,
        rs4300i_cop1_rs_mt,        rs4300i_cop1_rs_dmt,        rs4300i_cop1_rs_ct,        r4300i_unknown,
        rs4300i_cop1_rs_bc,        r4300i_unknown,          r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,             r4300i_unknown,        r4300i_unknown,
        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,
        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,
        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,       rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,
        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co,        rs4300i_cop1_rs_co
);





cop1_rt_instruction:array[0..32-1]of procedure =
(
        rs4300i_cop1_rt_bcf,        rs4300i_cop1_rt_bct,        rs4300i_cop1_rt_bcfl,        rs4300i_cop1_rt_bctl,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,
        r4300i_unknown,        r4300i_unknown,        r4300i_unknown,        r4300i_unknown
);





cop1_instruction:array[0..64-1]of procedure =
(
        rs4300i_cop1_add,        rs4300i_cop1_sub,
        rs4300i_cop1_mul,        rs4300i_cop1_div,
        rs4300i_cop1_sqrt,        rs4300i_cop1_abs,
        rs4300i_cop1_mov,         rs4300i_cop1_neg,
        rs4300i_cop1_roundl,        rs4300i_cop1_truncl,
        rs4300i_cop1_ceill,         rs4300i_cop1_floorl,
        rs4300i_cop1_roundw,        rs4300i_cop1_truncw,
        rs4300i_cop1_ceilw,         rs4300i_cop1_floorw,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        rs4300i_cop1_cvts,          rs4300i_cop1_cvtd,
        r4300i_unknown,             r4300i_unknown,
        rs4300i_cop1_cvtw,          rs4300i_cop1_cvtl,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,             r4300i_unknown,
        r4300i_unknown,              r4300i_unknown,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c,
        rs4300i_cop1_c,              rs4300i_cop1_c
);





cop2_rs_instruction:array[0..32-1]of procedure =
(
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,
        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented,        rs4300i_cop2_rs_not_implemented
);

procedure Cpu_step;
procedure Cpu_reset;
function __T:uWORD;
function ____T:uWord;
function __O:uWord;
function __I:sWord;
function __F:ubyte;
function __SA:ubyte;
function __RD:ubyte;
function __RT:ubyte;
function __RS:ubyte;
function __OPCODE:ubyte;
function __PREV_CODE:uWord;
function __NEXT_CODE:uWord;
function __CODE:uWord;
function READ_CPU_INSTRUCTION(addr:int64):uWord;
procedure check_int;

var
compile_chunk:array[0..$1000]of byte;
recompiled_chunk:array[0..$1000]of byte;
current_x86:procedure;
cp:integer = 0;
debugs:tstringlist;
implementation
uses emulate,exceptions,interrupts;


function get_immediate : string;
begin
result:='imm('+IntToStr(immediate)+') ';
end;

function get_rt : string;
begin
result:='rt('+IntToStr(rt)+') ';
end;

function get_rd : String;
begin
result:='rd('+IntToStr(rd)+') ';
end;

function get_rs : String;
begin
result:='rs('+IntToStr(rs)+') ';
end;

function get_offset : String;
begin
result:='offset('+IntToStr(offset)+') ';
end;

function get_sa : String;
begin
result:='sa('+IntToStr(sa)+') ';
end;

function get_target : string;
begin
result:='Target($'+IntToHex(target,1)+') ';
end;




procedure CHECK_64BIT_OVERFLOW(x, y, z, dest:sDWORD);
begin
if ((x shr 63)=(y shr 63)) and ((x shr 63)<>(z shr 63))  then
    reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_INTEGER_OVERFLOW_EXCEPTION
        else
       reg.r[dest] := z;
end;


procedure CHECK_32BIT_OVERFLOW(x, y, z, dest:sWORD);
begin
        if( ((x shr 31)=(y shr 31)) and ((x shr 31)<>(z shr 31)) ) then
        reg.do_or_check_sthg := reg.do_or_check_sthg  or RS4300I_DO_INTEGER_OVERFLOW_EXCEPTION
        else
        reg.r[dest] := z;
end;


// **** OPCODES **** //


procedure r4300i_unknown; register; //done
begin
reg.do_or_check_sthg := RS4300I_DO_RESERVED_INSTRUCTION_EXCEPTION;
//ms('Unknown Opcode!',false);
end;

procedure r4300i_special; register;
begin
Special_Opcodes[__F];
//ms(get_rt,false);
end;

procedure r4300i_regimm; register; //done
begin
regimm_instruction[__RT];
//ms(get_rt,false);
end;

procedure r4300i_j;  register; //done
begin
//lemmy says this is how used to do it
//reg.pc := (reg.pc and $FF000000) or (Opcode shl 2 and $00FFFFFF);

{      if(rsp_reg.halt)<>0 then //says speed hack
      if(__T = reg.pc) then
      if(__NEXT_CODE = $00000000) then
      begin
      reg.cpr[0][9] := next_interrupt_count - 1;
      end;}

 reg.delay := DO_DELAY;
 reg.delaypc := __T;
 //ms(get_target,false);
end;

procedure r4300i_jal; register; //done
begin
        reg.delay := DO_DELAY;
        reg.delaypc := __T;
        reg.r[31] := reg.pc + 8;
        reg.r_m[31] := 1;
//ms(get_target,false);
end;

procedure r4300i_beq;   register; //done
begin
      if(reg.r[__RS] = reg.r[__RT]) then
      begin
     {  if(rsp_reg.halt) <> 0 then
      if(__I < 0) then
      if(__NEXT_CODE = $00000000) then
      begin
      reg.cpr[0][9] := next_interrupt_count - 1;
      end;}
      reg.delay := DO_DELAY;
      reg.delaypc := __O;
      end;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_bne; register; //done
begin
    if(reg.r[__RS] <> reg.r[__RT]) then
    begin
    {if(rsp_reg.halt)<> 0 then
    if(__I = -1) then
    if(__NEXT_CODE = $00000000) then
    begin
    reg.cpr[0][9] := next_interrupt_count - 1;
    end; }
    reg.delay := DO_DELAY;
    reg.delaypc := __O;
    end;
//ms(get_rs+get_rt,false);
end;

procedure r4300i_blez; register; //done
begin
      if((reg.r[__RS]) <= 0) then
      begin
     { if(rsp_reg.halt)<> 0 then
      if(__I = -1) then
      if(__NEXT_CODE = $00000000) then
      begin
      reg.cpr[0][9] := next_interrupt_count - 1;
      end; }
      reg.delay := DO_DELAY;
      reg.delaypc := __O;
      end;
//ms(get_rs,false);
end;

procedure r4300i_bgtz;  register; //done
begin
      if((reg.r[__RS]) > 0) then
      begin
     { if(rsp_reg.halt)<> 0 then
      if(__I = -1) then
      if(__NEXT_CODE = $00000000) then
      begin
      reg.cpr[0][9] := next_interrupt_count - 1;
      end;      }
      reg.delay := DO_DELAY;
      reg.delaypc := __O;
      end;
//ms(get_rs,false);
end;

procedure r4300i_addi;    register; //done
var
x, y, z:sWORD;
begin
//rt:=rs+immediate; //wrong
        x := sword(reg.r[__RS]);
        y := sword(__I);
        z := x + y;
        CHECK_32BIT_OVERFLOW(x, y, z, __RT);
        reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_addiu; register; //done
begin

 reg.r[__RT] := reg.r[__RS] + __I;
 reg.r[0] := 0;
//ms(get_rs+get_rt,false);
end;

procedure r4300i_slti; register;
begin
   if(reg.r[__RS] < __I) then
   reg.r[__RT] := 1
   else
   reg.r[__RT] := 0;

   reg.r[0] := 0;
//ms(get_rs+get_rt,false);
end;

procedure r4300i_sltiu; register;
begin
       if (reg.r[__RS] < __I) then
                reg.r[__RT] := 1
        else
                reg.r[__RT] := 0;
        reg.r[0] := 0;
//ms(get_rs+get_rt,false);
end;

procedure r4300i_andi;register; //done
begin

  reg.r[__RT] := reg.r[__RS] and __I;
  reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_ori; register; //done
begin

   reg.r[__RT] := reg.r[__RS] or __I;
   reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_xori;register; //done
begin
//MainCPUReg[rt] := MainCPUReg[rs] xor (offset_immediate and $FFFF);
reg.r[__RT] := reg.r[__RS] xor __I;
reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_lui;   register; //done
begin
//rt:=immediate*$4096; //wrong
//MainCPUReg[rt] := offset_immediate shl 16;
  reg.r[__RT] := (__I shl 16);
  reg.r[0] := 0;
//ms(get_rt+get_immediate,false);
end;

procedure r4300i_cop0; register;
begin
cop0_rs_instruction[__RS];
//ms(get_rs,false);
end;

procedure r4300i_cop1; register;
begin
cop1_rs_instruction[__RS]();
//ms(get_rs,false);
end;

procedure r4300i_cop2; register;
begin
cop2_rs_instruction[__RS];
end;

procedure r4300i_beql; register; //done
begin
if(reg.r[__RS] = reg.r[__RT]) then
begin
{if(rsp_reg.halt)<> 0 then
if(__I = -1) then
if(__NEXT_CODE = $00000000) then
begin
reg.cpr[0][9] := next_interrupt_count - 1;
end;  }
reg.delay := DO_DELAY;
reg.delaypc := __O;
end
else
reg.pc := reg.pc + 4;

//ms(get_rs+get_rt,false);
end;

procedure r4300i_bnel;  register; //done
begin
if(reg.r[__RS] <> reg.r[__RT]) then
begin
{if(rsp_reg.halt)<> 0 then
if(__I = -1) then
if(__NEXT_CODE = $00000000) then
begin
reg.cpr[0][9] := next_interrupt_count - 1;
end;}
reg.delay := DO_DELAY;
reg.delaypc := __O;
end
else
reg.pc := reg.pc + 4;

//ms(get_rs+get_rt,false);
end;

procedure r4300i_blezl; register; //done
begin
       if (reg.r[__RS] <= 0) then
       begin
       reg.delay := DO_DELAY;
       reg.delaypc := __O;
       end
       else
       reg.pc := reg.pc + 4;
//ms(get_rs+get_rt,false);
end;

procedure r4300i_bgtzl; register; //done
begin
        if(reg.r[__RS] > 0) then
        begin
        reg.delay := DO_DELAY;
        reg.delaypc := __O;
        end
        else
        reg.pc := reg.pc + 4;
//ms(get_rs,false);
end;

procedure r4300i_daddi; register; //done
var
x, y, z:longint;
begin
        x := reg.r[__RS];
        y := __I;
        z := x + y;
        CHECK_64BIT_OVERFLOW(x, y, z, __RT);
        reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_daddiu; register; //done
begin
       reg.r[__RT] := reg.r[__RS] + __I;
        reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_ldl; register;
var
  offset,
  data:longint;
begin
        offset := (reg.r[__RS] + __I);

        data := 0;//doReadMemDoubleWord(offset and $fffffff8);

        case (offset mod 8)of
        0:
        begin
        reg.r[__RT] := data;
        end;

        1:
        begin
        reg.r[__RT]  := (reg.r[__RT] and $00000000000000ff) or (data shl 8);
        end;

        2:
        begin
        reg.r[__RT]  := (reg.r[__RT] and $000000000000ffff) or (data shl 16);
        end;

         3:
         begin
         reg.r[__RT]  := (reg.r[__RT] and $0000000000ffffff) or (data shl 24);
         end;

         4:
         begin
         //reg.r[__RT]  := (reg.r[__RT] and $00000000ffffffff) or (data shl 32);
         end;

         5:
         begin
          //reg.r[__RT]  := (reg.r[__RT] and $000000ffffffffff) or (data shl 40);
         end;

         6:
         begin
         //reg.r[__RT]  := (reg.r[__RT] and $0000ffffffffffff) or (data shl 48);
         end;

         7:
         begin
         //reg.r[__RT]  := (reg.r[__RT] and $00ffffffffffffff) or (data shl 56);
         end;

        end;



        // tlb miss exception
        // tlb invalid exception
        // bus error exception
        // address error exception
        // reserved instruction exception (vr4300 in 32-bit user or supervisor mode)

        reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_ldr; register;
begin
end;

procedure r4300i_lb; register; //done
begin
////ms(get_rt+get_rd,false);
//rt:=byte(base+offset); wrong
reg.r[__RT] :=0;// doReadMemByte(reg.r[__RS] + __I);
end;

procedure r4300i_lh; register;
begin
     reg.r[__RT] := 0;//doReadMemHalfWord(reg.r[__RS] + __I);
     // exception
     reg.r[0] := 0;
//ms(get_rt+get_rt,false);
end;

procedure r4300i_lwl;register;
var
offset,
data:longint;
begin

        offset := (reg.r[__RS] + __I);
        data := 0;//doReadMemWord(offset and $fffffffc);
        case (offset mod 4) of
        0:
        begin
        reg.r[__RT] := data;
        end;

        1:
        begin
        reg.r[__RT]  := ((reg.r[__RT] and $000000ff) or (data shl 8));
        end;

        2:
        begin
        reg.r[__RT]  := ((reg.r[__RT] and $0000ffff) or (data shl 16));
        end;

        3:
        begin
        reg.r[__RT]  := ((reg.r[__RT] and $00ffffff) or (data shl 24));
        end;

        end;

        // exception
        reg.r[0] := 0;
        //ms(get_rt+get_rs,false);
end;

procedure r4300i_lw; register; //done
begin
////ms(get_rt+get_rd,false);
//rt:=word(base+offset);
  reg.r[__RT] := 0;//doReadMemWord(reg.r[__RS] + __I);
  // exception
  reg.r[0] := 0;
  //ms(get_rt+get_rs,false);
end;

procedure r4300i_lbu; register; //done
begin
//rt:=byte(base+offset);
        reg.r[__RT] := 0;//doReadMemByte(reg.r[__RS] + __I);
        reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_lhu; register;
begin
        reg.r[__RT] := 0;//doReadMemHalfWord(reg.r[__RS] + __I);
        // exception
        reg.r[0] := 0;
        //ms(get_rs+get_rt,false);

end;

procedure r4300i_lwr; register;
var
 offset,
 data:longint;
begin

        offset := (reg.r[__RS] + __I);

        data := 0;//doReadMemWord(offset and $fffffffc);

        case (offset mod 4) of
        0:
        begin
        reg.r[__RT]  := (reg.r[__RT] and $ffffff00) + (data shr 24);
        end;

        1:
        begin
        reg.r[__RT]  := (reg.r[__RT] and $ffff0000) + (data shr 16);
        end;

        2:
        begin
        reg.r[__RT]  := (reg.r[__RT] and $ff000000) + (data shr 8);
        end;

        3:
        begin
        reg.r[__RT]  := data;
        end;

        end;

        // exception
        reg.r[0] := 0;
        //ms(get_rs+get_rt,false);
end;

procedure r4300i_lwu; register;
begin
        reg.r[__RT] := 0;//doReadMemWord(reg.r[__RS] + __I);
        // exception
        reg.r[0] := 0;
        //ms(get_rs+get_rt,false);
end;

procedure r4300i_sb; register;
begin
//doWriteMemByte(reg.r[__RT], (reg.r[__RS]) + __I);
//ms(get_rs+get_rt,false);
end;

procedure r4300i_sh; register;
begin
//doWriteMemHalfWord(reg.r[__RT], (reg.r[__RS]) + __I);
//ms(get_rs+get_rt,false);
end;

procedure r4300i_swl; register;
var
 offset, data,
 old_data:longint;
begin


        offset := reg.r[__RS] + __I;

        old_data := 0;//doReadMemWord(offset and $fffffffc);

        case (offset mod 4) of
        0:
        begin
        data := reg.r[__RT];
        end;

        1:
        begin
        data := (old_data and $ff000000) or (reg.r[__RT] shr 8);
        end;

        2:
        begin
        data := (old_data and $ffff0000) or (reg.r[__RT] shr 16);
        end;

        3:
        begin
        data := (old_data and $ffffff00) or (reg.r[__RT] shr 24);
        end;

        else
        data := 0;
        end;

       // doWriteMemWord(data, offset and $fffffffc);

        // exception

       //ms(get_rt+get_rs,false);

end;

procedure r4300i_sw; register;
begin
 //doWriteMemWord(reg.r[__RT],reg.r[__RS] + __I);
//ms(get_rt+get_rs,false);
end;

procedure r4300i_sdl; register;
begin
end;

procedure r4300i_sdr; register;
begin
end;

procedure r4300i_swr; register;
begin
end;

procedure r4300i_cache; register;
begin
//ms('Ignored',false);
end;

procedure r4300i_ll; register;
begin
end;

procedure r4300i_lwc1; register;
begin
end;

procedure r4300i_lwc2; register;
begin
end;

procedure r4300i_lld; register;
begin
end;

procedure r4300i_ldc1; register;
begin
end;

procedure r4300i_ldc2; register;
begin
end;

procedure r4300i_ld; register;
begin
end;

procedure r4300i_sc; register;
begin
end;

procedure r4300i_swc1; register;
begin
end;

procedure r4300i_swc2; register;
begin

end;

procedure r4300i_scd; register;
begin
end;

procedure r4300i_sdc1; register;
begin
end;

procedure r4300i_sdc2; register;
begin
end;

procedure r4300i_sd; register;
begin
end;

// Special opcodes

procedure r4300i_special_sll;   register; //done
begin
        if(reg.code = 0) then exit;
        reg.r[__RD] := (reg.r[__RT] shl __SA) and $ffffffff;
        reg.r[0] := 0;
        //ms(get_rt+get_rs,false);
end;

procedure r4300i_special_srl; register;
begin
        reg.r[__RD] := (reg.r[__RT] shr __SA);
        reg.r[0] := 0;
        //ms(get_rd+get_rt,false);
end;

procedure r4300i_special_sra; register;
begin
        reg.r[__RD] := (reg.r[__RT] shr __SA);
        reg.r[0] := 0;
        //ms(get_rd+get_rt,false);
end;

procedure r4300i_special_sllv; register;
begin
        reg.r[__RD] := ((reg.r[__RT]) shl (reg.r[__RS] and $1f) and $ffffffff);
        reg.r[0] := 0;
        //ms(get_rd+get_rs+get_rt,false);

end;

procedure r4300i_special_srlv; register;
begin
        reg.r[__RD] := (reg.r[__RT] shr (reg.r[__RS] and $1f));
        reg.r[0] := 0;
        //ms(get_rs+get_rt+get_rd,false);
end;

procedure r4300i_special_srav; register;
begin
       reg.r[__RD] := (reg.r[__RT] shr (reg.r[__RS] and $1f));
       reg.r[0] := 0;
       //ms(get_rs+get_rt+get_rd,false);
end;

procedure r4300i_special_jr; register; //done
begin
        reg.delay := DO_DELAY;
        reg.delaypc := reg.r[__RS];
        //ms(get_rs,false);
end;

procedure r4300i_special_jalr; register; //done
begin
        reg.delay := DO_DELAY;
        reg.delaypc := reg.r[__RS];
        reg.r[__RD] := (reg.pc + 8);
        reg.r[0] := 0;
//ms(get_rs,false);
end;

procedure r4300i_special_syscall; register; //done
begin
reg.do_or_check_sthg :=reg.do_or_check_sthg or RS4300I_DO_SYSCALL_EXCEPTION;
//ms('System Call',false);
end;

procedure r4300i_special_break; register; //done
begin
reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_BREAK_EXCEPTION;
//ms('Break',false);
end;

procedure r4300i_special_sync; register;  //done
begin
//ms('Sync : Ignored',false);
end;

procedure r4300i_special_mfhi; register; //done
begin
      reg.r[__RD] := reg.hi;
      reg.r[0] := 0;
//ms(get_rd,false);
end;

procedure r4300i_special_mthi; register; //done
begin
reg.hi := reg.r[__RS];
//ms(get_rs,false);
end;

procedure r4300i_special_mflo; register;  //done
begin
    reg.r[__RD] := reg.lo;
    reg.r[0] := 0;
//ms(get_rd,false);
end;

procedure r4300i_special_mtlo; register;  //done
begin
        reg.lo := reg.r[__RS];
        //ms(get_rs,false);
end;

procedure r4300i_special_dsllv; register;
begin
   reg.r[__RD] := reg.r[__RT] shl (reg.r[__RS] and $1f);
   reg.r[0] := 0;
   //ms(get_rs,false);
end;

procedure r4300i_special_dsrlv; register;
begin
      reg.r[__RD] := reg.r[__RT] shr (reg.r[__RS] and $1f);
      reg.r[0] := 0;
      //ms(get_rs,false);
end;

procedure r4300i_special_dsrav; register;
begin
   reg.r[__RD] := reg.r[__RT] shr (reg.r[__RS] and $1f);
   reg.r[0] := 0;
      //ms(get_rs,false);

end;

procedure r4300i_special_mult; register;
var
temp:longint;
begin
        temp := (reg.r[__RS]) * (reg.r[__RT]);
        reg.lo := (temp);
        reg.hi := (temp shr 32);
      //ms(get_rs,false);

end;

procedure r4300i_special_multu; register;
var temp:longint;
begin
        temp := (reg.r[__RS]) * (reg.r[__RT]);
        reg.lo := (temp);
        reg.hi := (temp shr 32);
      //ms(get_rs,false);
end;

procedure r4300i_special_div0; register;
begin
        if(reg.r[__RT] <> 0) then
        begin
                reg.lo := (reg.r[__RS] div reg.r[__RT]);
                reg.hi := (reg.r[__RS] mod reg.r[__RT]);
        end;
        //ms(get_rs,false);
end;

procedure r4300i_special_divu; register;
begin
        if(reg.r[__RT] <> 0) then
        begin
                reg.lo := (reg.r[__RS] div reg.r[__RT]);
                reg.hi := (reg.r[__RS] mod reg.r[__RT]);
        end;
        //ms(get_rs,false);
end;

procedure r4300i_special_dmult; register;
begin
        // reserved instruction exception (in 32bit mode)
        reg.lo := reg.r[__RS] * reg.r[__RT];
        reg.hi := 0;
        //ms(get_rs,false);
end;

procedure r4300i_special_dmultu; register;
begin
        reg.lo := reg.r[__RS] * reg.r[__RT];
        reg.hi := 0;
        //ms(get_rs,false);
end;

procedure r4300i_special_ddiv; register;
begin
     if(reg.r[__RT] <> 0) then
     begin
                reg.lo := reg.r[__RS] div reg.r[__RT];
                reg.hi := reg.r[__RS] mod reg.r[__RT];
     end;
        //ms(get_rs,false);
end;

procedure r4300i_special_ddivu; register;
begin
     if(reg.r[__RT] <> 0) then
     begin
                reg.lo := reg.r[__RS] div reg.r[__RT];
                reg.hi := reg.r[__RS] mod reg.r[__RT];
     end;
        //ms(get_rs,false);
end;

procedure r4300i_special_add; register;
var
x, y, z:longint;
begin
        x := reg.r[__RS];
        y := reg.r[__RT];
        z := x + y;
        CHECK_32BIT_OVERFLOW(x, y, z, __RD);
        reg.r[0] := 0;
        //ms(get_rs,false);
end;

procedure r4300i_special_addu; register;
begin
  reg.r[__RD] := (reg.r[__RS] + reg.r[__RT]);
  reg.r[0] := 0;
        //ms(get_rs,false);
end;

procedure r4300i_special_sub; register;
var
x, y, z:longint;
begin

        x := reg.r[__RS];
        y := reg.r[__RT];

        z := x - y;

        y := not y;
        CHECK_32BIT_OVERFLOW(x, y, z, __RD);
        reg.r[0] := 0;
        //ms(get_rs,false);
end;

procedure r4300i_special_subu; register;
begin
     reg.r[__RD] := (reg.r[__RS] - reg.r[__RT]);
     reg.r[0] := 0;
        //ms(get_rs,false);
end;

procedure r4300i_special_and0; register; //done
begin

     reg.r[__RD] := reg.r[__RS] and reg.r[__RT];
      reg.r[0] := 0;
//ms(get_rd+get_rs+get_rt,false);
end;

procedure r4300i_special_or0; register; //done
begin
     reg.r[__RD] := reg.r[__RS] or reg.r[__RT];
     reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_special_xor0; register; //done
begin
reg.r[__RD] := reg.r[__RS] xor reg.r[__RT];
reg.r[0] := 0;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_special_nor; register;
begin
reg.r[__RD] := not (reg.r[__RS] or reg.r[__RT]);
reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);
end;

procedure r4300i_special_slt; register; //done
begin
      if(reg.r[__RS] < reg.r[__RT]) then
                reg.r[__RD] := 1
        else
                reg.r[__RD] := 0;
       reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);
end;

procedure r4300i_special_sltu; register;//done
begin
       if(reg.r[__RS] < reg.r[__RT]) then
                reg.r[__RD] := 1
        else
                reg.r[__RD] := 0;
        reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);
end;

procedure r4300i_special_dadd; register; //done
var
x, y, z:longint;
begin

        x := reg.r[__RS];
        y := reg.r[__RT];

        z := x + y;
        CHECK_64BIT_OVERFLOW(x, y, z, __RD);
        reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);
end;

procedure r4300i_special_daddu; register;
begin
        reg.r[__RD] := reg.r[__RS] + reg.r[__RT];
        reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);
end;

procedure r4300i_special_dsub; register;
var
x, y, z:longint;
begin

        // reserved instruction exception (in 32bit mode)
        x := reg.r[__RS];
        y := reg.r[__RT];
        z := x - y;
        y := not y;
        CHECK_64BIT_OVERFLOW(x, y, z, __RD);
        reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);

end;

procedure r4300i_special_dsubu; register;
var
temp:longint;
begin

       // reserved instruction exception (in 32bit mode)
        temp := reg.r[__RS] - reg.r[__RT];
        reg.r[__RD] := temp;
        reg.r[0] := 0;
//ms(get_rt+get_rs+get_rd,false);
end;

procedure r4300i_special_tge; register;
begin
        if (reg.r[__RS] >= reg.r[__RT]) then
        begin
        reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_TRAP_EXCEPTION;
        end;
//ms(get_rt,false);
end;

procedure r4300i_special_tgeu; register;
begin

       if(reg.r[__RS] >= reg.r[__RT]) then
       begin
       reg.do_or_check_sthg :=  reg.do_or_check_sthg  or RS4300I_DO_TRAP_EXCEPTION;
       end;
//ms(get_rt,false);
end;

procedure r4300i_special_tlt; register;
begin

       if(reg.r[__RS] < reg.r[__RT]) then
       begin
       reg.do_or_check_sthg :=  reg.do_or_check_sthg  or RS4300I_DO_TRAP_EXCEPTION;
       end;
//ms(get_rt,false);

end;

procedure r4300i_special_tltu; register;
begin

       if(reg.r[__RS] < reg.r[__RT]) then
       begin
       reg.do_or_check_sthg :=  reg.do_or_check_sthg  or RS4300I_DO_TRAP_EXCEPTION;
       end;
//ms(get_rt,false);

end;

procedure r4300i_special_teq; register;
begin
if(reg.r[__RS] = reg.r[__RT]) then
begin
reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_TRAP_EXCEPTION;
end;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_special_tne; register;
begin
      if(reg.r[__RS] <> reg.r[__RT]) then
      begin
      reg.do_or_check_sthg := reg.do_or_check_sthg  or RS4300I_DO_TRAP_EXCEPTION;
      end;
//ms(get_rt+get_rs,false);
end;

procedure r4300i_special_dsll; register;
begin
      reg.r[__RD] := reg.r[__RT] shl __SA;
      reg.r[0] := 0;
//ms(get_rt+get_rd,false);
end;

procedure r4300i_special_dsrl; register;
begin
   reg.r[__RD] := reg.r[__RT] shr __SA;
   reg.r[0] := 0;
//ms(get_rt+get_rd,false);
end;

procedure r4300i_special_dsra; register;
begin
   reg.r[__RD] := reg.r[__RT] shr __SA;
   reg.r[0] := 0;
//ms(get_rt+get_rd,false);
end;

procedure r4300i_special_dsll32; register;
begin
       reg.r[__RD] := reg.r[__RT] shl (32 + __SA);
       reg.r[0] := 0;
       //ms(get_rt+get_rd,false);
end;

procedure r4300i_special_dsrl32; register;
begin
     reg.r[__RD] := reg.r[__RT] shr (32 + __SA);
     reg.r[0] := 0;
     //ms(get_rt+get_rd,false);
end;

procedure r4300i_special_dsra32; register;
begin
    reg.r[__RD] := reg.r[__RT] shr (32 + __SA);
    reg.r[0] := 0;
    //ms(get_rt+get_rd,false);
end;

procedure r4300i_regimm_bgez; register; //done
begin

      if(reg.r[__RS] >= 0) then
      begin
    {  if(rsp_reg.halt) <> 0 then
      if(__I = -1) then
      if(__NEXT_CODE = $00000000) then
      begin
      reg.cpr[0][9] := next_interrupt_count - 1;
      end;}
      reg.delay := DO_DELAY;
      reg.delaypc := __O;
      end;


//ms(get_rs,false);
end;


procedure r4300i_regimm_bltz; register;
begin
        if(reg.r[__RS] < 0) then
        begin
        {if(rsp_reg.halt) <> 0 then
        if(__I = -1) then
        if(__NEXT_CODE = $00000000) then
        begin
        reg.cpr[0][9] := next_interrupt_count - 1;
        end;   }
        reg.delay := DO_DELAY;
        reg.delaypc := __O;
        end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_bltzl; register;
begin
  if (reg.r[__RS] < 0) then
  begin
  reg.delay := DO_DELAY;
  reg.delaypc := __O;
  end
  else
  reg.pc := reg.pc + 4;
  //ms(get_rs,false);
end;

procedure r4300i_regimm_bgezl; register; //done
begin
        if(reg.r[__RS] >= 0) then
        begin
        reg.delay := DO_DELAY;
        reg.delaypc := __O;
        end
        else
        reg.pc := reg.pc + 4;
//ms(get_rs,false);
end;

procedure r4300i_regimm_tgei; register;
begin
       if(reg.r[__RS] >= __I) then
        begin
        reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_TRAP_EXCEPTION;
        end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_tgeiu; register;
begin
  if (reg.r[__RS] >= __I) then
     begin
     reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_TRAP_EXCEPTION;
     end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_tlti; register;
label con1,con2;
begin
        if (reg.r[__RS] < __I) then
        begin
        reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_TRAP_EXCEPTION;
        end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_tltiu; register;
begin
        if (reg.r[__RS] < __I) then
        begin
        reg.do_or_check_sthg :=reg.do_or_check_sthg  or RS4300I_DO_TRAP_EXCEPTION;
        end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_teqi; register;
begin
      if (reg.r[__RS] = __I) then
      begin
      reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_TRAP_EXCEPTION;
      end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_tnei; register;
begin
   if (reg.r[__RS] <> __I) then
      begin
      reg.do_or_check_sthg :=reg.do_or_check_sthg  or RS4300I_DO_TRAP_EXCEPTION;
      end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_bltzal; register;
begin
        reg.r[31] := reg.pc + 8;
        if (reg.r[__RS] < 0) then
        begin
                reg.delay := DO_DELAY;
                reg.delaypc := __O;
        end;
 //ms(get_rs,false);
end;

procedure r4300i_regimm_bgezal; register; //done
begin
        reg.r[31] := reg.pc + 8;
        if (reg.r[__RS] >= 0) then
        begin
                reg.delay := DO_DELAY;
                reg.delaypc := __O;
        end;
//ms(get_rs,false);
end;

procedure r4300i_regimm_bltzall; register;
begin
        reg.r[31] := reg.pc + 8;
        if (reg.r[__RS] < 0) then
        begin
        reg.delay := DO_DELAY;
        reg.delaypc := __O;
        end
        else
        reg.pc :=  reg.pc + 4;
//ms(get_rs,false);
end;

procedure r4300i_regimm_bgezall; register; //done
begin
        reg.r[31] := reg.pc + 8;

        if (reg.r[__RS] >= 0) then
        begin
        reg.delay := DO_DELAY;
        reg.delaypc := __O;
        end
        else
        reg.pc := reg.pc + 4;

//ms(get_rs,false);
end;



procedure rs4300i_cop0_rs_mf; register;
begin
        reg.r[__RT] := reg.cpr[0][__RD];
        //cop0 unusable exception
        reg.r[0] := 0;
end;

procedure rs4300i_cop0_rs_dmf; register;
begin
    reg.r[__RT] := reg.cpr[0][__RD];
   //cop0 unusable exception
   //reserved instruction exception
   reg.r[0] := 0;
end;

procedure rs4300i_cop0_rs_cf; register;
begin
        reg.r[__RT] := reg.ccr[0][__RD];
        //cop0 unusable exception
        reg.r[0] := 0;
end;

procedure rs4300i_cop0_rs_mt; register;
begin
        if(__RD = COUNT) then
        begin
        rs4300i_VI_or_CP_calc;
        end;

        if(__RD = CAUSE) then
        begin
        reg.cpr[0][CAUSE] := reg.r[__RT] and $00000300;
        exit;
        end;

        reg.cpr[0][__RD] := reg.r[__RT];

        if ((__RD = STATUS) and (reg.r[__RT] and $ff01 <> 0)) then
        reg.do_or_check_sthg :=   reg.do_or_check_sthg or RS4300I_CHECK_CPU_INTERRUPTS;

        if(__RD = COMPARE) then
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] and not $00008000;
        rs4300i_VI_or_CP_calc;
        end;

        //cop0 unusable exception
end;

procedure rs4300i_cop0_rs_dmt; register;
begin
        if(__RD = COUNT) then
        begin
        rs4300i_VI_or_CP_calc;
        end;

        if(__RD = CAUSE) then
        begin
        reg.cpr[0][CAUSE] := reg.r[__RT] and $00000300;
        exit;
        end;

        reg.cpr[0][__RD] := reg.r[__RT];

        if((__RD = STATUS) and (reg.r[__RT] and $ff01 <> 0 )) then
       reg.do_or_check_sthg :=  reg.do_or_check_sthg or RS4300I_CHECK_CPU_INTERRUPTS;

        if(__RD = COMPARE) then
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] and not $00008000;
        rs4300i_VI_or_CP_calc;
        end;
end;

procedure rs4300i_cop0_rs_ct; register;
begin
  reg.ccr[0][__RD] := reg.r[__RT];
end;

procedure rs4300i_cop0_rs_bc; register;
begin
 cop0_rt_instruction[__RT];
end;

procedure rs4300i_cop0_rs_co; register;
begin
 cop0_instruction[__F];
end;

procedure rs4300i_cop0_rt_bcf; register;
begin

end;

procedure rs4300i_cop0_rt_bct; register;
begin

end;

procedure rs4300i_cop0_rt_bcfl; register;
begin

end;

procedure rs4300i_cop0_rt_bctl; register;
begin

end;

procedure rs4300i_cop0_tlbr; register;
var
_index:longint;
begin

        _index := reg.cpr[0][INDEX] and $1f;

        reg.cpr[0][PAGEMASK] := reg.tlb[_index].hh;
        reg.cpr[0][ENTRYHI]  := reg.tlb[_index].hl or (not reg.tlb[_index].hh);
        reg.cpr[0][ENTRYLO1] := reg.tlb[_index].lh or reg.tlb[_index].g;
        reg.cpr[0][ENTRYLO0] := reg.tlb[_index].ll or reg.tlb[_index].g;


end;

procedure rs4300i_cop0_tlbwi; register;
var
tlb:Pt_rs4300i_tlb;
begin

        tlb := @(reg.tlb[reg.cpr[0][INDEX]]);

        tlb^.hh := reg.cpr[0][PAGEMASK];
        tlb^.hl := reg.cpr[0][ENTRYHI];
        tlb^.lh := reg.cpr[0][ENTRYLO1];
        tlb^.ll := reg.cpr[0][ENTRYLO0];

        tlb^.g       := $01 and tlb^.lh and tlb^.ll;
        tlb^.mask    := tlb^.hh or $00001fff;
        tlb^.invmask := not(tlb^.mask);

        case (tlb^.hh) of

        $00000000:
        begin
        tlb^.even_odd_checkbit := $00001000;
        end;
        $00006000:
        begin
        tlb^.even_odd_checkbit := $00004000;
        end;
        $0001e000:
        begin
        tlb^.even_odd_checkbit := $00010000;
        end;
        $0007e000:
        begin
        tlb^.even_odd_checkbit := $00040000;
        end;
        $001fe000:
        begin
        tlb^.even_odd_checkbit := $00100000;
        end;
        $007fe000:
        begin
        tlb^.even_odd_checkbit := $00400000;
        end;
        $01ffe000:
        begin
        tlb^.even_odd_checkbit := $01000000;
        end;
        else
        tlb^.even_odd_checkbit := 0;
        end;

end;

procedure rs4300i_cop0_tlbwr; register;
var
tlb:Pt_rs4300i_tlb;
begin

        tlb := @(reg.tlb[reg.cpr[0][_RANDOM]]);

        tlb^.hh := reg.cpr[0][PAGEMASK];
        tlb^.hl := reg.cpr[0][ENTRYHI];
        tlb^.lh := reg.cpr[0][ENTRYLO1];
        tlb^.ll := reg.cpr[0][ENTRYLO0];

        tlb^.g       := $01 and tlb^.lh and tlb^.ll;
        tlb^.mask    := tlb^.hh or $00001fff;
        tlb^.invmask := not(tlb^.mask);

        case (tlb^.hh) of

            $00000000:
            begin
            tlb^.even_odd_checkbit := $00001000;
            end;
            $00006000:
            begin
            tlb^.even_odd_checkbit := $00004000;
            end;
            $0001e000:
            begin
            tlb^.even_odd_checkbit := $00010000;
            end;
            $0007e000:
            begin
            tlb^.even_odd_checkbit := $00040000;
            end;
            $001fe000:
            begin
                tlb^.even_odd_checkbit := $00100000;
            end;
            $007fe000:
            begin
            tlb^.even_odd_checkbit := $00400000;
            end;
            $01ffe000:
            begin
            tlb^.even_odd_checkbit := $01000000;
            end;
            else
                tlb^.even_odd_checkbit := 0;

        end;
end;

procedure rs4300i_cop0_tlbp; register;
var i:integer;
begin

for i:=0 to 32-1 do
  begin
  if ((reg.tlb[i].hl and not $1fff) = uword(reg.cpr[0][ENTRYHI] and not $1fff)) and
  (reg.tlb[i].g<>0) or  ((reg.tlb[i].hl and $ff) = uword(reg.cpr[0][ENTRYHI] and $ff)) then
  begin
  reg.cpr[0][INDEX] := i;
  exit;
  end;
  end;

end;

procedure rs4300i_cop0_eret; register;
begin
        if (reg.cpr[0][STATUS] and $0004)<>0 then
        begin
        reg.pc := reg.cpr[0][ERROREPC] - 4;
        //reg.cpr[0][STATUS] := reg.cpr[0][STATUS] and $fffffffffffffffb;
        end
        else
        begin
        reg.pc := reg.cpr[0][EPC] - 4;
        //reg.cpr[0][STATUS] := reg.cpr[0][STATUS] and $fffffffffffffffd;
        end;
        reg.delay := NO_DELAY;
        reg.llbit := 0;
end;

procedure rs4300i_cop1_rs_mf; register;
begin

end;

procedure rs4300i_cop1_rs_dmf; register;
begin

end;

procedure rs4300i_cop1_rs_cf; register;
begin

end;

procedure rs4300i_cop1_rs_mt; register;
begin

end;

procedure rs4300i_cop1_rs_dmt; register;
begin

end;

procedure rs4300i_cop1_rs_ct; register;
begin

end;

procedure rs4300i_cop1_rs_bc; register;
begin

end;

procedure rs4300i_cop1_rs_co; register;
begin

end;

procedure rs4300i_cop1_rt_bcf; register;
begin

end;

procedure rs4300i_cop1_rt_bct; register;
begin

end;

procedure rs4300i_cop1_rt_bcfl; register;
begin

end;

procedure rs4300i_cop1_rt_bctl; register;
begin

end;

procedure rs4300i_cop1_add; register;
begin

end;

procedure rs4300i_cop1_sub; register;
begin

end;

procedure rs4300i_cop1_mul; register;
begin

end;

procedure rs4300i_cop1_div; register;
begin

end;

procedure rs4300i_cop1_sqrt; register;
begin

end;

procedure rs4300i_cop1_abs; register;
begin

end;

procedure rs4300i_cop1_mov; register;
begin

end;

procedure rs4300i_cop1_neg; register;
begin

end;

procedure rs4300i_cop1_roundl; register;
begin

end;

procedure rs4300i_cop1_truncl; register;
begin

end;

procedure rs4300i_cop1_ceill; register;
begin

end;

procedure rs4300i_cop1_floorl; register;
begin

end;

procedure rs4300i_cop1_roundw; register;
begin

end;

procedure rs4300i_cop1_truncw; register;
begin

end;

procedure rs4300i_cop1_ceilw; register;
begin

end;

procedure rs4300i_cop1_floorw; register;
begin

end;

procedure rs4300i_cop1_cvts; register;
begin

end;

procedure rs4300i_cop1_cvtd; register;
begin

end;

procedure rs4300i_cop1_cvtw; register;
begin

end;

procedure rs4300i_cop1_cvtl; register;
begin

end;

procedure rs4300i_cop1_c; register;
begin

end;

procedure rs4300i_cop2_rs_not_implemented; register;
begin

end;



procedure r4300i_nop; register; //done
begin
//ms('',false);
end;


function READ_CPU_INSTRUCTION(addr:int64):uWord;
var
c:uWord;
begin
        if (addr < $a4000040)  then
        begin
        C := uword((rd_ram[(addr and $1fffffff)+3]shl 24) or
              (rd_ram[(addr and $1fffffff)+2]shl 16) or
              (rd_ram[(addr and $1fffffff)+1]shl 8) or
             (rd_ram[(addr and $1fffffff)]));
        result := C;
        end
        else
        begin
        if (addr < $e0000000) then
        begin
        c := uword(
             (sp_dmem[(addr and $fff)+3] shl 24) or
             (sp_dmem[(addr and $fff)+2] shl 16) or
             (sp_dmem[(addr and $fff)+1] shl 8 ) or
              sp_dmem[(addr and $fff)  ]
                  );
        result := C;
        end
        else
        begin
        c :=uword(
             (ubyte(rom.image[(addr and $fff)+3]) shl 24) or
             (ubyte(rom.image[(addr and $fff)+2]) shl 16) or
             (ubyte(rom.image[(addr and $fff)+1]) shl 8 ) or
              ubyte(rom.image[(addr and $fff)  ]        )
              );
        result := C;
        end;
        end;
end;


function __CODE:uWord;
begin
reg.code := READ_CPU_INSTRUCTION(reg.pc);
result := reg.code;
end;

function __NEXT_CODE:uWord;
begin
result := (READ_CPU_INSTRUCTION(reg.pc + 4));
end;

function __PREV_CODE:uWord;
begin
result := (READ_CPU_INSTRUCTION(reg.pc - 4));
end;

function __OPCODE:ubyte;
begin
result := (__CODE shr 26);
end;

function __RS:ubyte;
begin
rs := (reg.code shr 21) and $1f;
result := (reg.code shr 21) and $1f;
end;

function __RT:ubyte;
begin
rt := (reg.code shr 16) and $1f;
result := (reg.code shr 16) and $1f;
end;


function __RD:ubyte;
begin
rd := (reg.code shr 11) and $1f;
result := (reg.code shr 11) and $1f;
end;

function __SA:ubyte;
begin
sa := (reg.code shr  6) and $1f;
result := (reg.code shr  6) and $1f;
end;

function __F:ubyte;
begin
result := (reg.code) and $3f;
end;

function __I:sWord;
begin
result := sword(shword(reg.code));
end;

function __O:uWord;
begin
result :=  uword( reg.pc + 4 + uword(__I shl 2) );
end;

function ____T:uWord;
begin
result :=  (reg.code and $3ffffff);
end;

function __T:uWord;
begin
result := ( (reg.pc and $f0000000) or (____T shl 2) );
end;




procedure compileMIPS(opcode:byte);
var i:integer;
begin
compile_chunk[cp] := opcode;
asm add cp , 1 end;
if cp >= 4096 then cp := 0;
end;



procedure RecompileMIPS;
var i:integer;
begin
recompiled_chunk[cp] := compile_chunk[cp];
minstruction[recompiled_chunk[cp]];
end;

procedure debugopen;
begin
debugs := tstringlist.create;
end;


procedure debugwrite(text:string);
begin
debugs.add(text);
end;


procedure debugclose(filename:string);
begin
debugs.savetofile(filename);
debugs.free;
end;

procedure Cpu_step;
var i:integer;
begin

        check_int;
        opcode := __OPCODE;
        compileMips(opcode); //kidding
        recompileMips; //kidding haha
        setwindowtext(mhwnd,pchar(inttostr(opcode)));
         debugwrite(opcodes_string[opcode]);
   	if  reg.delay = EXEC_DELAY then
        begin
        reg.delay := NO_DELAY;
        reg.pc := reg.delaypc;
     	end;
        if reg.delay = DO_DELAY then
        begin
        reg.delay := EXEC_DELAY;
        end;
	if reg.delay = NO_DELAY then
        begin
        reg.pc :=  reg.pc + 4;
     	end;
        inc(reg.cpr[0][9]);
end;


procedure check_int;
begin
         if(reg.do_or_check_sthg) <> 0 then
         begin

         if (reg.do_or_check_sthg and RS4300I_DO_SI_INTERRUPT) <> 0 then
         begin
         rs4300i_MI_Intr_SI;
         reg.do_or_check_sthg :=reg.do_or_check_sthg and not RS4300I_DO_SI_INTERRUPT;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_SP_INTERRUPT) <> 0 then
         begin
         rs4300i_MI_Intr_SP;
         reg.do_or_check_sthg   :=reg.do_or_check_sthg and not RS4300I_DO_SP_INTERRUPT;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_DP_INTERRUPT) <> 0 then
         begin
         rs4300i_MI_Intr_DP;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_DP_INTERRUPT;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_AI_INTERRUPT) <> 0 then
         begin
         rs4300i_MI_Intr_AI;
         reg.do_or_check_sthg  :=reg.do_or_check_sthg and not RS4300I_DO_AI_INTERRUPT;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_PI_INTERRUPT) <> 0 then
         begin
         rs4300i_MI_Intr_PI;
         reg.do_or_check_sthg  :=reg.do_or_check_sthg and not RS4300I_DO_PI_INTERRUPT;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_CHECK_MI_INTERRUPTS) <> 0 then
         begin
         _rs4300i_Check_MI_Interrupts;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_CHECK_MI_INTERRUPTS;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_CHECK_CPU_INTERRUPTS) <> 0 then
         begin
         _rs4300i_Check_CPU_Interrupts;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_CHECK_CPU_INTERRUPTS;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_INTEGER_OVERFLOW_EXCEPTION) <> 0 then
         begin
         rs4300i_integer_overflow_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_INTEGER_OVERFLOW_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_FLOATING_POINT_EXCEPTION) <> 0 then
         begin
         rs4300i_floating_point_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_FLOATING_POINT_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_TRAP_EXCEPTION) <> 0 then
         begin
         rs4300i_trap_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_TRAP_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_SYSCALL_EXCEPTION) <> 0 then
         begin
         rs4300i_syscall_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_SYSCALL_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_BREAK_EXCEPTION) <> 0 then
         begin
         rs4300i_break_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_BREAK_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_RESERVED_INSTRUCTION_EXCEPTION) <> 0 then
         begin
         rs4300i_reserved_instruction_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_RESERVED_INSTRUCTION_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_TLB_MISS_EXCEPTION) <> 0 then
         begin
         rs4300i_tlb_miss_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_TLB_MISS_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_TLB_INVALID_EXCEPTION) <> 0 then
         begin
         rs4300i_tlb_invalid_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_TLB_INVALID_EXCEPTION;
         end;

         if(reg.do_or_check_sthg  and  RS4300I_DO_TLB_MODIFICATION_EXCEPTION) <> 0 then
         begin
         rs4300i_tlb_modification_exception;
         reg.do_or_check_sthg  := reg.do_or_check_sthg and not RS4300I_DO_TLB_MODIFICATION_EXCEPTION;
         end;
        end;


        if (reg.cpr[0][9] = next_interrupt_count) then
        begin
        rs4300i_VI_or_CP_interrupt;
        end;
end;



procedure Cpu_reset;
var i,j:integer;
begin
   debugopen;
   MainStartAddr := $A4000040;
   reg.pc :=  $A4000040;
   endbootpc := MainStartAddr+1008*4;
   reg.code := 0;
   for i:=0 to 32-1 do reg.r[i]   := 0;
   reg.r[20]   := $00000001;
   reg.r[22]   := $3f;
   reg.r[29]   := $a0400000;

   reg.hi := 0;
   reg.lo := 0;
   reg.llbit := 0;
   reg.delay := NO_DELAY;
   cp := 0;

   for j:=0 to 2-1 do
   begin
   for i:=0 to 32-1 do
   begin
   reg.cpr[j][i] := 0;
   reg.ccr[j][i] := 0;
   end;
   end;

        reg.cpr[0][STATUS] := $70400004;
        reg.cpr[0][_RANDOM] := $0000002f;
        reg.cpr[0][CONFIG] := $00066463;
        reg.cpr[0][PRID]   := $00000b00;
        reg.ccr[1][0]      := $00000511;
   rs4300i_InitInterrupts;
end;


end.
