unit controller;

interface
uses sysutils;

const GET_STATUS     = $00;
const READ_CONTROLLER = $01;
const READ_MEMPACK  =  $02;
const WRITE_MEMPACK =  $03;
const READ_EEPROM   =  $04;
const WRITE_EEPROM  =  $05;
const _RESET         =  $ff;
const STATUS_EEPROM =  $100;

const ABS          =   $01000000;
const REL          =   $02000000;
const JOY          =   $04000000;
const EEPROM       =   $00800000;
const MEMPACK      =   $00000100;
const NOMEMPACK    =   $00000200;

const EEPROM_SIZE  =    1024;


var
_eeprom:array[0..EEPROM_SIZE]of longint;
eeprom_:integer;

procedure InitController(num:integer);
procedure controller_check;
implementation
uses global;

procedure controller_check;
var
    i,j:integer;      (* offset to origin of pif ram *)
    code:integer;
    c1:integer;     (* command (main) *)
    c2:integer;     (* command *)
    re:integer;     (* uBYTEs to read *)
    wr:integer;     (* uBYTEs to write *)
    curr:integer;   (* current controller *)
    pif:PuByte;
begin
    (* major thanks go to LaC *)

        pif := pi_ram;



        i := 0;
        curr := 1;

        repeat
        code := ord(pif[i]);
       if(code = 0) then
       begin
                 (* let's read or write a eeprom ;-) *)
       inc(i);   (* we have to jump to the next uWORD to get the info *)
       code := ord(pif[i]);
       wr := (code  shr   24)  and  $ff;   (* length+2 in uBYTEs of eeprom read/write *)
       re := (code  shr   16)  and  $ff;   (* write: always 1? read: read re uBYTEs   *)
       c2 := (code  shr    8)  and  $ff;   (* write: 5; read: 4                      *)
       c1 := (code      )  and  $ff;   (* offset in uDWORDs                       *)
       if(wr = $ff) then   (* hack *)
       begin
       (* this way we can get the status of the eeprom ;-) *)
       c2 := c2 or STATUS_EEPROM;
       end;
       c1  := c1 shl 3;   (* c1 = c1 * 8; so we get the offset in uBYTEs *)
       end
       else
       begin
       (* let's read or write the controller ;-) *)
                        c1 := (code  shr   24)  and  $ff;
                        wr := (code  shr   16)  and  $ff;
                        re := (code  shr    8)  and  $ff;
                        c2 := (code      )  and  $ff;
       end;

                if(c1 = $fe) then   (* indicates the end *)
                begin
                exit;   (* exit this dobeginend;while; *)
                end;

                case c2 of
                GET_STATUS:
                begin
                if(curr  and plugged_controller)<>0 then   (* connected *)
                begin
                if(wr = 1)  and  (re <= 4) then
                begin
                inc(i);
                if re = 4 then pif[i]  := (pif[i] and $00000000);
                if re = 3 then pif[i]  := (pif[i] and $000000ff);
                if re = 2 then pif[i]  := (pif[i] and $0000ffff);
                if re = 1 then pif[i]  := (pif[i] and $00ffffff);
                pif[i] := pif[i] or ABS or JOY or NOMEMPACK;
                end
                else   (* error in transfer *)
                begin
                pif[i] :=pif[i] or $4000;
                inc(i);
                end;
                end
                else   (* not connected *)
                begin
                pif[i] :=pif[i] or $8000;
                inc(i);
                end;
                end;

                READ_CONTROLLER:
                begin
                if(curr  and  plugged_controller)<>0 then   (* connected *)
                begin
                if(wr = 1)  and (re <= 4) then
                begin
                inc(i);
               if re=4 then pif[i] := pif[i] and $00000000;
               if re=3 then pif[i] := pif[i] and $000000ff;
               if re=2 then pif[i] := pif[i] and $0000ffff;
               if re=1 then pif[i] := pif[i] and $00ffffff;
            // pif[i] :=pif[i]  or controller_get_status(i shr  1);
             end
             else   (* error in transfer *)
             begin
             pif[i] := pif[i] or $4000;
             inc(i);
             end;
             end
             else   (* not connected *)
             begin
             pif[i] := pif[i] or $8000;
             inc(i);
             end;
             end;

             READ_MEMPACK:
             begin
             pif[i] := pif[i] or $8000;
             inc(i)
             end;

             WRITE_MEMPACK:
             begin
             pif[i] := pif[i] or $8000;
             end;

             STATUS_EEPROM or $00,
             STATUS_EEPROM or $01,
             STATUS_EEPROM or $02,
             STATUS_EEPROM or $03,
             STATUS_EEPROM or $04:
             begin
            if(eeprom_)<> 0  then  (* eeprom *)
            begin
            wr := c2  and  $ff;   (* hack *)
            if(re = 1)  and  (wr <= 4) then
            begin
            inc(i);
            if wr = 4 then pif[i] := pif[i] and $00000000;
            if wr = 3 then pif[i] := pif[i] and $000000ff;
            if wr = 2 then pif[i] := pif[i] and $0000ffff;
            if wr = 1 then pif[i] := pif[i] and $00ffffff;
            pif[i] :=pif[i] or EEPROM;
            end
            else   (* error in transfer *)
            begin
            pif[i] :=pif[i] or $4000;
            inc(i);
            end;
            end
            else   (* no eeprom *)
            begin
            pif[i] := pif[i] or $8000;
            inc(i);
            end;
            end;

            READ_EEPROM:
            begin
            if(eeprom_)<> 0 then   (* eeprom *)
            begin
            if(wr = 2) then
            begin
            inc(i);
            for j:=0 to re-1 do
            begin
            pif[(i shl  2)+j] := _eeprom[j+c1];
            end;
            i := 16;   (* just one eeprom command can appear *)
            end
            else   (* error in transfer *)
            begin
            pif[i] := pif[i] or $4000;
            i := 16;
            end;
            end
            else   (* no eeprom *)
            begin
            pif[i] := pif[i] or $8000;
            i := 16;
            end;
            end;

            WRITE_EEPROM:
            begin
            if(eeprom_)<> 0 then   (* eeprom *)
            begin
            if(re = 1)  and  (wr >= 2) then
            begin
            inc(i);
            wr := wr -  2;
            for j:=0 to wr-1 do
            begin
            _eeprom[j+c1] := pif[(i shl  2)+j];
            end;
            i := 16;   (* just one eeprom command can appear *)
            end
            else   (* error in transfer *)
            begin
            pif[i] := pif[i] or $4000;
            i := 16;
            end;
            end
            else   (* no eeprom *)
            begin
            pif[i] := pif[i] or $8000;
            i := 16;
            end;
            end;

            _RESET:
            begin
            inc(i);
            end;

               else
               begin
                        pif[i] := pif[i] or$8000;
                        i:=16;   (* exit *)

                end; (* switch(c2) *)

                inc(i);
                curr :=curr shl 1;   (* switch to next controller *)

        end; (* do *)
        until (i >=16);   (* we have to pay attension that we don't read beond pif ram *)

        pif[63] := 0;   (* command processed *)

end; (* procedure controller_check; *)





procedure InitController(num:integer);
var
i:integer;
begin

        plugged_controller := num;
        for i:=0 to EEPROM_SIZE-1 do
                _eeprom[i] := 0;

end; (* procedure InitController(int num) *)


procedure check_keys;
var
StickFlag :integer;
begin
StickFlag := 0;

//** KeyPress and KeyReleases

//** Function-Buttons
  //** Start Button
{    if _ctrl[options.listbox2.itemindex].Button_start then
    keystate := keystate or $1000
    else
    keystate := keystate adn not $1000;

  //** A-Button
    if (Keys[kW])
        keystate |= 0x8000;
	else
		keystate &= ~0x8000;

  //** B-Button
    if (Keys[kE])
        keystate |= 0x4000;
	else
		keystate &= ~0x4000;

//** C-Buttons...
  //** C-Button UP
    if (Keys[kHOME])    
        keystate |= 0x0008;
	else
		keystate &= ~0x0008;

  //** C-Button DOWN
    if (Keys[kEND])    
        keystate |= 0x0004;
	else
		keystate &= ~0x0004;

  //** C-Button LEFT
    if (Keys[kDEL])    
        keystate |= 0x0002;
	else
		keystate &= ~0x0002;

  //** C-Button RIGHT
    if (Keys[kPGDN])
        keystate |= 0x0001;
	else
		keystate &= ~0x0001;

//** D-Buttons...
  //** D-Button UP
    if (Keys[kI])    
        keystate |= 0x0800;
	else
		keystate &= ~0x0800;

  //** D-Button DOWN
    if (Keys[kK])
        keystate |= 0x0400;
	else
		keystate &= ~0x0400;

  //** D-Button LEFT
    if (Keys[kJ])    
        keystate |= 0x0200;
	else
		keystate &= ~0x0200;

  //** D-Button RIGHT
    if (Keys[kL])    
        keystate |= 0x0100;
	else
		keystate &= ~0x0100;

//** d
  //** L-Button
    if (Keys[kA])    
        keystate |= 0x0020;
	else
		keystate &= ~0x0020;

  //** R-Button
    if (Keys[kS])    
        keystate |= 0x0010;
	else
		keystate &= ~0x0010;

  //** Z-Button
    if (Keys[kD])
        keystate |= 0x2000;
	else
		keystate &= ~0x2000;

//************************************

  //** Stick UP
	if (Keys[kUP])
	{
		StickFlag = 1;
		if(stick_y < 0x60) stick_y += 0x20;
	}

  //** Stick DOWN
 {   if (Keys[kDOWN])
	{
		StickFlag = 1;
        if(stick_y > -0x60) stick_y -= 0x20;
	}

  //** Stick RIGHT
  {	if (Keys[kRIGHT])
	{
		StickFlag = 1;
        if(stick_x < 0x60) stick_x += 0x20;
	}

  //** Stick LEFT
  {  if (Keys[kLEFT])
	{
		StickFlag = 1;
        if(stick_x > -0x60) stick_x -= 0x20;
	}
			

//** Release Stick
   {	if (StickFlag == 0)
	{
		stick_x = 0;
		stick_y = 0;
	}

   { return(((dword)(keystate << 16)) | ((dword)(W)(stick_x << 8)) | ((dword)(byte)stick_y));

}

end;



end.

