unit emulate;

interface
uses windows,mmsystem,sysutils,cpu;
const BIG_ENDIAN  = 9;
const LITTLE_ENDIAN = 2;

var
mfid:array[0..128-1] of pchar =
(
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', 'Nintendo', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?'
);

countrycode:array[0..128-1]of pchar =
(
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', 'Germany', 'USA', '?', '?', '?', '?', 'Japan', '?', '?', '?', '?', '?',
        'Europe', '?', '?', '?', '?', 'Australia', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?',
        '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?'
);


procedure Sm(Command : String; handled : boolean);
function  fps:string;
procedure Start_emulating;
procedure Stop_emulating;
procedure n64File_load(Romname:pchar);

var
isN64:boolean = false;
isNES:boolean = false;
implementation
uses global,controller,main;


procedure change_rom_endian(file_endian:integer);
var
     i:integer;
     change_endian:array[0..3]of char;
begin

        i := 0;
        repeat
        change_endian[0] := (rom.image[i+0]);
        change_endian[1] := (rom.image[i+1]);
        change_endian[2] := (rom.image[i+2]);
        change_endian[3] := (rom.image[i+3]);
        if(file_endian = BIG_ENDIAN) then
        begin
        rom.image[i+0] := (change_endian[3]);//3
        rom.image[i+1] := (change_endian[2]);//2
        rom.image[i+2] := (change_endian[1]);
        rom.image[i+3] := (change_endian[0]);
        end
        else
        if(file_endian = LITTLE_ENDIAN) then
        begin
        rom.image[i+0] := (change_endian[2]);
        rom.image[i+1] := (change_endian[3]);
        rom.image[i+2] := (change_endian[0]);
        rom.image[i+3] := (change_endian[1]);
        end;
        inc(i,4);
        until (i >= rom.length div 100);

end;


procedure change_endian(file_endian:integer; addr:PuByte; length:integer);
var
i:integer;
change_endian:array[0..3]of ubyte;
begin

        i := 0;
        repeat
        change_endian[0] := (addr[i+0]);
        change_endian[1] := (addr[i+1]);
        change_endian[2] := (addr[i+2]);
        change_endian[3] := (addr[i+3]);
        if(file_endian = BIG_ENDIAN) then
        begin
        addr[i+0] := (change_endian[3]);
        addr[i+1] := (change_endian[2]);
        addr[i+2] := (change_endian[1]);
        addr[i+3] := (change_endian[0]);
        end
        else
        if(file_endian = LITTLE_ENDIAN) then
        begin
        addr[i+0] := (change_endian[2]);
        addr[i+1] := (change_endian[3]);
        addr[i+2] := (change_endian[0]);
        addr[i+3] := (change_endian[1]);
        end;
        inc(i,4);
        until(i >= length);

end;


function read_n64_image:integer;
var
returnValue:integer;
i:integer;
io_result:dword;
endian_1,endian_2:char;
bytes:array[0..$16000]of char;
tmp:array[0..1024]of byte;
hfile:Thandle;
pc:int64;
testc:cardinal;
b1,b2,b3,b4:byte;
C,g:dword;
begin
        returnValue := 0;
        i := 0;
        io_result := 0;
        hfile := createfile(rominfo.real_name,
        GENERIC_READ,FILE_SHARE_READ,nil,OPEN_EXISTING,
        FILE_ATTRIBUTE_NORMAL,0);

        rom.length :=getfilesize(hfile,nil);
        rom.prgcode_length := rom.length - $1000;
        rom.header   := rom.image;
        rom.bootcode := rom.image + $40;
        rom.prgcode  := pointer(rom.image + $1000);

        readfile(hfile,endian_1,1,io_result,nil);
        readfile(hfile,endian_2,1,io_result,nil);
       {
        if ((endian_1 <> chr($37)) and (endian_2 <> chr($80))) or
           ((endian_1 <> chr($80)) and (endian_2 <> chr($37))) then
        begin
        messagebox(mhwnd,'This is not a N64 Rom!!','ERROR',MB_OK or MB_ICONEXCLAMATION);
        fileclose(hfile);
        result := -6;
        exit;
        end;
       }
        fileseek(hfile,0,0);
        getmem(rom.image,rom.length+1);
        readfile(hfile,rom.image^,rom.length,io_result,nil);
        fileseek(hfile,0,0);
        getmem(sp_dmem,$4000+1);
        readfile(hfile,sp_dmem^,$4000,io_result,nil);
        getmem(sp_imem,$4000+1);
        readfile(hfile,sp_imem^,$4000,io_result,nil);
        fileclose(hfile);
        change_endian(BIG_ENDIAN,sp_dmem, $4000);
        change_endian(BIG_ENDIAN,sp_imem, $4000);
        if(endian_1 = chr($37)) and (endian_2 = chr($80)) then
        begin
        change_rom_endian(LITTLE_ENDIAN);
        returnValue := 4;
        end
        else
        begin
        change_rom_endian(BIG_ENDIAN);
        returnValue := 3;
        end;



        rominfo.validation           := ord(rom.image[($00 xor $02)]);
        rominfo.compression          := ord(rom.image[($02 xor $03)]);
        rominfo.unknown1             := ord(rom.image[($03 xor $03)]);
        rominfo.clockrate            := ord(rom.image[$04]);
        rominfo.programcounter       := ord(rom.image[$08]);
        rominfo.release              := ord(rom.image[$0c]);
        rominfo.crc1                 := ord(rom.image[$10]);
        rominfo.crc2                 := ord(rom.image[$14]);
        rominfo.unknown2             := ord(rom.image[$18 shl 32]) + ord(rom.image[$1c]);
        for i:=0 to 20-1 do
        rominfo.name[i xor $03] := ord(rom.image[i+$20]);
        rominfo.unknown3             := ord(rom.image[($34 xor $03)]);
        rominfo.unknown4             := ord(rom.image[($35 xor $03)]);
        rominfo.unknown5             := ord(rom.image[($36 xor $03)]);
        rominfo.unknown6             := ord(rom.image[($37 xor $03)]);
        rominfo.unknown7             := ord(rom.image[($38 xor $03)]);
        rominfo.unknown8             := ord(rom.image[($39 xor $03)]);
        rominfo.unknown9             := ord(rom.image[($3a xor $03)]);
        rominfo.manufacturerid       := ord(rom.image[($3b xor $03)]);
        rominfo.cartridgeid          := ord(rom.image[($3c xor $02)]);
        rominfo.countrycode          := ord(rom.image[($3e xor $03)]);
        rominfo.unknown10            := ord(rom.image[($3f xor $03)]);
        rom.prgcode_base_orig := rominfo.programcounter;
        rom.prgcode_base := rom.prgcode_base_orig  and $1fffffff;
        result := (returnValue);
end;


procedure n64File_load(Romname:pchar);
var i:integer;
begin
rominfo.real_name := RomName;
//alloc_n64_mem;
read_n64_image;
   n64Romname := '';
   for i := 0 to 19 do
   n64romname := n64romname + chr(rominfo.name[i]);
   if romname = '                    ' then
   n64romname := ExtractFilename(rominfo.real_name);

   SetWindowText(mhwnd,pchar('Blur - '+n64romname));
end;


procedure sm(Command : String; handled : boolean);
begin
 {with debugger do
 begin
 commandlist.Items.Add('$'+a+': '+ opcodes_string[opcode]+' '+command);
 commandlist.Itemindex := debugger.commandlist.Items.count - 1;
 if commandlist.Items.count > 9000 then debugger.commandlist.Items.clear;
 unh:=handled;
 end;}
end;



procedure Start_emulating;
Var
   Tmp : dword;
   i:integer;
begin
counter := 0;
eeprom_ := 0;
plugged_controller := CONTR_1;
InitController(plugged_controller);
cpu_reset;
Repeat
  Cpu_Step;
//  SetWindowText(mhwnd,pchar('Blur - '+n64romname+'  Fps: ' + fps));
until (msg_ = quit);
//Stop_emulating;
//free_n64_mem;
//Start1.enabled := true;
//Stop1.enabled := false;
//Reset1.enabled := false;
end;

procedure Stop_emulating;
var
tmp:cardinal;
begin
     msg_ := quit; // stop emulation
     getExitCodeThread(th,tmp);
     TerminateThread(th,tmp);
     //debugger.commandlist.Clear;
end;


function fps:string;
var
tmp:string;
begin
dwFrameCount := dwFrameCount+1;
    dwTime := timeGetTime - dwFrameTime;
    if ( dwTime >= 1000 ) then
begin
     dwFrames := ( dwFrameCount*1000 ) / dwTime;
     dwFrameTime := timeGetTime;
     dwFrameCount := 0;
end;
tmp := floattostr(dwFrames);
setlength(tmp,4);
 result := tmp;
end;
end.
