unit Unit1;

interface

uses
  Windows, Messages, SysUtils,  Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, ComCtrls,  StdCtrls, IniFiles, 
  emulate,cpu,ToolWin;

type
  TMain = class(TForm)
    MainMenu1: TMainMenu;
    Filemenu: TMenuItem;
    OpenRom1: TMenuItem;
    CloseRom1: TMenuItem;
    Emulation1: TMenuItem;
    Start1: TMenuItem;
    Stop1: TMenuItem;
    Reset1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    open: TOpenDialog;
    N2: TMenuItem;
    Info1: TMenuItem;
    ShowOpcodes1: TMenuItem;
    Pause1: TMenuItem;
    N1: TMenuItem;
    Options1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure OpenRom1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure CloseRom1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Start1Click(Sender: TObject);
    procedure Reset1Click(Sender: TObject);
    procedure Stop1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ShowOpcodes1Click(Sender: TObject);
    procedure Pause1Click(Sender: TObject);
    procedure Options1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type PVideo_Plugin = ^TVideo_Plugin;
     TVideo_Plugin = record
     version:integer;
     name:pchar;
     DC:HDC;
     Init:procedure;
     Config:procedure(Parent:Hwnd);
     About:procedure(Parent:Hwnd);
     Quit:procedure;
{     matrix:Tmatrix;
     poly:Tpoly;
     tri:TTriangle;}
end;


type Pcontrol_plugin = ^Tcontrol_plugin;
     Tcontrol_plugin = record
name:pchar;
version:integer;  //$110
id:integer; //dll hinst
init:procedure;
quit:procedure;
about:procedure(parent:hwnd);
config:procedure(parent:hwnd);
Button_Start:function:boolean;
Button_A:function:boolean;
Button_B:function:boolean;
Button_Z:function:boolean;
Cursor_Up:function:boolean;
Cursor_Down:function:boolean;
Cursor_Left:function:boolean;
Cursor_Right:function:boolean;

end;

var
    Romname, Romfrom : String;
    Main: TMain;
    BlurIni : TIniFile;
    Pause : boolean = false;
    _ctrl:array[0..99]of Pcontrol_plugin;
    current_ctrl:integer = 0;
    current_vid:integer = 0;
    current_aud:integer = 0;
    Controll_plugins:Tstringlist;
    Video_plugins:Tstringlist;
    Sound_plugins:Tstringlist;
    thp : integer = THREAD_PRIORITY_NORMAL;
implementation

uses Unit2, Unit3, Unit4, Unit5,global;
{$R *.DFM}

procedure LoadPlugins;
var
  Item: TMenuItem;
  DirRec: TSearchRec;
  Found: Integer;
  path: string;
  i:integer;
  id:integer;
  tmpfunc:function:Pcontrol_plugin;
begin
  Controll_plugins := Tstringlist.create;
  path := extractfilepath(application.exename);
  Found := FindFirst(path + '*.dll', faAnyfile, DirRec);
  while Found = 0 do
  begin
  Controll_plugins.add(Dirrec.name);
  Found := FindNext(DirRec);
  end;
  FindClose(DirRec);


for i := 0 to Controll_plugins.count-1 do
begin             //pchar(path+'vctrl.dll')
id := loadlibrary(pchar(Controll_plugins[i]));
tmpfunc := GetProcAddress(id,'Get_C_Plugin');
if tmpfunc <> nil then
begin
_ctrl[i] := tmpfunc;
_ctrl[i].id := id;
_ctrl[i].init;
if _ctrl[i].version <> $110 then
begin
freelibrary(id);
_ctrl[i] := nil;
end;
end;
end;



end;

procedure trash_rom;
begin
with main do
begin
   msg_ := quit;
   closerom1.Enabled:=false;
   application.Title:='Blur';
   Main.Caption:='Blur';
   start1.enabled:=false;
   info.Label1.caption := 'File: ';
   info.Label2.caption := 'Title: ';
   info.Label3.caption := 'Country: ';
   info.Label4.caption := 'Size: ';
end;
end;

procedure TMain.Exit1Click(Sender: TObject);
begin
close;
end;



procedure TMain.OpenRom1Click(Sender: TObject);
var i:integer;
begin
   trash_rom;
   if open.Execute=true then
   begin
   File_load(pchar(open.filename));
   Romname := '';
   for i := 0 to 19 do
   romname := romname + chr(rominfo.name[i]);
   if romname = '                    ' then
   romname := ExtractFilename(rominfo.real_name);
      Main.Caption:='Blur - '+romname;
      Application.Title:='Blur - '+romname;
      closerom1.Enabled:=true;
      Start1.Enabled:=true;


info.Label1.caption := 'File: '+ExtractFilename(open.filename);
info.Label2.caption := 'Title: '+Romname;
info.Label3.caption := 'Country: '+countrycode[rominfo.countrycode];
info.Label4.caption := 'Size: '+inttostr(rom.length div 1024 div 1024 * 8)+' bit';


end;
end;


procedure TMain.About1Click(Sender: TObject);
begin
     about.showmodal;
end;

procedure TMain.CloseRom1Click(Sender: TObject);
begin
trash_rom;
end;

procedure TMain.FormCreate(Sender: TObject);
begin
SetWindowLong(main.handle,GWL_EXSTYLE,WS_EX_ACCEPTFILES or WS_EX_LEFT);
show;
     if fileExists(getcurrentdir+'blur.ini') then IniPath:=getcurrentdir+'blur.ini';
     if fileExists(getcurrentdir+'\blur.ini') then IniPath:=getcurrentdir+'\blur.ini';
     blurIni:=TIniFile.Create(IniPath);
LoadPlugins;
end;

procedure TMain.Start1Click(Sender: TObject);
var
x,y:integer;

begin
msg_ := start;
Start1.enabled := false;
Pause1.Enabled:=true;
Stop1.enabled := true;
Reset1.enabled := true;
th := CreateThread(nil,0,@Start_emulating,nil,CREATE_SUSPENDED,th); //changed!
SetThreadPriority(th,thp);
ResumeThread(th);
end;

procedure TMain.Reset1Click(Sender: TObject);
begin
Stop_emulating;
msg_ := Quit;
msg_ := Start;
Start_emulating;
end;

procedure TMain.Stop1Click(Sender: TObject);
begin

Stop_emulating;
Start1.enabled := true;
Pause1.enabled := false;
Stop1.enabled := false;
Reset1.enabled := false;
end;

procedure TMain.Info1Click(Sender: TObject);
begin
info.show;
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
var i:integer;
begin
trash_rom;
for i := 0 to Controll_plugins.count-1 do
begin
if _ctrl[i] <> nil then
begin
_ctrl[i].quit;
freelibrary(_ctrl[i].id);
_ctrl[i] := nil;
end;
end;

halt;
end;

procedure TMain.ShowOpcodes1Click(Sender: TObject);
begin
debugger.show;
end;

procedure TMain.Pause1Click(Sender: TObject);
begin
if pause = true then
begin
pause := false;
 Resumethread(th);
 pause1.checked:=false;
 exit;
 end
else
begin
pause := true;
 pause1.checked:=true;
 SuspendThread(th);
end;

end;

procedure TMain.Options1Click(Sender: TObject);
begin
options.showmodal;
end;

end.
