unit snd;

interface
uses windows,mmsystem;
const SND_MELODIC = $01-1;      (* Melodic sound (default)    *)
const SND_NOISE  =  $02-1;      (* White noise                *)
const SND_PERIODIC = $04-1;      (* Periodic noise (not im-ed) *)

const SND_CHANNELS =   5-1;      (* Number of channels         *)
const SND_BUFSIZE  = 256-1;      (* Size of a wave buffer      *)
const SND_BUFFERS  =  32-1;      (* Number of wave buffers     *)

const SND_MSG_VOLUME = $1000-1;
const SND_MSG_FREQ  = $1001-1;
const SND_MSG_SOUND = $1002-1;

type frq = record
Note:integer;
Wheel:WORD;
end;

var freqs:array[0..4095]of frq =
(
(note:-36;wheel:8063 ),(note:-12;wheel:8063 ),(note: -3;wheel:8298 ),(note:  3;wheel:8358 ),
(note:  8;wheel:8201 ),(note: 12;wheel:8063 ),(note: 15;wheel:8054 ),(note: 17;wheel:8238 ),
(note: 19;wheel:8311 ),(note: 21;wheel:8298 ),(note: 23;wheel:8217 ),(note: 25;wheel:8080 ),
(note: 26;wheel:8238 ),(note: 27;wheel:8358 ),(note: 29;wheel:8102 ),(note: 30;wheel:8159 ),
(note: 31;wheel:8191 ),(note: 32;wheel:8201 ),(note: 33;wheel:8191 ),(note: 34;wheel:8164 ),
(note: 35;wheel:8121 ),(note: 36;wheel:8063 ),(note: 36;wheel:8334 ),(note: 37;wheel:8251 ),
(note: 38;wheel:8158 ),(note: 39;wheel:8054 ),(note: 39;wheel:8283 ),(note: 40;wheel:8162 ),
(note: 41;wheel:8033 ),(note: 41;wheel:8238 ),(note: 42;wheel:8095 ),(note: 42;wheel:8287 ), 
(note: 43;wheel:8131 ),(note: 43;wheel:8311 ),(note: 44;wheel:8144 ),(note: 44;wheel:8314 ),
(note: 45;wheel:8137 ),(note: 45;wheel:8298 ),(note: 46;wheel:8113 ),(note: 46;wheel:8265 ),
(note: 47;wheel:8072 ),(note: 47;wheel:8217 ),(note: 47;wheel:8358 ),(note: 48;wheel:8155 ),
(note: 48;wheel:8289 ),(note: 49;wheel:8080 ),(note: 49;wheel:8209 ),(note: 49;wheel:8335 ),
(note: 50;wheel:8117 ),(note: 50;wheel:8238 ),(note: 50;wheel:8357 ),(note: 51;wheel:8132 ),
(note: 51;wheel:8246 ),(note: 51;wheel:8358 ),(note: 52;wheel:8126 ),(note: 52;wheel:8234 ),
(note: 52;wheel:8340 ),(note: 53;wheel:8102 ),(note: 53;wheel:8204 ),(note: 53;wheel:8305 ),
(note: 54;wheel:8062 ),(note: 54;wheel:8159 ),(note: 54;wheel:8255 ),(note: 54;wheel:8349 ),
(note: 55;wheel:8100 ),(note: 55;wheel:8191 ),(note: 55;wheel:8281 ),(note: 56;wheel:8028 ),
(note: 56;wheel:8115 ),(note: 56;wheel:8201 ),(note: 56;wheel:8286 ),(note: 57;wheel:8028 ),
(note: 57;wheel:8110 ),(note: 57;wheel:8191 ),(note: 57;wheel:8271 ),(note: 57;wheel:8350 ),
(note: 58;wheel:8087 ),(note: 58;wheel:8164 ),(note: 58;wheel:8240 ),(note: 58;wheel:8315 ),
(note: 59;wheel:8047 ),(note: 59;wheel:8121 ),(note: 59;wheel:8193 ),(note: 59;wheel:8264 ),
(note: 59;wheel:8335 ),(note: 60;wheel:8063 ),(note: 60;wheel:8132 ),(note: 60;wheel:8200 ),
(note: 60;wheel:8267 ),(note: 60;wheel:8334 ),(note: 61;wheel:8058 ),(note: 61;wheel:8123 ),
(note: 61;wheel:8188 ),(note: 61;wheel:8251 ),(note: 61;wheel:8314 ),(note: 62;wheel:8035 ),
(note: 62;wheel:8097 ),(note: 62;wheel:8158 ),(note: 62;wheel:8218 ),(note: 62;wheel:8278 ),
(note: 62;wheel:8337 ),(note: 63;wheel:8054 ),(note: 63;wheel:8112 ),(note: 63;wheel:8170 ),
(note: 63;wheel:8227 ),(note: 63;wheel:8283 ),(note: 63;wheel:8339 ),(note: 64;wheel:8053 ),
(note: 64;wheel:8108 ),(note: 64;wheel:8162 ),(note: 64;wheel:8216 ),(note: 64;wheel:8269 ),
(note: 64;wheel:8322 ),(note: 65;wheel:8033 ),(note: 65;wheel:8085 ),(note: 65;wheel:8137 ),
(note: 65;wheel:8188 ),(note: 65;wheel:8238 ),(note: 65;wheel:8288 ),(note: 65;wheel:8338 ),
(note: 66;wheel:8046 ),(note: 66;wheel:8095 ),(note: 66;wheel:8143 ),(note: 66;wheel:8191 ),
(note: 66;wheel:8239 ),(note: 66;wheel:8287 ),(note: 66;wheel:8334 ),(note: 67;wheel:8039 ),
(note: 67;wheel:8085 ),(note: 67;wheel:8131 ),(note: 67;wheel:8176 ),(note: 67;wheel:8222 ),
(note: 67;wheel:8266 ),(note: 67;wheel:8311 ),(note: 67;wheel:8355 ),(note: 68;wheel:8057 ),
(note: 68;wheel:8101 ),(note: 68;wheel:8144 ),(note: 68;wheel:8187 ),(note: 68;wheel:8230 ),
(note: 68;wheel:8272 ),(note: 68;wheel:8314 ),(note: 68;wheel:8356 ),(note: 69;wheel:8056 ),
(note: 69;wheel:8097 ),(note: 69;wheel:8137 ),(note: 69;wheel:8178 ),(note: 69;wheel:8218 ),
(note: 69;wheel:8258 ),(note: 69;wheel:8298 ),(note: 69;wheel:8337 ),(note: 70;wheel:8035 ),
(note: 70;wheel:8074 ),(note: 70;wheel:8113 ),(note: 70;wheel:8151 ),(note: 70;wheel:8189 ),
(note: 70;wheel:8227 ),(note: 70;wheel:8265 ),(note: 70;wheel:8302 ),(note: 70;wheel:8340 ),
(note: 71;wheel:8035 ),(note: 71;wheel:8072 ),(note: 71;wheel:8108 ),(note: 71;wheel:8145 ),
(note: 71;wheel:8181 ),(note: 71;wheel:8217 ),(note: 71;wheel:8252 ),(note: 71;wheel:8288 ),
(note: 71;wheel:8323 ),(note: 71;wheel:8358 ),(note: 72;wheel:8051 ),(note: 72;wheel:8086 ),
(note: 72;wheel:8120 ),(note: 72;wheel:8155 ),(note: 72;wheel:8189 ),(note: 72;wheel:8222 ),
(note: 72;wheel:8256 ),(note: 72;wheel:8289 ),(note: 72;wheel:8323 ),(note: 72;wheel:8356 ),
(note: 73;wheel:8047 ),(note: 73;wheel:8080 ),(note: 73;wheel:8112 ),(note: 73;wheel:8145 ),
(note: 73;wheel:8177 ),(note: 73;wheel:8209 ),(note: 73;wheel:8241 ),(note: 73;wheel:8272 ),
(note: 73;wheel:8304 ),(note: 73;wheel:8335 ),(note: 74;wheel:8025 ),(note: 74;wheel:8056 ),
(note: 74;wheel:8087 ),(note: 74;wheel:8117 ),(note: 74;wheel:8148 ),(note: 74;wheel:8178 ),
(note: 74;wheel:8208 ),(note: 74;wheel:8238 ),(note: 74;wheel:8268 ),(note: 74;wheel:8298 ),
(note: 74;wheel:8327 ),(note: 74;wheel:8357 ),(note: 75;wheel:8045 ),(note: 75;wheel:8074 ),
(note: 75;wheel:8103 ),(note: 75;wheel:8132 ),(note: 75;wheel:8160 ),(note: 75;wheel:8189 ),
(note: 75;wheel:8217 ),(note: 75;wheel:8246 ),(note: 75;wheel:8274 ),(note: 75;wheel:8302 ),
(note: 75;wheel:8330 ),(note: 75;wheel:8358 ),(note: 76;wheel:8044 ),(note: 76;wheel:8071 ),
(note: 76;wheel:8099 ),(note: 76;wheel:8126 ),(note: 76;wheel:8153 ),(note: 76;wheel:8180 ),
(note: 76;wheel:8207 ),(note: 76;wheel:8234 ),(note: 76;wheel:8260 ),(note: 76;wheel:8287 ),
(note: 76;wheel:8313 ),(note: 76;wheel:8340 ),(note: 77;wheel:8024 ),(note: 77;wheel:8051 ),
(note: 77;wheel:8076 ),(note: 77;wheel:8102 ),(note: 77;wheel:8128 ),(note: 77;wheel:8154 ),
(note: 77;wheel:8179 ),(note: 77;wheel:8204 ),(note: 77;wheel:8230 ),(note: 77;wheel:8255 ),
(note: 77;wheel:8280 ),(note: 77;wheel:8305 ),(note: 77;wheel:8330 ),(note: 77;wheel:8354 ),
(note: 78;wheel:8038 ),(note: 78;wheel:8062 ),(note: 78;wheel:8087 ),(note: 78;wheel:8111 ),
(note: 78;wheel:8135 ),(note: 78;wheel:8159 ),(note: 78;wheel:8183 ),(note: 78;wheel:8207 ),
(note: 78;wheel:8231 ),(note: 78;wheel:8255 ),(note: 78;wheel:8279 ),(note: 78;wheel:8302 ),
(note: 78;wheel:8326 ),(note: 78;wheel:8349 ),(note: 79;wheel:8031 ),(note: 79;wheel:8054 ),
(note: 79;wheel:8077 ),(note: 79;wheel:8100 ),(note: 79;wheel:8123 ),(note: 79;wheel:8146 ),
(note: 79;wheel:8169 ),(note: 79;wheel:8191 ),(note: 79;wheel:8214 ),(note: 79;wheel:8237 ),
(note: 79;wheel:8259 ),(note: 79;wheel:8281 ),(note: 79;wheel:8303 ),(note: 79;wheel:8326 ),
(note: 79;wheel:8348 ),(note: 80;wheel:8028 ),(note: 80;wheel:8050 ),(note: 80;wheel:8072 ),
(note: 80;wheel:8094 ),(note: 80;wheel:8115 ),(note: 80;wheel:8137 ),(note: 80;wheel:8159 ),
(note: 80;wheel:8180 ),(note: 80;wheel:8201 ),(note: 80;wheel:8223 ),(note: 80;wheel:8244 ),
(note: 80;wheel:8265 ),(note: 80;wheel:8286 ),(note: 80;wheel:8307 ),(note: 80;wheel:8328 ),
(note: 80;wheel:8349 ),(note: 81;wheel:8028 ),(note: 81;wheel:8049 ),(note: 81;wheel:8069 ),
(note: 81;wheel:8090 ),(note: 81;wheel:8110 ),(note: 81;wheel:8131 ),(note: 81;wheel:8151 ),
(note: 81;wheel:8171 ),(note: 81;wheel:8191 ),(note: 81;wheel:8212 ),(note: 81;wheel:8232 ),
(note: 81;wheel:8252 ),(note: 81;wheel:8271 ),(note: 81;wheel:8291 ),(note: 81;wheel:8311 ),
(note: 81;wheel:8331 ),(note: 81;wheel:8350 ),(note: 82;wheel:8029 ),(note: 82;wheel:8048 ),
(note: 82;wheel:8068 ),(note: 82;wheel:8087 ),(note: 82;wheel:8106 ),(note: 82;wheel:8126 ),
(note: 82;wheel:8145 ),(note: 82;wheel:8164 ),(note: 82;wheel:8183 ),(note: 82;wheel:8202 ),
(note: 82;wheel:8221 ),(note: 82;wheel:8240 ),(note: 82;wheel:8259 ),(note: 82;wheel:8277 ),
(note: 82;wheel:8296 ),(note: 82;wheel:8315 ),(note: 82;wheel:8333 ),(note: 82;wheel:8352 ),
(note: 83;wheel:8029 ),(note: 83;wheel:8047 ),(note: 83;wheel:8066 ),(note: 83;wheel:8084 ),
(note: 83;wheel:8102 ),(note: 83;wheel:8121 ),(note: 83;wheel:8139 ),(note: 83;wheel:8157 ),
(note: 83;wheel:8175 ),(note: 83;wheel:8193 ),(note: 83;wheel:8211 ),(note: 83;wheel:8229 ),
(note: 83;wheel:8246 ),(note: 83;wheel:8264 ),(note: 83;wheel:8282 ),(note: 83;wheel:8299 ),
(note: 83;wheel:8317 ),(note: 83;wheel:8335 ),(note: 83;wheel:8352 ),(note: 84;wheel:8028 ),
(note: 84;wheel:8046 ),(note: 84;wheel:8063 ),(note: 84;wheel:8080 ),(note: 84;wheel:8097 ),
(note: 84;wheel:8115 ),(note: 84;wheel:8132 ),(note: 84;wheel:8149 ),(note: 84;wheel:8166 ),
(note: 84;wheel:8183 ),(note: 84;wheel:8200 ),(note: 84;wheel:8217 ),(note: 84;wheel:8234 ),
(note: 84;wheel:8250 ),(note: 84;wheel:8267 ),(note: 84;wheel:8284 ),(note: 84;wheel:8300 ),
(note: 84;wheel:8317 ),(note: 84;wheel:8334 ),(note: 84;wheel:8350 ),(note: 85;wheel:8025 ),
(note: 85;wheel:8042 ),(note: 85;wheel:8058 ),(note: 85;wheel:8074 ),(note: 85;wheel:8091 ),
(note: 85;wheel:8107 ),(note: 85;wheel:8123 ),(note: 85;wheel:8139 ),(note: 85;wheel:8155 ),
(note: 85;wheel:8171 ),(note: 85;wheel:8188 ),(note: 85;wheel:8203 ),(note: 85;wheel:8219 ),
(note: 85;wheel:8235 ),(note: 85;wheel:8251 ),(note: 85;wheel:8267 ),(note: 85;wheel:8283 ),
(note: 85;wheel:8298 ),(note: 85;wheel:8314 ),(note: 85;wheel:8330 ),(note: 85;wheel:8345 ),
(note: 85;wheel:8361 ),(note: 86;wheel:8035 ),(note: 86;wheel:8051 ),(note: 86;wheel:8066 ),
(note: 86;wheel:8081 ),(note: 86;wheel:8097 ),(note: 86;wheel:8112 ),(note: 86;wheel:8127 ),
(note: 86;wheel:8143 ),(note: 86;wheel:8158 ),(note: 86;wheel:8173 ),(note: 86;wheel:8188 ),
(note: 86;wheel:8203 ),(note: 86;wheel:8218 ),(note: 86;wheel:8233 ),(note: 86;wheel:8248 ),
(note: 86;wheel:8263 ),(note: 86;wheel:8278 ),(note: 86;wheel:8293 ),(note: 86;wheel:8308 ),
(note: 86;wheel:8322 ),(note: 86;wheel:8337 ),(note: 86;wheel:8352 ),(note: 87;wheel:8025 ),
(note: 87;wheel:8040 ),(note: 87;wheel:8054 ),(note: 87;wheel:8069 ),(note: 87;wheel:8084 ),
(note: 87;wheel:8098 ),(note: 87;wheel:8112 ),(note: 87;wheel:8127 ),(note: 87;wheel:8141 ),
(note: 87;wheel:8156 ),(note: 87;wheel:8170 ),(note: 87;wheel:8184 ),(note: 87;wheel:8198 ),
(note: 87;wheel:8213 ),(note: 87;wheel:8227 ),(note: 87;wheel:8241 ),(note: 87;wheel:8255 ),
(note: 87;wheel:8269 ),(note: 87;wheel:8283 ),(note: 87;wheel:8297 ),(note: 87;wheel:8311 ),
(note: 87;wheel:8325 ),(note: 87;wheel:8339 ),(note: 87;wheel:8353 ),(note: 88;wheel:8025 ),
(note: 88;wheel:8039 ),(note: 88;wheel:8053 ),(note: 88;wheel:8067 ),(note: 88;wheel:8081 ),
(note: 88;wheel:8094 ),(note: 88;wheel:8108 ),(note: 88;wheel:8121 ),(note: 88;wheel:8135 ),
(note: 88;wheel:8149 ),(note: 88;wheel:8162 ),(note: 88;wheel:8176 ),(note: 88;wheel:8189 ),
(note: 88;wheel:8203 ),(note: 88;wheel:8216 ),(note: 88;wheel:8229 ),(note: 88;wheel:8243 ),
(note: 88;wheel:8256 ),(note: 88;wheel:8269 ),(note: 88;wheel:8283 ),(note: 88;wheel:8296 ),
(note: 88;wheel:8309 ),(note: 88;wheel:8322 ),(note: 88;wheel:8335 ),(note: 88;wheel:8348 ),
(note: 88;wheel:8361 ),(note: 89;wheel:8033 ),(note: 89;wheel:8046 ),(note: 89;wheel:8059 ),
(note: 89;wheel:8072 ),(note: 89;wheel:8085 ),(note: 89;wheel:8098 ),(note: 89;wheel:8111 ),
(note: 89;wheel:8124 ),(note: 89;wheel:8137 ),(note: 89;wheel:8149 ),(note: 89;wheel:8162 ),
(note: 89;wheel:8175 ),(note: 89;wheel:8188 ),(note: 89;wheel:8200 ),(note: 89;wheel:8213 ),
(note: 89;wheel:8226 ),(note: 89;wheel:8238 ),(note: 89;wheel:8251 ),(note: 89;wheel:8263 ),
(note: 89;wheel:8276 ),(note: 89;wheel:8288 ),(note: 89;wheel:8301 ),(note: 89;wheel:8313 ),
(note: 89;wheel:8326 ),(note: 89;wheel:8338 ),(note: 89;wheel:8350 ),(note: 90;wheel:8021 ),
(note: 90;wheel:8034 ),(note: 90;wheel:8046 ),(note: 90;wheel:8058 ),(note: 90;wheel:8070 ),
(note: 90;wheel:8083 ),(note: 90;wheel:8095 ),(note: 90;wheel:8107 ),(note: 90;wheel:8119 ),
(note: 90;wheel:8131 ),(note: 90;wheel:8143 ),(note: 90;wheel:8155 ),(note: 90;wheel:8167 ),
(note: 90;wheel:8179 ),(note: 90;wheel:8191 ),(note: 90;wheel:8203 ),(note: 90;wheel:8215 ),
(note: 90;wheel:8227 ),(note: 90;wheel:8239 ),(note: 90;wheel:8251 ),(note: 90;wheel:8263 ),
(note: 90;wheel:8275 ),(note: 90;wheel:8287 ),(note: 90;wheel:8298 ),(note: 90;wheel:8310 ),
(note: 90;wheel:8322 ),(note: 90;wheel:8334 ),(note: 90;wheel:8345 ),(note: 90;wheel:8357 ),
(note: 91;wheel:8027 ),(note: 91;wheel:8039 ),(note: 91;wheel:8050 ),(note: 91;wheel:8062 ),
(note: 91;wheel:8073 ),(note: 91;wheel:8085 ),(note: 91;wheel:8096 ),(note: 91;wheel:8108 ),
(note: 91;wheel:8119 ),(note: 91;wheel:8131 ),(note: 91;wheel:8142 ),(note: 91;wheel:8154 ),
(note: 91;wheel:8165 ),(note: 91;wheel:8176 ),(note: 91;wheel:8188 ),(note: 91;wheel:8199 ),
(note: 91;wheel:8210 ),(note: 91;wheel:8222 ),(note: 91;wheel:8233 ),(note: 91;wheel:8244 ),
(note: 91;wheel:8255 ),(note: 91;wheel:8266 ),(note: 91;wheel:8278 ),(note: 91;wheel:8289 ),
(note: 91;wheel:8300 ),(note: 91;wheel:8311 ),(note: 91;wheel:8322 ),(note: 91;wheel:8333 ),
(note: 91;wheel:8344 ),(note: 91;wheel:8355 ),(note: 92;wheel:8025 ),(note: 92;wheel:8036 ),
(note: 92;wheel:8047 ),(note: 92;wheel:8057 ),(note: 92;wheel:8068 ),(note: 92;wheel:8079 ),
(note: 92;wheel:8090 ),(note: 92;wheel:8101 ),(note: 92;wheel:8112 ),(note: 92;wheel:8123 ),
(note: 92;wheel:8133 ),(note: 92;wheel:8144 ),(note: 92;wheel:8155 ),(note: 92;wheel:8166 ),
(note: 92;wheel:8176 ),(note: 92;wheel:8187 ),(note: 92;wheel:8198 ),(note: 92;wheel:8208 ),
(note: 92;wheel:8219 ),(note: 92;wheel:8230 ),(note: 92;wheel:8240 ),(note: 92;wheel:8251 ),
(note: 92;wheel:8261 ),(note: 92;wheel:8272 ),(note: 92;wheel:8282 ),(note: 92;wheel:8293 ),
(note: 92;wheel:8303 ),(note: 92;wheel:8314 ),(note: 92;wheel:8324 ),(note: 92;wheel:8335 ),
(note: 92;wheel:8345 ),(note: 92;wheel:8356 ),(note: 93;wheel:8025 ),(note: 93;wheel:8035 ),
(note: 93;wheel:8045 ),(note: 93;wheel:8056 ),(note: 93;wheel:8066 ),(note: 93;wheel:8076 ),
(note: 93;wheel:8086 ),(note: 93;wheel:8097 ),(note: 93;wheel:8107 ),(note: 93;wheel:8117 ),
(note: 93;wheel:8127 ),(note: 93;wheel:8137 ),(note: 93;wheel:8148 ),(note: 93;wheel:8158 ),
(note: 93;wheel:8168 ),(note: 93;wheel:8178 ),(note: 93;wheel:8188 ),(note: 93;wheel:8198 ),
(note: 93;wheel:8208 ),(note: 93;wheel:8218 ),(note: 93;wheel:8228 ),(note: 93;wheel:8238 ),
(note: 93;wheel:8248 ),(note: 93;wheel:8258 ),(note: 93;wheel:8268 ),(note: 93;wheel:8278 ),
(note: 93;wheel:8288 ),(note: 93;wheel:8298 ),(note: 93;wheel:8308 ),(note: 93;wheel:8318 ),
(note: 93;wheel:8327 ),(note: 93;wheel:8337 ),(note: 93;wheel:8347 ),(note: 93;wheel:8357 ),
(note: 94;wheel:8025 ),(note: 94;wheel:8035 ),(note: 94;wheel:8045 ),(note: 94;wheel:8055 ),
(note: 94;wheel:8064 ),(note: 94;wheel:8074 ),(note: 94;wheel:8084 ),(note: 94;wheel:8093 ),
(note: 94;wheel:8103 ),(note: 94;wheel:8113 ),(note: 94;wheel:8122 ),(note: 94;wheel:8132 ),
(note: 94;wheel:8142 ),(note: 94;wheel:8151 ),(note: 94;wheel:8161 ),(note: 94;wheel:8170 ),
(note: 94;wheel:8180 ),(note: 94;wheel:8189 ),(note: 94;wheel:8199 ),(note: 94;wheel:8208 ),
(note: 94;wheel:8218 ),(note: 94;wheel:8227 ),(note: 94;wheel:8237 ),(note: 94;wheel:8246 ),
(note: 94;wheel:8256 ),(note: 94;wheel:8265 ),(note: 94;wheel:8274 ),(note: 94;wheel:8284 ),
(note: 94;wheel:8293 ),(note: 94;wheel:8302 ),(note: 94;wheel:8312 ),(note: 94;wheel:8321 ),
(note: 94;wheel:8330 ),(note: 94;wheel:8340 ),(note: 94;wheel:8349 ),(note: 94;wheel:8358 ),
(note: 95;wheel:8026 ),(note: 95;wheel:8035 ),(note: 95;wheel:8044 ),(note: 95;wheel:8054 ),
(note: 95;wheel:8063 ),(note: 95;wheel:8072 ),(note: 95;wheel:8081 ),(note: 95;wheel:8090 ),
(note: 95;wheel:8099 ),(note: 95;wheel:8108 ),(note: 95;wheel:8118 ),(note: 95;wheel:8127 ),
(note: 95;wheel:8136 ),(note: 95;wheel:8145 ),(note: 95;wheel:8154 ),(note: 95;wheel:8163 ),
(note: 95;wheel:8172 ),(note: 95;wheel:8181 ),(note: 95;wheel:8190 ),(note: 95;wheel:8199 ),
(note: 95;wheel:8208 ),(note: 95;wheel:8217 ),(note: 95;wheel:8226 ),(note: 95;wheel:8235 ),
(note: 95;wheel:8243 ),(note: 95;wheel:8252 ),(note: 95;wheel:8261 ),(note: 95;wheel:8270 ),
(note: 95;wheel:8279 ),(note: 95;wheel:8288 ),(note: 95;wheel:8297 ),(note: 95;wheel:8305 ),
(note: 95;wheel:8314 ),(note: 95;wheel:8323 ),(note: 95;wheel:8332 ),(note: 95;wheel:8340 ),
(note: 95;wheel:8349 ),(note: 95;wheel:8358 ),(note: 96;wheel:8025 ),(note: 96;wheel:8034 ),
(note: 96;wheel:8043 ),(note: 96;wheel:8051 ),(note: 96;wheel:8060 ),(note: 96;wheel:8069 ),
(note: 96;wheel:8077 ),(note: 96;wheel:8086 ),(note: 96;wheel:8095 ),(note: 96;wheel:8103 ),
(note: 96;wheel:8112 ),(note: 96;wheel:8120 ),(note: 96;wheel:8129 ),(note: 96;wheel:8137 ),
(note: 96;wheel:8146 ),(note: 96;wheel:8155 ),(note: 96;wheel:8163 ),(note: 96;wheel:8172 ),
(note: 96;wheel:8180 ),(note: 96;wheel:8189 ),(note: 96;wheel:8197 ),(note: 96;wheel:8205 ),
(note: 96;wheel:8214 ),(note: 96;wheel:8222 ),(note: 96;wheel:8231 ),(note: 96;wheel:8239 ),
(note: 96;wheel:8248 ),(note: 96;wheel:8256 ),(note: 96;wheel:8264 ),(note: 96;wheel:8273 ),
(note: 96;wheel:8281 ),(note: 96;wheel:8289 ),(note: 96;wheel:8298 ),(note: 96;wheel:8306 ),
(note: 96;wheel:8314 ),(note: 96;wheel:8323 ),(note: 96;wheel:8331 ),(note: 96;wheel:8339 ),
(note: 96;wheel:8347 ),(note: 96;wheel:8356 ),(note: 97;wheel:8023 ),(note: 97;wheel:8031 ),
(note: 97;wheel:8039 ),(note: 97;wheel:8047 ),(note: 97;wheel:8055 ),(note: 97;wheel:8064 ),
(note: 97;wheel:8072 ),(note: 97;wheel:8080 ),(note: 97;wheel:8088 ),(note: 97;wheel:8096 ),
(note: 97;wheel:8104 ),(note: 97;wheel:8112 ),(note: 97;wheel:8120 ),(note: 97;wheel:8129 ),
(note: 97;wheel:8137 ),(note: 97;wheel:8145 ),(note: 97;wheel:8153 ),(note: 97;wheel:8161 ),
(note: 97;wheel:8169 ),(note: 97;wheel:8177 ),(note: 97;wheel:8185 ),(note: 97;wheel:8193 ),
(note: 97;wheel:8201 ),(note: 97;wheel:8209 ),(note: 97;wheel:8217 ),(note: 97;wheel:8225 ),
(note: 97;wheel:8233 ),(note: 97;wheel:8241 ),(note: 97;wheel:8249 ),(note: 97;wheel:8256 ),
(note: 97;wheel:8264 ),(note: 97;wheel:8272 ),(note: 97;wheel:8280 ),(note: 97;wheel:8288 ),
(note: 97;wheel:8296 ),(note: 97;wheel:8304 ),(note: 97;wheel:8312 ),(note: 97;wheel:8319 ),
(note: 97;wheel:8327 ),(note: 97;wheel:8335 ),(note: 97;wheel:8343 ),(note: 97;wheel:8351 ),
(note: 97;wheel:8358 ),(note: 98;wheel:8025 ),(note: 98;wheel:8033 ),(note: 98;wheel:8040 ),
(note: 98;wheel:8048 ),(note: 98;wheel:8056 ),(note: 98;wheel:8063 ),(note: 98;wheel:8071 ),
(note: 98;wheel:8079 ),(note: 98;wheel:8087 ),(note: 98;wheel:8094 ),(note: 98;wheel:8102 ),
(note: 98;wheel:8110 ),(note: 98;wheel:8117 ),(note: 98;wheel:8125 ),(note: 98;wheel:8132 ),
(note: 98;wheel:8140 ),(note: 98;wheel:8148 ),(note: 98;wheel:8155 ),(note: 98;wheel:8163 ),
(note: 98;wheel:8170 ),(note: 98;wheel:8178 ),(note: 98;wheel:8186 ),(note: 98;wheel:8193 ),
(note: 98;wheel:8201 ),(note: 98;wheel:8208 ),(note: 98;wheel:8216 ),(note: 98;wheel:8223 ),
(note: 98;wheel:8231 ),(note: 98;wheel:8238 ),(note: 98;wheel:8246 ),(note: 98;wheel:8253 ),
(note: 98;wheel:8261 ),(note: 98;wheel:8268 ),(note: 98;wheel:8276 ),(note: 98;wheel:8283 ),
(note: 98;wheel:8290 ),(note: 98;wheel:8298 ),(note: 98;wheel:8305 ),(note: 98;wheel:8313 ),
(note: 98;wheel:8320 ),(note: 98;wheel:8327 ),(note: 98;wheel:8335 ),(note: 98;wheel:8342 ),
(note: 98;wheel:8349 ),(note: 98;wheel:8357 ),(note: 99;wheel:8023 ),(note: 99;wheel:8030 ),
(note: 99;wheel:8037 ),(note: 99;wheel:8045 ),(note: 99;wheel:8052 ),(note: 99;wheel:8059 ),
(note: 99;wheel:8067 ),(note: 99;wheel:8074 ),(note: 99;wheel:8081 ),(note: 99;wheel:8088 ),
(note: 99;wheel:8096 ),(note: 99;wheel:8103 ),(note: 99;wheel:8110 ),(note: 99;wheel:8117 ),
(note: 99;wheel:8125 ),(note: 99;wheel:8132 ),(note: 99;wheel:8139 ),(note: 99;wheel:8146 ),
(note: 99;wheel:8153 ),(note: 99;wheel:8160 ),(note: 99;wheel:8168 ),(note: 99;wheel:8175 ),
(note: 99;wheel:8182 ),(note: 99;wheel:8189 ),(note: 99;wheel:8196 ),(note: 99;wheel:8203 ),
(note: 99;wheel:8210 ),(note: 99;wheel:8217 ),(note: 99;wheel:8225 ),(note: 99;wheel:8232 ),
(note: 99;wheel:8239 ),(note: 99;wheel:8246 ),(note: 99;wheel:8253 ),(note: 99;wheel:8260 ),
(note: 99;wheel:8267 ),(note: 99;wheel:8274 ),(note: 99;wheel:8281 ),(note: 99;wheel:8288 ),
(note: 99;wheel:8295 ),(note: 99;wheel:8302 ),(note: 99;wheel:8309 ),(note: 99;wheel:8316 ),
(note: 99;wheel:8323 ),(note: 99;wheel:8330 ),(note: 99;wheel:8337 ),(note: 99;wheel:8344 ),
(note: 99;wheel:8351 ),(note: 99;wheel:8358 ),(note:100;wheel:8023 ),(note:100;wheel:8030 ),
(note:100;wheel:8037 ),(note:100;wheel:8044 ),(note:100;wheel:8051 ),(note:100;wheel:8058 ),
(note:100;wheel:8065 ),(note:100;wheel:8071 ),(note:100;wheel:8078 ),(note:100;wheel:8085 ),
(note:100;wheel:8092 ),(note:100;wheel:8099 ),(note:100;wheel:8106 ),(note:100;wheel:8112 ),
(note:100;wheel:8119 ),(note:100;wheel:8126 ),(note:100;wheel:8133 ),(note:100;wheel:8140 ),
(note:100;wheel:8146 ),(note:100;wheel:8153 ),(note:100;wheel:8160 ),(note:100;wheel:8167 ),
(note:100;wheel:8173 ),(note:100;wheel:8180 ),(note:100;wheel:8187 ),(note:100;wheel:8194 ),
(note:100;wheel:8200 ),(note:100;wheel:8207 ),(note:100;wheel:8214 ),(note:100;wheel:8220 ),
(note:100;wheel:8227 ),(note:100;wheel:8234 ),(note:100;wheel:8240 ),(note:100;wheel:8247 ),
(note:100;wheel:8254 ),(note:100;wheel:8260 ),(note:100;wheel:8267 ),(note:100;wheel:8274 ),
(note:100;wheel:8280 ),(note:100;wheel:8287 ),(note:100;wheel:8294 ),(note:100;wheel:8300 ),
(note:100;wheel:8307 ),(note:100;wheel:8313 ),(note:100;wheel:8320 ),(note:100;wheel:8326 ),
(note:100;wheel:8333 ),(note:100;wheel:8340 ),(note:100;wheel:8346 ),(note:100;wheel:8353 ),
(note:100;wheel:8359 ),(note:101;wheel:8024 ),(note:101;wheel:8031 ),(note:101;wheel:8037 ),
(note:101;wheel:8044 ),(note:101;wheel:8051 ),(note:101;wheel:8057 ),(note:101;wheel:8063 ),
(note:101;wheel:8070 ),(note:101;wheel:8076 ),(note:101;wheel:8083 ),(note:101;wheel:8089 ),
(note:101;wheel:8096 ),(note:101;wheel:8102 ),(note:101;wheel:8109 ),(note:101;wheel:8115 ),
(note:101;wheel:8122 ),(note:101;wheel:8128 ),(note:101;wheel:8134 ),(note:101;wheel:8141 ),
(note:101;wheel:8147 ),(note:101;wheel:8154 ),(note:101;wheel:8160 ),(note:101;wheel:8166 ),
(note:101;wheel:8173 ),(note:101;wheel:8179 ),(note:101;wheel:8185 ),(note:101;wheel:8192 ),
(note:101;wheel:8198 ),(note:101;wheel:8204 ),(note:101;wheel:8211 ),(note:101;wheel:8217 ),
(note:101;wheel:8223 ),(note:101;wheel:8230 ),(note:101;wheel:8236 ),(note:101;wheel:8242 ),
(note:101;wheel:8249 ),(note:101;wheel:8255 ),(note:101;wheel:8261 ),(note:101;wheel:8267 ),
(note:101;wheel:8274 ),(note:101;wheel:8280 ),(note:101;wheel:8286 ),(note:101;wheel:8292 ),
(note:101;wheel:8299 ),(note:101;wheel:8305 ),(note:101;wheel:8311 ),(note:101;wheel:8317 ),
(note:101;wheel:8324 ),(note:101;wheel:8330 ),(note:101;wheel:8336 ),(note:101;wheel:8342 ),
(note:101;wheel:8348 ),(note:101;wheel:8354 ),(note:101;wheel:8361 ),(note:102;wheel:8025 ),
(note:102;wheel:8032 ),(note:102;wheel:8038 ),(note:102;wheel:8044 ),(note:102;wheel:8050 ),
(note:102;wheel:8056 ),(note:102;wheel:8062 ),(note:102;wheel:8068 ),(note:102;wheel:8075 ),
(note:102;wheel:8081 ),(note:102;wheel:8087 ),(note:102;wheel:8093 ),(note:102;wheel:8099 ),
(note:102;wheel:8105 ),(note:102;wheel:8111 ),(note:102;wheel:8117 ),(note:102;wheel:8123 ),
(note:102;wheel:8129 ),(note:102;wheel:8135 ),(note:102;wheel:8141 ),(note:102;wheel:8147 ),
(note:102;wheel:8153 ),(note:102;wheel:8159 ),(note:102;wheel:8165 ),(note:102;wheel:8171 ),
(note:102;wheel:8177 ),(note:102;wheel:8183 ),(note:102;wheel:8189 ),(note:102;wheel:8195 ),
(note:102;wheel:8201 ),(note:102;wheel:8207 ),(note:102;wheel:8213 ),(note:102;wheel:8219 ),
(note:102;wheel:8225 ),(note:102;wheel:8231 ),(note:102;wheel:8237 ),(note:102;wheel:8243 ),
(note:102;wheel:8249 ),(note:102;wheel:8255 ),(note:102;wheel:8261 ),(note:102;wheel:8267 ),
(note:102;wheel:8273 ),(note:102;wheel:8279 ),(note:102;wheel:8285 ),(note:102;wheel:8290 ),
(note:102;wheel:8296 ),(note:102;wheel:8302 ),(note:102;wheel:8308 ),(note:102;wheel:8314 ),
(note:102;wheel:8320 ),(note:102;wheel:8326 ),(note:102;wheel:8332 ),(note:102;wheel:8337 ),
(note:102;wheel:8343 ),(note:102;wheel:8349 ),(note:102;wheel:8355 ),(note:102;wheel:8361 ),
(note:103;wheel:8025 ),(note:103;wheel:8031 ),(note:103;wheel:8037 ),(note:103;wheel:8043 ),
(note:103;wheel:8048 ),(note:103;wheel:8054 ),(note:103;wheel:8060 ),(note:103;wheel:8066 ),
(note:103;wheel:8072 ),(note:103;wheel:8077 ),(note:103;wheel:8083 ),(note:103;wheel:8089 ),
(note:103;wheel:8095 ),(note:103;wheel:8100 ),(note:103;wheel:8106 ),(note:103;wheel:8112 ),
(note:103;wheel:8118 ),(note:103;wheel:8123 ),(note:103;wheel:8129 ),(note:103;wheel:8135 ),
(note:103;wheel:8140 ),(note:103;wheel:8146 ),(note:103;wheel:8152 ),(note:103;wheel:8157 ),
(note:103;wheel:8163 ),(note:103;wheel:8169 ),(note:103;wheel:8174 ),(note:103;wheel:8180 ),
(note:103;wheel:8186 ),(note:103;wheel:8191 ),(note:103;wheel:8197 ),(note:103;wheel:8203 ),
(note:103;wheel:8208 ),(note:103;wheel:8214 ),(note:103;wheel:8220 ),(note:103;wheel:8225 ),
(note:103;wheel:8231 ),(note:103;wheel:8237 ),(note:103;wheel:8242 ),(note:103;wheel:8248 ),
(note:103;wheel:8253 ),(note:103;wheel:8259 ),(note:103;wheel:8265 ),(note:103;wheel:8270 ),
(note:103;wheel:8276 ),(note:103;wheel:8281 ),(note:103;wheel:8287 ),(note:103;wheel:8292 ),
(note:103;wheel:8298 ),(note:103;wheel:8303 ),(note:103;wheel:8309 ),(note:103;wheel:8315 ),
(note:103;wheel:8320 ),(note:103;wheel:8326 ),(note:103;wheel:8331 ),(note:103;wheel:8337 ),
(note:103;wheel:8342 ),(note:103;wheel:8348 ),(note:103;wheel:8353 ),(note:103;wheel:8359 ),
(note:104;wheel:8023 ),(note:104;wheel:8028 ),(note:104;wheel:8034 ),(note:104;wheel:8039 ),
(note:104;wheel:8045 ),(note:104;wheel:8050 ),(note:104;wheel:8056 ),(note:104;wheel:8061 ),
(note:104;wheel:8067 ),(note:104;wheel:8072 ),(note:104;wheel:8077 ),(note:104;wheel:8083 ),
(note:104;wheel:8088 ),(note:104;wheel:8094 ),(note:104;wheel:8099 ),(note:104;wheel:8105 ),
(note:104;wheel:8110 ),(note:104;wheel:8115 ),(note:104;wheel:8121 ),(note:104;wheel:8126 ),
(note:104;wheel:8132 ),(note:104;wheel:8137 ),(note:104;wheel:8142 ),(note:104;wheel:8148 ),
(note:104;wheel:8153 ),(note:104;wheel:8159 ),(note:104;wheel:8164 ),(note:104;wheel:8169 ),
(note:104;wheel:8175 ),(note:104;wheel:8180 ),(note:104;wheel:8185 ),(note:104;wheel:8191 ),
(note:104;wheel:8196 ),(note:104;wheel:8201 ),(note:104;wheel:8207 ),(note:104;wheel:8212 ),
(note:104;wheel:8217 ),(note:104;wheel:8223 ),(note:104;wheel:8228 ),(note:104;wheel:8233 ),
(note:104;wheel:8238 ),(note:104;wheel:8244 ),(note:104;wheel:8249 ),(note:104;wheel:8254 ),
(note:104;wheel:8260 ),(note:104;wheel:8265 ),(note:104;wheel:8270 ),(note:104;wheel:8275 ),
(note:104;wheel:8281 ),(note:104;wheel:8286 ),(note:104;wheel:8291 ),(note:104;wheel:8296 ),
(note:104;wheel:8302 ),(note:104;wheel:8307 ),(note:104;wheel:8312 ),(note:104;wheel:8317 ),
(note:104;wheel:8323 ),(note:104;wheel:8328 ),(note:104;wheel:8333 ),(note:104;wheel:8338 ),
(note:104;wheel:8343 ),(note:104;wheel:8349 ),(note:104;wheel:8354 ),(note:104;wheel:8359 ),
(note:105;wheel:8023 ),(note:105;wheel:8028 ),(note:105;wheel:8033 ),(note:105;wheel:8038 ),
(note:105;wheel:8044 ),(note:105;wheel:8049 ),(note:105;wheel:8054 ),(note:105;wheel:8059 ),
(note:105;wheel:8064 ),(note:105;wheel:8069 ),(note:105;wheel:8074 ),(note:105;wheel:8080 ),
(note:105;wheel:8085 ),(note:105;wheel:8090 ),(note:105;wheel:8095 ),(note:105;wheel:8100 ),
(note:105;wheel:8105 ),(note:105;wheel:8110 ),(note:105;wheel:8115 ),(note:105;wheel:8120 ),
(note:105;wheel:8126 ),(note:105;wheel:8131 ),(note:105;wheel:8136 ),(note:105;wheel:8141 ),
(note:105;wheel:8146 ),(note:105;wheel:8151 ),(note:105;wheel:8156 ),(note:105;wheel:8161 ),
(note:105;wheel:8166 ),(note:105;wheel:8171 ),(note:105;wheel:8176 ),(note:105;wheel:8181 ),
(note:105;wheel:8186 ),(note:105;wheel:8191 ),(note:105;wheel:8196 ),(note:105;wheel:8201 ),
(note:105;wheel:8206 ),(note:105;wheel:8212 ),(note:105;wheel:8217 ),(note:105;wheel:8222 ),
(note:105;wheel:8227 ),(note:105;wheel:8232 ),(note:105;wheel:8237 ),(note:105;wheel:8242 ),
(note:105;wheel:8247 ),(note:105;wheel:8252 ),(note:105;wheel:8257 ),(note:105;wheel:8261 ),
(note:105;wheel:8266 ),(note:105;wheel:8271 ),(note:105;wheel:8276 ),(note:105;wheel:8281 ),
(note:105;wheel:8286 ),(note:105;wheel:8291 ),(note:105;wheel:8296 ),(note:105;wheel:8301 ),
(note:105;wheel:8306 ),(note:105;wheel:8311 ),(note:105;wheel:8316 ),(note:105;wheel:8321 ),
(note:105;wheel:8326 ),(note:105;wheel:8331 ),(note:105;wheel:8336 ),(note:105;wheel:8341 ),
(note:105;wheel:8345 ),(note:105;wheel:8350 ),(note:105;wheel:8355 ),(note:105;wheel:8360 ),
(note:106;wheel:8024 ),(note:106;wheel:8029 ),(note:106;wheel:8034 ),(note:106;wheel:8038 ),
(note:106;wheel:8043 ),(note:106;wheel:8048 ),(note:106;wheel:8053 ),(note:106;wheel:8058 ),
(note:106;wheel:8063 ),(note:106;wheel:8068 ),(note:106;wheel:8072 ),(note:106;wheel:8077 ),
(note:106;wheel:8082 ),(note:106;wheel:8087 ),(note:106;wheel:8092 ),(note:106;wheel:8097 ),
(note:106;wheel:8101 ),(note:106;wheel:8106 ),(note:106;wheel:8111 ),(note:106;wheel:8116 ),
(note:106;wheel:8121 ),(note:106;wheel:8126 ),(note:106;wheel:8130 ),(note:106;wheel:8135 ),
(note:106;wheel:8140 ),(note:106;wheel:8145 ),(note:106;wheel:8150 ),(note:106;wheel:8154 ),
(note:106;wheel:8159 ),(note:106;wheel:8164 ),(note:106;wheel:8169 ),(note:106;wheel:8173 ),
(note:106;wheel:8178 ),(note:106;wheel:8183 ),(note:106;wheel:8188 ),(note:106;wheel:8192 ),
(note:106;wheel:8197 ),(note:106;wheel:8202 ),(note:106;wheel:8207 ),(note:106;wheel:8211 ),
(note:106;wheel:8216 ),(note:106;wheel:8221 ),(note:106;wheel:8226 ),(note:106;wheel:8230 ),
(note:106;wheel:8235 ),(note:106;wheel:8240 ),(note:106;wheel:8245 ),(note:106;wheel:8249 ),
(note:106;wheel:8254 ),(note:106;wheel:8259 ),(note:106;wheel:8263 ),(note:106;wheel:8268 ),
(note:106;wheel:8273 ),(note:106;wheel:8277 ),(note:106;wheel:8282 ),(note:106;wheel:8287 ),
(note:106;wheel:8291 ),(note:106;wheel:8296 ),(note:106;wheel:8301 ),(note:106;wheel:8305 ),
(note:106;wheel:8310 ),(note:106;wheel:8315 ),(note:106;wheel:8319 ),(note:106;wheel:8324 ),
(note:106;wheel:8329 ),(note:106;wheel:8333 ),(note:106;wheel:8338 ),(note:106;wheel:8343 ),
(note:106;wheel:8347 ),(note:106;wheel:8352 ),(note:106;wheel:8357 ),(note:106;wheel:8361 ),
(note:107;wheel:8024 ),(note:107;wheel:8029 ),(note:107;wheel:8034 ),(note:107;wheel:8038 ),
(note:107;wheel:8043 ),(note:107;wheel:8047 ),(note:107;wheel:8052 ),(note:107;wheel:8057 ),
(note:107;wheel:8061 ),(note:107;wheel:8066 ),(note:107;wheel:8070 ),(note:107;wheel:8075 ),
(note:107;wheel:8080 ),(note:107;wheel:8084 ),(note:107;wheel:8089 ),(note:107;wheel:8093 ),
(note:107;wheel:8098 ),(note:107;wheel:8102 ),(note:107;wheel:8107 ),(note:107;wheel:8111 ),
(note:107;wheel:8116 ),(note:107;wheel:8121 ),(note:107;wheel:8125 ),(note:107;wheel:8130 ),
(note:107;wheel:8134 ),(note:107;wheel:8139 ),(note:107;wheel:8143 ),(note:107;wheel:8148 ),
(note:107;wheel:8152 ),(note:107;wheel:8157 ),(note:107;wheel:8161 ),(note:107;wheel:8166 ),
(note:107;wheel:8170 ),(note:107;wheel:8175 ),(note:107;wheel:8179 ),(note:107;wheel:8184 ),
(note:107;wheel:8188 ),(note:107;wheel:8193 ),(note:107;wheel:8197 ),(note:107;wheel:8202 ),
(note:107;wheel:8206 ),(note:107;wheel:8211 ),(note:107;wheel:8215 ),(note:107;wheel:8220 ),
(note:107;wheel:8224 ),(note:107;wheel:8229 ),(note:107;wheel:8233 ),(note:107;wheel:8237 ),
(note:107;wheel:8242 ),(note:107;wheel:8246 ),(note:107;wheel:8251 ),(note:107;wheel:8255 ),
(note:107;wheel:8260 ),(note:107;wheel:8264 ),(note:107;wheel:8269 ),(note:107;wheel:8273 ),
(note:107;wheel:8277 ),(note:107;wheel:8282 ),(note:107;wheel:8286 ),(note:107;wheel:8291 ),
(note:107;wheel:8295 ),(note:107;wheel:8299 ),(note:107;wheel:8304 ),(note:107;wheel:8308 ),
(note:107;wheel:8313 ),(note:107;wheel:8317 ),(note:107;wheel:8321 ),(note:107;wheel:8326 ),
(note:107;wheel:8330 ),(note:107;wheel:8335 ),(note:107;wheel:8339 ),(note:107;wheel:8343 ),
(note:107;wheel:8348 ),(note:107;wheel:8352 ),(note:107;wheel:8356 ),(note:107;wheel:8361 ),
(note:108;wheel:8024 ),(note:108;wheel:8028 ),(note:108;wheel:8033 ),(note:108;wheel:8037 ),
(note:108;wheel:8041 ),(note:108;wheel:8046 ),(note:108;wheel:8050 ),(note:108;wheel:8054 ),
(note:108;wheel:8059 ),(note:108;wheel:8063 ),(note:108;wheel:8067 ),(note:108;wheel:8072 ),
(note:108;wheel:8076 ),(note:108;wheel:8080 ),(note:108;wheel:8085 ),(note:108;wheel:8089 ),
(note:108;wheel:8093 ),(note:108;wheel:8097 ),(note:108;wheel:8102 ),(note:108;wheel:8106 ),
(note:108;wheel:8110 ),(note:108;wheel:8115 ),(note:108;wheel:8119 ),(note:108;wheel:8123 ),
(note:108;wheel:8128 ),(note:108;wheel:8132 ),(note:108;wheel:8136 ),(note:108;wheel:8140 ),
(note:108;wheel:8145 ),(note:108;wheel:8149 ),(note:108;wheel:8153 ),(note:108;wheel:8157 ),
(note:108;wheel:8162 ),(note:108;wheel:8166 ),(note:108;wheel:8170 ),(note:108;wheel:8174 ),
(note:108;wheel:8179 ),(note:108;wheel:8183 ),(note:108;wheel:8187 ),(note:108;wheel:8191 ),
(note:108;wheel:8196 ),(note:108;wheel:8200 ),(note:108;wheel:8204 ),(note:108;wheel:8208 ),
(note:108;wheel:8213 ),(note:108;wheel:8217 ),(note:108;wheel:8221 ),(note:108;wheel:8225 ),
(note:108;wheel:8229 ),(note:108;wheel:8234 ),(note:108;wheel:8238 ),(note:108;wheel:8242 ),
(note:108;wheel:8246 ),(note:108;wheel:8250 ),(note:108;wheel:8255 ),(note:108;wheel:8259 ),
(note:108;wheel:8263 ),(note:108;wheel:8267 ),(note:108;wheel:8271 ),(note:108;wheel:8275 ),
(note:108;wheel:8280 ),(note:108;wheel:8284 ),(note:108;wheel:8288 ),(note:108;wheel:8292 ),
(note:108;wheel:8296 ),(note:108;wheel:8300 ),(note:108;wheel:8305 ),(note:108;wheel:8309 ),
(note:108;wheel:8313 ),(note:108;wheel:8317 ),(note:108;wheel:8321 ),(note:108;wheel:8325 ),
(note:108;wheel:8330 ),(note:108;wheel:8334 ),(note:108;wheel:8338 ),(note:108;wheel:8342 ),
(note:108;wheel:8346 ),(note:108;wheel:8350 ),(note:108;wheel:8354 ),(note:108;wheel:8358 ),
(note:109;wheel:8021 ),(note:109;wheel:8025 ),(note:109;wheel:8029 ),(note:109;wheel:8034 ),
(note:109;wheel:8038 ),(note:109;wheel:8042 ),(note:109;wheel:8046 ),(note:109;wheel:8050 ),
(note:109;wheel:8054 ),(note:109;wheel:8058 ),(note:109;wheel:8062 ),(note:109;wheel:8066 ),
(note:109;wheel:8070 ),(note:109;wheel:8074 ),(note:109;wheel:8079 ),(note:109;wheel:8083 ),
(note:109;wheel:8087 ),(note:109;wheel:8091 ),(note:109;wheel:8095 ),(note:109;wheel:8099 ),
(note:109;wheel:8103 ),(note:109;wheel:8107 ),(note:109;wheel:8111 ),(note:109;wheel:8115 ),
(note:109;wheel:8119 ),(note:109;wheel:8123 ),(note:109;wheel:8127 ),(note:109;wheel:8131 ),
(note:109;wheel:8135 ),(note:109;wheel:8139 ),(note:109;wheel:8143 ),(note:109;wheel:8147 ),
(note:109;wheel:8151 ),(note:109;wheel:8155 ),(note:109;wheel:8159 ),(note:109;wheel:8163 ),
(note:109;wheel:8167 ),(note:109;wheel:8171 ),(note:109;wheel:8175 ),(note:109;wheel:8179 ),
(note:109;wheel:8184 ),(note:109;wheel:8188 ),(note:109;wheel:8192 ),(note:109;wheel:8195 ),
(note:109;wheel:8199 ),(note:109;wheel:8203 ),(note:109;wheel:8207 ),(note:109;wheel:8211 ),
(note:109;wheel:8215 ),(note:109;wheel:8219 ),(note:109;wheel:8223 ),(note:109;wheel:8227 ),
(note:109;wheel:8231 ),(note:109;wheel:8235 ),(note:109;wheel:8239 ),(note:109;wheel:8243 ),
(note:109;wheel:8247 ),(note:109;wheel:8251 ),(note:109;wheel:8255 ),(note:109;wheel:8259 ),
(note:109;wheel:8263 ),(note:109;wheel:8267 ),(note:109;wheel:8271 ),(note:109;wheel:8275 ),
(note:109;wheel:8279 ),(note:109;wheel:8283 ),(note:109;wheel:8287 ),(note:109;wheel:8291 ),
(note:109;wheel:8295 ),(note:109;wheel:8298 ),(note:109;wheel:8302 ),(note:109;wheel:8306 ),
(note:109;wheel:8310 ),(note:109;wheel:8314 ),(note:109;wheel:8318 ),(note:109;wheel:8322 ),
(note:109;wheel:8326 ),(note:109;wheel:8330 ),(note:109;wheel:8334 ),(note:109;wheel:8338 ),
(note:109;wheel:8341 ),(note:109;wheel:8345 ),(note:109;wheel:8349 ),(note:109;wheel:8353 ),
(note:109;wheel:8357 ),(note:109;wheel:8361 ),(note:110;wheel:8023 ),(note:110;wheel:8027 ),
(note:110;wheel:8031 ),(note:110;wheel:8035 ),(note:110;wheel:8039 ),(note:110;wheel:8043 ),
(note:110;wheel:8047 ),(note:110;wheel:8051 ),(note:110;wheel:8054 ),(note:110;wheel:8058 ),
(note:110;wheel:8062 ),(note:110;wheel:8066 ),(note:110;wheel:8070 ),(note:110;wheel:8074 ),
(note:110;wheel:8078 ),(note:110;wheel:8081 ),(note:110;wheel:8085 ),(note:110;wheel:8089 ),
(note:110;wheel:8093 ),(note:110;wheel:8097 ),(note:110;wheel:8101 ),(note:110;wheel:8104 ),
(note:110;wheel:8108 ),(note:110;wheel:8112 ),(note:110;wheel:8116 ),(note:110;wheel:8120 ),
(note:110;wheel:8124 ),(note:110;wheel:8127 ),(note:110;wheel:8131 ),(note:110;wheel:8135 ),
(note:110;wheel:8139 ),(note:110;wheel:8143 ),(note:110;wheel:8146 ),(note:110;wheel:8150 ),
(note:110;wheel:8154 ),(note:110;wheel:8158 ),(note:110;wheel:8162 ),(note:110;wheel:8165 ),
(note:110;wheel:8169 ),(note:110;wheel:8173 ),(note:110;wheel:8177 ),(note:110;wheel:8181 ),
(note:110;wheel:8184 ),(note:110;wheel:8188 ),(note:110;wheel:8192 ),(note:110;wheel:8196 ),
(note:110;wheel:8199 ),(note:110;wheel:8203 ),(note:110;wheel:8207 ),(note:110;wheel:8211 ),
(note:110;wheel:8214 ),(note:110;wheel:8218 ),(note:110;wheel:8222 ),(note:110;wheel:8226 ),
(note:110;wheel:8229 ),(note:110;wheel:8233 ),(note:110;wheel:8237 ),(note:110;wheel:8241 ),
(note:110;wheel:8244 ),(note:110;wheel:8248 ),(note:110;wheel:8252 ),(note:110;wheel:8256 ),
(note:110;wheel:8259 ),(note:110;wheel:8263 ),(note:110;wheel:8267 ),(note:110;wheel:8271 ),
(note:110;wheel:8274 ),(note:110;wheel:8278 ),(note:110;wheel:8282 ),(note:110;wheel:8285 ),
(note:110;wheel:8289 ),(note:110;wheel:8293 ),(note:110;wheel:8297 ),(note:110;wheel:8300 ),
(note:110;wheel:8304 ),(note:110;wheel:8308 ),(note:110;wheel:8311 ),(note:110;wheel:8315 ),
(note:110;wheel:8319 ),(note:110;wheel:8322 ),(note:110;wheel:8326 ),(note:110;wheel:8330 ),
(note:110;wheel:8334 ),(note:110;wheel:8337 ),(note:110;wheel:8341 ),(note:110;wheel:8345 ),
(note:110;wheel:8348 ),(note:110;wheel:8352 ),(note:110;wheel:8356 ),(note:110;wheel:8359 ),
(note:111;wheel:8022 ),(note:111;wheel:8025 ),(note:111;wheel:8029 ),(note:111;wheel:8033 ),
(note:111;wheel:8036 ),(note:111;wheel:8040 ),(note:111;wheel:8044 ),(note:111;wheel:8047 ),
(note:111;wheel:8051 ),(note:111;wheel:8054 ),(note:111;wheel:8058 ),(note:111;wheel:8062 ),
(note:111;wheel:8065 ),(note:111;wheel:8069 ),(note:111;wheel:8073 ),(note:111;wheel:8076 ),
(note:111;wheel:8080 ),(note:111;wheel:8084 ),(note:111;wheel:8087 ),(note:111;wheel:8091 ),
(note:111;wheel:8094 ),(note:111;wheel:8098 ),(note:111;wheel:8102 ),(note:111;wheel:8105 ),
(note:111;wheel:8109 ),(note:111;wheel:8112 ),(note:111;wheel:8116 ),(note:111;wheel:8120 ),
(note:111;wheel:8123 ),(note:111;wheel:8127 ),(note:111;wheel:8131 ),(note:111;wheel:8134 ),
(note:111;wheel:8138 ),(note:111;wheel:8141 ),(note:111;wheel:8145 ),(note:111;wheel:8148 ),
(note:111;wheel:8152 ),(note:111;wheel:8156 ),(note:111;wheel:8159 ),(note:111;wheel:8163 ),
(note:111;wheel:8166 ),(note:111;wheel:8170 ),(note:111;wheel:8174 ),(note:111;wheel:8177 ),
(note:111;wheel:8181 ),(note:111;wheel:8184 ),(note:111;wheel:8188 ),(note:111;wheel:8191 ),
(note:111;wheel:8195 ),(note:111;wheel:8198 ),(note:111;wheel:8202 ),(note:111;wheel:8206 ),
(note:111;wheel:8209 ),(note:111;wheel:8213 ),(note:111;wheel:8216 ),(note:111;wheel:8220 ),
(note:111;wheel:8223 ),(note:111;wheel:8227 ),(note:111;wheel:8230 ),(note:111;wheel:8234 ),
(note:111;wheel:8237 ),(note:111;wheel:8241 ),(note:111;wheel:8245 ),(note:111;wheel:8248 ),
(note:111;wheel:8252 ),(note:111;wheel:8255 ),(note:111;wheel:8259 ),(note:111;wheel:8262 ),
(note:111;wheel:8266 ),(note:111;wheel:8269 ),(note:111;wheel:8273 ),(note:111;wheel:8276 ),
(note:111;wheel:8280 ),(note:111;wheel:8283 ),(note:111;wheel:8287 ),(note:111;wheel:8290 ),
(note:111;wheel:8294 ),(note:111;wheel:8297 ),(note:111;wheel:8301 ),(note:111;wheel:8304 ),
(note:111;wheel:8308 ),(note:111;wheel:8311 ),(note:111;wheel:8315 ),(note:111;wheel:8318 ),
(note:111;wheel:8322 ),(note:111;wheel:8325 ),(note:111;wheel:8329 ),(note:111;wheel:8332 ),
(note:111;wheel:8336 ),(note:111;wheel:8339 ),(note:111;wheel:8343 ),(note:111;wheel:8346 ),
(note:111;wheel:8349 ),(note:111;wheel:8353 ),(note:111;wheel:8356 ),(note:111;wheel:8360 ),
(note:112;wheel:8022 ),(note:112;wheel:8025 ),(note:112;wheel:8029 ),(note:112;wheel:8032 ),
(note:112;wheel:8036 ),(note:112;wheel:8039 ),(note:112;wheel:8043 ),(note:112;wheel:8046 ),
(note:112;wheel:8050 ),(note:112;wheel:8053 ),(note:112;wheel:8056 ),(note:112;wheel:8060 ),
(note:112;wheel:8063 ),(note:112;wheel:8067 ),(note:112;wheel:8070 ),(note:112;wheel:8074 ),
(note:112;wheel:8077 ),(note:112;wheel:8081 ),(note:112;wheel:8084 ),(note:112;wheel:8087 ),
(note:112;wheel:8091 ),(note:112;wheel:8094 ),(note:112;wheel:8098 ),(note:112;wheel:8101 ),
(note:112;wheel:8104 ),(note:112;wheel:8108 ),(note:112;wheel:8111 ),(note:112;wheel:8115 ),
(note:112;wheel:8118 ),(note:112;wheel:8121 ),(note:112;wheel:8125 ),(note:112;wheel:8128 ),
(note:112;wheel:8132 ),(note:112;wheel:8135 ),(note:112;wheel:8138 ),(note:112;wheel:8142 ),
(note:112;wheel:8145 ),(note:112;wheel:8149 ),(note:112;wheel:8152 ),(note:112;wheel:8155 ),
(note:112;wheel:8159 ),(note:112;wheel:8162 ),(note:112;wheel:8166 ),(note:112;wheel:8169 ),
(note:112;wheel:8172 ),(note:112;wheel:8176 ),(note:112;wheel:8179 ),(note:112;wheel:8182 ),
(note:112;wheel:8186 ),(note:112;wheel:8189 ),(note:112;wheel:8192 ),(note:112;wheel:8196 ),
(note:112;wheel:8199 ),(note:112;wheel:8203 ),(note:112;wheel:8206 ),(note:112;wheel:8209 ),
(note:112;wheel:8213 ),(note:112;wheel:8216 ),(note:112;wheel:8219 ),(note:112;wheel:8223 ),
(note:112;wheel:8226 ),(note:112;wheel:8229 ),(note:112;wheel:8233 ),(note:112;wheel:8236 ),
(note:112;wheel:8239 ),(note:112;wheel:8243 ),(note:112;wheel:8246 ),(note:112;wheel:8249 ),
(note:112;wheel:8253 ),(note:112;wheel:8256 ),(note:112;wheel:8259 ),(note:112;wheel:8263 ),
(note:112;wheel:8266 ),(note:112;wheel:8269 ),(note:112;wheel:8273 ),(note:112;wheel:8276 ),
(note:112;wheel:8279 ),(note:112;wheel:8283 ),(note:112;wheel:8286 ),(note:112;wheel:8289 ),
(note:112;wheel:8292 ),(note:112;wheel:8296 ),(note:112;wheel:8299 ),(note:112;wheel:8302 ),
(note:112;wheel:8306 ),(note:112;wheel:8309 ),(note:112;wheel:8312 ),(note:112;wheel:8316 ),
(note:112;wheel:8319 ),(note:112;wheel:8322 ),(note:112;wheel:8325 ),(note:112;wheel:8329 ),
(note:112;wheel:8332 ),(note:112;wheel:8335 ),(note:112;wheel:8339 ),(note:112;wheel:8342 ),
(note:112;wheel:8345 ),(note:112;wheel:8348 ),(note:112;wheel:8352 ),(note:112;wheel:8355 ),
(note:112;wheel:8358 ),(note:112;wheel:8361 ),(note:113;wheel:8023 ),(note:113;wheel:8027 ),
(note:113;wheel:8030 ),(note:113;wheel:8033 ),(note:113;wheel:8036 ),(note:113;wheel:8040 ),
(note:113;wheel:8043 ),(note:113;wheel:8046 ),(note:113;wheel:8049 ),(note:113;wheel:8053 ),
(note:113;wheel:8056 ),(note:113;wheel:8059 ),(note:113;wheel:8062 ),(note:113;wheel:8066 ),
(note:113;wheel:8069 ),(note:113;wheel:8072 ),(note:113;wheel:8075 ),(note:113;wheel:8079 ),
(note:113;wheel:8082 ),(note:113;wheel:8085 ),(note:113;wheel:8088 ),(note:113;wheel:8092 ),
(note:113;wheel:8095 ),(note:113;wheel:8098 ),(note:113;wheel:8101 ),(note:113;wheel:8104 ),
(note:113;wheel:8108 ),(note:113;wheel:8111 ),(note:113;wheel:8114 ),(note:113;wheel:8117 ),
(note:113;wheel:8120 ),(note:113;wheel:8124 ),(note:113;wheel:8127 ),(note:113;wheel:8130 ),
(note:113;wheel:8133 ),(note:113;wheel:8137 ),(note:113;wheel:8140 ),(note:113;wheel:8143 ),
(note:113;wheel:8146 ),(note:113;wheel:8149 ),(note:113;wheel:8153 ),(note:113;wheel:8156 ),
(note:113;wheel:8159 ),(note:113;wheel:8162 ),(note:113;wheel:8165 ),(note:113;wheel:8168 ),
(note:113;wheel:8172 ),(note:113;wheel:8175 ),(note:113;wheel:8178 ),(note:113;wheel:8181 ),
(note:113;wheel:8184 ),(note:113;wheel:8188 ),(note:113;wheel:8191 ),(note:113;wheel:8194 ),
(note:113;wheel:8197 ),(note:113;wheel:8200 ),(note:113;wheel:8203 ),(note:113;wheel:8207 ),
(note:113;wheel:8210 ),(note:113;wheel:8213 ),(note:113;wheel:8216 ),(note:113;wheel:8219 ),
(note:113;wheel:8222 ),(note:113;wheel:8226 ),(note:113;wheel:8229 ),(note:113;wheel:8232 ),
(note:113;wheel:8235 ),(note:113;wheel:8238 ),(note:113;wheel:8241 ),(note:113;wheel:8244 ),
(note:113;wheel:8248 ),(note:113;wheel:8251 ),(note:113;wheel:8254 ),(note:113;wheel:8257 ),
(note:113;wheel:8260 ),(note:113;wheel:8263 ),(note:113;wheel:8266 ),(note:113;wheel:8270 ),
(note:113;wheel:8273 ),(note:113;wheel:8276 ),(note:113;wheel:8279 ),(note:113;wheel:8282 ),
(note:113;wheel:8285 ),(note:113;wheel:8288 ),(note:113;wheel:8291 ),(note:113;wheel:8295 ),
(note:113;wheel:8298 ),(note:113;wheel:8301 ),(note:113;wheel:8304 ),(note:113;wheel:8307 ),
(note:113;wheel:8310 ),(note:113;wheel:8313 ),(note:113;wheel:8316 ),(note:113;wheel:8319 ),
(note:113;wheel:8322 ),(note:113;wheel:8326 ),(note:113;wheel:8329 ),(note:113;wheel:8332 ),
(note:113;wheel:8335 ),(note:113;wheel:8338 ),(note:113;wheel:8341 ),(note:113;wheel:8344 ),
(note:113;wheel:8347 ),(note:113;wheel:8350 ),(note:113;wheel:8353 ),(note:113;wheel:8357 ),
(note:113;wheel:8360 ),(note:114;wheel:8021 ),(note:114;wheel:8024 ),(note:114;wheel:8028 ),
(note:114;wheel:8031 ),(note:114;wheel:8034 ),(note:114;wheel:8037 ),(note:114;wheel:8040 ),
(note:114;wheel:8043 ),(note:114;wheel:8046 ),(note:114;wheel:8049 ),(note:114;wheel:8052 ),
(note:114;wheel:8055 ),(note:114;wheel:8058 ),(note:114;wheel:8061 ),(note:114;wheel:8064 ),
(note:114;wheel:8067 ),(note:114;wheel:8070 ),(note:114;wheel:8074 ),(note:114;wheel:8077 ),
(note:114;wheel:8080 ),(note:114;wheel:8083 ),(note:114;wheel:8086 ),(note:114;wheel:8089 ),
(note:114;wheel:8092 ),(note:114;wheel:8095 ),(note:114;wheel:8098 ),(note:114;wheel:8101 ),
(note:114;wheel:8104 ),(note:114;wheel:8107 ),(note:114;wheel:8110 ),(note:114;wheel:8113 ),
(note:114;wheel:8116 ),(note:114;wheel:8119 ),(note:114;wheel:8122 ),(note:114;wheel:8125 ),
(note:114;wheel:8128 ),(note:114;wheel:8131 ),(note:114;wheel:8134 ),(note:114;wheel:8137 ),
(note:114;wheel:8140 ),(note:114;wheel:8143 ),(note:114;wheel:8146 ),(note:114;wheel:8149 ),
(note:114;wheel:8152 ),(note:114;wheel:8155 ),(note:114;wheel:8158 ),(note:114;wheel:8161 ),
(note:114;wheel:8164 ),(note:114;wheel:8167 ),(note:114;wheel:8170 ),(note:114;wheel:8173 ),
(note:114;wheel:8176 ),(note:114;wheel:8179 ),(note:114;wheel:8182 ),(note:114;wheel:8185 ),
(note:114;wheel:8188 ),(note:114;wheel:8191 ),(note:114;wheel:8194 ),(note:114;wheel:8197 ),
(note:114;wheel:8200 ),(note:114;wheel:8203 ),(note:114;wheel:8206 ),(note:114;wheel:8209 ),
(note:114;wheel:8212 ),(note:114;wheel:8215 ),(note:114;wheel:8218 ),(note:114;wheel:8221 ),
(note:114;wheel:8224 ),(note:114;wheel:8227 ),(note:114;wheel:8230 ),(note:114;wheel:8233 ),
(note:114;wheel:8236 ),(note:114;wheel:8239 ),(note:114;wheel:8242 ),(note:114;wheel:8245 ),
(note:114;wheel:8248 ),(note:114;wheel:8251 ),(note:114;wheel:8254 ),(note:114;wheel:8257 ),
(note:114;wheel:8260 ),(note:114;wheel:8263 ),(note:114;wheel:8266 ),(note:114;wheel:8269 ),
(note:114;wheel:8272 ),(note:114;wheel:8275 ),(note:114;wheel:8278 ),(note:114;wheel:8281 ),
(note:114;wheel:8284 ),(note:114;wheel:8287 ),(note:114;wheel:8289 ),(note:114;wheel:8292 ),
(note:114;wheel:8295 ),(note:114;wheel:8298 ),(note:114;wheel:8301 ),(note:114;wheel:8304 ),
(note:114;wheel:8307 ),(note:114;wheel:8310 ),(note:114;wheel:8313 ),(note:114;wheel:8316 ),
(note:114;wheel:8319 ),(note:114;wheel:8322 ),(note:114;wheel:8325 ),(note:114;wheel:8328 ),
(note:114;wheel:8331 ),(note:114;wheel:8334 ),(note:114;wheel:8336 ),(note:114;wheel:8339 ),
(note:114;wheel:8342 ),(note:114;wheel:8345 ),(note:114;wheel:8348 ),(note:114;wheel:8351 ),
(note:114;wheel:8354 ),(note:114;wheel:8357 ),(note:114;wheel:8360 ),(note:115;wheel:8021 ),
(note:115;wheel:8024 ),(note:115;wheel:8027 ),(note:115;wheel:8030 ),(note:115;wheel:8033 ),
(note:115;wheel:8036 ),(note:115;wheel:8039 ),(note:115;wheel:8042 ),(note:115;wheel:8045 ),
(note:115;wheel:8047 ),(note:115;wheel:8050 ),(note:115;wheel:8053 ),(note:115;wheel:8056 ),
(note:115;wheel:8059 ),(note:115;wheel:8062 ),(note:115;wheel:8065 ),(note:115;wheel:8068 ),
(note:115;wheel:8071 ),(note:115;wheel:8073 ),(note:115;wheel:8076 ),(note:115;wheel:8079 ),
(note:115;wheel:8082 ),(note:115;wheel:8085 ),(note:115;wheel:8088 ),(note:115;wheel:8091 ),
(note:115;wheel:8094 ),(note:115;wheel:8096 ),(note:115;wheel:8099 ),(note:115;wheel:8102 ),
(note:115;wheel:8105 ),(note:115;wheel:8108 ),(note:115;wheel:8111 ),(note:115;wheel:8114 ),
(note:115;wheel:8117 ),(note:115;wheel:8119 ),(note:115;wheel:8122 ),(note:115;wheel:8125 ),
(note:115;wheel:8128 ),(note:115;wheel:8131 ),(note:115;wheel:8134 ),(note:115;wheel:8137 ),
(note:115;wheel:8139 ),(note:115;wheel:8142 ),(note:115;wheel:8145 ),(note:115;wheel:8148 ),
(note:115;wheel:8151 ),(note:115;wheel:8154 ),(note:115;wheel:8157 ),(note:115;wheel:8159 ),
(note:115;wheel:8162 ),(note:115;wheel:8165 ),(note:115;wheel:8168 ),(note:115;wheel:8171 ),
(note:115;wheel:8174 ),(note:115;wheel:8176 ),(note:115;wheel:8179 ),(note:115;wheel:8182 ),
(note:115;wheel:8185 ),(note:115;wheel:8188 ),(note:115;wheel:8191 ),(note:115;wheel:8193 ),
(note:115;wheel:8196 ),(note:115;wheel:8199 ),(note:115;wheel:8202 ),(note:115;wheel:8205 ),
(note:115;wheel:8207 ),(note:115;wheel:8210 ),(note:115;wheel:8213 ),(note:115;wheel:8216 ),
(note:115;wheel:8219 ),(note:115;wheel:8222 ),(note:115;wheel:8224 ),(note:115;wheel:8227 ),
(note:115;wheel:8230 ),(note:115;wheel:8233 ),(note:115;wheel:8236 ),(note:115;wheel:8238 ),
(note:115;wheel:8241 ),(note:115;wheel:8244 ),(note:115;wheel:8247 ),(note:115;wheel:8250 ),
(note:115;wheel:8252 ),(note:115;wheel:8255 ),(note:115;wheel:8258 ),(note:115;wheel:8261 ),
(note:115;wheel:8264 ),(note:115;wheel:8266 ),(note:115;wheel:8269 ),(note:115;wheel:8272 ),
(note:115;wheel:8275 ),(note:115;wheel:8278 ),(note:115;wheel:8280 ),(note:115;wheel:8283 ),
(note:115;wheel:8286 ),(note:115;wheel:8289 ),(note:115;wheel:8291 ),(note:115;wheel:8294 ),
(note:115;wheel:8297 ),(note:115;wheel:8300 ),(note:115;wheel:8303 ),(note:115;wheel:8305 ),
(note:115;wheel:8308 ),(note:115;wheel:8311 ),(note:115;wheel:8314 ),(note:115;wheel:8316 ),
(note:115;wheel:8319 ),(note:115;wheel:8322 ),(note:115;wheel:8325 ),(note:115;wheel:8327 ),
(note:115;wheel:8330 ),(note:115;wheel:8333 ),(note:115;wheel:8336 ),(note:115;wheel:8338 ),
(note:115;wheel:8341 ),(note:115;wheel:8344 ),(note:115;wheel:8347 ),(note:115;wheel:8350 ),
(note:115;wheel:8352 ),(note:115;wheel:8355 ),(note:115;wheel:8358 ),(note:115;wheel:8361 ),
(note:116;wheel:8022 ),(note:116;wheel:8025 ),(note:116;wheel:8027 ),(note:116;wheel:8030 ),
(note:116;wheel:8033 ),(note:116;wheel:8036 ),(note:116;wheel:8038 ),(note:116;wheel:8041 ),
(note:116;wheel:8044 ),(note:116;wheel:8047 ),(note:116;wheel:8049 ),(note:116;wheel:8052 ),
(note:116;wheel:8055 ),(note:116;wheel:8057 ),(note:116;wheel:8060 ),(note:116;wheel:8063 ),
(note:116;wheel:8066 ),(note:116;wheel:8068 ),(note:116;wheel:8071 ),(note:116;wheel:8074 ),
(note:116;wheel:8077 ),(note:116;wheel:8079 ),(note:116;wheel:8082 ),(note:116;wheel:8085 ),
(note:116;wheel:8087 ),(note:116;wheel:8090 ),(note:116;wheel:8093 ),(note:116;wheel:8096 ),
(note:116;wheel:8098 ),(note:116;wheel:8101 ),(note:116;wheel:8104 ),(note:116;wheel:8106 ),
(note:116;wheel:8109 ),(note:116;wheel:8112 ),(note:116;wheel:8115 ),(note:116;wheel:8117 ),
(note:116;wheel:8120 ),(note:116;wheel:8123 ),(note:116;wheel:8125 ),(note:116;wheel:8128 ),
(note:116;wheel:8131 ),(note:116;wheel:8133 ),(note:116;wheel:8136 ),(note:116;wheel:8139 ),
(note:116;wheel:8142 ),(note:116;wheel:8144 ),(note:116;wheel:8147 ),(note:116;wheel:8150 ),
(note:116;wheel:8152 ),(note:116;wheel:8155 ),(note:116;wheel:8158 ),(note:116;wheel:8160 ),
(note:116;wheel:8163 ),(note:116;wheel:8166 ),(note:116;wheel:8168 ),(note:116;wheel:8171 ),
(note:116;wheel:8174 ),(note:116;wheel:8176 ),(note:116;wheel:8179 ),(note:116;wheel:8182 ),
(note:116;wheel:8184 ),(note:116;wheel:8187 ),(note:116;wheel:8190 ),(note:116;wheel:8192 ),
(note:116;wheel:8195 ),(note:116;wheel:8198 ),(note:116;wheel:8200 ),(note:116;wheel:8203 ),
(note:116;wheel:8206 ),(note:116;wheel:8208 ),(note:116;wheel:8211 ),(note:116;wheel:8214 ),
(note:116;wheel:8216 ),(note:116;wheel:8219 ),(note:116;wheel:8222 ),(note:116;wheel:8224 ),
(note:116;wheel:8227 ),(note:116;wheel:8230 ),(note:116;wheel:8232 ),(note:116;wheel:8235 ),
(note:116;wheel:8238 ),(note:116;wheel:8240 ),(note:116;wheel:8243 ),(note:116;wheel:8246 ),
(note:116;wheel:8248 ),(note:116;wheel:8251 ),(note:116;wheel:8253 ),(note:116;wheel:8256 ),
(note:116;wheel:8259 ),(note:116;wheel:8261 ),(note:116;wheel:8264 ),(note:116;wheel:8267 ),
(note:116;wheel:8269 ),(note:116;wheel:8272 ),(note:116;wheel:8275 ),(note:116;wheel:8277 ),
(note:116;wheel:8280 ),(note:116;wheel:8282 ),(note:116;wheel:8285 ),(note:116;wheel:8288 ),
(note:116;wheel:8290 ),(note:116;wheel:8293 ),(note:116;wheel:8296 ),(note:116;wheel:8298 ),
(note:116;wheel:8301 ),(note:116;wheel:8303 ),(note:116;wheel:8306 ),(note:116;wheel:8309 ),
(note:116;wheel:8311 ),(note:116;wheel:8314 ),(note:116;wheel:8316 ),(note:116;wheel:8319 ),
(note:116;wheel:8322 ),(note:116;wheel:8324 ),(note:116;wheel:8327 ),(note:116;wheel:8330 ),
(note:116;wheel:8332 ),(note:116;wheel:8335 ),(note:116;wheel:8337 ),(note:116;wheel:8340 ),
(note:116;wheel:8343 ),(note:116;wheel:8345 ),(note:116;wheel:8348 ),(note:116;wheel:8350 ),
(note:116;wheel:8353 ),(note:116;wheel:8356 ),(note:116;wheel:8358 ),(note:116;wheel:8361 ),
(note:117;wheel:8022 ),(note:117;wheel:8025 ),(note:117;wheel:8027 ),(note:117;wheel:8030 ),
(note:117;wheel:8032 ),(note:117;wheel:8035 ),(note:117;wheel:8037 ),(note:117;wheel:8040 ),
(note:117;wheel:8043 ),(note:117;wheel:8045 ),(note:117;wheel:8048 ),(note:117;wheel:8050 ),
(note:117;wheel:8053 ),(note:117;wheel:8056 ),(note:117;wheel:8058 ),(note:117;wheel:8061 ),
(note:117;wheel:8063 ),(note:117;wheel:8066 ),(note:117;wheel:8068 ),(note:117;wheel:8071 ),
(note:117;wheel:8074 ),(note:117;wheel:8076 ),(note:117;wheel:8079 ),(note:117;wheel:8081 ),
(note:117;wheel:8084 ),(note:117;wheel:8086 ),(note:117;wheel:8089 ),(note:117;wheel:8092 ),
(note:117;wheel:8094 ),(note:117;wheel:8097 ),(note:117;wheel:8099 ),(note:117;wheel:8102 ),
(note:117;wheel:8104 ),(note:117;wheel:8107 ),(note:117;wheel:8109 ),(note:117;wheel:8112 ),
(note:117;wheel:8115 ),(note:117;wheel:8117 ),(note:117;wheel:8120 ),(note:117;wheel:8122 ),
(note:117;wheel:8125 ),(note:117;wheel:8127 ),(note:117;wheel:8130 ),(note:117;wheel:8132 ),
(note:117;wheel:8135 ),(note:117;wheel:8137 ),(note:117;wheel:8140 ),(note:117;wheel:8143 ),
(note:117;wheel:8145 ),(note:117;wheel:8148 ),(note:117;wheel:8150 ),(note:117;wheel:8153 ),
(note:117;wheel:8155 ),(note:117;wheel:8158 ),(note:117;wheel:8160 ),(note:117;wheel:8163 ),
(note:117;wheel:8165 ),(note:117;wheel:8168 ),(note:117;wheel:8170 ),(note:117;wheel:8173 ),
(note:117;wheel:8175 ),(note:117;wheel:8178 ),(note:117;wheel:8180 ),(note:117;wheel:8183 ),
(note:117;wheel:8186 ),(note:117;wheel:8188 ),(note:117;wheel:8191 ),(note:117;wheel:8193 ),
(note:117;wheel:8196 ),(note:117;wheel:8198 ),(note:117;wheel:8201 ),(note:117;wheel:8203 ),
(note:117;wheel:8206 ),(note:117;wheel:8208 ),(note:117;wheel:8211 ),(note:117;wheel:8213 ),
(note:117;wheel:8216 ),(note:117;wheel:8218 ),(note:117;wheel:8221 ),(note:117;wheel:8223 ),
(note:117;wheel:8226 ),(note:117;wheel:8228 ),(note:117;wheel:8231 ),(note:117;wheel:8233 ),
(note:117;wheel:8236 ),(note:117;wheel:8238 ),(note:117;wheel:8241 ),(note:117;wheel:8243 ),
(note:117;wheel:8246 ),(note:117;wheel:8248 ),(note:117;wheel:8251 ),(note:117;wheel:8253 ),
(note:117;wheel:8256 ),(note:117;wheel:8258 ),(note:117;wheel:8261 ),(note:117;wheel:8263 ),
(note:117;wheel:8266 ),(note:117;wheel:8268 ),(note:117;wheel:8271 ),(note:117;wheel:8273 ),
(note:117;wheel:8276 ),(note:117;wheel:8278 ),(note:117;wheel:8281 ),(note:117;wheel:8283 ),
(note:117;wheel:8285 ),(note:117;wheel:8288 ),(note:117;wheel:8290 ),(note:117;wheel:8293 ),
(note:117;wheel:8295 ),(note:117;wheel:8298 ),(note:117;wheel:8300 ),(note:117;wheel:8303 ),
(note:117;wheel:8305 ),(note:117;wheel:8308 ),(note:117;wheel:8310 ),(note:117;wheel:8313 ),
(note:117;wheel:8315 ),(note:117;wheel:8318 ),(note:117;wheel:8320 ),(note:117;wheel:8323 ),
(note:117;wheel:8325 ),(note:117;wheel:8327 ),(note:117;wheel:8330 ),(note:117;wheel:8332 ),
(note:117;wheel:8335 ),(note:117;wheel:8337 ),(note:117;wheel:8340 ),(note:117;wheel:8342 ),
(note:117;wheel:8345 ),(note:117;wheel:8347 ),(note:117;wheel:8350 ),(note:117;wheel:8352 ),
(note:117;wheel:8354 ),(note:117;wheel:8357 ),(note:117;wheel:8359 ),(note:117;wheel:8362 ),
(note:118;wheel:8023 ),(note:118;wheel:8025 ),(note:118;wheel:8028 ),(note:118;wheel:8030 ),
(note:118;wheel:8033 ),(note:118;wheel:8035 ),(note:118;wheel:8038 ),(note:118;wheel:8040 ),
(note:118;wheel:8042 ),(note:118;wheel:8045 ),(note:118;wheel:8047 ),(note:118;wheel:8050 ),
(note:118;wheel:8052 ),(note:118;wheel:8055 ),(note:118;wheel:8057 ),(note:118;wheel:8060 ),
(note:118;wheel:8062 ),(note:118;wheel:8064 ),(note:118;wheel:8067 ),(note:118;wheel:8069 ),
(note:118;wheel:8072 ),(note:118;wheel:8074 ),(note:118;wheel:8077 ),(note:118;wheel:8079 ),
(note:118;wheel:8081 ),(note:118;wheel:8084 ),(note:118;wheel:8086 ),(note:118;wheel:8089 ),
(note:118;wheel:8091 ),(note:118;wheel:8093 ),(note:118;wheel:8096 ),(note:118;wheel:8098 ),
(note:118;wheel:8101 ),(note:118;wheel:8103 ),(note:118;wheel:8106 ),(note:118;wheel:8108 ),
(note:118;wheel:8110 ),(note:118;wheel:8113 ),(note:118;wheel:8115 ),(note:118;wheel:8118 ),
(note:118;wheel:8120 ),(note:118;wheel:8122 ),(note:118;wheel:8125 ),(note:118;wheel:8127 ),
(note:118;wheel:8130 ),(note:118;wheel:8132 ),(note:118;wheel:8134 ),(note:118;wheel:8137 ),
(note:118;wheel:8139 ),(note:118;wheel:8142 ),(note:118;wheel:8144 ),(note:118;wheel:8146 ),
(note:118;wheel:8149 ),(note:118;wheel:8151 ),(note:118;wheel:8154 ),(note:118;wheel:8156 ),
(note:118;wheel:8158 ),(note:118;wheel:8161 ),(note:118;wheel:8163 ),(note:118;wheel:8165 ),
(note:118;wheel:8168 ),(note:118;wheel:8170 ),(note:118;wheel:8173 ),(note:118;wheel:8175 ),
(note:118;wheel:8177 ),(note:118;wheel:8180 ),(note:118;wheel:8182 ),(note:118;wheel:8185 ),
(note:118;wheel:8187 ),(note:118;wheel:8189 ),(note:118;wheel:8192 ),(note:118;wheel:8194 ),
(note:118;wheel:8196 ),(note:118;wheel:8199 ),(note:118;wheel:8201 ),(note:118;wheel:8204 ),
(note:118;wheel:8206 ),(note:118;wheel:8208 ),(note:118;wheel:8211 ),(note:118;wheel:8213 ),
(note:118;wheel:8215 ),(note:118;wheel:8218 ),(note:118;wheel:8220 ),(note:118;wheel:8223 ),
(note:118;wheel:8225 ),(note:118;wheel:8227 ),(note:118;wheel:8230 ),(note:118;wheel:8232 ),
(note:118;wheel:8234 ),(note:118;wheel:8237 ),(note:118;wheel:8239 ),(note:118;wheel:8241 ),
(note:118;wheel:8244 ),(note:118;wheel:8246 ),(note:118;wheel:8248 ),(note:118;wheel:8251 ),
(note:118;wheel:8253 ),(note:118;wheel:8256 ),(note:118;wheel:8258 ),(note:118;wheel:8260 ),
(note:118;wheel:8263 ),(note:118;wheel:8265 ),(note:118;wheel:8267 ),(note:118;wheel:8270 ),
(note:118;wheel:8272 ),(note:118;wheel:8274 ),(note:118;wheel:8277 ),(note:118;wheel:8279 ),
(note:118;wheel:8281 ),(note:118;wheel:8284 ),(note:118;wheel:8286 ),(note:118;wheel:8288 ),
(note:118;wheel:8291 ),(note:118;wheel:8293 ),(note:118;wheel:8295 ),(note:118;wheel:8298 ),
(note:118;wheel:8300 ),(note:118;wheel:8302 ),(note:118;wheel:8305 ),(note:118;wheel:8307 ),
(note:118;wheel:8309 ),(note:118;wheel:8312 ),(note:118;wheel:8314 ),(note:118;wheel:8316 ),
(note:118;wheel:8319 ),(note:118;wheel:8321 ),(note:118;wheel:8323 ),(note:118;wheel:8326 ),
(note:118;wheel:8328 ),(note:118;wheel:8330 ),(note:118;wheel:8333 ),(note:118;wheel:8335 ),
(note:118;wheel:8337 ),(note:118;wheel:8340 ),(note:118;wheel:8342 ),(note:118;wheel:8344 ),
(note:118;wheel:8347 ),(note:118;wheel:8349 ),(note:118;wheel:8351 ),(note:118;wheel:8353 ),
(note:118;wheel:8356 ),(note:118;wheel:8358 ),(note:118;wheel:8360 ),(note:119;wheel:8021 ),
(note:119;wheel:8024 ),(note:119;wheel:8026 ),(note:119;wheel:8028 ),(note:119;wheel:8031 ),
(note:119;wheel:8033 ),(note:119;wheel:8035 ),(note:119;wheel:8038 ),(note:119;wheel:8040 ),
(note:119;wheel:8042 ),(note:119;wheel:8044 ),(note:119;wheel:8047 ),(note:119;wheel:8049 ),
(note:119;wheel:8051 ),(note:119;wheel:8054 ),(note:119;wheel:8056 ),(note:119;wheel:8058 ),
(note:119;wheel:8060 ),(note:119;wheel:8063 ),(note:119;wheel:8065 ),(note:119;wheel:8067 ),
(note:119;wheel:8070 ),(note:119;wheel:8072 ),(note:119;wheel:8074 ),(note:119;wheel:8077 ),
(note:119;wheel:8079 ),(note:119;wheel:8081 ),(note:119;wheel:8083 ),(note:119;wheel:8086 ),
(note:119;wheel:8088 ),(note:119;wheel:8090 ),(note:119;wheel:8093 ),(note:119;wheel:8095 ),
(note:119;wheel:8097 ),(note:119;wheel:8099 ),(note:119;wheel:8102 ),(note:119;wheel:8104 ),
(note:119;wheel:8106 ),(note:119;wheel:8108 ),(note:119;wheel:8111 ),(note:119;wheel:8113 ),
(note:119;wheel:8115 ),(note:119;wheel:8118 ),(note:119;wheel:8120 ),(note:119;wheel:8122 ),
(note:119;wheel:8124 ),(note:119;wheel:8127 ),(note:119;wheel:8129 ),(note:119;wheel:8131 ),
(note:119;wheel:8133 ),(note:119;wheel:8136 ),(note:119;wheel:8138 ),(note:119;wheel:8140 ),
(note:119;wheel:8142 ),(note:119;wheel:8145 ),(note:119;wheel:8147 ),(note:119;wheel:8149 ),
(note:119;wheel:8152 ),(note:119;wheel:8154 ),(note:119;wheel:8156 ),(note:119;wheel:8158 ),
(note:119;wheel:8161 ),(note:119;wheel:8163 ),(note:119;wheel:8165 ),(note:119;wheel:8167 ),
(note:119;wheel:8170 ),(note:119;wheel:8172 ),(note:119;wheel:8174 ),(note:119;wheel:8176 ),
(note:119;wheel:8179 ),(note:119;wheel:8181 ),(note:119;wheel:8183 ),(note:119;wheel:8185 ),
(note:119;wheel:8188 ),(note:119;wheel:8190 ),(note:119;wheel:8192 ),(note:119;wheel:8194 ),
(note:119;wheel:8197 ),(note:119;wheel:8199 ),(note:119;wheel:8201 ),(note:119;wheel:8203 ),
(note:119;wheel:8205 ),(note:119;wheel:8208 ),(note:119;wheel:8210 ),(note:119;wheel:8212 ),
(note:119;wheel:8214 ),(note:119;wheel:8217 ),(note:119;wheel:8219 ),(note:119;wheel:8221 ),
(note:119;wheel:8223 ),(note:119;wheel:8226 ),(note:119;wheel:8228 ),(note:119;wheel:8230 ),
(note:119;wheel:8232 ),(note:119;wheel:8235 ),(note:119;wheel:8237 ),(note:119;wheel:8239 ),
(note:119;wheel:8241 ),(note:119;wheel:8243 ),(note:119;wheel:8246 ),(note:119;wheel:8248 ),
(note:119;wheel:8250 ),(note:119;wheel:8252 ),(note:119;wheel:8255 ),(note:119;wheel:8257 ),
(note:119;wheel:8259 ),(note:119;wheel:8261 ),(note:119;wheel:8263 ),(note:119;wheel:8266 ),
(note:119;wheel:8268 ),(note:119;wheel:8270 ),(note:119;wheel:8272 ),(note:119;wheel:8274 ),
(note:119;wheel:8277 ),(note:119;wheel:8279 ),(note:119;wheel:8281 ),(note:119;wheel:8283 ),
(note:119;wheel:8286 ),(note:119;wheel:8288 ),(note:119;wheel:8290 ),(note:119;wheel:8292 ),
(note:119;wheel:8294 ),(note:119;wheel:8297 ),(note:119;wheel:8299 ),(note:119;wheel:8301 ),
(note:119;wheel:8303 ),(note:119;wheel:8305 ),(note:119;wheel:8308 ),(note:119;wheel:8310 ),
(note:119;wheel:8312 ),(note:119;wheel:8314 ),(note:119;wheel:8316 ),(note:119;wheel:8319 ),
(note:119;wheel:8321 ),(note:119;wheel:8323 ),(note:119;wheel:8325 ),(note:119;wheel:8327 ),
(note:119;wheel:8330 ),(note:119;wheel:8332 ),(note:119;wheel:8334 ),(note:119;wheel:8336 ),
(note:119;wheel:8338 ),(note:119;wheel:8340 ),(note:119;wheel:8343 ),(note:119;wheel:8345 ),
(note:119;wheel:8347 ),(note:119;wheel:8349 ),(note:119;wheel:8351 ),(note:119;wheel:8354 ),
(note:119;wheel:8356 ),(note:119;wheel:8358 ),(note:119;wheel:8360 ),(note:120;wheel:8021 ),
(note:120;wheel:8023 ),(note:120;wheel:8025 ),(note:120;wheel:8027 ),(note:120;wheel:8030 ),
(note:120;wheel:8032 ),(note:120;wheel:8034 ),(note:120;wheel:8036 ),(note:120;wheel:8038 ),
(note:120;wheel:8041 ),(note:120;wheel:8043 ),(note:120;wheel:8045 ),(note:120;wheel:8047 ),
(note:120;wheel:8049 ),(note:120;wheel:8051 ),(note:120;wheel:8054 ),(note:120;wheel:8056 ),
(note:120;wheel:8058 ),(note:120;wheel:8060 ),(note:120;wheel:8062 ),(note:120;wheel:8064 ),
(note:120;wheel:8067 ),(note:120;wheel:8069 ),(note:120;wheel:8071 ),(note:120;wheel:8073 ),
(note:120;wheel:8075 ),(note:120;wheel:8077 ),(note:120;wheel:8080 ),(note:120;wheel:8082 ),
(note:120;wheel:8084 ),(note:120;wheel:8086 ),(note:120;wheel:8088 ),(note:120;wheel:8090 ),
(note:120;wheel:8092 ),(note:120;wheel:8095 ),(note:120;wheel:8097 ),(note:120;wheel:8099 ),
(note:120;wheel:8101 ),(note:120;wheel:8103 ),(note:120;wheel:8105 ),(note:120;wheel:8108 ),
(note:120;wheel:8110 ),(note:120;wheel:8112 ),(note:120;wheel:8114 ),(note:120;wheel:8116 ),
(note:120;wheel:8118 ),(note:120;wheel:8120 ),(note:120;wheel:8123 ),(note:120;wheel:8125 ),
(note:120;wheel:8127 ),(note:120;wheel:8129 ),(note:120;wheel:8131 ),(note:120;wheel:8133 ),
(note:120;wheel:8135 ),(note:120;wheel:8137 ),(note:120;wheel:8140 ),(note:120;wheel:8142 ),
(note:120;wheel:8144 ),(note:120;wheel:8146 ),(note:120;wheel:8148 ),(note:120;wheel:8150 ),
(note:120;wheel:8152 ),(note:120;wheel:8155 ),(note:120;wheel:8157 ),(note:120;wheel:8159 ),
(note:120;wheel:8161 ),(note:120;wheel:8163 ),(note:120;wheel:8165 ),(note:120;wheel:8167 ),
(note:120;wheel:8169 ),(note:120;wheel:8172 ),(note:120;wheel:8174 ),(note:120;wheel:8176 ),
(note:120;wheel:8178 ),(note:120;wheel:8180 ),(note:120;wheel:8182 ),(note:120;wheel:8184 ),
(note:120;wheel:8186 ),(note:120;wheel:8189 ),(note:120;wheel:8191 ),(note:120;wheel:8193 ),
(note:120;wheel:8195 ),(note:120;wheel:8197 ),(note:120;wheel:8199 ),(note:120;wheel:8201 ),
(note:120;wheel:8203 ),(note:120;wheel:8205 ),(note:120;wheel:8208 ),(note:120;wheel:8210 ),
(note:120;wheel:8212 ),(note:120;wheel:8214 ),(note:120;wheel:8216 ),(note:120;wheel:8218 ),
(note:120;wheel:8220 ),(note:120;wheel:8222 ),(note:120;wheel:8224 ),(note:120;wheel:8227 ),
(note:120;wheel:8229 ),(note:120;wheel:8231 ),(note:120;wheel:8233 ),(note:120;wheel:8235 ),
(note:120;wheel:8237 ),(note:120;wheel:8239 ),(note:120;wheel:8241 ),(note:120;wheel:8243 ),
(note:120;wheel:8245 ),(note:120;wheel:8248 ),(note:120;wheel:8250 ),(note:120;wheel:8252 ),
(note:120;wheel:8254 ),(note:120;wheel:8256 ),(note:120;wheel:8258 ),(note:120;wheel:8260 ),
(note:120;wheel:8262 ),(note:120;wheel:8264 ),(note:120;wheel:8266 ),(note:120;wheel:8269 ),
(note:120;wheel:8271 ),(note:120;wheel:8273 ),(note:120;wheel:8275 ),(note:120;wheel:8277 ),
(note:120;wheel:8279 ),(note:120;wheel:8281 ),(note:120;wheel:8283 ),(note:120;wheel:8285 ),
(note:120;wheel:8287 ),(note:120;wheel:8289 ),(note:120;wheel:8291 ),(note:120;wheel:8294 ),
(note:120;wheel:8296 ),(note:120;wheel:8298 ),(note:120;wheel:8300 ),(note:120;wheel:8302 ),
(note:120;wheel:8304 ),(note:120;wheel:8306 ),(note:120;wheel:8308 ),(note:120;wheel:8310 ),
(note:120;wheel:8312 ),(note:120;wheel:8314 ),(note:120;wheel:8316 ),(note:120;wheel:8318 ),
(note:120;wheel:8321 ),(note:120;wheel:8323 ),(note:120;wheel:8325 ),(note:120;wheel:8327 ),
(note:120;wheel:8329 ),(note:120;wheel:8331 ),(note:120;wheel:8333 ),(note:120;wheel:8335 ),
(note:120;wheel:8337 ),(note:120;wheel:8339 ),(note:120;wheel:8341 ),(note:120;wheel:8343 ),
(note:120;wheel:8345 ),(note:120;wheel:8347 ),(note:120;wheel:8349 ),(note:120;wheel:8352 ),
(note:120;wheel:8354 ),(note:120;wheel:8356 ),(note:120;wheel:8358 ),(note:120;wheel:8360 ),
(note:120;wheel:8362 ),(note:121;wheel:8023 ),(note:121;wheel:8025 ),(note:121;wheel:8027 ),
(note:121;wheel:8029 ),(note:121;wheel:8031 ),(note:121;wheel:8033 ),(note:121;wheel:8035 ),
(note:121;wheel:8037 ),(note:121;wheel:8039 ),(note:121;wheel:8041 ),(note:121;wheel:8043 ),
(note:121;wheel:8045 ),(note:121;wheel:8047 ),(note:121;wheel:8049 ),(note:121;wheel:8051 ),
(note:121;wheel:8053 ),(note:121;wheel:8055 ),(note:121;wheel:8057 ),(note:121;wheel:8059 ),
(note:121;wheel:8062 ),(note:121;wheel:8064 ),(note:121;wheel:8066 ),(note:121;wheel:8068 ),
(note:121;wheel:8070 ),(note:121;wheel:8072 ),(note:121;wheel:8074 ),(note:121;wheel:8076 ),
(note:121;wheel:8078 ),(note:121;wheel:8080 ),(note:121;wheel:8082 ),(note:121;wheel:8084 ),
(note:121;wheel:8086 ),(note:121;wheel:8088 ),(note:121;wheel:8090 ),(note:121;wheel:8092 ),
(note:121;wheel:8094 ),(note:121;wheel:8096 ),(note:121;wheel:8098 ),(note:121;wheel:8100 ),
(note:121;wheel:8102 ),(note:121;wheel:8104 ),(note:121;wheel:8106 ),(note:121;wheel:8108 ),
(note:121;wheel:8110 ),(note:121;wheel:8112 ),(note:121;wheel:8114 ),(note:121;wheel:8116 ),
(note:121;wheel:8118 ),(note:121;wheel:8120 ),(note:121;wheel:8122 ),(note:121;wheel:8125 ),
(note:121;wheel:8127 ),(note:121;wheel:8129 ),(note:121;wheel:8131 ),(note:121;wheel:8133 ),
(note:121;wheel:8135 ),(note:121;wheel:8137 ),(note:121;wheel:8139 ),(note:121;wheel:8141 ),
(note:121;wheel:8143 ),(note:121;wheel:8145 ),(note:121;wheel:8147 ),(note:121;wheel:8149 ),
(note:121;wheel:8151 ),(note:121;wheel:8153 ),(note:121;wheel:8155 ),(note:121;wheel:8157 ),
(note:121;wheel:8159 ),(note:121;wheel:8161 ),(note:121;wheel:8163 ),(note:121;wheel:8165 ),
(note:121;wheel:8167 ),(note:121;wheel:8169 ),(note:121;wheel:8171 ),(note:121;wheel:8173 ),
(note:121;wheel:8175 ),(note:121;wheel:8177 ),(note:121;wheel:8179 ),(note:121;wheel:8181 ),
(note:121;wheel:8183 ),(note:121;wheel:8185 ),(note:121;wheel:8187 ),(note:121;wheel:8189 ),
(note:121;wheel:8191 ),(note:121;wheel:8193 ),(note:121;wheel:8195 ),(note:121;wheel:8197 ),
(note:121;wheel:8199 ),(note:121;wheel:8201 ),(note:121;wheel:8203 ),(note:121;wheel:8205 ),
(note:121;wheel:8207 ),(note:121;wheel:8209 ),(note:121;wheel:8211 ),(note:121;wheel:8213 ),
(note:121;wheel:8215 ),(note:121;wheel:8217 ),(note:121;wheel:8219 ),(note:121;wheel:8221 ),
(note:121;wheel:8223 ),(note:121;wheel:8225 ),(note:121;wheel:8227 ),(note:121;wheel:8229 ),
(note:121;wheel:8231 ),(note:121;wheel:8233 ),(note:121;wheel:8235 ),(note:121;wheel:8237 ),
(note:121;wheel:8239 ),(note:121;wheel:8241 ),(note:121;wheel:8243 ),(note:121;wheel:8245 ),
(note:121;wheel:8247 ),(note:121;wheel:8249 ),(note:121;wheel:8251 ),(note:121;wheel:8252 ),
(note:121;wheel:8254 ),(note:121;wheel:8256 ),(note:121;wheel:8258 ),(note:121;wheel:8260 ),
(note:121;wheel:8262 ),(note:121;wheel:8264 ),(note:121;wheel:8266 ),(note:121;wheel:8268 ),
(note:121;wheel:8270 ),(note:121;wheel:8272 ),(note:121;wheel:8274 ),(note:121;wheel:8276 ),
(note:121;wheel:8278 ),(note:121;wheel:8280 ),(note:121;wheel:8282 ),(note:121;wheel:8284 ),
(note:121;wheel:8286 ),(note:121;wheel:8288 ),(note:121;wheel:8290 ),(note:121;wheel:8292 ),
(note:121;wheel:8294 ),(note:121;wheel:8296 ),(note:121;wheel:8298 ),(note:121;wheel:8300 ),
(note:121;wheel:8302 ),(note:121;wheel:8304 ),(note:121;wheel:8306 ),(note:121;wheel:8308 ),
(note:121;wheel:8310 ),(note:121;wheel:8312 ),(note:121;wheel:8313 ),(note:121;wheel:8315 ),
(note:121;wheel:8317 ),(note:121;wheel:8319 ),(note:121;wheel:8321 ),(note:121;wheel:8323 ),
(note:121;wheel:8325 ),(note:121;wheel:8327 ),(note:121;wheel:8329 ),(note:121;wheel:8331 ),
(note:121;wheel:8333 ),(note:121;wheel:8335 ),(note:121;wheel:8337 ),(note:121;wheel:8339 ),
(note:121;wheel:8341 ),(note:121;wheel:8343 ),(note:121;wheel:8345 ),(note:121;wheel:8347 ),
(note:121;wheel:8349 ),(note:121;wheel:8351 ),(note:121;wheel:8353 ),(note:121;wheel:8354 ),
(note:121;wheel:8356 ),(note:121;wheel:8358 ),(note:121;wheel:8360 ),(note:122;wheel:8021 ),
(note:122;wheel:8023 ),(note:122;wheel:8025 ),(note:122;wheel:8027 ),(note:122;wheel:8029 ),
(note:122;wheel:8031 ),(note:122;wheel:8033 ),(note:122;wheel:8034 ),(note:122;wheel:8036 ),
(note:122;wheel:8038 ),(note:122;wheel:8040 ),(note:122;wheel:8042 ),(note:122;wheel:8044 ),
(note:122;wheel:8046 ),(note:122;wheel:8048 ),(note:122;wheel:8050 ),(note:122;wheel:8052 ),
(note:122;wheel:8054 ),(note:122;wheel:8056 ),(note:122;wheel:8058 ),(note:122;wheel:8060 ),
(note:122;wheel:8062 ),(note:122;wheel:8063 ),(note:122;wheel:8065 ),(note:122;wheel:8067 ),
(note:122;wheel:8069 ),(note:122;wheel:8071 ),(note:122;wheel:8073 ),(note:122;wheel:8075 ),
(note:122;wheel:8077 ),(note:122;wheel:8079 ),(note:122;wheel:8081 ),(note:122;wheel:8083 ),
(note:122;wheel:8085 ),(note:122;wheel:8087 ),(note:122;wheel:8088 ),(note:122;wheel:8090 ),
(note:122;wheel:8092 ),(note:122;wheel:8094 ),(note:122;wheel:8096 ),(note:122;wheel:8098 ),
(note:122;wheel:8100 ),(note:122;wheel:8102 ),(note:122;wheel:8104 ),(note:122;wheel:8106 ),
(note:122;wheel:8108 ),(note:122;wheel:8110 ),(note:122;wheel:8111 ),(note:122;wheel:8113 ),
(note:122;wheel:8115 ),(note:122;wheel:8117 ),(note:122;wheel:8119 ),(note:122;wheel:8121 ),
(note:122;wheel:8123 ),(note:122;wheel:8125 ),(note:122;wheel:8127 ),(note:122;wheel:8129 ),
(note:122;wheel:8131 ),(note:122;wheel:8132 ),(note:122;wheel:8134 ),(note:122;wheel:8136 ),
(note:122;wheel:8138 ),(note:122;wheel:8140 ),(note:122;wheel:8142 ),(note:122;wheel:8144 ),
(note:122;wheel:8146 ),(note:122;wheel:8148 ),(note:122;wheel:8150 ),(note:122;wheel:8151 ),
(note:122;wheel:8153 ),(note:122;wheel:8155 ),(note:122;wheel:8157 ),(note:122;wheel:8159 ),
(note:122;wheel:8161 ),(note:122;wheel:8163 ),(note:122;wheel:8165 ),(note:122;wheel:8167 ),
(note:122;wheel:8169 ),(note:122;wheel:8170 ),(note:122;wheel:8172 ),(note:122;wheel:8174 ),
(note:122;wheel:8176 ),(note:122;wheel:8178 ),(note:122;wheel:8180 ),(note:122;wheel:8182 ),
(note:122;wheel:8184 ),(note:122;wheel:8186 ),(note:122;wheel:8187 ),(note:122;wheel:8189 ),
(note:122;wheel:8191 ),(note:122;wheel:8193 ),(note:122;wheel:8195 ),(note:122;wheel:8197 ),
(note:122;wheel:8199 ),(note:122;wheel:8201 ),(note:122;wheel:8203 ),(note:122;wheel:8204 ),
(note:122;wheel:8206 ),(note:122;wheel:8208 ),(note:122;wheel:8210 ),(note:122;wheel:8212 ),
(note:122;wheel:8214 ),(note:122;wheel:8216 ),(note:122;wheel:8218 ),(note:122;wheel:8219 ),
(note:122;wheel:8221 ),(note:122;wheel:8223 ),(note:122;wheel:8225 ),(note:122;wheel:8227 ),
(note:122;wheel:8229 ),(note:122;wheel:8231 ),(note:122;wheel:8233 ),(note:122;wheel:8234 ),
(note:122;wheel:8236 ),(note:122;wheel:8238 ),(note:122;wheel:8240 ),(note:122;wheel:8242 ),
(note:122;wheel:8244 ),(note:122;wheel:8246 ),(note:122;wheel:8248 ),(note:122;wheel:8249 ),
(note:122;wheel:8251 ),(note:122;wheel:8253 ),(note:122;wheel:8255 ),(note:122;wheel:8257 ),
(note:122;wheel:8259 ),(note:122;wheel:8261 ),(note:122;wheel:8262 ),(note:122;wheel:8264 ),
(note:122;wheel:8266 ),(note:122;wheel:8268 ),(note:122;wheel:8270 ),(note:122;wheel:8272 ),
(note:122;wheel:8274 ),(note:122;wheel:8276 ),(note:122;wheel:8277 ),(note:122;wheel:8279 ),
(note:122;wheel:8281 ),(note:122;wheel:8283 ),(note:122;wheel:8285 ),(note:122;wheel:8287 ),
(note:122;wheel:8289 ),(note:122;wheel:8290 ),(note:122;wheel:8292 ),(note:122;wheel:8294 ),
(note:122;wheel:8296 ),(note:122;wheel:8298 ),(note:122;wheel:8300 ),(note:122;wheel:8301 ),
(note:122;wheel:8303 ),(note:122;wheel:8305 ),(note:122;wheel:8307 ),(note:122;wheel:8309 ),
(note:122;wheel:8311 ),(note:122;wheel:8313 ),(note:122;wheel:8314 ),(note:122;wheel:8316 ),
(note:122;wheel:8318 ),(note:122;wheel:8320 ),(note:122;wheel:8322 ),(note:122;wheel:8324 ),
(note:122;wheel:8326 ),(note:122;wheel:8327 ),(note:122;wheel:8329 ),(note:122;wheel:8331 ),
(note:122;wheel:8333 ),(note:122;wheel:8335 ),(note:122;wheel:8337 ),(note:122;wheel:8338 ),
(note:122;wheel:8340 ),(note:122;wheel:8342 ),(note:122;wheel:8344 ),(note:122;wheel:8346 ),
(note:122;wheel:8348 ),(note:122;wheel:8349 ),(note:122;wheel:8351 ),(note:122;wheel:8353 ),
(note:122;wheel:8355 ),(note:122;wheel:8357 ),(note:122;wheel:8359 ),(note:122;wheel:8360 ),
(note:123;wheel:8021 ),(note:123;wheel:8023 ),(note:123;wheel:8025 ),(note:123;wheel:8026 ),
(note:123;wheel:8028 ),(note:123;wheel:8030 ),(note:123;wheel:8032 ),(note:123;wheel:8034 ),
(note:123;wheel:8036 ),(note:123;wheel:8037 ),(note:123;wheel:8039 ),(note:123;wheel:8041 ),
(note:123;wheel:8043 ),(note:123;wheel:8045 ),(note:123;wheel:8047 ),(note:123;wheel:8048 ),
(note:123;wheel:8050 ),(note:123;wheel:8052 ),(note:123;wheel:8054 ),(note:123;wheel:8056 ),
(note:123;wheel:8057 ),(note:123;wheel:8059 ),(note:123;wheel:8061 ),(note:123;wheel:8063 ),
(note:123;wheel:8065 ),(note:123;wheel:8067 ),(note:123;wheel:8068 ),(note:123;wheel:8070 ),
(note:123;wheel:8072 ),(note:123;wheel:8074 ),(note:123;wheel:8076 ),(note:123;wheel:8077 ),
(note:123;wheel:8079 ),(note:123;wheel:8081 ),(note:123;wheel:8083 ),(note:123;wheel:8085 ),
(note:123;wheel:8087 ),(note:123;wheel:8088 ),(note:123;wheel:8090 ),(note:123;wheel:8092 ),
(note:123;wheel:8094 ),(note:123;wheel:8096 ),(note:123;wheel:8097 ),(note:123;wheel:8099 ),
(note:123;wheel:8101 ),(note:123;wheel:8103 ),(note:123;wheel:8105 ),(note:123;wheel:8106 ),
(note:123;wheel:8108 ),(note:123;wheel:8110 ),(note:123;wheel:8112 ),(note:123;wheel:8114 ),
(note:123;wheel:8115 ),(note:123;wheel:8117 ),(note:123;wheel:8119 ),(note:123;wheel:8121 ),
(note:123;wheel:8123 ),(note:123;wheel:8125 ),(note:123;wheel:8126 ),(note:123;wheel:8128 ),
(note:123;wheel:8130 ),(note:123;wheel:8132 ),(note:123;wheel:8134 ),(note:123;wheel:8135 ),
(note:123;wheel:8137 ),(note:123;wheel:8139 ),(note:123;wheel:8141 ),(note:123;wheel:8142 ),
(note:123;wheel:8144 ),(note:123;wheel:8146 ),(note:123;wheel:8148 ),(note:123;wheel:8150 ),
(note:123;wheel:8151 ),(note:123;wheel:8153 ),(note:123;wheel:8155 ),(note:123;wheel:8157 ),
(note:123;wheel:8159 ),(note:123;wheel:8160 ),(note:123;wheel:8162 ),(note:123;wheel:8164 ),
(note:123;wheel:8166 ),(note:123;wheel:8168 ),(note:123;wheel:8169 ),(note:123;wheel:8171 ),
(note:123;wheel:8173 ),(note:123;wheel:8175 ),(note:123;wheel:8177 ),(note:123;wheel:8178 ),
(note:123;wheel:8180 ),(note:123;wheel:8182 ),(note:123;wheel:8184 ),(note:123;wheel:8185 ),
(note:123;wheel:8187 ),(note:123;wheel:8189 ),(note:123;wheel:8191 ),(note:123;wheel:8193 ),
(note:123;wheel:8194 ),(note:123;wheel:8196 ),(note:123;wheel:8198 ),(note:123;wheel:8200 ),
(note:123;wheel:8201 ),(note:123;wheel:8203 ),(note:123;wheel:8205 ),(note:123;wheel:8207 ),
(note:123;wheel:8209 ),(note:123;wheel:8210 ),(note:123;wheel:8212 ),(note:123;wheel:8214 ),
(note:123;wheel:8216 ),(note:123;wheel:8217 ),(note:123;wheel:8219 ),(note:123;wheel:8221 ),
(note:123;wheel:8223 ),(note:123;wheel:8225 ),(note:123;wheel:8226 ),(note:123;wheel:8228 ),
(note:123;wheel:8230 ),(note:123;wheel:8232 ),(note:123;wheel:8233 ),(note:123;wheel:8235 ),
(note:123;wheel:8237 ),(note:123;wheel:8239 ),(note:123;wheel:8240 ),(note:123;wheel:8242 ),
(note:123;wheel:8244 ),(note:123;wheel:8246 ),(note:123;wheel:8247 ),(note:123;wheel:8249 ),
(note:123;wheel:8251 ),(note:123;wheel:8253 ),(note:123;wheel:8255 ),(note:123;wheel:8256 ),
(note:123;wheel:8258 ),(note:123;wheel:8260 ),(note:123;wheel:8262 ),(note:123;wheel:8263 ),
(note:123;wheel:8265 ),(note:123;wheel:8267 ),(note:123;wheel:8269 ),(note:123;wheel:8270 ),
(note:123;wheel:8272 ),(note:123;wheel:8274 ),(note:123;wheel:8276 ),(note:123;wheel:8277 ),
(note:123;wheel:8279 ),(note:123;wheel:8281 ),(note:123;wheel:8283 ),(note:123;wheel:8284 ),
(note:123;wheel:8286 ),(note:123;wheel:8288 ),(note:123;wheel:8290 ),(note:123;wheel:8291 ),
(note:123;wheel:8293 ),(note:123;wheel:8295 ),(note:123;wheel:8297 ),(note:123;wheel:8298 ),
(note:123;wheel:8300 ),(note:123;wheel:8302 ),(note:123;wheel:8304 ),(note:123;wheel:8305 ),
(note:123;wheel:8307 ),(note:123;wheel:8309 ),(note:123;wheel:8311 ),(note:123;wheel:8312 ),
(note:123;wheel:8314 ),(note:123;wheel:8316 ),(note:123;wheel:8318 ),(note:123;wheel:8319 ),
(note:123;wheel:8321 ),(note:123;wheel:8323 ),(note:123;wheel:8325 ),(note:123;wheel:8326 ),
(note:123;wheel:8328 ),(note:123;wheel:8330 ),(note:123;wheel:8332 ),(note:123;wheel:8333 ),
(note:123;wheel:8335 ),(note:123;wheel:8337 ),(note:123;wheel:8338 ),(note:123;wheel:8340 ),
(note:123;wheel:8342 ),(note:123;wheel:8344 ),(note:123;wheel:8345 ),(note:123;wheel:8347 ),
(note:123;wheel:8349 ),(note:123;wheel:8351 ),(note:123;wheel:8352 ),(note:123;wheel:8354 ),
(note:123;wheel:8356 ),(note:123;wheel:8358 ),(note:123;wheel:8359 ),(note:123;wheel:8361 ),
(note:124;wheel:8021 ),(note:124;wheel:8023 ),(note:124;wheel:8025 ),(note:124;wheel:8027 ),
(note:124;wheel:8028 ),(note:124;wheel:8030 ),(note:124;wheel:8032 ),(note:124;wheel:8034 ),
(note:124;wheel:8035 ),(note:124;wheel:8037 ),(note:124;wheel:8039 ),(note:124;wheel:8040 ),
(note:124;wheel:8042 ),(note:124;wheel:8044 ),(note:124;wheel:8046 ),(note:124;wheel:8047 ),
(note:124;wheel:8049 ),(note:124;wheel:8051 ),(note:124;wheel:8052 ),(note:124;wheel:8054 ),
(note:124;wheel:8056 ),(note:124;wheel:8058 ),(note:124;wheel:8059 ),(note:124;wheel:8061 ),
(note:124;wheel:8063 ),(note:124;wheel:8065 ),(note:124;wheel:8066 ),(note:124;wheel:8068 ),
(note:124;wheel:8070 ),(note:124;wheel:8071 ),(note:124;wheel:8073 ),(note:124;wheel:8075 ),
(note:124;wheel:8077 ),(note:124;wheel:8078 ),(note:124;wheel:8080 ),(note:124;wheel:8082 ),
(note:124;wheel:8083 ),(note:124;wheel:8085 ),(note:124;wheel:8087 ),(note:124;wheel:8089 ),
(note:124;wheel:8090 ),(note:124;wheel:8092 ),(note:124;wheel:8094 ),(note:124;wheel:8095 ),
(note:124;wheel:8097 ),(note:124;wheel:8099 ),(note:124;wheel:8100 ),(note:124;wheel:8102 ),
(note:124;wheel:8104 ),(note:124;wheel:8106 ),(note:124;wheel:8107 ),(note:124;wheel:8109 ),
(note:124;wheel:8111 ),(note:124;wheel:8112 ),(note:124;wheel:8114 ),(note:124;wheel:8116 ),
(note:124;wheel:8118 ),(note:124;wheel:8119 ),(note:124;wheel:8121 ),(note:124;wheel:8123 ),
(note:124;wheel:8124 ),(note:124;wheel:8126 ),(note:124;wheel:8128 ),(note:124;wheel:8129 ),
(note:124;wheel:8131 ),(note:124;wheel:8133 ),(note:124;wheel:8134 ),(note:124;wheel:8136 ),
(note:124;wheel:8138 ),(note:124;wheel:8140 ),(note:124;wheel:8141 ),(note:124;wheel:8143 ),
(note:124;wheel:8145 ),(note:124;wheel:8146 ),(note:124;wheel:8148 ),(note:124;wheel:8150 ),
(note:124;wheel:8151 ),(note:124;wheel:8153 ),(note:124;wheel:8155 ),(note:124;wheel:8157 ),
(note:124;wheel:8158 ),(note:124;wheel:8160 ),(note:124;wheel:8162 ),(note:124;wheel:8163 ),
(note:124;wheel:8165 ),(note:124;wheel:8167 ),(note:124;wheel:8168 ),(note:124;wheel:8170 ),
(note:124;wheel:8172 ),(note:124;wheel:8173 ),(note:124;wheel:8175 ),(note:124;wheel:8177 ),
(note:124;wheel:8178 ),(note:124;wheel:8180 ),(note:124;wheel:8182 ),(note:124;wheel:8184 ),
(note:124;wheel:8185 ),(note:124;wheel:8187 ),(note:124;wheel:8189 ),(note:124;wheel:8190 ),
(note:124;wheel:8192 ),(note:124;wheel:8194 ),(note:124;wheel:8195 ),(note:124;wheel:8197 ),
(note:124;wheel:8199 ),(note:124;wheel:8200 ),(note:124;wheel:8202 ),(note:124;wheel:8204 ),
(note:124;wheel:8205 ),(note:124;wheel:8207 ),(note:124;wheel:8209 ),(note:124;wheel:8210 ),
(note:124;wheel:8212 ),(note:124;wheel:8214 ),(note:124;wheel:8215 ),(note:124;wheel:8217 ),
(note:124;wheel:8219 ),(note:124;wheel:8220 ),(note:124;wheel:8222 ),(note:124;wheel:8224 ),
(note:124;wheel:8225 ),(note:124;wheel:8227 ),(note:124;wheel:8229 ),(note:124;wheel:8230 ),
(note:124;wheel:8232 ),(note:124;wheel:8234 ),(note:124;wheel:8235 ),(note:124;wheel:8237 ),
(note:124;wheel:8239 ),(note:124;wheel:8240 ),(note:124;wheel:8242 ),(note:124;wheel:8244 ),
(note:124;wheel:8245 ),(note:124;wheel:8247 ),(note:124;wheel:8249 ),(note:124;wheel:8250 ),
(note:124;wheel:8252 ),(note:124;wheel:8254 ),(note:124;wheel:8255 ),(note:124;wheel:8257 ),
(note:124;wheel:8259 ),(note:124;wheel:8260 ),(note:124;wheel:8262 ),(note:124;wheel:8264 ),
(note:124;wheel:8265 ),(note:124;wheel:8267 ),(note:124;wheel:8269 ),(note:124;wheel:8270 ),
(note:124;wheel:8272 ),(note:124;wheel:8274 ),(note:124;wheel:8275 ),(note:124;wheel:8277 ),
(note:124;wheel:8279 ),(note:124;wheel:8280 ),(note:124;wheel:8282 ),(note:124;wheel:8284 ),
(note:124;wheel:8285 ),(note:124;wheel:8287 ),(note:124;wheel:8289 ),(note:124;wheel:8290 ),
(note:124;wheel:8292 ),(note:124;wheel:8294 ),(note:124;wheel:8295 ),(note:124;wheel:8297 ),
(note:124;wheel:8299 ),(note:124;wheel:8300 ),(note:124;wheel:8302 ),(note:124;wheel:8303 ),
(note:124;wheel:8305 ),(note:124;wheel:8307 ),(note:124;wheel:8308 ),(note:124;wheel:8310 ),
(note:124;wheel:8312 ),(note:124;wheel:8313 ),(note:124;wheel:8315 ),(note:124;wheel:8317 ),
(note:124;wheel:8318 ),(note:124;wheel:8320 ),(note:124;wheel:8322 ),(note:124;wheel:8323 ),
(note:124;wheel:8325 ),(note:124;wheel:8326 ),(note:124;wheel:8328 ),(note:124;wheel:8330 ),
(note:124;wheel:8331 ),(note:124;wheel:8333 ),(note:124;wheel:8335 ),(note:124;wheel:8336 ),
(note:124;wheel:8338 ),(note:124;wheel:8340 ),(note:124;wheel:8341 ),(note:124;wheel:8343 ),
(note:124;wheel:8345 ),(note:124;wheel:8346 ),(note:124;wheel:8348 ),(note:124;wheel:8349 ),
(note:124;wheel:8351 ),(note:124;wheel:8353 ),(note:124;wheel:8354 ),(note:124;wheel:8356 ),
(note:124;wheel:8358 ),(note:124;wheel:8359 ),(note:124;wheel:8361 ),(note:125;wheel:8021 ),
(note:125;wheel:8023 ),(note:125;wheel:8024 ),(note:125;wheel:8026 ),(note:125;wheel:8028 ),
(note:125;wheel:8029 ),(note:125;wheel:8031 ),(note:125;wheel:8033 ),(note:125;wheel:8034 ),
(note:125;wheel:8036 ),(note:125;wheel:8037 ),(note:125;wheel:8039 ),(note:125;wheel:8041 ),
(note:125;wheel:8042 ),(note:125;wheel:8044 ),(note:125;wheel:8046 ),(note:125;wheel:8047 ),
(note:125;wheel:8049 ),(note:125;wheel:8051 ),(note:125;wheel:8052 ),(note:125;wheel:8054 ),
(note:125;wheel:8055 ),(note:125;wheel:8057 ),(note:125;wheel:8059 ),(note:125;wheel:8060 ),
(note:125;wheel:8062 ),(note:125;wheel:8063 ),(note:125;wheel:8065 ),(note:125;wheel:8067 ),
(note:125;wheel:8068 ),(note:125;wheel:8070 ),(note:125;wheel:8072 ),(note:125;wheel:8073 ),
(note:125;wheel:8075 ),(note:125;wheel:8076 ),(note:125;wheel:8078 ),(note:125;wheel:8080 ),
(note:125;wheel:8081 ),(note:125;wheel:8083 ),(note:125;wheel:8085 ),(note:125;wheel:8086 ),
(note:125;wheel:8088 ),(note:125;wheel:8089 ),(note:125;wheel:8091 ),(note:125;wheel:8093 ),
(note:125;wheel:8094 ),(note:125;wheel:8096 ),(note:125;wheel:8097 ),(note:125;wheel:8099 ),
(note:125;wheel:8101 ),(note:125;wheel:8102 ),(note:125;wheel:8104 ),(note:125;wheel:8105 ),
(note:125;wheel:8107 ),(note:125;wheel:8109 ),(note:125;wheel:8110 ),(note:125;wheel:8112 ),
(note:125;wheel:8114 ),(note:125;wheel:8115 ),(note:125;wheel:8117 ),(note:125;wheel:8118 ),
(note:125;wheel:8120 ),(note:125;wheel:8122 ),(note:125;wheel:8123 ),(note:125;wheel:8125 ),
(note:125;wheel:8126 ),(note:125;wheel:8128 ),(note:125;wheel:8130 ),(note:125;wheel:8131 ),
(note:125;wheel:8133 ),(note:125;wheel:8134 ),(note:125;wheel:8136 ),(note:125;wheel:8138 ),
(note:125;wheel:8139 ),(note:125;wheel:8141 ),(note:125;wheel:8142 ),(note:125;wheel:8144 ),
(note:125;wheel:8146 ),(note:125;wheel:8147 ),(note:125;wheel:8149 ),(note:125;wheel:8150 ),
(note:125;wheel:8152 ),(note:125;wheel:8154 ),(note:125;wheel:8155 ),(note:125;wheel:8157 ),
(note:125;wheel:8158 ),(note:125;wheel:8160 ),(note:125;wheel:8162 ),(note:125;wheel:8163 ),
(note:125;wheel:8165 ),(note:125;wheel:8166 ),(note:125;wheel:8168 ),(note:125;wheel:8170 ),
(note:125;wheel:8171 ),(note:125;wheel:8173 ),(note:125;wheel:8174 ),(note:125;wheel:8176 ),
(note:125;wheel:8177 ),(note:125;wheel:8179 ),(note:125;wheel:8181 ),(note:125;wheel:8182 ),
(note:125;wheel:8184 ),(note:125;wheel:8185 ),(note:125;wheel:8187 ),(note:125;wheel:8189 ),
(note:125;wheel:8190 ),(note:125;wheel:8192 ),(note:125;wheel:8193 ),(note:125;wheel:8195 ),
(note:125;wheel:8197 ),(note:125;wheel:8198 ),(note:125;wheel:8200 ),(note:125;wheel:8201 ),
(note:125;wheel:8203 ),(note:125;wheel:8204 ),(note:125;wheel:8206 ),(note:125;wheel:8208 ),
(note:125;wheel:8209 ),(note:125;wheel:8211 ),(note:125;wheel:8212 ),(note:125;wheel:8214 ),
(note:125;wheel:8216 ),(note:125;wheel:8217 ),(note:125;wheel:8219 ),(note:125;wheel:8220 ),
(note:125;wheel:8222 ),(note:125;wheel:8223 ),(note:125;wheel:8225 ),(note:125;wheel:8227 ),
(note:125;wheel:8228 ),(note:125;wheel:8230 ),(note:125;wheel:8231 ),(note:125;wheel:8233 ),
(note:125;wheel:8234 ),(note:125;wheel:8236 ),(note:125;wheel:8238 ),(note:125;wheel:8239 ),
(note:125;wheel:8241 ),(note:125;wheel:8242 ),(note:125;wheel:8244 ),(note:125;wheel:8245 ),
(note:125;wheel:8247 ),(note:125;wheel:8249 ),(note:125;wheel:8250 ),(note:125;wheel:8252 ),
(note:125;wheel:8253 ),(note:125;wheel:8255 ),(note:125;wheel:8256 ),(note:125;wheel:8258 ),
(note:125;wheel:8260 ),(note:125;wheel:8261 ),(note:125;wheel:8263 ),(note:125;wheel:8264 ),
(note:125;wheel:8266 ),(note:125;wheel:8267 ),(note:125;wheel:8269 ),(note:125;wheel:8271 ),
(note:125;wheel:8272 ),(note:125;wheel:8274 ),(note:125;wheel:8275 ),(note:125;wheel:8277 ),
(note:125;wheel:8278 ),(note:125;wheel:8280 ),(note:125;wheel:8281 ),(note:125;wheel:8283 ),
(note:125;wheel:8285 ),(note:125;wheel:8286 ),(note:125;wheel:8288 ),(note:125;wheel:8289 ),
(note:125;wheel:8291 ),(note:125;wheel:8292 ),(note:125;wheel:8294 ),(note:125;wheel:8296 ),
(note:125;wheel:8297 ),(note:125;wheel:8299 ),(note:125;wheel:8300 ),(note:125;wheel:8302 ),
(note:125;wheel:8303 ),(note:125;wheel:8305 ),(note:125;wheel:8306 ),(note:125;wheel:8308 ),
(note:125;wheel:8310 ),(note:125;wheel:8311 ),(note:125;wheel:8313 ),(note:125;wheel:8314 ),
(note:125;wheel:8316 ),(note:125;wheel:8317 ),(note:125;wheel:8319 ),(note:125;wheel:8320 ),
(note:125;wheel:8322 ),(note:125;wheel:8324 ),(note:125;wheel:8325 ),(note:125;wheel:8327 ),
(note:125;wheel:8328 ),(note:125;wheel:8330 ),(note:125;wheel:8331 ),(note:125;wheel:8333 ),
(note:125;wheel:8334 ),(note:125;wheel:8336 ),(note:125;wheel:8337 ),(note:125;wheel:8339 ),
(note:125;wheel:8341 ),(note:125;wheel:8342 ),(note:125;wheel:8344 ),(note:125;wheel:8345 ),
(note:125;wheel:8347 ),(note:125;wheel:8348 ),(note:125;wheel:8350 ),(note:125;wheel:8351 ),
(note:125;wheel:8353 ),(note:125;wheel:8354 ),(note:125;wheel:8356 ),(note:125;wheel:8358 ),
(note:125;wheel:8359 ),(note:125;wheel:8361 ),(note:126;wheel:8021 ),(note:126;wheel:8022 ),
(note:126;wheel:8024 ),(note:126;wheel:8025 ),(note:126;wheel:8027 ),(note:126;wheel:8029 ),
(note:126;wheel:8030 ),(note:126;wheel:8032 ),(note:126;wheel:8033 ),(note:126;wheel:8035 ),
(note:126;wheel:8036 ),(note:126;wheel:8038 ),(note:126;wheel:8039 ),(note:126;wheel:8041 ),
(note:126;wheel:8042 ),(note:126;wheel:8044 ),(note:126;wheel:8045 ),(note:126;wheel:8047 ),
(note:126;wheel:8049 ),(note:126;wheel:8050 ),(note:126;wheel:8052 ),(note:126;wheel:8053 ),
(note:126;wheel:8055 ),(note:126;wheel:8056 ),(note:126;wheel:8058 ),(note:126;wheel:8059 ),
(note:126;wheel:8061 ),(note:126;wheel:8062 ),(note:126;wheel:8064 ),(note:126;wheel:8065 ),
(note:126;wheel:8067 ),(note:126;wheel:8068 ),(note:126;wheel:8070 ),(note:126;wheel:8071 ),
(note:126;wheel:8073 ),(note:126;wheel:8075 ),(note:126;wheel:8076 ),(note:126;wheel:8078 ),
(note:126;wheel:8079 ),(note:126;wheel:8081 ),(note:126;wheel:8082 ),(note:126;wheel:8084 ),
(note:126;wheel:8085 ),(note:126;wheel:8087 ),(note:126;wheel:8088 ),(note:126;wheel:8090 ),
(note:126;wheel:8091 ),(note:126;wheel:8093 ),(note:126;wheel:8094 ),(note:126;wheel:8096 ),
(note:126;wheel:8097 ),(note:126;wheel:8099 ),(note:126;wheel:8100 ),(note:126;wheel:8102 ),
(note:126;wheel:8103 ),(note:126;wheel:8105 ),(note:126;wheel:8107 ),(note:126;wheel:8108 ),
(note:126;wheel:8110 ),(note:126;wheel:8111 ),(note:126;wheel:8113 ),(note:126;wheel:8114 ),
(note:126;wheel:8116 ),(note:126;wheel:8117 ),(note:126;wheel:8119 ),(note:126;wheel:8120 ),
(note:126;wheel:8122 ),(note:126;wheel:8123 ),(note:126;wheel:8125 ),(note:126;wheel:8126 ),
(note:126;wheel:8128 ),(note:126;wheel:8129 ),(note:126;wheel:8131 ),(note:126;wheel:8132 ),
(note:126;wheel:8134 ),(note:126;wheel:8135 ),(note:126;wheel:8137 ),(note:126;wheel:8138 ),
(note:126;wheel:8140 ),(note:126;wheel:8141 ),(note:126;wheel:8143 ),(note:126;wheel:8144 ),
(note:126;wheel:8146 ),(note:126;wheel:8147 ),(note:126;wheel:8149 ),(note:126;wheel:8150 ),
(note:126;wheel:8152 ),(note:126;wheel:8153 ),(note:126;wheel:8155 ),(note:126;wheel:8156 ),
(note:126;wheel:8158 ),(note:126;wheel:8159 ),(note:126;wheel:8161 ),(note:126;wheel:8162 ),
(note:126;wheel:8164 ),(note:126;wheel:8165 ),(note:126;wheel:8167 ),(note:126;wheel:8168 ),
(note:126;wheel:8170 ),(note:126;wheel:8171 ),(note:126;wheel:8173 ),(note:126;wheel:8174 ),
(note:126;wheel:8176 ),(note:126;wheel:8177 ),(note:126;wheel:8179 ),(note:126;wheel:8180 ),
(note:126;wheel:8182 ),(note:126;wheel:8183 ),(note:126;wheel:8185 ),(note:126;wheel:8186 ),
(note:126;wheel:8188 ),(note:126;wheel:8189 ),(note:126;wheel:8191 ),(note:126;wheel:8192 ),
(note:126;wheel:8194 ),(note:126;wheel:8195 ),(note:126;wheel:8197 ),(note:126;wheel:8198 ),
(note:126;wheel:8200 ),(note:126;wheel:8201 ),(note:126;wheel:8203 ),(note:126;wheel:8204 ),
(note:126;wheel:8206 ),(note:126;wheel:8207 ),(note:126;wheel:8209 ),(note:126;wheel:8210 ),
(note:126;wheel:8212 ),(note:126;wheel:8213 ),(note:126;wheel:8215 ),(note:126;wheel:8216 ),
(note:126;wheel:8218 ),(note:126;wheel:8219 ),(note:126;wheel:8221 ),(note:126;wheel:8222 ),
(note:126;wheel:8224 ),(note:126;wheel:8225 ),(note:126;wheel:8227 ),(note:126;wheel:8228 ),
(note:126;wheel:8230 ),(note:126;wheel:8231 ),(note:126;wheel:8233 ),(note:126;wheel:8234 ),
(note:126;wheel:8236 ),(note:126;wheel:8237 ),(note:126;wheel:8239 ),(note:126;wheel:8240 ),
(note:126;wheel:8242 ),(note:126;wheel:8243 ),(note:126;wheel:8245 ),(note:126;wheel:8246 ),
(note:126;wheel:8248 ),(note:126;wheel:8249 ),(note:126;wheel:8251 ),(note:126;wheel:8252 ),
(note:126;wheel:8254 ),(note:126;wheel:8255 ),(note:126;wheel:8257 ),(note:126;wheel:8258 ),
(note:126;wheel:8259 ),(note:126;wheel:8261 ),(note:126;wheel:8262 ),(note:126;wheel:8264 ),
(note:126;wheel:8265 ),(note:126;wheel:8267 ),(note:126;wheel:8268 ),(note:126;wheel:8270 ),
(note:126;wheel:8271 ),(note:126;wheel:8273 ),(note:126;wheel:8274 ),(note:126;wheel:8276 ),
(note:126;wheel:8277 ),(note:126;wheel:8279 ),(note:126;wheel:8280 ),(note:126;wheel:8282 ),
(note:126;wheel:8283 ),(note:126;wheel:8285 ),(note:126;wheel:8286 ),(note:126;wheel:8288 ),
(note:126;wheel:8289 ),(note:126;wheel:8290 ),(note:126;wheel:8292 ),(note:126;wheel:8293 ),
(note:126;wheel:8295 ),(note:126;wheel:8296 ),(note:126;wheel:8298 ),(note:126;wheel:8299 ),
(note:126;wheel:8301 ),(note:126;wheel:8302 ),(note:126;wheel:8304 ),(note:126;wheel:8305 ),
(note:126;wheel:8307 ),(note:126;wheel:8308 ),(note:126;wheel:8310 ),(note:126;wheel:8311 ),
(note:126;wheel:8313 ),(note:126;wheel:8314 ),(note:126;wheel:8315 ),(note:126;wheel:8317 ),
(note:126;wheel:8318 ),(note:126;wheel:8320 ),(note:126;wheel:8321 ),(note:126;wheel:8323 ),
(note:126;wheel:8324 ),(note:126;wheel:8326 ),(note:126;wheel:8327 ),(note:126;wheel:8329 ),
(note:126;wheel:8330 ),(note:126;wheel:8332 ),(note:126;wheel:8333 ),(note:126;wheel:8334 ),
(note:126;wheel:8336 ),(note:126;wheel:8337 ),(note:126;wheel:8339 ),(note:126;wheel:8340 ),
(note:126;wheel:8342 ),(note:126;wheel:8343 ),(note:126;wheel:8345 ),(note:126;wheel:8346 ),
(note:126;wheel:8348 ),(note:126;wheel:8349 ),(note:126;wheel:8351 ),(note:126;wheel:8352 ),
(note:126;wheel:8353 ),(note:126;wheel:8355 ),(note:126;wheel:8356 ),(note:126;wheel:8358 ),
(note:126;wheel:8359 ),(note:126;wheel:8361 ),(note:127;wheel:8021 ),(note:127;wheel:8022 ),
(note:127;wheel:8024 ),(note:127;wheel:8025 ),(note:127;wheel:8027 ),(note:127;wheel:8028 ),
(note:127;wheel:8030 ),(note:127;wheel:8031 ),(note:127;wheel:8032 ),(note:127;wheel:8034 ),
(note:127;wheel:8035 ),(note:127;wheel:8037 ),(note:127;wheel:8038 ),(note:127;wheel:8040 ),
(note:127;wheel:8041 ),(note:127;wheel:8043 ),(note:127;wheel:8044 ),(note:127;wheel:8046 ),
(note:127;wheel:8047 ),(note:127;wheel:8048 ),(note:127;wheel:8050 ),(note:127;wheel:8051 ),
(note:127;wheel:8053 ),(note:127;wheel:8054 ),(note:127;wheel:8056 ),(note:127;wheel:8057 ),
(note:127;wheel:8059 ),(note:127;wheel:8060 ),(note:127;wheel:8061 ),(note:127;wheel:8063 ),
(note:127;wheel:8064 ),(note:127;wheel:8066 ),(note:127;wheel:8067 ),(note:127;wheel:8069 )
);

var
MasterVolume :integer = 200-1;
MasterSwitch :integer = $FF-1;

SndRate :integer     = 0;
NoiseGen :int64;

hWave :HWAVEOUT  = 0;
hMIDI :HMIDIOUT  = 0;
ThreadID :DWORD   = 0;

Buf:array[0..SND_BUFFERS,0..SND_BUFSIZE]of char;
Header:array[0..SND_BUFFERS]of WAVEHDR;
Volume:array[0..SND_CHANNELS]of integer;
Freq:array[0..SND_CHANNELS]of integer;
Type1:array[0..SND_CHANNELS]of integer;
Note:array[0..SND_CHANNELS]of integer;
Pitch:array[0..SND_CHANNELS]of integer;
Level:array[0..SND_CHANNELS]of integer;
Count:array[0..SND_CHANNELS]of integer;
Wave:array[0..SND_BUFSIZE]of integer;

function ThreadFunc(Param:LPDWORD):dword;
function InitWave(_hInst:hinst; Rate:integer; Buffers:integer):integer;
function InitMIDI(_hInst:hinst):integer;
procedure NoteOn(Channel:integer; NewNote:integer);
procedure NoteOff(Channel:integer);
procedure ChangePitch(Channel:integer;  NewPitch:integer);
procedure ChangeLevel(Channel:integer;  NewLevel:integer);
procedure TrashSound;
procedure Sound(Channel,NewFreq, NewVolume:integer);
function InitSound(_hInst:hinst; Rate:integer; Buffers:integer):integer;
procedure SetChannels(Volume:integer; Switch:integer);
procedure SetFreq(Channel:integer; NewFreq:integer);
procedure SetVolume(Channel:integer; NewVolume:integer);

implementation


(** InitSound() **********************************************)
(** Initialize sound. Returns 0 on failure, effective rate  **)
(** otherwise. Special cases of rate argument:0 - return 1 **)
(** and be silent, 1..8191 - use MIDI mapper to play music. **)
(*************************************************************)
function InitSound(_hInst:hinst; Rate:integer; Buffers:integer):integer;
var
J:integer;
begin

  (* If initialized, shut down *)
  TrashSound;

  (* Reset variables *)
  MasterVolume:=200;
  MasterSwitch:=$FF;
  SndRate:=0;
  ThreadID:=0;
  hWave:=0;
  hMIDI:=0;
  NoiseGen:=1;

  (* No sound requested:EXIT *)
  if(Rate = 0)then result := 1;

  (* Reset channels *)
  for J:=0 to SND_CHANNELS-1 do
  begin
  Count[J]:=0;
  Level[J]:=0;
   Volume[J]:=Count[J];
   Pitch[J]:=Level[J];
    Freq[J]:=Volume[J];
    Note[J]:=Pitch[J];
    Type1[J]:=SND_MELODIC;
  end;

  if rate>8192 then
  result := InitWave(_hInst,Rate,Buffers)
  else
  result := InitMIDI(_hInst);

end;

(** TrashSound() *********************************************)
(** Close all devices and free all allocated resources.     **)
(*************************************************************)
procedure TrashSound;
begin
  (* Sound off *)
  SndRate:=0;

  (* Close waveOut if necessary *)
  if(hWave <> 0) then
    while(waveOutClose(hWave)=WAVERR_STILLPLAYING) do
      waveOutReset(hWave);

  (* Close midiOut if necessary *)
  if (hMIDI <>0)then begin midiOutReset(hMIDI);midiOutClose(hMIDI); end;

  hWave:=0;hMIDI:=0;
end;

(** SetSound() ***********************************************)
(** Set sound type for a given channel.                     **)
(*************************************************************)
procedure SetSound(Channel:integer; NewType:integer);
var
Programs:array[0..3]of integer;
begin
  Programs[0] := 80;
  Programs[1] := 126;
  Programs[2] := 125;
  Programs[3] := 80;

  Type1[Channel]:=NewType;
  if(SndRate = 0) then exit;
  if(SndRate<8192) then
    midiOutShortMsg(hMIDI,(Programs[NewType and $03]shl 8)or (Channel and $0F) or $C0);
end;

(** SetFreq() ************************************************)
(** Set sound frequency for a given channel.                **)
(*************************************************************)
procedure SetFreq(Channel:integer; NewFreq:integer);
begin
  if(SndRate = 0) then exit;
  if(SndRate<8192) then Sound(Channel,NewFreq,Volume[Channel])
  else PostThreadMessage(ThreadID,SND_MSG_FREQ,Channel,NewFreq);
end;

(** SetVolume() **********************************************)
(** Set sound volume for a given channel.                   **)
(*************************************************************)
procedure SetVolume(Channel:integer; NewVolume:integer);
begin
  if(SndRate = 0)then exit;
  if(SndRate<8192) then Sound(Channel,Freq[Channel],NewVolume)
  else PostThreadMessage(ThreadID,SND_MSG_VOLUME,Channel,NewVolume);
end;

(** Sound() **************************************************)
(** Set sound volume and frequency for a given channel.     **)
(*************************************************************)
procedure Sound(Channel,NewFreq, NewVolume:integer);
begin
  if(SndRate = 0)then exit;
  NewVolume := NewVolume  and $FF;

  if(SndRate>=8192)  then
    PostThreadMessage  (ThreadID,SND_MSG_SOUND,Channel,NewVolume+(NewFreq shl 8))
  else
  begin
    (* Clip the frequency *)
    if (NewFreq<3*3) or (NewFreq>=4096*3) then NewFreq:=0;

    (* Store new frequency/volume *)
    Freq[Channel]:=NewFreq;
    Volume[Channel]:=NewVolume;

    (* MIDI volume is 0..127, frequency is 0..4095 *)
    NewVolume:=NewVolume div 2;
    NewFreq := NewFreq div 3;

    (* Only if channel is on *)
    if boolean(MasterSwitch and (1 shl Channel)) then
      if(NewVolume = 0) or (NewFreq = 0) then NoteOff(Channel)
      else
      begin
        (* Important:volume/pitch changes done when note off *)
        if(Note[Channel]<> Freqs[NewFreq].Note)then NoteOff(Channel);

        (* Set volume and pitch *)
        ChangeLevel(Channel,NewVolume);
        ChangePitch(Channel,Freqs[NewFreq].Wheel);

        (* Start playing a note *)
        NoteOn(Channel,Freqs[NewFreq].Note);
      end;
  end;
end;

(** SetChannels() ********************************************)
(** Set overall sound volume and switch channels on/off.    **)
(*************************************************************)
procedure SetChannels(Volume:integer; Switch:integer);
var
 J:integer;
begin

  if(SndRate = 0)then exit;

  Volume :=  Volume and $FF;
  MasterVolume:=Volume;
  Switch := Switch and ((1 shl SND_CHANNELS)-1);

    if(Switch = 0) and (MasterSwitch <> 0) then waveOutPause(hWave);
    if (Switch <> 0)and (MasterSwitch = 0)then waveOutRestart(hWave);
    waveOutSetVolume(UINT(hWave),Volume*$1000100);
  MasterSwitch:=Switch;
end;

(** NoteOn() *************************************************)
(** Play a new note.                                        **)
(*************************************************************)
procedure NoteOn(Channel, NewNote:integer);
begin
 if(NewNote <> Note[Channel]) then
  begin
    if(Note[Channel])<>0 then NoteOff(Channel);
    if(NewNote)<>0 then
      midiOutShortMsg(hMIDI,((NewNote and $7F)shl 8) or (Channel and $0F)or $7F0090);
    Note[Channel]:=NewNote;
  end;
end;

(** NoteOff() ************************************************)
(** Turn off a note.                                        **)
(*************************************************************)
procedure NoteOff(Channel:integer);
begin
  if(Note[Channel])<> 0 then
  begin
    midiOutShortMsg(hMIDI,((Note[Channel]and $7F)shl 8)or(Channel and $0F)or $7F0080);
    Note[Channel]:=0;
  end;
end;

(** ChangePitch() ********************************************)
(** Change channel pitch.                                   **)
(*************************************************************)
procedure ChangePitch(Channel,NewPitch:integer);
begin
  if(NewPitch<>Pitch[Channel]) then
  begin
   midiOutShortMsg(hMIDI,((NewPitch and $3F80)shl 1)or((NewPitch and $7F) shl 8)or(Channel and $0F) or $E0);
    Pitch[Channel]:=NewPitch;
  end;
end;

(** ChangeLevel() ********************************************)
(** Change channel level (volume).                          **)
(*************************************************************)
procedure ChangeLevel(Channel,NewLevel:integer);
begin
  if(NewLevel<>Level[Channel]) then
  begin
    midiOutShortMsg(hMIDI,((NewLevel and $7F)shl 16)or(Channel and $0F)or $07B0);
    Level[Channel]:=NewLevel;
  end;
end;

(** InitWave() ***********************************************)
(** Initialize waveOut. Returns 0 on failure or effective   **)
(** rate otherwise.                                         **)
(*************************************************************)
function InitWave(_hInst:hinst; Rate,Buffers:integer):integer;
var
Format:TPCMWAVEFORMAT;
hThread:THANDLE;
J:integer;
begin

  (* No sound yet *)
  SndRate:=0;

  (* Adjust number of buffers if it is wrong *)
  if(Buffers<2) then Buffers:=2
  else if(Buffers>SND_BUFFERS)then Buffers:=SND_BUFFERS;

  (* Reset headers *)
  for J:=0 to SND_BUFFERS-1 do
    Header[J].dwFlags:=WHDR_DONE;

  (* Create a thread *)
  hThread:=CreateThread(nil,0,@ThreadFunc,nil,0,ThreadID);
  if(hThread = 0)then result :=0;

  (* Sound update thread is time critical *)
  SetThreadPriority(hThread,THREAD_PRIORITY_TIME_CRITICAL);

  (* Let the thread go into message loop *)
  Sleep(1000);

  (* Open WaveOut device *)
  Format.wf.wFormatTag      := WAVE_FORMAT_PCM;
  Format.wf.nChannels       := 1;
  Format.wf.nSamplesPerSec  := Rate;
  Format.wBitsPerSample     := 8;
  Format.wf.nBlockAlign     := (Format.wf.nChannels*Format.wBitsPerSample)div 8;
  Format.wf.nAvgBytesPerSec := Format.wf.nSamplesPerSec*Format.wf.nBlockAlign;
  if (waveOutOpen(@hWave,WAVE_MAPPER,@Format,ThreadID,0,CALLBACK_THREAD)) <> 1 then
  begin PostThreadMessage(ThreadID,MM_WOM_CLOSE,WPARAM(hWave),0);
  result := 0 end;

  (* waveOut opened successfully *)
  SndRate:=Rate;

  (* Initially, pump in from all buffers *)
  for J := 0 to Buffers-1 do
    PostThreadMessage(ThreadID,MM_WOM_DONE,WPARAM(hWave),LPARAM(@Header[J]));

  (* Success! *)
 result := SndRate;
end;

(** InitMIDI() ***********************************************)
(** Initialize midiOut. Returns 0 on failure or 1 otherwise **)
(*************************************************************)
function InitMIDI(_hInst:hinst):integer;
var
Data:DWORD;
J:integer;
begin
  (* No sound yet *)
  SndRate:=0;

  (* Open MIDI mapper *)
  if midiOutOpen(@hMIDI,MIDI_MAPPER,0,0,0)<> MMSYSERR_NOERROR then result := 0;

  (* midiOut opened successfully *)
  SndRate:=1;

  (* Reset MIDI *)
  midiOutReset(hMIDI);
  for J:=0 to SND_CHANNELS-1 do
    midiOutShortMsg(hMIDI,(80 shl 8)or(J and $0F)or $C0);

  (* Success! *)
  result := (SndRate);
end;

(** ThreadFunc() *********************************************)
(** This is a thread responsible for receiving messages     **)
(** from waveOut and pumping new waveform data into it.     **)
(*************************************************************)
function ThreadFunc(Param:LPDWORD):DWORD;
var
   N,J,K,I,L1,L2,V:integer;
   hWave:HWAVEOUT;
   uMsg:MSG;
begin
   V := 0;
  while GetMessage(uMsg,0,0,0) = true do
  begin
    case uMsg.message of
    SND_MSG_VOLUME:
    begin
    Volume[uMsg.wParam]:=uMsg.lParam and $FF;
    end;

    SND_MSG_FREQ:
    begin
    if uMsg.lParam>(SndRate div 2) then
    Freq[uMsg.wParam]:= uMsg.lParam;
    end;

    SND_MSG_SOUND:
    begin
    Volume[uMsg.wParam]:=uMsg.lParam and $FF;
    uMsg.lParam :=    uMsg.lParam shr 8;
    if uMsg.lParam>(SndRate div 2) then
    Freq[uMsg.wParam]:= uMsg.lParam;
    end;

     MM_WOM_CLOSE:result := 0;

      MM_WOM_DONE:begin
        (* Sound must be properly initialized *)
        if(SndRate<8192) then break;

        (* Get header number and waveOut handle *)
        N:=((uMsg.lParam));
        hWave:=HWAVEOUT(uMsg.wParam);

        (* Waveform generator *)
        for J:=0 to SND_CHANNELS-1 do
        begin
          if (Freq[J] <> 0)and(V=Volume[J]) and (MasterSwitch and (1 shl J)  <> 0) then
          begin
            case Type1[J] of
                  SND_MELODIC: (* Melodic Sound *)
                  begin
                  K:=$10000*Freq[J] div SndRate;
                  L1:=Count[J];
                  for I:=0 to SND_BUFSIZE-1 do
                  begin
                  L2:=L1+K;
                  Wave[I]:=Wave[I]+V*(L1 and $8000);//? (L2&$8000? 32767:0):(L2&$8000? 0:-32767));
                  L1:=L2;
                  end;
                  Count[J]:=L1;
                  end;

                  SND_NOISE: (* White Noise *)
                  begin
                  K:=$10000*Freq[J] div SndRate;
                  L1:=Count[J];
                  for I:=0 to SND_BUFSIZE-1 do
                  begin
                  L1:=L1+K;
                  if(L1 and $FFFF0000 <>0) then
                  begin
                  L1:=L1 and $FFFF;
                  if NoiseGen=(NoiseGen shl 1 and $80000000) then NoiseGen := NoiseGen xor $08000001;
                  end;
                  Wave[I]:=Wave[I]+V*(NoiseGen and 1);//? 32767:-32767);
                  end;
                  Count[J]:=L1;
                  end;

                 end;
            end;
       end;


        (* Mix and convert waveforms *)
        for J:=0 to SND_BUFSIZE-1 do
        begin
          I:=Wave[J] div SND_CHANNELS div 256;
          Buf[N][J]:=char(I div 256 +128);
          Wave[J]:=0;
        end;

        (* Send buffer to the wave device *)
        waveOutUnprepareHeader(hWave,@Header[N],sizeof(WAVEHDR));
        Header[N].lpData         := Buf[N];
        Header[N].dwBufferLength := SND_BUFSIZE;
        Header[N].dwFlags        := 0;
        Header[N].dwLoops        := 0;
        if(waveOutPrepareHeader(hWave,@Header[N],sizeof(WAVEHDR))) = 0 then
          waveOutWrite(hWave,@Header[N],sizeof(WAVEHDR));
    end;
  end;
end;
result := 0;
end;


end.
