unit nes_mmc;

interface
uses windows,c6502,global;

const	DISABLE	=  0;
const	ENABLE	= 1;

type
  TMMCWrite = procedure (Addr : word; value : byte);
  procedure VROM_BANK1(A : word; V : byte);
  procedure VROM_BANK4(A : word; V : byte);
  procedure VROM_BANK8(A : word; V : byte);
  procedure ROM_BANK8(A : word; V : byte);
  procedure ROM_BANK16(A : word; V : byte);
  procedure ROM_BANK32(A : word; V : byte);
  { NO MAPPER }
  function  MMCInit(MMCType : integer): boolean;
  procedure NONEInit;
  procedure NONEWrite(Addr : word; value : byte);
  procedure MMC1Init;
  procedure MMC1Write(Addr : word; value : byte);

type
Pmap_func = ^map_func;
map_func = record
init:procedure;
write:TMMCWrite;
end;

pmapper = ^tmapper;
tmapper = record
use:Pmap_func;
no:integer;
end;

var
  MMC1_Reg : array[0..3] of byte;
  MMC1_sft,
  MMC1_buf : byte;
  IRQ_counter,IRQ_latch:word;
  IRQ_flg,IRQ_ratch:byte;
  vmask:integer;
  mappers:array[0..199]of map_func;
  currentwrite:TMMCWrite;
  currentinit:procedure;
implementation

uses main,nes, SysUtils;

  procedure VROM_BANK1(A : word; V : byte);
  begin
      if VRomSize>0 then
        VPage[(A shr 10)] := VROM + (V * $400) - A
      else
        VPage[(A shr 10)] := nil; //@VRAM[V * $400] - A;

  end; { VROM_BANK1 }

  procedure VROM_BANK4(A : word; V : byte);
  begin

      if VRomSize>0 then
      begin
        VPage[(A shr 10)] := VROM + (V * $1000) - A;
        VPage[(A shr 10)+1] := VROM + (V * $1000) - A;
        VPage[(A shr 10)+2] := VROM + (V * $1000) - A;
        VPage[(A shr 10)+3] := VROM + (V * $1000) - A;
      end
      else
      begin
        VPage[(A shr 10)] := nil; //PChar(@VRAM + (V * $400) - A);
      end;

  end; { ROM_BANK4 }

  procedure VROM_BANK8(A : word; V : byte);
  begin

      if VRomSize>0 then
      begin
        VPage[(A shr 10)] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+1] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+2] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+3] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+4] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+5] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+6] := VROM + (V * $2000) - A;
        VPage[(A shr 10)+7] := VROM + (V * $2000) - A;
      end
      else
      begin
        VPage[(A shr 10)] := nil; //PChar(@VRAM + (V * $400) - A);
      end;

  end; { ROM_BANK8 }

  procedure ROM_BANK8(A : word; V : byte);
  begin
    Page[(A shr 13)] := PROM + (V * $2000) - A;
  end; { ROM_BANK8 }

  procedure ROM_BANK16(A : word; V : byte);
  begin

      Page[(A shr 13)]     := PROM + (V * $4000) - A;
      Page[(A shr 13) + 1] := PROM + (V * $4000) - A;

  end; { ROM_BANK16 }

  procedure ROM_BANK32(A : word; V : byte);
  begin

      Page[4] := PROM + (V * $8000) - A;
      Page[5] := PROM + (V * $8000) - A;
      Page[6] := PROM + (V * $8000) - A;
      Page[7] := PROM + (V * $8000) - A;
 
  end; { ROM_BANK32 }

  // ******************************************** //
  // **          NONE mapper                   ** //
  // ******************************************** //
  procedure NONEInit;
  var
    LastBank,
    i : integer;
  begin

      LastBank := (RomSize - 1);
      ROM_BANK16($8000, 0);
      ROM_BANK16($C000, LastBank);
      for i:= Low(VPage) to High(VPage) do
        if VROMSize>0 then
          VPage[i] := VROM
        else
          VPage[i] := @VRAM;

	vmask := VROMSize-1;
 end; { NONEInit }

  procedure NONEWrite(Addr : word; value : byte);
  begin
  end; { NONEWrite }

  // ******************************************** //
  // **          MMC1 mapper                   ** //
  // ******************************************** //
  procedure MMC1Init;
  var
     LastBank,i : integer;
  begin
  NONEInit;
  LastBank := (RomSize - 1);
  ROM_BANK16($8000, 0);
  ROM_BANK16($C000, LastBank);
    for i:=0 to 3 do
      MMC1_Reg[i] := 0;
    MMC1_sft := 0;
    MMC1_buf := 0;

  end; { MMC1Init }


procedure MIRROR_SET(Value:byte);
begin
Mirroring:=Value;
Mirrorxor := $400 shl Mirroring;
end;


procedure ROM32_init;
begin
	ROM_BANK32($8000,0);
end;

  procedure MMC1Write(Addr : word; value : byte);
  var
    n : integer;
  begin
    n := (Addr shr 13) - 4;
    if (value and $80)<>0 then
    begin
      MMC1_sft := 0;
      MMC1_buf := 0;
      MMC1_Reg[0] := MMC1_Reg[0] or $0C;
      Exit;
    end;
    MMC1_buf := MMC1_buf or ((value and 1) shl MMC1_sft);
    inc(MMC1_sft);
    if MMC1_sft=5 then
    begin
      MMC1_Reg[n] := MMC1_buf;
      value := MMC1_buf;
      MMC1_sft := 0;
      MMC1_buf := 0;
      case n of
        0 : begin

                if (value and 2)<>0 then
                  MirrorXor := $C00
                else
                begin
                  if Mirroring=(Value and 1) then
                    MirrorXor := ($400 shl 1)
                  else
                    MirrorXor := $400;
                end;
            end;
        1 : begin

                if (MMC1_Reg[0] and $10)<>0 then
                begin
                  VPage[0] := VROM + (value * $1000);
                  VPage[1] := VROM + (value * $1000);
                  VPage[2] := VROM + (value * $1000);
                  VPage[3] := VROM + (value * $1000);
                end
                else
                begin
                  VPage[0] := VROM + ((value shr 1) * $2000);
                end;
            end;
        2 : begin

                if (MMC1_Reg[0] and $10)<>0 then
                begin
                  VPage[($1000 shr 10)]     := VROM + (value * $1000) - $1000;
                  VPage[($1000 shr 10) + 1] := VROM + (value * $1000) - $1000;
                  VPage[($1000 shr 10) + 2] := VROM + (value * $1000) - $1000;
                  VPage[($1000 shr 10) + 3] := VROM + (value * $1000) - $1000;
                end
            end;
        3 : begin

                if (MMC1_Reg[0] and 8)<>0 then
                begin
                  if ((MMC1_Reg[0] and 4)<>0) then
                  begin
                    Page[($8000 shr 13)]     := PROM + (value * $4000) - $8000;
                    Page[($8000 shr 13) + 1] := PROM + (value * $4000) - $8000;
                  end
                  else
                  begin
                    Page[($C000 shr 13)]     := PROM + (value * $4000) - $C000;
                    Page[($C000 shr 13) + 1] := PROM + (value * $4000) - $C000;
                  end;
                end
                else
                begin
                  Page[4] := PROM + ((value shr 1) * $8000) - $8000;
                  Page[5] := PROM + ((value shr 1) * $8000) - $8000;
                  Page[6] := PROM + ((value shr 1) * $8000) - $8000;
                  Page[7] := PROM + ((value shr 1) * $8000) - $8000;
                end;
            end;
      end;
    end;
  end; { MMC1Write }




procedure MMC7_Write(addr:word;Value:byte);
begin
        if(ReadBit( addr, 5 ) = false) then
       begin
         //       MMC_Table := $2000;
         end
        else
        begin
         //       MMC_Table = $2400;
         end;

        Value :=Value and $0F;

    //    MMC_low_base = Value * 32768;
end;


procedure iNES2_write(Addr:word;Value:byte);
begin
	//printf("%04x %02x\n",A,V);
	ROM_BANK16($8000,Value);
end;




procedure VROMsw_write(Addr:word;Value:byte);
begin
	VROM_BANK8($0000,Value and vmask);
end;


{
var MMC3_cmd:byte;
function MMC3_IRQ(scanline:integer):integer;
begin
	if boolean(IRQ_flg) then
        begin
dec(IRQ_counter);
        if (IRQ_counter=0) then result := 1 else  result := 0;
       	end;
  result := 0;
end;

procedure MMC3_init;
begin
ROM_BANK8($C000,0);
ROM_BANK8($8000,0);
VROM_BANK8($0000,0);
end;
}

var
MMC3_cmd:byte;
cbase:integer;


function MMC3_IRQ:integer;
begin
   result := 0;
	if boolean(IRQ_flg) then
        begin
dec(IRQ_counter);
        if (IRQ_counter=0) then result := 1 else  result := 0;
       	end;

end;

procedure MMC3_init;
begin
NONEINIT;
ROM_BANK8($C000,0);
ROM_BANK8($8000,0);
VROM_BANK8($0000,0);
end;


procedure MMC3_write(Addr:word;Value:byte);
var
tempCalc:byte;
begin

	tempCalc := (ROMsize-1)shl 1;
case addr of
        $8000:begin
		MMC3_cmd := Value;
		if(MMC3_cmd and $80)<>0 then
			cbase:=$1000;
		end;
	8001:begin
		case (MMC3_cmd and $07) of
                0:begin
		Value := value and $FE;
		VROM_BANK1(cbase xor $0000,Value);
		VROM_BANK1(cbase xor $0400,Value+1);
		end;
		1:begin
                Value := Value and $FE;
		VROM_BANK1(cbase xor $0800,Value);
		VROM_BANK1(cbase xor $0C00,Value+1);
		end;
		2:begin
		VROM_BANK1(cbase xor $1000,Value);
		end;
                3:begin
		VROM_BANK1(cbase xor $1400,Value);
		end;
		4:begin
		VROM_BANK1(cbase xor $1800,Value);
		end;
                5:begin
		VROM_BANK1(cbase xor $1C00,Value);
		end;
                6:begin
		if (MMC3_cmd and $40) <> 0 then
		begin
		ROM_BANK8($C000,Value);
		ROM_BANK8($8000,tempCalc);
	        end
		else
		begin
		ROM_BANK8($8000,Value);
		ROM_BANK8($C000,tempCalc);
                end;
		end;
                7:begin
                if (MMC3_cmd and $40)<>0 then
		begin
		ROM_BANK8($A000,Value);
		ROM_BANK8($8000,tempCalc);
		end
                else
		begin
		ROM_BANK8($A000,Value);
		ROM_BANK8($C000,tempCalc);
		end;
		end;
	end;
        end;
	$A000:begin
		MIRROR_SET(Value and 1);
	end;
	$A001:begin  end;
	$C000:begin
		IRQ_Counter := IRQ_latch;
		IRQ_flg  := 0;
        end;
	$C001:begin
        IRQ_latch := Value;
	IRQ_flg := 1;
	end;
	$C002:begin
	IRQ_flg := 0;
	end;
	$E000:begin
		IRQ_Counter := IRQ_Latch;
		IRQ_flg  := 0;
		Value  := IRQ_ratch;
	VPage[$C000 shr 13] :=  VPage[$C001 shr 13];
	end;

         $E001:begin IRQ_FLG := 0;  end;
	 $E002:begin end;
	 $E003:begin IRQ_FLG := 0;        end;
	end;

end;

{procedure MMC3_write(Addr:word;Value:byte);
begin
	case Addr of
	$8000:begin MMC3_cmd := Value; end;
	$8001:begin
		case (MMC3_cmd and $C7)
                of
		0:begin Value:=Value and $FE; VROM_BANK1($0000,Value);VROM_BANK1($0400,Value+1); end;
		1:begin Value := Value and $FE; VROM_BANK1($0800,Value);VROM_BANK1($0C00,Value+1); end;
		2:begin VROM_BANK1($1000,Value); end;
		3:begin VROM_BANK1($1400,Value); end;
		4:begin VROM_BANK1($1800,Value); end;
                5: begin
                if boolean(MMC3_cmd and $40) then
                begin
                ROM_BANK8($C000,Value);
                ROM_BANK8($8000,(ROMsize-1)*2);
                end else begin
                ROM_BANK8($8000,Value);
                ROM_BANK8($C000,(ROMsize-1)*2);
                end;
		end;
		6:begin
                if boolean(MMC3_cmd and $40) then begin
                ROM_BANK8($A000,Value);
                ROM_BANK8($8000,(ROMsize-1)*2);
                end else begin
                ROM_BANK8($A000,Value);
                ROM_BANK8($C000,(ROMsize-1)*2);
                end;
                end;
                end;
		end;
	$A000:begin MIRROR_SET(Value and 1); end;
	$A001:begin end;
	$E000:begin Value:=IRQ_ratch; end;
	$C000:begin IRQ_counter:=Value; if(Value=0) then IRQ_flg:=DISABLE; end;
	$C001:begin IRQ_ratch:=Value;end;
	$E001:begin IRQ_flg:=ENABLE;  _n_ := INT_IRQ end;
	end;
end;

}


var
map9_latch1_lo,
map9_latch1_hi,
map9_latch1_state,
map9_latch2_lo,
map9_latch2_hi,
map9_latch2_state:integer;

procedure map9_latchfunc(Addr:word);
begin
    if ((addr and $3ff0) = $0fd0) then begin
	map9_latch1_state := 0;
	Vpage[0] := @vrom[(map9_latch1_lo shl 12) + $0000];
	Vpage[1] := @vrom[(map9_latch1_lo shl 12) + $0400];
	Vpage[2] := @vrom[(map9_latch1_lo shl 12) + $0800];
	Vpage[3] := @vrom[(map9_latch1_lo shl 12) + $0c00];
    end else
    begin
     if ((addr and $3ff0) = $0fe0) then begin
	map9_latch1_state := 1;
	Vpage[0] := @vrom[(map9_latch1_hi shl 12) + $0000];
	Vpage[1] := @vrom[(map9_latch1_hi shl 12) + $0400];
	Vpage[2] := @vrom[(map9_latch1_hi shl 12) + $0800];
	Vpage[3] := @vrom[(map9_latch1_hi shl 12) + $0c00];
       end;
    if ((addr and $3ff0) = $1fd0)then begin
	map9_latch2_state := 0;
	Vpage[4] := @vrom[(map9_latch2_lo shl 12) + $0000];
	Vpage[5] := @vrom[(map9_latch2_lo shl 12) + $0400];
	Vpage[6] := @vrom[(map9_latch2_lo shl 12) + $0800];
	Vpage[7] := @vrom[(map9_latch2_lo shl 12) + $0c00];
    end
    else
    if ((addr and $3ff0) = $1fe0) then
    begin
	map9_latch2_state := 1;
	Vpage[4] := @vrom[(map9_latch2_hi shl 12) + $0000];
	Vpage[5] := @vrom[(map9_latch2_hi shl 12) + $0400];
	Vpage[6] := @vrom[(map9_latch2_hi shl 12) + $0800];
	Vpage[7] := @vrom[(map9_latch2_hi shl 12) + $0c00];
    end;
    end;
end;

procedure mmc9_write(addr:word; value:byte);
begin
    if (addr < $a000) then
    begin

    end
    else
    if (addr < $b000) then
    begin
      //	bank8_reg := value;
     	//sync_banks();
    ROM_BANK8($8000,Value);
    end
    else
    if (addr < $c000) then
    begin
    map9_latch1_lo := value;
    if (map9_latch1_state = 0)then
    begin
    Vpage[0] := @vrom[(value shl 12) + $0000];
    Vpage[1] := @vrom[(value shl 12) + $0400];
    Vpage[2] := @vrom[(value shl 12) + $0800];
    Vpage[3] := @vrom[(value shl 12) + $0c00];
    end;
    end
    else
    if (addr < $d000) then
    begin
    map9_latch1_hi := value;
    if (map9_latch1_state = 1) then
    begin
    Vpage[0] := @vrom[(value shl 12) + $0000];
    Vpage[1] := @vrom[(value shl 12) + $0400];
    Vpage[2] := @vrom[(value shl 12) + $0800];
    Vpage[3] := @vrom[(value shl 12) + $0c00];
    end;
    end
    else
    if (addr < $e000) then
    begin
    map9_latch2_lo := value;
    if (map9_latch2_state = 0) then
    begin
    Vpage[4] := @vrom[(value shl 12) + $0000];
    Vpage[5] := @vrom[(value shl 12) + $0400];
    Vpage[6] := @vrom[(value shl 12) + $0800];
    Vpage[7] := @vrom[(value shl 12) + $0c00];
    end;
    end
    else
    if (addr < $f000) then
    begin
    map9_latch2_hi := value;
    if (map9_latch2_state = 1)  then
    begin
    Vpage[4] := @vrom[(value shl 12) + $0000];
    Vpage[5] := @vrom[(value shl 12) + $0400];
    Vpage[6] := @vrom[(value shl 12) + $0800];
    Vpage[7] := @vrom[(value shl 12) + $0c00];
    end;
    end
    else
    begin
    MIRROR_SET(value and 1);
	{if (value and 1)
        then
        begin
	    PPU_mirror_horizontal();
	end
        else
        begin
	    PPU_mirror_vertical();
	end;}
    end;
end;

procedure mmc9_init;
begin
NONEINIT;
    map9_latch1_state := 1;
    map9_latch2_state := 1;
    //ppu_latchfunc := map9_latchfunc;
       	ROM_BANK16($8000,romsize-2);
       	ROM_BANK16($C000,romsize-1);
        ROM_BANK8($8000,0);

end;

procedure MMC5_write(Addr:word; Value:byte);
begin
 
end;

procedure FFEF4_write(addr:word;Value:byte);
begin
	case Addr of
	$42FC:begin end;
	$42FD:begin end;
	$42EE:begin end;
	$42FF:begin end;
	$43FE:begin end;
	$4500:begin end;
	$4501:begin end;
	$4502:begin end;
	$4503:begin end;
	$8000:begin end;
	$A000:begin end;
	$C000:begin end;
	$E000:begin end;
	end;
end;


procedure ROMsw_init;
begin
	ROM_BANK32($8000,0);
end;

procedure ROMsw_write(Addr:word;Value:byte);
begin
	ROM_BANK32($8000,Value and $f);
//??	if ((V&0x10)==0) nametbl=0x2000; else nametbl=0x2400;
end;


procedure FFEF3_init;
begin
NONEINIT;
	ROM_BANK16($8000,0);
	ROM_BANK16($C000,1);
       	ROM_BANK8($8000,0);
end;

procedure FFEF3_write(Addr:word;Value:byte);
begin
	ROM_BANK16($8000,Value shr 3);
	VROM_BANK8($0000,Value and 7);
end;


var BG_latch:byte;
var SP_latch:byte;

procedure MMC2_init;
begin
	BG_latch:=$FE;
       	ROM_BANK16($8000,romsize-2);
       	ROM_BANK16($C000,romsize-1);
        ROM_BANK8($8000,0);
end;

procedure MMC2_write(Addr:word;Value:byte);
begin
	case (Addr and $F000) of
	$A000:begin
        ROM_BANK8($8000,Value);
        end;
        $B000:begin
	VROM_BANK4($0000,Value);
        end;
	$C000: begin
	VROM_BANK4($0000,Value);
        end;
	$D000: begin
		if (BG_latch=$FD) then VROM_BANK4($1000,Value);
		end;
	$E000: begin
		if (BG_latch=$FE) then VROM_BANK4($1000,Value);
		end;
	$F000: begin
	       	MIRROR_SET(Value and 1);
		end;
	end;
end;


var MMC4_latch1,MMC4_latch2:byte;
procedure MMC4_init;
begin
        MMC4_latch2 :=$FE;
	MMC4_latch1 := MMC4_latch2;
	ROM_BANK16($8000,0);
        ROM_BANK16($C000,0);

end;

procedure MMC4_write(Addr:word;Value:byte);
begin
	case (addr and $F000) of
	$A000: begin
		ROM_BANK16($8000,Value);
		end;
	$B000:  begin
		if (MMC4_latch1=$FD) then VROM_BANK4($0000,Value);
		end;
	$C000:  begin
		if (MMC4_latch1=$FE)then VROM_BANK4($0000,Value);
		end;
	$D000:  begin
		if (MMC4_latch2=$FD) then VROM_BANK4($1000,Value);
		end;
	$E000: begin
		if (MMC4_latch2=$FE) then VROM_BANK4($1000,Value);
               end;
	$F000: begin
		MIRROR_SET(Value and 1);
       

		end;
	end;
end;

procedure iNES11_init;
begin
	ROM_BANK32($8000,0);
	VROM_BANK8($8000,0);
end;

procedure iNES11_write(Addr : word; value : byte);
begin
	ROM_BANK32($8000,Value and 15);
	VROM_BANK8($0000,Value shr 4);
end;


procedure in1_init;
begin
	ROM_BANK32($8000,0);
        VROM_BANK8($0000,0);
end;

procedure in1_write( Addr:word; Value:byte);
begin
case addr of
	 $8000:
         begin
         MIRROR_SET((Value shr 6) and 1);
         Value:=Value and $3F;
         ROM_BANK16($8000,Value);
         ROM_BANK16($C000,Value+1);
         //swap ??
         end;
	$8003:
        begin
        MIRROR_SET((Value shr 6) and 1);
        end;
	$8001:
        begin
	     if boolean(Value and $80)  then begin
			Value:=Value and $3F;
			ROM_BANK8($C000,Value*2+1);
			ROM_BANK8($E000,Value*2);
		end else begin
			ROM_BANK16($C000,Value);
		end;
             end;
	$8002:
        begin
		if boolean(Value and $80) then
                begin
			ROM_BANK8($8000,Value);
		end else
                begin
			ROM_BANK8($8000,Value);
		end;
		end;
	end;
end;


procedure Bandai_init;
begin
         IRQ_counter := 0;
         IRQ_flg := IRQ_counter;
	ROM_BANK16($8000,0);
end;

procedure Bandai_write(Addr:word; Value:byte);
begin
  (* A=$6000..$FFFF
  	 use $60$,$7FFx,$80$
  *)
      case (Addr and $F)
      of
      $0: begin
      VROM_BANK1($0000,Value);
      end;
      $1:begin VROM_BANK1($0400,Value);end;
      $2:begin VROM_BANK1($0800,Value);end;
      $3:begin VROM_BANK1($0C00,Value);end;
      $4:begin VROM_BANK1($1000,Value);end;
      $5:begin VROM_BANK1($1400,Value);end;
      $6:begin VROM_BANK1($1800,Value);end;
      $7:begin VROM_BANK1($1C00,Value);end;
      $8:begin ROM_BANK16($8000,Value);end;
      $9: begin end;//mirror; end;
      $A: begin IRQ_flg:=Value and 1; end;
      $B: begin IRQ_counter := (IRQ_counter and $FF00)or Value;end;
      $C: begin IRQ_counter := (IRQ_counter and $FF) or (Value shl 8);end;
      $D: begin end;///* WRAM read */
      end;
end;

function Bandai_read(Addr:word):byte;
begin
// WRAM write //
	if boolean(Addr and 15) then result := $FF;
    result := $FF;
end;


procedure Bandai1_write(Addr:word; Value:byte);
begin
	ROM_BANK32($8000,(Value shr 4) and 3);
	VROM_BANK8($0000,Value and 3);
end;

procedure Bandai2_write(Addr:word; Value:byte);
begin
	MIRROR_SET(Value shr 7);
	ROM_BANK32($8000,(Value shr 4) and 7);
	VROM_BANK8($0000,Value and 15);
end;


procedure FFEF8_init;
begin
	ROM_BANK16($8000,0);
end;

procedure FFEF8_write(Addr:word; Value:byte);
begin
	case Addr of
	$42FC:begin end; //??
	$42FD:begin end; //??
	$42FE:begin end; // /* mirror*/; end;
	$42FF:begin MIRROR_SET((Value shr 4)and 1); end;
	$4501:begin IRQ_flg :=DISABLE; end;
	$4502:begin  IRQ_counter:=(IRQ_counter and $FF00)or Value;end;
	$4503:begin  IRQ_counter:=(IRQ_counter and $FF) or (Value shl 8);IRQ_flg:=ENABLE;end;
	$4504:begin ROM_BANK8($8000,Value);end;
	$4505:begin ROM_BANK8($A000,Value);end;
	$4506:begin ROM_BANK8($C000,Value);end;
	$4507:begin ROM_BANK8($E000,Value);end;
	$4510:begin VROM_BANK1($0000,Value);end;
	$4511:begin VROM_BANK1($0400,Value);end;
	$4512:begin VROM_BANK1($0800,Value);end;
	$4513:begin VROM_BANK1($0C00,Value);end;
	$4514:begin VROM_BANK1($1000,Value);end;
	$4515:begin VROM_BANK1($1400,Value);end;
	$4516:begin VROM_BANK1($1800,Value);end;
	$4517:begin VROM_BANK1($1C00,Value);end;
	end;
end;

var V0,V1,V2,P0,P1,P2,P3:byte;

procedure Jaleco_init;
begin
     ROM_BANK16($8000,0);
end;

procedure Jaleco_write(Addr:word;Value:byte);
begin
	case Addr of
         $8000:begin V0 := (V0 and $F0)or(Value and 15); ROM_BANK8($8000,V0); end;
         $8001:begin V0 := (V0 and $F) or(Value shl 4); ROM_BANK8($8000,V0); end;
         $8002:begin V1 := (V1 and $F0)or(Value and 15); ROM_BANK8($A000,V1);end;
	 $8003:begin V1 := (V1 and $F) or(Value shl 4); ROM_BANK8($A000,V1); end;
	 $9000:begin V2 := (V2 and $F0)or(Value and 15); ROM_BANK8($C000,V2); end;
	 $9001:begin V2 := (V2 and $F) or(Value shl 4); ROM_BANK8($C000,V2); end;
	 $A000:begin P0 := (P0 and $F0)or(Value and 15); VROM_BANK1($0000,P0); end;
	 $A001:begin P0 := (P0 and $F) or(Value shl 4); VROM_BANK1($0000,P0); end;
	 $A002:begin P1 := (P1 and $F0)or(Value and 15); VROM_BANK1($0400,P1);end;
	 $A003:begin P1 := (P1 and $F) or(Value shl 4); VROM_BANK1($0400,P1); end;
	$E000:begin  IRQ_counter:=(IRQ_counter and $FF00) or Value;end;
	$E001:begin  IRQ_counter:=(IRQ_counter and $FF) or (Value shl 8);end;
	end;
end;

procedure Namco_init;
begin
	ROM_BANK16($8000,0);
	// if (vromsize) VROM_BANK8($0000,0);
end;

procedure Namco_write(Addr:word;Value:byte);
begin
	case (Addr and $F800) of
	$5000:begin end;// IRQ_counter=(IRQ_counter&$FF00)|V;end;
	$5800:begin end;//IRQ_counter=(IRQ_counter&$FF)|((V&7F)<<8);IRQ_flg=V&1;end;
	$8000:begin VROM_BANK1($0000,Value);end;
	$8800:begin VROM_BANK1($0400,Value);end;
	$9000:begin VROM_BANK1($0800,Value);end;
	$9800:begin VROM_BANK1($0C00,Value);end;
	$A000:begin VROM_BANK1($1000,Value);end;
	$A800:begin VROM_BANK1($1400,Value);end;
	$B000:begin VROM_BANK1($1800,Value);end;
	$B800:begin VROM_BANK1($1C00,Value);end;
	$C000:begin VROM_BANK1($2000,Value);end;
	$C800:begin VROM_BANK1($2400,Value);end;
	$D000:begin VROM_BANK1($2800,Value);end;
	$D800:begin VROM_BANK1($2C00,Value);end;
	$E000:begin ROM_BANK8($8000,Value);end;
	$E800:begin ROM_BANK8($A000,Value);end;
	$F000:begin ROM_BANK8($C000,Value);end;
	end;
end;

procedure Konami4_init;
begin
Rom_BANK16($8000,0);
end;

procedure Konami4_write(addr:word; value:byte);
begin
	case addr of
        $8000:begin ROM_BANK8($8000,Value);end;
	$9000:begin ROM_BANK8($A000,Value);end;
	$A000:begin ROM_BANK8($A000,Value);end;
	$B000:begin VROM_BANK1($0000,Value shr 1);end;
	$B001:begin VROM_BANK1($0400,Value shr 1);end;
	$C000:begin VROM_BANK1($0800,Value shr 1);end;
	$C001:begin VROM_BANK1($0C00,Value shr 1);end;
	$D000:begin VROM_BANK1($1000,Value shr 1);end;
	$D001:begin VROM_BANK1($1400,Value shr 1);end;
	$E000:begin VROM_BANK1($1800,Value shr 1);end;
	$E001:begin VROM_BANK1($1C00,Value shr 1);end;
	end;
end;


procedure Konami2A_init;
begin
	ROM_BANK16($8000,0);
	VROM_BANK8($8000,0);
end;

procedure Konami2A_write(addr:word; value:byte);
begin
	case addr of
        $8000:begin ROM_BANK8($8000,Value);end;
	$9000:begin ROM_BANK8($A000,Value);end; //mirror
	$A000:begin ROM_BANK8($A000,Value);end;
	$B000:begin VROM_BANK1($0000,Value shr 1);end;
	$B001:begin VROM_BANK1($0400,Value shr 1);end;
	$C000:begin VROM_BANK1($0800,Value shr 1);end;
	$C001:begin VROM_BANK1($0C00,Value shr 1);end;
	$D000:begin VROM_BANK1($1000,Value shr 1);end;
	$D001:begin VROM_BANK1($1400,Value shr 1);end;
	$E000:begin VROM_BANK1($1800,Value shr 1);end;
	$E001:begin VROM_BANK1($1C00,Value shr 1);end;
	end;
end;



procedure Taito_write(addr:word; value:byte);
begin
	case addr of
	$8000:begin ROM_BANK8($8000,Value and $1F); MIRROR_SET((Value shr 6)and 1); end;
	$8001:begin ROM_BANK8($A000,Value and $1F); end;
      	$8002:begin Value := value *2;VROM_BANK1($0000,Value);VROM_BANK1($0400,Value); end;
	$8003:begin Value := value *2;VROM_BANK1($0800,Value);VROM_BANK1($0C00,Value); end;
	$A000:begin VROM_BANK1($1000,Value); end;
	$A001:begin VROM_BANK1($1400,Value); end;
	$A002:begin VROM_BANK1($1800,Value); end;
	$A003:begin VROM_BANK1($1C00,Value); end;
	$C000:begin  IRQ_counter := Value;end;
	$C001:begin  IRQ_flg := ENABLE;end;
	$C002:begin  IRQ_flg := DISABLE;end;
	$C003:begin  IRQ_counter := Value;end;
	$E000:begin  MIRROR_SET(Value and 1);end;
	end;
end;

procedure Taito2_write(addr:word; value:byte);
begin
	MIRROR_SET(Value shr 7);
	ROM_BANK16($8000,(Value shr 4)and 7);
	VROM_BANK8($0000,Value and 15);
end;

procedure Taito3_write(addr:word; value:byte);
begin
	case addr of
	$7EF0:begin Value :=(Value*$7F);VROM_BANK1($0000,Value);VROM_BANK1($0400,Value+1);end;
	$7EF1:begin Value :=(Value*$7F);VROM_BANK1($0800,Value);VROM_BANK1($0C00,Value+1);end;
	$7EF2:begin VROM_BANK1($1000,Value);end;
	$7EF3:begin VROM_BANK1($1400,Value);end;
	$7EF4:begin VROM_BANK1($1800,Value);end;
	$7EF5:begin VROM_BANK1($1C00,Value);end;
	$7EFA:begin ROM_BANK8($8000,Value);end;
	$7EFB:begin ROM_BANK8($8000,Value);end;
       //	$7EFC:begin ROM_BANK8($A000,Value);end;
	$7EFD:begin ROM_BANK8($A000,Value);end;
      	$7EFC:begin ROM_BANK8($C000,Value);end;
      //	$7EFD:begin ROM_BANK8($C000,Value);end;
	end;
end;


procedure iNES34_write(addr:word; value:byte);
begin
	if (Addr>=$8000) or (Addr=$7FFD)  then
        begin
		ROM_BANK32($8000,Value);
	end else
	case addr of
	$7FFE: begin
		VROM_BANK4($0000,Value);
		end;
	$7FFF: begin
		VROM_BANK4($1000,Value);
		end;
	end;
end;




function MMCInit(MMCType : integer): boolean;
begin
    Result := true;
    IRQ_flg := 0;
    IRQ_counter := 0;


mappers[0].init := @NONEInit;
mappers[0].write := @NONEWrite;
mappers[1].init := @MMC1init;
mappers[1].write := @MMC1write;
mappers[2].init := @NONEInit;
mappers[2].write := @iNES2_write;
mappers[3].init := @NONEInit;
mappers[3].write := @VROMsw_write;
mappers[4].init := @MMC3_init;
mappers[4].write := @MMC3_write;
mappers[6].init := @NONEInit;
mappers[6].write := @MMC5_write;
mappers[7].init := @NONEInit;
mappers[7].write := @FFEF4_write;
mappers[8].init := @FFEF3_init;
mappers[8].write := @FFEF3_write;
mappers[9].init := @MMC9_init;
mappers[9].write := @MMC9_write;
mappers[10].init := @NONEInit;
mappers[10].write := @MMC4_write;
mappers[11].init := @NONEInit;
mappers[11].write := @iNES11_write;
mappers[12].init := @in1_init;
mappers[12].write := @in1_write;
mappers[13].init := @Bandai_init;
mappers[13].write := @Bandai_write;
mappers[14].init := @FFEF8_init;
mappers[14].write := @FFEF8_write;
mappers[15].init := @NONEInit;
mappers[15].write := @Jaleco_write;

currentwrite := mappers[mmctype].write;
currentinit := mappers[mmctype].init;
currentinit;
end;

end.

