unit c6502;

interface

const
  INT_NONE : byte = 0;            //* No interrupt required      */
  INT_IRQ  : byte = 1;            //* Standard IRQ interrupt     */
  INT_NMI  : byte = 2;            //* Non-maskable interrupt     */
  INT_QUIT : byte = 3;            //* Exit the emulation         */

type
  PairByte = record
    h, l : byte;
  end;

  Pair = record
   case integer of
     0 : (B : PairByte);
     1 : (W : word );
  end;

  M6502 = record
    A, P, X, Y, S : byte;
    PC : Pair;
    IPeriod, ICount : integer;
    IRequest : byte;
    AfterCLI : byte;
    IBackup : integer;
    //void *User;
    TrapBadOps : byte;
    Trap : word;
    Trace : byte;
  end;

  procedure Wr6502(Addr : word; Value: byte );register;
  function  Rd6502(Addr : word) : byte; register;
  function  Op6502(Addr : word ): byte; register ;
  function  Loop6502(var R: M6502) : byte; register;
  {$L C6502.OBJ}
  function  Exec6502(var R : M6502) : word; register; external;
  procedure Int6502(var R : M6502; Tp : byte); register; external;
  function  Run6502(var R : M6502) : word; register; external;
  procedure Reset6502(var R : M6502); register; external;



implementation

uses nes;

procedure Wr6502(Addr : word; value: byte );
begin
  MemoryWrite (Addr, value);
end;

function Rd6502(Addr : word): byte;
begin
  Result := MemoryReadByte(Addr);
end;

function Op6502(Addr : word ): byte;
begin
  Result := MemoryReadOpCode(Addr);
end;

function Loop6502(var R: M6502) : byte;
begin
  result :=  cpuLoop;
end;





end.


