unit rsp;

interface
uses windows,sysutils;

procedure rsp_special;
procedure rsp_regimm;
procedure rsp_j;
procedure rsp_jal;
procedure rsp_beq;
procedure rsp_bne;
procedure rsp_blez;
procedure rsp_bgtz;
procedure rsp_addi;
procedure rsp_addiu;
procedure rsp_slti;
procedure rsp_sltiu;
procedure rsp_andi;
procedure rsp_ori;
procedure rsp_xori;
procedure rsp_lui;
procedure rsp_cop0;
procedure rsp_cop2;
procedure rsp_lb;
procedure rsp_lh;
procedure rsp_lw;
procedure rsp_lbu;
procedure rsp_lhu;
procedure rsp_sb;
procedure rsp_sh;
procedure rsp_sw;
procedure rsp_lwc2;
procedure rsp_swc2;
procedure rsp_reserved;




procedure rsp_special_sll;
procedure rsp_special_srl;
procedure rsp_special_sra;
procedure rsp_special_sllv;
procedure rsp_special_srlv;
procedure rsp_special_srav;
procedure rsp_special_jr;
procedure rsp_special_jalr;
procedure rsp_special_break;
procedure rsp_special_add;
procedure rsp_special_addu;
procedure rsp_special_sub;
procedure rsp_special_subu;
procedure rsp_special_and;
procedure rsp_special_or;
procedure rsp_special_xor;
procedure rsp_special_nor;
procedure rsp_special_slt;
procedure rsp_special_sltu;
procedure rsp_special_reserved;




procedure rsp_regimm_bltz;
procedure rsp_regimm_bgez;
procedure rsp_regimm_bltzal;
procedure rsp_regimm_bgezal;
procedure rsp_regimm_reserved;




procedure rsp_cop0_mf;
procedure rsp_cop0_mt;
procedure rsp_cop0_reserved;




procedure rsp_cop2_mf;
procedure rsp_cop2_cf;
procedure rsp_cop2_mt;
procedure rsp_cop2_ct;
procedure rsp_cop2_vectop;
procedure rsp_cop2_reserved;




procedure rsp_cop2_vectop_vmulf;
procedure rsp_cop2_vectop_vmulu;
procedure rsp_cop2_vectop_vrndp;
procedure rsp_cop2_vectop_vmulq;
procedure rsp_cop2_vectop_vmudl;
procedure rsp_cop2_vectop_vmudm;
procedure rsp_cop2_vectop_vmudn;
procedure rsp_cop2_vectop_vmudh;
procedure rsp_cop2_vectop_vmacf;
procedure rsp_cop2_vectop_vmacu;
procedure rsp_cop2_vectop_vrndn;
procedure rsp_cop2_vectop_vmacq;
procedure rsp_cop2_vectop_vmadl;
procedure rsp_cop2_vectop_vmadm;
procedure rsp_cop2_vectop_vmadn;
procedure rsp_cop2_vectop_vmadh;
procedure rsp_cop2_vectop_vadd;
procedure rsp_cop2_vectop_vsub;
procedure rsp_cop2_vectop_vsut;
procedure rsp_cop2_vectop_vabs;
procedure rsp_cop2_vectop_vaddc;
procedure rsp_cop2_vectop_vsubc;
procedure rsp_cop2_vectop_vaddb;
procedure rsp_cop2_vectop_vsubb;
procedure rsp_cop2_vectop_vaccb;
procedure rsp_cop2_vectop_vsucb;
procedure rsp_cop2_vectop_vsad;
procedure rsp_cop2_vectop_vsac;
procedure rsp_cop2_vectop_vsum;
procedure rsp_cop2_vectop_vsaw;
procedure rsp_cop2_vectop_vlt;
procedure rsp_cop2_vectop_veq;
procedure rsp_cop2_vectop_vne;
procedure rsp_cop2_vectop_vge;
procedure rsp_cop2_vectop_vcl;
procedure rsp_cop2_vectop_vch;
procedure rsp_cop2_vectop_vcr;
procedure rsp_cop2_vectop_vmrg;
procedure rsp_cop2_vectop_vand;
procedure rsp_cop2_vectop_vnand;
procedure rsp_cop2_vectop_vor;
procedure rsp_cop2_vectop_vnor;
procedure rsp_cop2_vectop_vxor;
procedure rsp_cop2_vectop_vnxor;
procedure rsp_cop2_vectop_vrcp;
procedure rsp_cop2_vectop_vrcpl;
procedure rsp_cop2_vectop_vrcph;
procedure rsp_cop2_vectop_vmov;
procedure rsp_cop2_vectop_vrsq;
procedure rsp_cop2_vectop_vrsql;
procedure rsp_cop2_vectop_vrsqh;
procedure rsp_cop2_vectop_vnoop;
procedure rsp_cop2_vectop_vextt;
procedure rsp_cop2_vectop_vextq;
procedure rsp_cop2_vectop_vextn;
procedure rsp_cop2_vectop_vinst;
procedure rsp_cop2_vectop_vinsq;
procedure rsp_cop2_vectop_vinsn;
procedure rsp_cop2_vectop_reserved;


var
instruction:array[0..64-1]of procedure =
(
        rsp_special,
        rsp_regimm,
        rsp_j,
        rsp_jal,
        rsp_beq,
        rsp_bne,
        rsp_blez,
        rsp_bgtz,
        rsp_addi,
        rsp_addiu,
        rsp_slti,
        rsp_sltiu,
        rsp_andi,
        rsp_ori,
        rsp_xori,
        rsp_lui,
        rsp_cop0,
        rsp_reserved,
        rsp_cop2,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_lb,
        rsp_lh,
        rsp_reserved,
        rsp_lw,
        rsp_lbu,
        rsp_lhu,
        rsp_reserved,
        rsp_reserved,
        rsp_sb,
        rsp_sh,
        rsp_reserved,
        rsp_sw,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_lwc2,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_swc2,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved,
        rsp_reserved
);





special_instruction:array[0..64-1]of procedure  =
(
        rsp_special_sll,
        rsp_special_reserved,
        rsp_special_srl,
        rsp_special_sra,
        rsp_special_sllv,
        rsp_special_reserved,
        rsp_special_srlv,
        rsp_special_srav,
        rsp_special_jr,
        rsp_special_jalr,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_break,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_add,
        rsp_special_addu,
        rsp_special_sub,
        rsp_special_subu,
        rsp_special_and,
        rsp_special_or,
        rsp_special_xor,
        rsp_special_nor,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_slt,
        rsp_special_sltu,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved,
        rsp_special_reserved
);



regimm_instruction:array[0..32-1]of procedure =
(
        rsp_regimm_bltz,
        rsp_regimm_bgez,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_bltzal,
        rsp_regimm_bgezal,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved,
        rsp_regimm_reserved
);



cop0_instruction:array[0..32-1]of procedure =
(
        rsp_cop0_mf,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_mt,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved,
        rsp_cop0_reserved
);


cop2_instruction:array[0..32-1]of procedure =
(
        rsp_cop2_mf,
        rsp_cop2_reserved,
        rsp_cop2_cf,
        rsp_cop2_reserved,
        rsp_cop2_mt,
        rsp_cop2_reserved,
        rsp_cop2_ct,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_reserved,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop,
        rsp_cop2_vectop
);



cop2_vectop_instruction:array[0..64-1]of procedure =
(
        rsp_cop2_vectop_vmulf,
        rsp_cop2_vectop_vmulu,
        rsp_cop2_vectop_vrndp,
        rsp_cop2_vectop_vmulq,
        rsp_cop2_vectop_vmudl,
        rsp_cop2_vectop_vmudm,
        rsp_cop2_vectop_vmudn,
        rsp_cop2_vectop_vmudh,
        rsp_cop2_vectop_vmacf,
        rsp_cop2_vectop_vmacu,
        rsp_cop2_vectop_vrndn,
        rsp_cop2_vectop_vmacq,
        rsp_cop2_vectop_vmadl,
        rsp_cop2_vectop_vmadm,
        rsp_cop2_vectop_vmadn,
        rsp_cop2_vectop_vmadh,
        rsp_cop2_vectop_vadd,
        rsp_cop2_vectop_vsub,
        rsp_cop2_vectop_vsut,
        rsp_cop2_vectop_vabs,
        rsp_cop2_vectop_vaddc,
        rsp_cop2_vectop_vsubc,
        rsp_cop2_vectop_vaddb,
        rsp_cop2_vectop_vsubb,
        rsp_cop2_vectop_vaccb,
        rsp_cop2_vectop_vsucb,
        rsp_cop2_vectop_vsad,
        rsp_cop2_vectop_vsac,
        rsp_cop2_vectop_vsum,
        rsp_cop2_vectop_vsaw,
        rsp_cop2_vectop_reserved,
        rsp_cop2_vectop_reserved,
        rsp_cop2_vectop_vlt,
        rsp_cop2_vectop_veq,
        rsp_cop2_vectop_vne,
        rsp_cop2_vectop_vge,
        rsp_cop2_vectop_vcl,
        rsp_cop2_vectop_vch,
        rsp_cop2_vectop_vcr,
        rsp_cop2_vectop_vmrg,
        rsp_cop2_vectop_vand,
        rsp_cop2_vectop_vnand,
        rsp_cop2_vectop_vor,
        rsp_cop2_vectop_vnor,
        rsp_cop2_vectop_vxor,
        rsp_cop2_vectop_vnxor,
        rsp_cop2_vectop_reserved,
        rsp_cop2_vectop_reserved,
        rsp_cop2_vectop_vrcp,
        rsp_cop2_vectop_vrcpl,
        rsp_cop2_vectop_vrcph,
        rsp_cop2_vectop_vmov,
        rsp_cop2_vectop_vrsq,
        rsp_cop2_vectop_vrsql,
        rsp_cop2_vectop_vrsqh,
        rsp_cop2_vectop_vnoop,
        rsp_cop2_vectop_vextt,
        rsp_cop2_vectop_vextq,
        rsp_cop2_vectop_vextn,
        rsp_cop2_vectop_reserved,
        rsp_cop2_vectop_vinst,
        rsp_cop2_vectop_vinsq,
        rsp_cop2_vectop_vinsn,
        rsp_cop2_vectop_reserved
);

type rsp_reg_ = record
  r:array[0..32-1]of longint;           // general purpose registers *)
  v:array[0..32-1,0..8-1]of longint;       // vector registers *)
  v_src1:array[0..8-1]of longint;      // dummy source 1 vector registers *)
  v_src2:array[0..8-1]of longint;      // dummy source 2 vector registers *)
  dummy:array[0..8-1]of longint;      // dummy source 2 vector registers *)

  ah:array[0..8-1]of longint;          // high portion of accu *)
  al:array[0..8-1]of longint;          // low  portion of accu *)
  flag:array[0..4-1]of longint;        // cop2 control registers *)
  vrcph_result:longint;       // calculated by VRCPL - stored by VRCPH *)
  vrcph_source:longint;       // used by VRCPL - stored by VRCPH *)
  pc_delay:longint;    // delayed program counter *)
  delay:integer;      // this is for correct emulation of the 6 stage pipeline *)
                            // if(delay ==  0) begin next instr is pc + 4 end; *)
                            // if(delay ==  1) begin next instr is delayed pcend; *)
                            // if(delay == -1) begin exec delayed pcend; *)

  code:longint;
  halt:integer;
  do_or_check_sthg:integer;
  count:longint;
end;



const NO_RSP_DELAY   = 0;
const DO_RSP_DELAY   = 1;
const EXEC_RSP_DELAY = 2;

var
rsp_reg:rsp_reg_;
procedure rsp_dis(code:longint);
implementation
uses unit1,emulate,cpu,global;

function READ_RSP_INSTRUCTION(addr:longint):cardinal;
begin
result := ord(sp_imem[(addr and $fff)]);
end;


function  __CODE:integer;
begin
rsp_reg.code := READ_RSP_INSTRUCTION(sp_reg_pc);
result :=  rsp_reg.code;
end;

function __NEXT_CODE:integer;
begin
result :=     (READ_RSP_INSTRUCTION((sp_reg_pc + 4)));
end;

function __OPCODE:integer;
begin
result := ((__CODE shr 26));
end;

function __RS:integer;
begin
result :=  (((rsp_reg.code shr 21)) and $1f);
end;

function __RT:integer;
begin
result := (((rsp_reg.code shr 16))  and  $1f);
end;

function __RD:integer;
begin
result :=  (((rsp_reg.code shr 11))  and  $1f);
end;

function __SA:integer;
begin
result := (((rsp_reg.code shr  6))  and  $1f);
end;

function __F :integer;
begin
result := ((rsp_reg.code)   and  $3f);
end;

function __I :integer;
begin
result := ( rsp_reg.code );
end;

function __O :integer;
begin
result := (trunc(sp_reg_pc) + 4 + (__I shr 2) );
end;

function __RSP_O(x:longint) :integer;
begin
result := (rsp_reg.code  and  $40);// (* ((rsp_reg.code  and  $7f) | $80) : (rsp_reg.code  and  $7f))) shl x );
end;

function ____T :integer;
begin
result := (rsp_reg.code  and  $3ffffff);
end;

function __T :integer;
begin
result :=  ( (trunc(sp_reg_pc)  and  $f0000000) or (____T shl 2) );
end;


procedure rsp_step;
begin
        (* execute instruction *)


       instruction[__OPCODE];

        (* calculate next pc *)

        case (rsp_reg.delay) of
        EXEC_RSP_DELAY:
        begin
           (* next instruction is at pc_delay *)
        rsp_reg.delay := NO_RSP_DELAY;
        sp_reg_pc := rsp_reg.pc_delay;
        end;

        DO_RSP_DELAY:begin
           (* a delayed pc was stored into pc_delay      *)
                       (* next instr is at pc+4 (case 0 is executed) *)
                       (* next instr is at pc_delay                  *)
        rsp_reg.delay := EXEC_RSP_DELAY;
        end;

        NO_RSP_DELAY:    (* normal execution *)
                sp_reg_pc := sp_reg_pc + 4;

        end; (* switch(rsp_reg.delay) *)



        (* do common things *)

        rsp_reg.r[0] := 0;
        inc(rsp_reg.count);

end; (*procedure rsp_step; *)





procedure rsp_dis(code:longint);
begin
        (instruction[code shr 26]);
end;


procedure rsp_reset;
var
i, j:integer;
begin




        (* debugging *)

        rsp_reg.halt := 1;
        rsp_reg.count := 0;



        (* gpr registers *)

        for i:=0 to 32-1 do
                rsp_reg.r[i] := 0;



        (* flags (ccr) *)

        for i:=0 to 4-1 do
                rsp_reg.flag[i] := 0;



        (* vector registers *)

        for j:=0 to 32-1 do
                for i:=0 to 8-1 do
                        rsp_reg.v[j][i] := 0;



        (* hidden registers *)

        rsp_reg.vrcph_source := 0;
        rsp_reg.vrcph_result := 0;

end; (*procedure rsp_reset; *)



(******************************************************************************\
*                                                                              *
*   RSP (Reality Signalprocessor)                                             *
*                                                                              *
\******************************************************************************)





procedure rsp_special;
begin
//        (special_instruction[__F]);
end;


procedure rsp_regimm;
begin
  //      (regimm_instruction[__RT]);
end;


procedure rsp_j;
begin

        rsp_reg.delay := DO_RSP_DELAY;
        rsp_reg.pc_delay := __T;
end;





procedure rsp_jal;
begin
        rsp_reg.delay := DO_RSP_DELAY;
        rsp_reg.pc_delay := __T;
        rsp_reg.r[31] := (sp_reg_pc + 8)  and  $1fff;

end;


procedure rsp_beq;
begin
        if(rsp_reg.r[__RS] = rsp_reg.r[__RT]) then
        begin
                rsp_reg.delay := DO_RSP_DELAY;
                rsp_reg.pc_delay := __O;
        end;
end;





procedure rsp_bne;
begin
        if(rsp_reg.r[__RS] <> rsp_reg.r[__RT]) then
        begin
                rsp_reg.delay := DO_RSP_DELAY;
                rsp_reg.pc_delay := __O;
        end;
end;






procedure rsp_blez;
begin
        if((rsp_reg.r[__RS]) <= 0) then
        begin
                rsp_reg.delay := DO_RSP_DELAY;
                rsp_reg.pc_delay := __O;
        end;
end;





procedure rsp_bgtz;
begin
        if((rsp_reg.r[__RS]) > 0) then
        begin
                rsp_reg.delay := DO_RSP_DELAY;
                rsp_reg.pc_delay := __O;
        end;
end;





procedure rsp_addi;
begin
       rsp_reg.r[__RT] := rsp_reg.r[__RS] + __I;
end;





procedure rsp_addiu;
begin
        rsp_reg.r[__RT] := rsp_reg.r[__RS] + __I;
end;


procedure rsp_slti;
begin
        if(rsp_reg.r[__RS] < __I)  then
                rsp_reg.r[__RT] := 1
        else
                rsp_reg.r[__RT] := 0;

end;





procedure rsp_sltiu;
begin
        if(rsp_reg.r[__RS] < __I) then
                rsp_reg.r[__RT] := 1
        else
                rsp_reg.r[__RT] := 0;
end;





procedure rsp_andi;
begin
        rsp_reg.r[__RT] := rsp_reg.r[__RS]  and  __I;
end;





procedure rsp_ori;
begin
        rsp_reg.r[__RT] := rsp_reg.r[__RS] or __I;

end;





procedure rsp_xori;
begin
        rsp_reg.r[__RT] := rsp_reg.r[__RS] xor __I;
end;





procedure rsp_lui;
begin
        rsp_reg.r[__RT] := __I shl 16;
end;


procedure rsp_cop0;
begin
//        (cop0_instruction[__RS]);
end;





procedure rsp_cop2;
begin
//        (cop2_instruction[__RS]);
end;





procedure rsp_lb;
begin
        rsp_reg.r[__RT] := ord(sp_dmem[((rsp_reg.r[__RS]+__I) and $fff)xor 3]);
end;


procedure rsp_lh;
var
addr:longint;
begin

        addr := rsp_reg.r[__RS]+__I;
        addr :=addr and $fff;

        rsp_reg.r[__RT] := (ord(sp_dmem[(addr+0) xor 3]) shl 8)
                          or ord(sp_dmem[(addr+1)xor 3]);
end;





procedure rsp_lw;
var
addr:longint;
begin


        addr := rsp_reg.r[__RS]+__I;
        addr  := addr and $fff;

        rsp_reg.r[__RT] :=   (ord(sp_dmem[(addr+0)xor 3]) shl 24)
                          or (ord(sp_dmem[(addr+1)xor 3]) shl 16)
                          or (ord(sp_dmem[(addr+2)xor 3]) shl 8)
                          or  ord(sp_dmem[(addr+3)xor 3]);
end;





procedure rsp_lbu;
begin
        rsp_reg.r[__RT] := ord(sp_dmem[((rsp_reg.r[__RS]+__I) and $fff)xor 3]);
end;

procedure rsp_lhu;
var
addr:longint;
begin


        addr := rsp_reg.r[__RS]+__I;
        addr := addr and  $fff;

        rsp_reg.r[__RT] :=(ord(sp_dmem[(addr+0)xor 3]) shl 8)
                          or ord(sp_dmem[(addr+1)xor 3]);
end;





procedure rsp_sb;
begin
     sp_dmem[((rsp_reg.r[__RS]+__I) and $fff)xor 3] := (rsp_reg.r[__RT]);
end;





procedure rsp_sh;
begin
(*        uWORD data, addr;

        data = rsp_reg.r[__RT];
        addr = rsp_reg.r[__RS]+__I;
        addr  and = $fff;

        mem.sp_dmem[(addr+0)^3] = (uBYTE)(data >> 8);
        mem.sp_dmem[(addr+1)^3] = (uBYTE)(data);
*)
end;





procedure rsp_sw;
begin (*
        uWORD data, addr;

        data = rsp_reg.r[__RT];
        addr = rsp_reg.r[__RS]+__I;
        addr  and = $fff;

        mem.sp_dmem[(addr+0)^3] = (uBYTE)(data >> 24);
        mem.sp_dmem[(addr+1)^3] = (uBYTE)(data >> 16);
        mem.sp_dmem[(addr+2)^3] = (uBYTE)(data >> 8);
        mem.sp_dmem[(addr+3)^3] = (uBYTE)(data >> 0);
BOX("sw")
*) end;





procedure rsp_lwc2;
begin (*
        sWORD   addr;
        int     offset = __SA >> 1;
        int     i;

        switch(__RD)
        begin (*
            case $00:
                addr = __RSP_O(0) + rsp_reg.r[__RS];
                addr  and = $fff;

                if(offset  and  1)
                begin (*
                        rsp_reg.v[__RT][offset>>1]  and = $ff00;
                        rsp_reg.v[__RT][offset>>1] |= mem.sp_dmem[addr^3];
                *) (*end
                else
                begin (*
                        rsp_reg.v[__RT][offset>>1]  and = $00ff;
                        rsp_reg.v[__RT][offset>>1] |= mem.sp_dmem[addr^3] << 8;
                *) (*end
                (*break;

            case $01:
                addr = __RSP_O(1) + rsp_reg.r[__RS];
                addr  and = $fff;

                rsp_reg.v[__RT][offset>>1] = (mem.sp_dmem[addr^3] << 8) | mem.sp_dmem[(addr+1)^3];
                break;

            case $02:
                addr = __RSP_O(2) + rsp_reg.r[__RS];
                addr  and = $fff;

                rsp_reg.v[__RT][offset>>1] = (mem.sp_dmem[(addr)^3] << 8) | mem.sp_dmem[(addr+1)^3];
                rsp_reg.v[__RT][(offset>>1)+1] = (mem.sp_dmem[(addr+2)^3] << 8) | mem.sp_dmem[(addr+3)^3];
                break;

            case $03:
                addr = __RSP_O(3) + rsp_reg.r[__RS];
                addr  and = $fff;

                rsp_reg.v[__RT][offset>>1] = (mem.sp_dmem[(addr)^3] << 8) | mem.sp_dmem[(addr+1)^3];
                rsp_reg.v[__RT][(offset>>1)+1] = (mem.sp_dmem[(addr+2)^3] << 8) | mem.sp_dmem[(addr+3)^3];
                rsp_reg.v[__RT][(offset>>1)+2] = (mem.sp_dmem[(addr+4)^3] << 8) | mem.sp_dmem[(addr+5)^3];
                rsp_reg.v[__RT][(offset>>1)+3] = (mem.sp_dmem[(addr+6)^3] << 8) | mem.sp_dmem[(addr+7)^3];
                break;

            case $04:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i < (16 - (addr  and  $f)); i++)
                begin (*
                        if((offset+i)  and  1)
                        begin (*
                                rsp_reg.v[__RT][((offset+i)>>1)]  and = $ff00;
                                rsp_reg.v[__RT][((offset+i)>>1)] |= mem.sp_dmem[(addr+i)^3];
                        *) (*end;
                        else
                        begin (*
                                rsp_reg.v[__RT][((offset+i)>>1)]  and = $00ff;
                                rsp_reg.v[__RT][((offset+i)>>1)] |= mem.sp_dmem[(addr+i)^3] << 8;
                        *) (*end;
                *)(* end;
                break;

            case $05:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i < (addr  and  $f); i++)
                begin (*
                        if(i  and  1)
                        begin (*
                                rsp_reg.v[__RT][7-(i>>1)]  and = $00ff;
                                rsp_reg.v[__RT][7-(i>>1)] |= mem.sp_dmem[(addr-i-1)^3] << 8;
                        *) (*end;
                        else
                        begin (*
                                rsp_reg.v[__RT][7-(i>>1)]  and = $ff00;
                                rsp_reg.v[__RT][7-(i>>1)] |= mem.sp_dmem[(addr-i-1)^3];
                        *) (*end;
                *) (*end;
                break;

            case $06:
                addr = __RSP_O(3) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)

             {   rsp_reg.v[__RT][offset>>1] = mem.sp_dmem[addr^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+1] = mem.sp_dmem[(addr+1)^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+2] = mem.sp_dmem[(addr+2)^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+3] = mem.sp_dmem[(addr+3)^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+4] = mem.sp_dmem[(addr+4)^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+5] = mem.sp_dmem[(addr+5)^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+6] = mem.sp_dmem[(addr+6)^3] << 8;
                rsp_reg.v[__RT][(offset>>1)+7] = mem.sp_dmem[(addr+7)^3] << 8;
                break;

            case $07:
                addr = __RSP_O(3) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)
                for(i=0; i<8; i++)
                begin (*
                        rsp_reg.v[__RT][((offset)>>1)+i] = mem.sp_dmem[(addr+i)^3] << 7;
                *) (*end;
                break;

            case $08:

                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)
                for(i=0; i < (16 - (addr  and  $f)); i+=2)
                begin (*
                        rsp_reg.v[__RT][(offset+i)>>1] = mem.sp_dmem[(addr+i)^3] << 7;
                *) (*end;
                break;

            case $09:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i < (16 - (addr  and  $f)); i+=4)
                begin (*
                        rsp_reg.v[__RT][(offset>>1)+(i>>2)] = mem.sp_dmem[(addr+i)^3] << 7;
                *) (*end;
                break;

            case $0a:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i<16; i++)
                begin (*
                        if(i >= offset)
                        begin (*
                                if(i  and  1)
                                begin (*
                                        rsp_reg.v[__RT][i>>1]  and = $ff00;
                                        rsp_reg.v[__RT][i>>1] |= mem.sp_dmem[(addr+i-offset)^3];
                                *) (*end;
                                else
                                begin (*
                                        rsp_reg.v[__RT][i>>1]  and = $00ff;
                                        rsp_reg.v[__RT][i>>1] |= mem.sp_dmem[(addr+i-offset)^3] << 8;
                                *) (*end;
                        *) (*end;
                        else
                        begin (*
                                if(i  and  1)
                                begin (*
                                        rsp_reg.v[__RT][i>>1]  and = $ff00;
                                        rsp_reg.v[__RT][i>>1] |= mem.sp_dmem[(addr+i+16-offset)^3];
                                *) (*end;
                                else
                                begin (*
                                        rsp_reg.v[__RT][i>>1]  and = $00ff;
                                        rsp_reg.v[__RT][i>>1] |= mem.sp_dmem[(addr+i+16-offset)^3] << 8;
                                *) (*end;
                        *) (*end;
                *)(* end;
                break;

            case $0b:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i<8; i++)
                begin (*
                        rsp_reg.v[__RT+i][(8-(offset>>1)+i) and 7] = (mem.sp_dmem[(addr+(i<<1))^3] << 8) | mem.sp_dmem[(addr+(i<<1)+1)^3];
                *) (*end;
                break;

            default:
				break;
        *) (*end; (* switch(__RD) *)
BOX("lwc2")
*)}
 end;





procedure rsp_swc2;
begin (*
        sWORD   addr;
        int     offset = __SA >> 1;
        int     i;

        switch(__RD)
        begin (*
            case $00:
                addr = __RSP_O(0) + rsp_reg.r[__RS];
                addr  and = $fff;

                if(offset  and  1)
                        mem.sp_dmem[addr^3] = rsp_reg.v[__RT][offset>>1];
                else
                        mem.sp_dmem[addr^3] = rsp_reg.v[__RT][offset>>1] >> 8;
                break;

            case $01:
                addr = __RSP_O(1) + rsp_reg.r[__RS];
                addr  and = $fff;

                mem.sp_dmem[addr^3] = rsp_reg.v[__RT][offset>>1] >> 8;
                mem.sp_dmem[(addr+1)^3] = rsp_reg.v[__RT][offset>>1];

                break;

            case $02:
                addr = __RSP_O(2) + rsp_reg.r[__RS];
                addr  and = $fff;

                mem.sp_dmem[addr^3] = rsp_reg.v[__RT][offset>>1] >> 8;
                mem.sp_dmem[(addr+1)^3] = rsp_reg.v[__RT][offset>>1];
                mem.sp_dmem[(addr+2)^3] = rsp_reg.v[__RT][(offset>>1)+1] >> 8;
                mem.sp_dmem[(addr+3)^3] = rsp_reg.v[__RT][(offset>>1)+1];
                break;

            case $03:
                addr = __RSP_O(3) + rsp_reg.r[__RS];
                addr  and = $fff;

                mem.sp_dmem[addr^3] = rsp_reg.v[__RT][offset>>1] >> 8;
                mem.sp_dmem[(addr+1)^3] = rsp_reg.v[__RT][offset>>1];
                mem.sp_dmem[(addr+2)^3] = rsp_reg.v[__RT][(offset>>1)+1] >> 8;
                mem.sp_dmem[(addr+3)^3] = rsp_reg.v[__RT][(offset>>1)+1];
                mem.sp_dmem[(addr+4)^3] = rsp_reg.v[__RT][(offset>>1)+2] >> 8;
                mem.sp_dmem[(addr+5)^3] = rsp_reg.v[__RT][(offset>>1)+2];
                mem.sp_dmem[(addr+6)^3] = rsp_reg.v[__RT][(offset>>1)+3] >> 8;
                mem.sp_dmem[(addr+7)^3] = rsp_reg.v[__RT][(offset>>1)+3];
                break;

            case $04:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i < (16 - (addr  and  $f)); i++)
                begin (*
                        if((offset+i)  and  1)
                                mem.sp_dmem[(addr+i)^3] = rsp_reg.v[__RT][(offset+i)>>1];
                        else
                                mem.sp_dmem[(addr+i)^3] = rsp_reg.v[__RT][(offset+i)>>1] >> 8;
                *) (*end;
                break;

            case $05:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i < (addr  and  $f); i++)
                begin (*
                        if((offset+i)  and  1)
                                mem.sp_dmem[(addr-i-1)^3] = rsp_reg.v[__RT][7-(i>>1)] >> 8;
                        else
                                mem.sp_dmem[(addr-i-1)^3] = rsp_reg.v[__RT][7-(i>>1)];
                *) (*end;
                break;

            case $06:
                addr = __RSP_O(3) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)
{                mem.sp_dmem[addr^3] = rsp_reg.v[__RT][offset>>1] >> 8;
                mem.sp_dmem[(addr+1)^3] = rsp_reg.v[__RT][(offset>>1)+1] >> 8;
                mem.sp_dmem[(addr+2)^3] = rsp_reg.v[__RT][(offset>>1)+2] >> 8;
                mem.sp_dmem[(addr+3)^3] = rsp_reg.v[__RT][(offset>>1)+3] >> 8;
                mem.sp_dmem[(addr+4)^3] = rsp_reg.v[__RT][(offset>>1)+4] >> 8;
                mem.sp_dmem[(addr+5)^3] = rsp_reg.v[__RT][(offset>>1)+5] >> 8;
                mem.sp_dmem[(addr+6)^3] = rsp_reg.v[__RT][(offset>>1)+6] >> 8;
                mem.sp_dmem[(addr+7)^3] = rsp_reg.v[__RT][(offset>>1)+7] >> 8;
                break;

            case $07:
                addr = __RSP_O(3) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)
                for(i=0; i<8; i++)
                begin (*
                        mem.sp_dmem[(addr+i)^3] = rsp_reg.v[__RT][((offset)>>1)+i] >> 7;
                *) (*end;
                break;

            case $08:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)
                for(i=0; i < (16 - (addr  and  $f)); i+=2)
                begin (*
                        mem.sp_dmem[(addr+i)^3] = rsp_reg.v[__RT][(offset+i)>>1] >> 7;
                *) (*end;
                break;

            case $09:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

    (* BUG: ??? offset should be removed ??? *)
                for(i=0; i < (16 - (addr  and  $f)); i+=4)
                begin (*
                        mem.sp_dmem[(addr+i)^3] = rsp_reg.v[__RT][(offset>>1)+(i>>2)] >> 7;
                *) (*end;
                break;

            case $0a:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                for(i=0; i<16; i++)
                begin (*
                        if(i >= offset)
                        begin (*
                                if(i  and  1)
                                        mem.sp_dmem[(addr+i-offset)^3] = rsp_reg.v[__RT][i>>1];
                                else
                                        mem.sp_dmem[(addr+i-offset)^3] = rsp_reg.v[__RT][i>>1] >> 8;
                        *)(* end;
                        else
                        begin (*
                                if(i  and  1)
                                        mem.sp_dmem[(addr+i+16-offset)^3] = rsp_reg.v[__RT][i>>1];
                                else
                                        mem.sp_dmem[(addr+i+16-offset)^3] = rsp_reg.v[__RT][i>>1] >> 8;
                        *) (*end;
                *) (*end;
                break;

            case $0b:
                addr = __RSP_O(4) + rsp_reg.r[__RS];
                addr  and = $fff;

                (* The following was VERY VERY hard to figure out!!! *)
                for(i=0; i<8; i++)
                begin (*
                        sWORD   o = offset ? addr + (16-offset) : addr;
                        mem.sp_dmem[((o  and  ~$0f) | ((o + (i<<1))  and  $0f))^3] = rsp_reg.v[__RT+i][(8-(offset>>1)+i) and 7] >> 8;
                        mem.sp_dmem[(((o  and  ~$0f) | ((o + (i<<1))  and  $0f)) + 1)^3] = rsp_reg.v[__RT+i][(8-(offset>>1)+i) and 7];
                *)(* end;
                break;

            default:
				break;
        *) (*end; (* switch(__RD) *)

BOX("swc2")
*)} end;






procedure rsp_reserved;
begin (*
*) end;





procedure rsp_special_sll;
begin (*
        rsp_reg.r[__RD] = (uWORD)rsp_reg.r[__RT] << __SA;
//BOX("sll")
*) end;





procedure rsp_special_srl;
begin (*
        rsp_reg.r[__RD] = (uWORD)rsp_reg.r[__RT] >> __SA;
BOX("srl")
*) end;





procedure rsp_special_sra;
begin (*
        rsp_reg.r[__RD] = (sWORD)rsp_reg.r[__RT] >> __SA;
BOX("sra")
*) end;





procedure rsp_special_sllv;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RT] << (rsp_reg.r[__RS]  and  $1f);
BOX("sllv")
*) end;





procedure rsp_special_srlv;
begin (*
        rsp_reg.r[__RD] = (uWORD)rsp_reg.r[__RT] >> (rsp_reg.r[__RS]  and  $1f);
BOX("srlv")
*) end;





procedure rsp_special_srav;
begin (*
        rsp_reg.r[__RD] = (sWORD)rsp_reg.r[__RT] >> (rsp_reg.r[__RS]  and  $1f);
BOX("srav")
*) end;





procedure rsp_special_jr;
begin (*
        rsp_reg.delay = DO_RSP_DELAY;
        rsp_reg.pc_delay = $04000000 | (rsp_reg.r[__RS]  and  $1fff);
BOX("jr")
*) end;





procedure rsp_special_jalr;
begin (*
        rsp_reg.delay = DO_RSP_DELAY;
        rsp_reg.pc_delay = $04000000 | (rsp_reg.r[__RS]  and  $1fff);
        rsp_reg.r[__RD] = (mem.sp_reg_pc + 8)  and  $1fff;
BOX("jalr")
*) end;





procedure rsp_special_break;
begin (*
        (mem.sp_reg)[4] |= $00000203;

        if(((uWORD )mem.sp_reg)[4]  and  $40)
                //reg.do_or_check_sthg |= RS4300I_DO_SP_INTERRUPT;
				rs4300i_MI_Intr_SP;

        rsp_reg.halt = 1;
*) end;





procedure rsp_special_add;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS] + rsp_reg.r[__RT];
BOX("add")
*) end;





procedure rsp_special_addu;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS] + rsp_reg.r[__RT];
BOX("addu")
*) end;





procedure rsp_special_sub;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS] - rsp_reg.r[__RT];
BOX("sub")
*) end;





procedure rsp_special_subu;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS] - rsp_reg.r[__RT];
BOX("subu")
*) end;





procedure rsp_special_and;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS]  and  rsp_reg.r[__RT];
BOX("and")
*) end;






procedure rsp_special_or;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS] | rsp_reg.r[__RT];
BOX("or")
*) end;





procedure rsp_special_xor;
begin (*
        rsp_reg.r[__RD] = rsp_reg.r[__RS] ^ rsp_reg.r[__RT];
BOX("xor")
*) end;





procedure rsp_special_nor;
begin (*
        rsp_reg.r[__RD] = ~(rsp_reg.r[__RS] | rsp_reg.r[__RT]);
BOX("nor")
*) end;





procedure rsp_special_slt;
begin (*
        if(rsp_reg.r[__RS] < rsp_reg.r[__RT])
                rsp_reg.r[__RD] = 1;
        else
                rsp_reg.r[__RD] = 0;
BOX("slt")
*) end;





procedure rsp_special_sltu;
begin (*
        if((uWORD)rsp_reg.r[__RS] < (uWORD)rsp_reg.r[__RT])
                rsp_reg.r[__RD] = 1;
        else
                rsp_reg.r[__RD] = 0;
BOX("sltu")
*) end;





procedure rsp_special_reserved;
begin (*
*) end;




procedure rsp_regimm_bltz;
begin (*
        if(((sWORD)rsp_reg.r[__RS]) < 0)
        begin (*
                rsp_reg.delay = DO_RSP_DELAY;
                rsp_reg.pc_delay = mem.sp_reg_pc + 4 + (__I << 2);
        *) end;


(* end;*)





procedure rsp_regimm_bgez;
begin (*
        if(((sWORD)rsp_reg.r[__RS]) >= 0)
        begin (*
                rsp_reg.delay = DO_RSP_DELAY;
                rsp_reg.pc_delay = mem.sp_reg_pc + 4 + (__I << 2);
        *) (*end;

*) end;





procedure rsp_regimm_bltzal;
begin (*
        rsp_reg.r[31] = mem.sp_reg_pc + 8;

        if(((sWORD)rsp_reg.r[__RS]) < 0)
        begin (*
                rsp_reg.delay = DO_RSP_DELAY;
                rsp_reg.pc_delay = mem.sp_reg_pc + 4 + (__I << 2);
        *) (*end;

*) end;





procedure rsp_regimm_bgezal;
begin (*
        rsp_reg.r[31] = mem.sp_reg_pc + 8;

        if(((sWORD)rsp_reg.r[__RS]) >= 0)
        begin (*
                rsp_reg.delay = DO_RSP_DELAY;
                rsp_reg.pc_delay = mem.sp_reg_pc + 4 + (__I << 2);
        *)(* end;

*) end;





procedure rsp_regimm_reserved;
begin (*
*) end;





procedure rsp_cop0_mf;
begin (*
        if(__RD < 8)
                rsp_reg.r[__RT] = doReadMemWord($04040000 | (__RD << 2));
        else
                rsp_reg.r[__RT] = doReadMemWord($04100000 | ((__RD  and  ~$08) << 2));


*) end;





procedure rsp_cop0_mt;
begin (*
        if(__RD < 8)
                doWriteMemWord(rsp_reg.r[__RT], $04040000 | (__RD << 2));
        else
                doWriteMemWord(rsp_reg.r[__RT], $04100000 | ((__RD  and  ~$08) << 2));

*) end;





procedure rsp_cop0_reserved;
begin (*
*) end;





procedure rsp_cop2_mf;
begin (*

        sHWORD  data;
        uBYTE    offs;

        offs = (__SA >> 1)  and  $0f;

        if(offs  and  $01)
        begin
                data =  rsp_reg.v[__RD][(offs >> 1) + 1]  and  $00ff;
                data += rsp_reg.v[__RD][offs >> 1]        and  $ff00;
         end
        else
        begin
                data = rsp_reg.v[__RD][offs >> 1];
         end;

        rsp_reg.r[__RT] := data;

*) end;





procedure rsp_cop2_cf;
begin (*
        rsp_reg.r[__RT] = rsp_reg.flag[__RD  and  $03];
*) end;





procedure rsp_cop2_mt;
begin (*
        uHWORD   data;
        uBYTE    offs;

        data = rsp_reg.r[__RT];
        offs = (__SA >> 1)  and  $0f;

        if(offs  and  $01)   (* odd *)
        //begin
        (*
                rsp_reg.v[__RD][offs >> 1]        and = $ff00;
                rsp_reg.v[__RD][offs >> 1]       |= data >> 8;
                rsp_reg.v[__RD][(offs >> 1) + 1]  and = $00ff;
                rsp_reg.v[__RD][(offs >> 1) + 1] |= data << 8;
        *)
       {  end;
        else              (* even *)
        begin (*
                rsp_reg.v[__RD][offs >> 1] = data;
        *) end;
BOX("mt")
*)} end;





procedure rsp_cop2_ct;
begin (*
        rsp_reg.flag[__RD  and  $03] = rsp_reg.r[__RT];
*) end;





procedure rsp_cop2_vectop;
begin (*
        (cop2_vectop_instruction[__F]);

*) end;





procedure rsp_cop2_reserved;
begin (*
*) end;





(* rsp cop2 vectop instructions *)

procedure rsp_cop2_vectop_vmulf;
begin (*

        STORE_REGISTER
        VECT_ACCU_OP(ah, +, (uHWORD), *, >> 16)

        ACCU_2_VREG(ah);

//        PRINT_NOT_IMPLEMENTED("VMULF")

BOX("vmulf")
*) end; (* procedure rsp_cop2_vectop_vmulf; *)





procedure rsp_cop2_vectop_vmulu;
begin (*
        PRINT_NOT_IMPLEMENTED("VMULU")

BOX("vmulu")
*) end; (* procedure rsp_cop2_vectop_vmulu; *)





procedure rsp_cop2_vectop_vrndp;
begin (*
        PRINT_NOT_IMPLEMENTED("VRNDP")
BOX("vrndp")
*) end; (* procedure rsp_cop2_vectop_vrndp; *)





procedure rsp_cop2_vectop_vmulq;
begin (*
        PRINT_NOT_IMPLEMENTED("VMULQ")
BOX("vmulq")
*) end; (* procedure rsp_cop2_vectop_vmulq; *)





procedure rsp_cop2_vectop_vmudl;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP_EQ(ah, (uHWORD), *, >> 16)

        ACCU_2_VREG(ah);
BOX("vmudl")
*) end; (* procedure rsp_cop2_vectop_vmudl; *)





procedure rsp_cop2_vectop_vmudm;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP_EQ(ah,(sHWORD), *, >> 16)

        ACCU_2_VREG(ah);
BOX("vmudm")
*) end; (* procedure rsp_cop2_vectop_vmudm; *)





procedure rsp_cop2_vectop_vmudn;
begin (*

        STORE_REGISTER
        VECT_ACCU_OP_EQ(al, (uHWORD), *, )

        ACCU_2_VREG(al);
BOX("vmudn")
*) end; (* procedure rsp_cop2_vectop_vmudn; *)





procedure rsp_cop2_vectop_vmudh;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP_EQ(ah, (sHWORD), *, )

        ACCU_2_VREG(ah);
BOX("vmudh")
*) end; (* procedure rsp_cop2_vectop_vmudh; *)





procedure rsp_cop2_vectop_vmacf;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP(ah, +, (uHWORD), *, >> 16)

        ACCU_2_VREG(ah);

//        PRINT_NOT_IMPLEMENTED("VMACF")
BOX("vmacf")
*) end; (* procedure rsp_cop2_vectop_vmacf; *)





procedure rsp_cop2_vectop_vmacu;
begin (*
        PRINT_NOT_IMPLEMENTED("VMACU")
BOX("vmacu")
*) end; (* procedure rsp_cop2_vectop_vmacu; *)





procedure rsp_cop2_vectop_vrndn;
begin (*
        PRINT_NOT_IMPLEMENTED("VRNDN")
BOX("vrndn")
*) end; (* procedure rsp_cop2_vectop_vrndn; *)





procedure rsp_cop2_vectop_vmacq;
begin (*
        PRINT_NOT_IMPLEMENTED("VMACQ")
BOX("vmacq")
*) end; (* procedure rsp_cop2_vectop_vmacq; *)





procedure rsp_cop2_vectop_vmadl;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP(ah, +, (uHWORD), *, >> 16)

        ACCU_2_VREG(ah);
BOX("vmadl")
*) end; (* procedure rsp_cop2_vectop_vmadl; *)





procedure rsp_cop2_vectop_vmadm;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP(ah, +, (sHWORD), *, >> 16)

        ACCU_2_VREG(ah);
BOX("vmadm")
*) end; (* procedure rsp_cop2_vectop_vmadm; *)





procedure rsp_cop2_vectop_vmadn;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP(al, +, (uHWORD), *, )

        ACCU_2_VREG(al);
BOX("vmadn")
*) end; (* procedure rsp_cop2_vectop_vmadn; *)





procedure rsp_cop2_vectop_vmadh;
begin (*
        STORE_REGISTER
        VECT_ACCU_OP(ah, +, (sHWORD), *, )

        ACCU_2_VREG(ah);
BOX("vmadh")
*) end; (* procedure rsp_cop2_vectop_vmadh; *)





procedure rsp_cop2_vectop_vadd;
begin (*
        STORE_REGISTER
        VECT_OP(+)
        ADD_CARRY(__SA)
        CLIP_RESULT_ADD
BOX("vadd")
*) end; (* procedure rsp_cop2_vectop_vadd; *)





procedure rsp_cop2_vectop_vsub;
begin (*
        STORE_REGISTER
        VECT_OP(-)
        SUB_CARRY(__SA)
        CLIP_RESULT_SUB
BOX("vsub")
*) end; (* procedure rsp_cop2_vectop_vsub; *)





procedure rsp_cop2_vectop_vsut;
begin (*
        PRINT_NOT_IMPLEMENTED("VSUT")
BOX("vsut")
*) end; (* procedure rsp_cop2_vectop_vsut; *)





procedure rsp_cop2_vectop_vabs;
begin (*
        STORE_REGISTER
        VECT_OP_ABS
BOX("vabs")
*) end; (* procedure rsp_cop2_vectop_vabs; *)





procedure rsp_cop2_vectop_vaddc;
begin (*
        STORE_REGISTER
        VECT_OP(+)
        SET_CARRY_ADD
BOX("vaddc")
*) end; (* procedure rsp_cop2_vectop_vaddc; *)





procedure rsp_cop2_vectop_vsubc;
begin (*
        STORE_REGISTER
        VECT_OP(-)
        SET_CARRY_SUB
        SET_ZERO_FLAGS(__SA)
BOX("vmsubc")
*) end; (* procedure rsp_cop2_vectop_vsubc; *)





procedure rsp_cop2_vectop_vaddb;
begin (*
        PRINT_NOT_IMPLEMENTED("VADDB")
BOX("vaddb")
*) end; (* procedure rsp_cop2_vectop_vaddb; *)





procedure rsp_cop2_vectop_vsubb;
begin (*
        PRINT_NOT_IMPLEMENTED("VSUBB")
BOX("vsubb")
*) end; (* procedure rsp_cop2_vectop_vsubb; *)





procedure rsp_cop2_vectop_vaccb;
begin (*
        PRINT_NOT_IMPLEMENTED("VACCB")
BOX("vaccb")
*) end; (* procedure rsp_cop2_vectop_vaccb; *)





procedure rsp_cop2_vectop_vsucb;
begin (*
        PRINT_NOT_IMPLEMENTED("VSUCB")
BOX("vsucb")
*) end; (* procedure rsp_cop2_vectop_vsucb; *)





procedure rsp_cop2_vectop_vsad;
begin (*
        PRINT_NOT_IMPLEMENTED("VSAD")
BOX("vsad")
*) end; (* procedure rsp_cop2_vectop_vsad; *)





procedure rsp_cop2_vectop_vsac;
begin (*
        PRINT_NOT_IMPLEMENTED("VSAC")
BOX("vsac")
*) end; (* procedure rsp_cop2_vectop_vsac; *)





procedure rsp_cop2_vectop_vsum;
begin (*
        PRINT_NOT_IMPLEMENTED("VSUM")
BOX("vsum")
*) end; (* procedure rsp_cop2_vectop_vsum; *)





procedure rsp_cop2_vectop_vsaw;
begin (*
        PRINT_NOT_IMPLEMENTED("VSAW")
BOX("vsaw")
*) end; (* procedure rsp_cop2_vectop_vsaw; *)





procedure rsp_cop2_vectop_vlt;
begin (*
        STORE_REGISTER
        VECT_OP_COMP(<)
        VECT_OP_COPY(rsp_reg.flag[1])
        rsp_reg.flag[0] = 0;
BOX("vlt")
*) end; (* procedure rsp_cop2_vectop_vlt; *)





procedure rsp_cop2_vectop_veq;
begin (*
        STORE_REGISTER
        VECT_OP_COMP(==)
        VECT_OP_COPY(0)
        rsp_reg.flag[0] = 0;
BOX("veq")
*) end; (* procedure rsp_cop2_vectop_veq; *)





procedure rsp_cop2_vectop_vne;
begin (*
        STORE_REGISTER
        VECT_OP_COMP(!=)
        VECT_OP_COPY($ff)
        rsp_reg.flag[0] = 0;
BOX("vne")
*) end; (* procedure rsp_cop2_vectop_vne; *)





procedure rsp_cop2_vectop_vge;
begin (*
        STORE_REGISTER
        VECT_OP_COMP(>=)
        VECT_OP_COPY(rsp_reg.flag[1])
        rsp_reg.flag[0] = 0;
BOX("vge")
*) end; (* procedure rsp_cop2_vectop_vge; *)





procedure rsp_cop2_vectop_vcl;
begin (*
        PRINT_NOT_IMPLEMENTED("VCL")
BOX("vcl")
*) end; (* procedure rsp_cop2_vectop_vcl; *)





procedure rsp_cop2_vectop_vch;
begin (*
        PRINT_NOT_IMPLEMENTED("VCH")
BOX("vch")
*) end; (* procedure rsp_cop2_vectop_vch; *)





procedure rsp_cop2_vectop_vcr;
begin (*
        PRINT_NOT_IMPLEMENTED("VCR")
BOX("vcr")
*) end; (* procedure rsp_cop2_vectop_vcr; *)





procedure rsp_cop2_vectop_vmrg;
begin (*
        int     i;

        STORE_REGISTER

        for(i=0; i<8; i++)
        begin (*
                if( (1<<i)  and  rsp_reg.flag[1] )
                        rsp_reg.v[__SA][i] = rsp_reg.v_src1[i];
                else
                        rsp_reg.v[__SA][i] = rsp_reg.v_src2[i];
        *)// end;

 end; (* procedure rsp_cop2_vectop_vmrg; *)





procedure rsp_cop2_vectop_vand;
begin (*
        STORE_REGISTER
        VECT_OP( and )
BOX("vand")
*) end; (* procedure rsp_cop2_vectop_vand; *)





procedure rsp_cop2_vectop_vnand;
begin (*
        STORE_REGISTER
        VECT_N_OP( and )
BOX("vnand")
*) end; (* procedure rsp_cop2_vectop_vnand; *)





procedure rsp_cop2_vectop_vor;
begin (*
        STORE_REGISTER
        VECT_OP(|)
BOX("vor")
*) end; (* procedure rsp_cop2_vectop_vor; *)





procedure rsp_cop2_vectop_vnor;
begin (*
        STORE_REGISTER
        VECT_N_OP(|)
BOX("vnor")
*) end; (* procedure rsp_cop2_vectop_vnor; *)





procedure rsp_cop2_vectop_vxor;
begin (*
        STORE_REGISTER
        VECT_OP(^)
BOX("vxor")
*) end; (* procedure rsp_cop2_vectop_vxor; *)





procedure rsp_cop2_vectop_vnxor;
begin (*
        STORE_REGISTER
        VECT_N_OP(^)
BOX("vnxor")
*) end; (* procedure rsp_cop2_vectop_vnxor; *)





procedure rsp_cop2_vectop_vrcp;
begin (*
        rsp_reg.v[__SA][__RD  and  $07] = rsp_reg.vrcph_source;
        rsp_reg.vrcph_result = rsp_reg.v[__RT][__RS  and  $07];
*) end; (* procedure rsp_cop2_vectop_vrcp; *)





procedure rsp_cop2_vectop_vrcpl;
var
_result:double;
int_part:integer;
begin (*



        result := 0.4999963 div ((rsp_reg.vrcph_source shl 16) or rsp_reg.v[__RT][__RS  and  $07]);

        rsp_reg.vrcph_result := _result;
        _result := frexp(result,@int_part);
        if(_result := 0) then
                rsp_reg.v[__SA][__RD  and  $07] := 0;
        else
        begin (*
                rsp_reg.v[__SA][__RD  and  $07] := ( ((((DWORDLONG )( and result))  and  $000fffffffffffff) or $0010000000000000 ) >> (abs(int_part) + 37) );
        *) //end;

end;  (* procedure rsp_cop2_vectop_vrcpl; *)





procedure rsp_cop2_vectop_vrcph;
begin
        rsp_reg.v[__SA][__RD  and  $07] := rsp_reg.vrcph_result;
        rsp_reg.vrcph_source := rsp_reg.v[__RT][__RS  and  $07];
end; (* procedure rsp_cop2_vectop_vrcph; *)





procedure rsp_cop2_vectop_vmov;
begin
rsp_reg.v[__SA][__RD  and  $07] := rsp_reg.v[__RT][__RS  and  $07];
end; (* procedure rsp_cop2_vectop_vmov; *)





procedure rsp_cop2_vectop_vrsq;
begin

end; (* procedure rsp_cop2_vectop_vrsq; *)





procedure rsp_cop2_vectop_vrsql;
begin

end; (* procedure rsp_cop2_vectop_vrsql; *)





procedure rsp_cop2_vectop_vrsqh;
begin

end; (* procedure rsp_cop2_vectop_vrsqh; *)





procedure rsp_cop2_vectop_vnoop;
begin

end; (* procedure rsp_cop2_vectop_vnoop; *)





procedure rsp_cop2_vectop_vextt;
begin

end; (* procedure rsp_cop2_vectop_vextt; *)





procedure rsp_cop2_vectop_vextq;
begin

end; (* procedure rsp_cop2_vectop_vextq; *)





procedure rsp_cop2_vectop_vextn;
begin

end; (* procedure rsp_cop2_vectop_vextn; *)





procedure rsp_cop2_vectop_vinst;
begin

end; (* procedure rsp_cop2_vectop_vinst; *)





procedure rsp_cop2_vectop_vinsq;
begin

end; (* procedure rsp_cop2_vectop_vinsq; *)





procedure rsp_cop2_vectop_vinsn;
begin

end; (* procedure rsp_cop2_vectop_vinsn; *)





procedure rsp_cop2_vectop_reserved;
begin

end; (* procedure rsp_cop2_vectop_reserved; *)


end.
