unit memory;

interface
uses windows,sysutils,global;

const DO_NOTHING      =        $0000;
const _DO_DISPLAY_REFRESH =     $0001;
const DO_RUN_RDP      =        $0002;
const _UPDATE_MI_REG   =        $0004;
const _UPDATE_VI_REG   =        $0008;
const _UPDATE_PI_REG   =        $0010;
const _UPDATE_SP_REG   =        $0020;
const _UPDATE_DP_REG   =        $0040;
const _CHECK_VI_REG    =        $0080;
const _CHECK_AI_REG    =        $0100;
const PI_DMA          =        $0200;
const PIF2DRAM_DMA    =        $0400;
const DRAM2PIF_DMA    =        $0800;
const IDMEM2DRAM_DMA  =        $1000;
const DRAM2IDMEM_DMA  =        $2000;


var
phys_read_fast:array[0..$8000]of function(virtualaddr:uWord):pchar;
phys_write_fast:array[0..$8000]of function(virtualaddr:uWord):pchar;

mem_todo:integer;
old_vi_status_reg:longint;
old_vi_width_reg:longint;
ai_addr_len_buffer_full:longint = 0;


const N_SEGMENTS = 20;
var
mem_size:array[0..N_SEGMENTS-1]of integer =
(
        4 * 1024 * 1024,
        $1000,
        $1000,
        $7c0,
        $40,
        $40,

        $28,
        $20,
        $20,
        $10,
        $10,
        $10,
        $38,
        $18,
        $34,
        $34,
        $20,
        $1c,
        4096,
        1024
);

mem_addr:array[0..N_SEGMENTS]of pchar;
function alloc_n64_mem:integer;
procedure clear_n64_mem;
procedure free_n64_mem;

function doReadMemByte(where:uWORD):ubyte;
function doReadMemHalfWord(where:uWORD):uHWORD;
function doReadMemWord(where:uWORD):uWORD;
function doReadMemDoubleWord(where:uWORD):uDWORD;
procedure doWriteMemByte(what,where:uWORD);
procedure doWriteMemHalfWord(what, where:uWORD);
procedure doWriteMemWord(what, where:uWORD);
procedure doWriteMemDoubleWord(what, where:uWORD);


procedure init_fast_mem;
procedure do_display_refresh;
procedure write_mem_addr;
procedure update_vi_reg;
procedure check_vi_reg;
procedure check_ai_reg;
procedure update_mi_reg;
procedure update_pi_reg;
procedure update_sp_reg;
procedure update_dp_reg;


function get_mapped(virtualaddr:uWord):pchar;
function put_mapped(virtualaddr:uWord):pchar;
function get_electricalnoise(virtualaddr:uWord):pchar;
function put_electricalnoise(virtualaddr:uWord):pchar;
function get_mem_83f0_83f0(virtualaddr:uWord):pchar;
function get_mem_8000_803f(virtualaddr:uWord):pchar;
function get_mem_8408_8408(virtualaddr:uWord):pchar;
function get_mem_8404_8404(virtualaddr:uWord):pchar;
function get_mem_8400_8400(virtualaddr:uWord):pchar;
function put_mem_8000_803f(virtualaddr:uWord):pchar;
function put_mem_83f0_83f0(virtualaddr:uWord):pchar;
function put_mem_8400_8400(virtualaddr:uWord):pchar;
function put_mem_8404_8404(virtualaddr:uWord):pchar;
function put_mem_8408_8408(virtualaddr:uWord):pchar;
function put_mem_8410_841f(virtualaddr:uWord):pchar;
function put_mem_8420_842f(virtualaddr:uWord):pchar;
function put_mem_8430_843f(virtualaddr:uWord):pchar;
function put_mem_8440_844f(virtualaddr:uWord):pchar;
function get_mem_8410_841f(virtualaddr:uWord):pchar;
function get_mem_8420_842f(virtualaddr:uWord):pchar;
function get_mem_8430_843f(virtualaddr:uWord):pchar;
function get_mem_8440_844f(virtualaddr:uWord):pchar;
function get_mem_8450_845f(virtualaddr:uWord):pchar;
function put_mem_8450_845f(virtualaddr:uWord):pchar;
function get_mem_8460_846f(virtualaddr:uWord):pchar;
function put_mem_8460_846f(virtualaddr:uWord):pchar;
function get_mem_8470_847f(virtualaddr:uWord):pchar;
function put_mem_8470_847f(virtualaddr:uWord):pchar;
function get_mem_8480_848f(virtualaddr:uWord):pchar;
function put_mem_8480_848f(virtualaddr:uWord):pchar;
function get_mem_9fc0_9fcf(virtualaddr:uWord):pchar;
function put_mem_9fc0_9fcf(virtualaddr:uWord):pchar;
function get_rom(virtualaddr:uWord):pchar;
implementation
uses cpu,emulate,dma,interrupts,video;

procedure final_check;
begin
if(mem_todo)<> 0 then
begin
if(mem_todo and _DO_DISPLAY_REFRESH)<> 0 then
                        do_display_refresh;
                //if(mem_todo  and  DO_RUN_RDP) then
                 //       rdp_go;
                if(mem_todo  and  _UPDATE_VI_REG)<> 0 then
                        update_vi_reg;
                if(mem_todo  and  _CHECK_VI_REG)<> 0 then
                        check_vi_reg;
                if(mem_todo  and  _CHECK_AI_REG)<> 0 then
                        check_ai_reg;
                if(mem_todo  and  _UPDATE_MI_REG)<> 0  then
                        update_mi_reg;
                if(mem_todo  and  _UPDATE_PI_REG)<> 0 then
                       update_pi_reg;
                  if(mem_todo  and  _UPDATE_SP_REG)<> 0 then
                        update_sp_reg;
                if(mem_todo  and  _UPDATE_DP_REG)<> 0  then
                        update_dp_reg;
                if(mem_todo  and  PI_DMA) <> 0  then
                        dma_pi_copy;
                if(mem_todo  and  PIF2DRAM_DMA)<> 0  then
                        dma_pif2dram;
                if(mem_todo  and  DRAM2PIF_DMA)<> 0 then
                        dma_dram2pif;
                if(mem_todo  and  IDMEM2DRAM_DMA)<> 0   then
                        dma_idmem2dram;
                if(mem_todo  and  DRAM2IDMEM_DMA)<> 0 then
                        dma_dram2idmem;
       end;
        mem_todo := DO_NOTHING;
end;

function alloc_n64_mem:integer;
var
i:integer;
begin
        for i:=0 to N_SEGMENTS-1 do
        begin
        //mem_addr[i] := malloc(mem_size[i]);
        //    if( ! mem_addr[i] )
        //     memset(mem_addr[i], 0, mem_size[i]);
        GetMem(mem_addr[i],mem_size[i]);
        mem_addr[i] := nil;
        end;

        for i := 0 to $8000 do
        begin
        phys_read_fast[i] := nil;
        phys_write_fast[i] := nil;
//        getmem(phys_read_fast[i],sizeof(phys_read_fast[i]));
//        getmem(phys_write_fast[i],sizeof(phys_write_fast[i]));
        end;

        write_mem_addr;
        // this need to be initialized /
        mi_reg[1] := 0;//$01010101;
        sp_reg_pc := $04001000;

       init_fast_mem;

result := 0;
end;






procedure clear_n64_mem;
var
i:integer;
begin



        for i:=0 to N_SEGMENTS-1 do
        begin
        freemem(mem_addr[i], mem_size[i]);
        end;



        mi_reg[1] := 0;//$001010101;
        sp_reg_pc := $04001000;



       mem_todo := DO_NOTHING;


        old_vi_status_reg := 0;
        old_vi_width_reg  := 0;
end;


procedure free_n64_mem;
var
i:integer;
begin

        for i:=0 to N_SEGMENTS-1 do
        begin
       //	 if (mem_addr[i])<> 0 then
              freemem(mem_addr[i]);
        end;

       // free(phys_read_fast);
       // free(phys_write_fast);
        for i := 0 to $8000 do
        begin
//        freemem(phys_read_fast[i],sizeof(phys_read_fast[i]));
//        freemem(phys_write_fast[i],sizeof(phys_write_fast[i]));
        end;
end;



function doReadMemByte(where:uWORD):ubyte;
begin
        where := where xor $03;
        result := 0;//ubyte(@phys_read_fast[where shr 18](where));
end;




function doReadMemHalfWord(where:uWORD):uHWORD;
begin
        where := where xor $02;
        result := 0;//phys_read_fast[where shr 18](where);
end;




function doReadMemWord(where:uWORD):uWORD;
begin
        result := 0;//phys_read_fast[where shr 18](where);
end;



function doReadMemDoubleWord(where:uWORD):uDWORD;
var
value:longint;
begin
        value := 0;//phys_read_fast[where shr 18](where);
        result :=( (value shr  32) or (value shl 32) );
end;




procedure doWriteMemByte(what,where:uWORD);
var t:pointer;
begin
        where :=  where  xor $03;
        t := pointer(phys_write_fast[where shr 18](where));
        pointer(what) := t;
        final_check();
end;



procedure doWriteMemHalfWord(what, where:uWORD);
var t:pointer;
begin
        where :=what xor $02;
        t := pointer(phys_write_fast[where shr 18](where));
        pointer(what) := t;
        final_check;
end;



procedure doWriteMemWord(what, where:uWORD);
var t:pointer;
begin
        t := pointer(phys_write_fast[where shr 18](where));
        pointer(what) := t;
        final_check;
end;


procedure doWriteMemDoubleWord(what, where:uWORD);
var t:pointer;
begin
        t := pointer(phys_write_fast[where shr 18](where));
        pointer(what) := t;
        final_check;
end;

procedure init_fast_mem;
var
i:integer;
begin




        for i := ($0000 shr 2) to ($7fff shr 2)-1 do
        begin
        phys_read_fast[i] := @get_mapped;
        phys_write_fast[i] := @put_mapped;
        end;

    (* we map the first 4M (rdram) of mem to the first 4M of virtual
       addresses. THIS IS A HACK! - niki *)

    (* as i thought before - we dont need this hack - niki *)

    (* seems to be incorrect - niki
        for i :=  ($0000 shr  2) to  ($003f shr  2) do
        begin
                phys_read_fast[i] = get_mem_8000_803f;
                phys_write_fast[i] = put_mem_8000_803f;
        end;
    *)


    (**
     * $80000000 - $9fffffff: physical memory (cachable)
    **)

    (* rdram *)
        for i :=  ($8000 shr  2) to  ($803f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8000_803f;
                phys_write_fast[i] := @put_mem_8000_803f;
        end;

    (* not used *)
        for i :=  ($8040 shr  2) to  ($83ef shr  2) do
        begin
                phys_read_fast[i] := @get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* rdram reg *)
        for i :=  ($83f0 shr  2) to  ($83f0 shr  2) do
        begin
                phys_read_fast[i] := @get_mem_83f0_83f0;
                phys_write_fast[i] := @put_mem_83f0_83f0;
        end;

    (* not used *)
        for i :=  ($83f4 shr  2) to  ($83ff shr  2) do
        begin
                phys_read_fast[i] := @get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* dmem/imem *)
        for i :=  ($8400 shr  2) to  ($8400 shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8400_8400;
                phys_write_fast[i] := @put_mem_8400_8400;
        end;

    (* sp reg *)
        for i :=  ($8404 shr  2) to  ($8404 shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8404_8404;
                phys_write_fast[i] := @put_mem_8404_8404;
        end;

    (* sp pc/ibist *)
        for i :=  ($8408 shr  2) to  ($8408 shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8408_8408;
                phys_write_fast[i] := @put_mem_8408_8408;
        end;

    (* not used *)
        for i :=  ($840c shr  2) to  ($840f shr  2) do
        begin
                phys_read_fast[i] := @get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* dpc reg *)
        for i :=  ($8410 shr  2) to  ($841f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8410_841f;
                phys_write_fast[i] := @put_mem_8410_841f;
        end;

    (* dps reg *)
        for i :=  ($8420 shr  2) to  ($824f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8420_842f;
                phys_write_fast[i] := @put_mem_8420_842f;
        end;

    (* mi reg *)
        for i :=  ($8430 shr  2) to  ($843f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8430_843f;
                phys_write_fast[i] := @put_mem_8430_843f;
        end;

    (* vi reg *)
        for i :=  ($8440 shr  2) to  ($844f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8440_844f;
                phys_write_fast[i] := @put_mem_8440_844f;
        end;

    (* ai reg *)
        for i :=  ($8450 shr  2) to  ($845f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8450_845f;
                phys_write_fast[i] := @put_mem_8450_845f;
        end;

    (* pi reg *)
        for i :=  ($8460 shr  2) to  ($846f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8460_846f;
                phys_write_fast[i] := @put_mem_8460_846f;
        end;

    (* ri reg *)
        for i :=  ($8470 shr  2) to  ($847f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8470_847f;
                phys_write_fast[i] := @put_mem_8470_847f;
        end;

    (* si reg *)
        for i :=  ($8480 shr  2) to  ($848f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8480_848f;
                phys_write_fast[i] := @put_mem_8480_848f;
        end;

    (* not used *)
        for i :=  ($8490 shr  2) to  ($849f shr  2) do
        begin
                phys_read_fast[i] := @get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* cartridge domain 2 addr 1 *)
        for i :=  ($8500 shr  2) to  ($85ff shr  2) do
        begin
            (* pong seems not to work with this!
                   phys_read_fast[i] = get_rom;
            *)
                phys_read_fast[i] := @get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* cartridge domain 1 addr 1 *)
        for i :=  ($8600 shr  2) to  ($87ff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* cartridge domain 2 addr 2 *)
        for i :=  ($8800 shr  2) to  ($8fff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* cartridge domain 1 addr 2 *)
        for i :=  ($9000 shr  2) to  ($9fbf shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* pif ram/rom *)
        for i :=  ($9fc0 shr  2) to  ($9fcf shr  2) do
        begin
                phys_read_fast[i] := @get_mem_9fc0_9fcf;
                phys_write_fast[i] := @put_mem_9fc0_9fcf;
        end;

    (* cartridge domain 1 addr 3 *)
        for i :=  ($9fc0 shr  2) to  ($9fff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;



    (**
     * $a0000000 - $bfffffff: physical memory (uncachable) (copy of the above!)
    **)

    (* rdram *)
        for i :=  ($a000 shr  2) to  ($a03f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8000_803f;
                phys_write_fast[i] := @put_mem_8000_803f;
        end;

    (* not used *)
        for i :=  ($a040 shr  2) to  ($a3ef shr  2) do
        begin
                phys_read_fast[i]  := get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* rdram reg *)
        for i :=  ($a3f0 shr  2) to  ($a3f0 shr  2) do
        begin
                phys_read_fast[i]  := get_mem_83f0_83f0;
                phys_write_fast[i] := @put_mem_83f0_83f0;
        end;

    (* not used *)
        for i :=  ($a3f4 shr  2) to  ($a3ff shr  2) do
        begin
                phys_read_fast[i]  := get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* dmem/imem *)
        for i :=  ($a400 shr  2) to  ($a400 shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8400_8400;
                phys_write_fast[i] := @put_mem_8400_8400;
        end;

    (* sp reg *)
        for i :=  ($a404 shr  2) to  ($a404 shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8404_8404;
                phys_write_fast[i] := @put_mem_8404_8404;
        end;

    (* sp pc/ibist *)
        for i :=  ($a408 shr  2) to  ($a408 shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8408_8408;
                phys_write_fast[i] := @put_mem_8408_8408;
        end;

    (* not used *)
        for i :=  ($a40c shr  2) to  ($a40f shr  2) do
        begin
                phys_read_fast[i]  := get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* dpc reg *)
        for i :=  ($a410 shr  2) to  ($a41f shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8410_841f;
                phys_write_fast[i] := @put_mem_8410_841f;
        end;

    (* dps reg *)
        for i :=  ($a420 shr  2) to  ($a24f shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8420_842f;
                phys_write_fast[i] := @put_mem_8420_842f;
        end;

    (* mi reg *)
        for i :=  ($a430 shr  2) to  ($a43f shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8430_843f;
                phys_write_fast[i] := @put_mem_8430_843f;
        end;

    (* vi reg *)
        for i :=  ($a440 shr  2) to  ($a44f shr  2) do
        begin
                phys_read_fast[i]  := get_mem_8440_844f;
                phys_write_fast[i] := @put_mem_8440_844f;
        end;

    (* ai reg *)
        for i :=  ($a450 shr  2) to  ($a45f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8450_845f;
                phys_write_fast[i] := @put_mem_8450_845f;
        end;

    (* pi reg *)
        for i :=  ($a460 shr  2) to  ($a46f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8460_846f;
                phys_write_fast[i] := @put_mem_8460_846f;
        end;

    (* ri reg *)
        for i :=  ($a470 shr  2) to  ($a47f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8470_847f;
                phys_write_fast[i] := @put_mem_8470_847f;
        end;

    (* si reg *)
        for i :=  ($a480 shr  2) to  ($a48f shr  2) do
        begin
                phys_read_fast[i] := @get_mem_8480_848f;
                phys_write_fast[i] := @put_mem_8480_848f;
        end;

    (* not used *)
        for i :=  ($a490 shr  2) to  ($a49f shr  2) do
        begin
                phys_read_fast[i] := @get_electricalnoise;
                phys_write_fast[i] := @put_electricalnoise;
        end;

    (* cartridge domain 2 addr 1 *)
        for i :=  ($a500 shr  2) to  ($a5ff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* cartridge domain 1 addr 1 *)
        for i :=  ($a600 shr  2) to  ($a7ff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* cartridge domain 2 addr 2 *)
        for i :=  ($a800 shr  2) to  ($afff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* cartridge domain 1 addr 2 *)
        for i :=  ($b000 shr  2) to  ($bfbf shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;

    (* pif ram/rom *)
        for i :=  ($bfc0 shr  2) to  ($bfcf shr  2) do
        begin
                phys_read_fast[i] := @get_mem_9fc0_9fcf;
                phys_write_fast[i] := @put_mem_9fc0_9fcf;
        end;

    (* cartridge domain 1 addr 3 *)
        for i :=  ($bfd0 shr  2) to  ($bfff shr  2) do
        begin
                phys_read_fast[i] := @get_rom;
                phys_write_fast[i] := @put_electricalnoise;   (* rom is not writable :) *)
        end;



    (**
     * $c0000000 - $dfffffff: mapped memory
    **)

    (* mapped *)
        for i :=  ($c000 shr  2) to  ($dfff shr  2) do
        begin
                phys_read_fast[i] := @get_mapped;
                phys_write_fast[i] := @put_mapped;
        end;



    (**
     * $e0000000 - $ffffffff: mapped memory
    **)

    (* mapped *)
        for i :=  ($e000 shr  2) to  ($ffff shr  2) do
        begin
                phys_read_fast[i] := @get_mapped;
                phys_write_fast[i] := @put_mapped;
        end;


end; (* static void init_fast_mem() *)





function get_electricalnoise(virtualaddr:uWord):pchar;
begin
        result := nil;//pchar(null_mem + virtualaddr);
end;

function put_electricalnoise(virtualaddr:uWord):pchar;
begin
        result := nil;//null_mem + 4;
end;

function get_mapped(virtualaddr:uWord):pchar;
var
 i:integer;
 tlb:Pt_rs4300i_tlb;
 addr:longint;
begin

        //printf("TLB: read from: %08lx\n", virtualaddr);

        for i:=0 to 32 do
        begin
        tlb := @reg.tlb[i];
        if(virtualaddr and tlb^.invmask) = (tlb^.hl and tlb^.invmask) then
        begin
        if (tlb^.g)<> 0 then
        begin
        if(virtualaddr and tlb^.even_odd_checkbit)<> 0 then
        begin
        if(tlb^.lh and $02)<> 0 then
        begin
        addr := $80000000 or ((tlb^.lh shl 6) and (tlb^.invmask shr 1)) or (virtualaddr and (tlb^.mask shr 1));
        result := phys_read_fast[addr shr 18](addr);
        end
        else
       begin

             reg.cpr[0][BADVADDR] := virtualaddr;
             tlb_load_or_store := EXC_TLB_LOAD;
             reg.do_or_check_sthg := RS4300I_DO_TLB_INVALID_EXCEPTION;
             result := get_electricalnoise(virtualaddr);
       end;
       end
       else (* even entry (EntryLo0) *)
       begin
       if(tlb^.ll  and  $02)<> 0 then (* valid bit *)
       begin
       addr := $80000000 or ((tlb^.ll  shl   6)  and  (tlb^.invmask  shr   1))
                      or  (virtualaddr  and  (tlb^.mask  shr   1));

             //printf("physical addr: %08lx\n", addr);
             result := phys_read_fast[addr shr  18](addr); (* recursive! *)
     end
     else
     begin
         (* tlb invalid exception *)
             reg.cpr[0][BADVADDR] := virtualaddr;
             tlb_load_or_store := EXC_TLB_LOAD;
             reg.do_or_check_sthg := RS4300I_DO_TLB_INVALID_EXCEPTION;
             result := (get_electricalnoise(virtualaddr));
     end;
                                end;
                        end
                        else (* global bit not set *)
                        begin
                            (* ^. check ASID *)
                            (* BUG: we dont check the ASID here - not implemented *)

                                reg.cpr[0][BADVADDR] := virtualaddr;
                                tlb_load_or_store := EXC_TLB_LOAD;
                                //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;
                                //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;
                                result := (get_electricalnoise(virtualaddr));
                        end;
                end;
        end;

    (* there is no valid tlb entry ^. tlb miss exception *)
        reg.cpr[0][BADVADDR] := virtualaddr;
        tlb_load_or_store := EXC_TLB_LOAD;
    (* seems not to work - niki *)
        //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;
        //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;

        result := (get_electricalnoise(virtualaddr));
end;

function put_mapped(virtualaddr:uWord):pchar;          (* TLB *)
var
   i:integer;
   tlb:Pt_rs4300i_tlb;
   addr:longint;
begin

        //printf("TLB: write to: %08lx\n", virtualaddr);

        for i := 0 to 32 do (* we search from tlb entry 0 up to 31 *)
        begin
             tlb := @(reg.tlb[i]);
             if( (virtualaddr  and  tlb^.invmask) = (tlb^.hl  and  tlb^.invmask) ) then
             begin
             (* we checked the upper bits and found a tlb match *)
             if(tlb^.g)<> 0 then (* global bit *)
             begin
             if(virtualaddr  and  tlb^.even_odd_checkbit)<> 0 then (* odd entry (EntryLo1) *)
             begin
             if(tlb^.lh  and  $02)<> 0 then (* valid bit *)
             begin
             if(tlb^.lh  and  $04)<> 0 then (* dirty bit *)
             begin
             addr := $80000000  or  ((tlb^.lh  shl   6)  and  (tlb^.invmask  shr   1)) or  (virtualaddr  and  (tlb^.mask  shr   1));
             result := phys_read_fast[addr shr  18](addr); (* recursive! *)
             end
             else
             begin
                 (* tlb modification exception *)
                     reg.cpr[0][BADVADDR] := virtualaddr;
                     tlb_load_or_store := EXC_TLB_STORE;
                     reg.do_or_check_sthg := RS4300I_DO_TLB_MODIFICATION_EXCEPTION;
                     result := (get_electricalnoise(virtualaddr));
             end;
     end
     else
     begin
         (* tlb invalid exception *)
             reg.cpr[0][BADVADDR] := virtualaddr;
             tlb_load_or_store := EXC_TLB_STORE;
             reg.do_or_check_sthg := RS4300I_DO_TLB_INVALID_EXCEPTION;
             result := (get_electricalnoise(virtualaddr));
     end;
                                end
                                else (* even entry (EntryLo0) *)
                                begin
     if(tlb^.ll  and  $02)<>0 then (* valid bit *)
     begin
             if(tlb^.ll  and  $03)<> 0 then (* dirty bit *)
             begin
             addr := $80000000 or  ((tlb^.lh  shl   6)  and  (tlb^.invmask  shr   1)) or  (virtualaddr  and  (tlb^.mask  shr   1));
             result :=  phys_read_fast[addr shr  18](addr); (* recursive! *)
             end
             else
             begin
            (* tlb modified exception *)
            reg.cpr[0][BADVADDR] := virtualaddr;
            tlb_load_or_store := EXC_TLB_STORE;
            reg.do_or_check_sthg := RS4300I_DO_TLB_MODIFICATION_EXCEPTION;
            result := (get_electricalnoise(virtualaddr));
            end;
     end
     else
     begin
         (* tlb invalid exception *)
             reg.cpr[0][BADVADDR] := virtualaddr;
             tlb_load_or_store := EXC_TLB_STORE;
             reg.do_or_check_sthg := RS4300I_DO_TLB_INVALID_EXCEPTION;
             result := (get_electricalnoise(virtualaddr));
     end;
     end;
     end
     else (* global bit not set *)
     begin
     (* ^. check ASID *)
     (* BUG: we dont check the ASID here - not implemented *)
      reg.cpr[0][BADVADDR] := virtualaddr;
      tlb_load_or_store := EXC_TLB_STORE;
      //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;
      //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;
      result := (get_electricalnoise(virtualaddr));
       end;
       end;
        end;

    (* there is no valid tlb entry ^. tlb miss exception *)
        reg.cpr[0][BADVADDR] := virtualaddr;
        tlb_load_or_store := EXC_TLB_STORE;
    (* seems not to work - niki *)
        //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;
        //reg.do_or_check_sthg = RS4300I_DO_TLB_MISS_EXCEPTION;

       result := (put_electricalnoise(virtualaddr));
end;



function get_mem_8000_803f(virtualaddr:uWord):pchar;   (* rd_mem *)
begin
//      image.position := (virtualaddr  and  $3fffff);
//      image.read(X,4)
       result := nil;//rd_ram + (virtualaddr  and  $3fffff);
//       image.position := Mpos;
end;

function get_mem_83f0_83f0(virtualaddr:uWord):pchar;   (* rd_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $03f00028) then
        begin
{       image.position := (virtualaddr  and  $ff);
       image.read(X,4)
       result := (X);
       image.position := Mpos;}
        result := nil;//rd_reg[(virtualaddr  and  $ff)];
        end
        else
         result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8400_8400(virtualaddr:uWord):pchar;   (* dmem/imem *)
var
tempc:dword;
begin
        if((virtualaddr  and  $1fffffff) < $04001000) then
        begin
        tempc := (sp_dmem[(virtualaddr  and  $fff)+3] shl 24) or
                 (sp_dmem[(virtualaddr  and  $fff)+2] shl 16 ) or
                 (sp_dmem[(virtualaddr  and  $fff)+1] shl 8) or
                 (sp_dmem[(virtualaddr  and  $fff)]);
        result := tempc;
        end
        else if((virtualaddr  and  $1fffffff) < $04002000) then
        begin
                tempc := (sp_imem[(virtualaddr  and  $fff)+3] shl 24) or
                 (sp_imem[(virtualaddr  and  $fff)+2] shl 16 ) or
                 (sp_imem[(virtualaddr  and  $fff)+1] shl 8) or
                 (sp_imem[(virtualaddr  and  $fff)]);
          result := tempc;
        end
        else
            result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8404_8404(virtualaddr:uWord):pchar;   (* sp_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04040020) then
        begin

                result := sp_reg[(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8408_8408(virtualaddr:uWord):pchar;   (* sp pc/ibist *)
begin
        if((virtualaddr  and  $1fffffff) < $04080004) then
        begin
                result := (sp_reg_pc+(virtualaddr  and  $03));
        end
        else if((virtualaddr  and  $1fffffff) < $04080008) then
        begin

                result := (sp_reg_ibist + virtualaddr - $04080004);
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8410_841f(virtualaddr:uWord):longint;   (* dpc_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04100020)  then
        begin
                result := dpc_reg [(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8420_842f(virtualaddr:uWord):longint;   (* dps_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04200010) then
        begin
                result := dps_reg[ (virtualaddr  and  $ff)];
        end
        else
                result := get_electricalnoise(virtualaddr);
end;

function get_mem_8430_843f(virtualaddr:uWord):longint;   (* mi_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04300010) then
        begin
         result := mi_reg[ (virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8440_844f(virtualaddr:uWord):longint;   (* vi_reg *)
var
current_verical_line:sWORD;
begin
        current_verical_line := -1;

        if((virtualaddr  and  $1fffffff) < $04400038) then
        begin
        case (virtualaddr  and  $ff) of
        $10,
        $11,
        $12,
        $13:
        begin
        if(current_verical_line < 512) then
        current_verical_line := current_verical_line + 2
        else
        begin
        current_verical_line := 0;
        end;
        result := (current_verical_line) + (virtualaddr  and  $03);
        end;
        else
        result := vi_reg[(virtualaddr  and  $ff)];
        end;

        end
        else
        begin;
        result := (get_electricalnoise(virtualaddr));
        end;

end;

function get_mem_8450_845f(virtualaddr:uWord):longint;   (* ai_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04500018) then
        begin
        case (virtualaddr  and  $ff) of
        $00,   (* AI_DRAM_ADDR_REG *)
        $01,
        $02,
        $03:
        begin
        end;
        $04,   (* AI_LEN_REG *)
        $05,
        $06,
        $07:
        begin
        ai_reg[1] := 0; (* should count to zero! *)
        end;

        $08,   (* AI_CONTROL_REG *)
        $09,
        $0a,
        $0b:
        begin
        end;

        $0c,   (* AI_STATUS_REG *)
        $0d,
        $0e,
        $0f:
        begin
(*
                        if(dispatch(AUDIO_READY, 0))
                        begin
                                puts("AUDIO READY"); fflush(stdout);
                                (ai_reg[3] = $00000000;
         end;
         else
         begin
         ai_reg[3] := $c0000001;
         end;
*)
          if(ai_addr_len_buffer_full = 2) then
          ai_reg[3] := 0//$80000000
          else
          ai_reg[3] := $00000000;
          if(ai_addr_len_buffer_full = 3) then
          ai_addr_len_buffer_full := 0;

          (* ??? bit 0 ??? *)

          end;

          $10,   (* AI_DACRATE_REG *)
          $11,
          $12,
          $13:
          begin
          end;

          $14,   (* AI_BITRATE_REG *)
          $15,
          $16,
          $17:
          begin
          end;

         end; (* switch(virtualaddr  and  $ff) *)

                result := ai_reg[(virtualaddr  and  $ff)];
        end
        else
                result := get_electricalnoise(virtualaddr);
end;

function get_mem_8460_846f(virtualaddr:uWord):longint;   (* pi_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04600034) then
        begin
              result := pi_reg[ (virtualaddr  and  $ff)];
        end
        else
             result := (get_electricalnoise(virtualaddr));
end;

function get_mem_8470_847f(virtualaddr:uWord):longint;   (* ri_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04700020) then
        begin
                result := ri_reg[(virtualaddr  and  $ff)];
        end
        else
                result := get_electricalnoise(virtualaddr);
end;

function get_mem_8480_848f(virtualaddr:uWord):longint;   (* si_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $0480001c) then
        begin
        result := si_reg[(virtualaddr  and  $ff)];
        end
        else
        result := (get_electricalnoise(virtualaddr));
end;

function get_rom(virtualaddr:uWord):pchar;             (* cartridge domains *)
begin
        if((virtualaddr  and  $01ffffff) < rom.length) then
        begin
                //print_debug_msg(prefs.debug  and  DBG_PI_DOM2_ADDR1, "read  - rom");
{                Image.position := (virtualaddr  and  $01ffffff);
                Image.read(X,4);
                Image.position := Mpos;}
                result := rom.image + (virtualaddr  and  $01ffffff);
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function get_mem_9fc0_9fcf(virtualaddr:uWord):longint;   (* pif ram/rom *)
begin
        if((virtualaddr  and  $1fffffff) < $1fc007c0) then
        begin
       result := pi_rom[(virtualaddr  and  $fff)];
        end
        else if((virtualaddr  and  $1fffffff) < $1fc00800) then
        begin
        result := pi_ram[(virtualaddr  and  $1fffffff) - $1fc007c0];
        end
        else
        result := get_electricalnoise(virtualaddr);
end;





function put_mem_8000_803f(virtualaddr:uWord):longint;   (* rd_mem *)
begin
        result := rd_ram[(virtualaddr  and  $3fffff)];
end;

function put_mem_83f0_83f0(virtualaddr:uWord):longint;   (* rd_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $03f00028) then
        begin
                result := rd_reg [(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8400_8400(virtualaddr:uWord):longint;   (* dmem/imem *)
begin
        if((virtualaddr  and  $1fffffff) < $04001000) then
        begin
                result := sp_dmem [(virtualaddr  and  $fff)];
        end
        else if((virtualaddr  and  $1fffffff) < $04002000) then
        begin

                result := sp_imem [(virtualaddr  and  $fff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8404_8404(virtualaddr:uWord):longint;   (* sp_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04040020) then
        begin
         case (virtualaddr  and  $ff) of
         $00,   (* SP_MEM_ADDR_REG *)
         $01,
         $02,
         $03:
         begin
         end;

         $04,   (* SP_DRAM_ADDR_REG *)
         $05,
         $06,
         $07:
         begin
         end;

         $08,   (* SP_RD_LEN_REG *)
         $09,
         $0a,
         $0b:
         begin
         mem_todo := mem_todo or DRAM2IDMEM_DMA;
         end;


         $0c,   (* SP_WR_LEN_REG *)
         $0d,
         $0e,
         $0f:
         begin
         mem_todo  := mem_todo  or IDMEM2DRAM_DMA;
         end;

         $10,   (* SP_STATUS_REG *)
         $11,
         $12,
         $13:
         begin
         mem_todo := mem_todo or _UPDATE_SP_REG;
         result := (sp_reg_status_w) + (virtualaddr  and  $3);
         end;

         $14,   (* SP_DMA_FULL_REG (ro) *)
         $15,
         $16,
         $17: result := null_mem[0];

         $18,   (* SP_DMA_BUSY_REG (ro) *)
         $19,
         $1a,
         $1b:  result := null_mem[0];

         $1c,   (* SP_SEMAPHORE_REG *)
         $1d,
         $1e,
         $1f:begin
             end;

         end; (* switch(virtualaddr  and  $ff) *)

        result := sp_reg [(virtualaddr  and  $ff)];
        end
        else
        result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8408_8408(virtualaddr:uWord):longint;   (* sp pc/ibist *)
begin
        if((virtualaddr  and  $1fffffff) < $04080004) then
        begin
                result := (sp_reg_pc) + (virtualaddr  and  $03);
        end
        else if((virtualaddr  and  $1fffffff) < $04080008) then
        begin
                result := (sp_reg_ibist) + virtualaddr - $04080004;
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8410_841f(virtualaddr:uWord):longint;   (* dpc_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04100020) then
        begin
        case (virtualaddr  and  $ff) of
        $00,   (* DPC_START_REG *)
        $01,
        $02,
        $03:begin end;


        $04,   (* DPC_END_REG *)
        $05,
        $06,
        $07:
        begin
        mem_todo :=mem_todo  or DO_RUN_RDP;
        end;

        $08,   (* DPC_CURRENT_REG (ro) *)
        $09,
        $0a,
        $0b: result := null_mem[0];

        $0c,   (* DPC_STATUS_REG *)
        $0d,
        $0e,
        $0f:begin
            mem_todo := mem_todo or _UPDATE_DP_REG;
            result := (dpc_reg_status_w) + (virtualaddr  and  $3);
            end;
         $10,   (* DPC_CLOCK_REG (ro) *)
         $11,
         $12,
         $13: result := null_mem[0];

         $14,   (* DPC_BUFBUSY_REG (ro) *)
         $15,
         $16,
         $17: result := null_mem[0];

         $18,   (* DPC_PIPEBUSY_REG (ro) *)
         $19,
         $1a,
         $1b: result := null_mem[0];

         $1c,   (* DPC_TMEM_REG (ro) *)
         $1d,
         $1e,
         $1f: result := null_mem[0];

         end; (* switch(virtualaddr  and  $ff) *)

        result := dpc_reg[(virtualaddr  and  $ff)];
        end
        else
        result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8420_842f(virtualaddr:uWord):longint;   (* dps_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04200010) then
        begin
        result := dps_reg [(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8430_843f(virtualaddr:uWord):longint;   (* mi_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04300010) then
        begin
        case (virtualaddr  and  $f) of
        $00,   (* MI_MODE_REG *)
        $01,
        $02,
        $03:
        begin
        mem_todo  :=mem_todo or _UPDATE_MI_REG;
        result := (mi_reg_mode_w) + (virtualaddr  and  $3);
        end;
        $04,   (* MI_VERSION_REG *)
        $05,
        $06,
        $07: result := null_mem[0];

        $08,   (* MI_INTR_REG *)
        $09,
        $0a,
        $0b: result := null_mem[0];


        $0c,   (* MI_INTR_MASK_REG *)
        $0d,
        $0e,
        $0f:
        begin
        mem_todo :=  mem_todo or _UPDATE_MI_REG;
        reg.do_or_check_sthg  :=reg.do_or_check_sthg  or RS4300I_CHECK_MI_INTERRUPTS;
        result := (mi_reg_intr_mask_w) + (virtualaddr  and  $3);
        end;

        end; (* switch(virtualaddr  and  $f) *)

                result := mi_reg[(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8440_844f(virtualaddr:uWord):longint;   (* vi_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04400038) then
        begin
        case (virtualaddr  and  $ff) of
        $00,   (* VI_CONTROL_REG *)
        $01,
        $02,
        $03:
        begin
        mem_todo := mem_todo  or _CHECK_VI_REG;
        end;

        $04,   (* VI_ORIGIN_REG *)
        $05,
        $06,
        $07:
        begin
        mem_todo  := mem_todo  or _UPDATE_VI_REG;
        mem_todo  := mem_todo  or _DO_DISPLAY_REFRESH;
        end;

        $08,   (* VI_WIDTH_REG *)
        $09,
        $0a,
        $0b:
        begin
        mem_todo  :=mem_todo  or _UPDATE_VI_REG;
        mem_todo  :=mem_todo  or _CHECK_VI_REG;
        end;

        $0c,   (* VI_INTR_REG *)
        $0d,
        $0e,
        $0f:begin end;

        $10,   (* VI_CURRENT_REG *)
        $11,
        $12,
        $13:
        begin
        mi_reg[2]  := mi_reg[2] and not MI_INTR_VI;   (* clr VI int line *)
        result := null_mem[0];
        end;

        $14,   (* VI_BURST_REG *)
        $15,
        $16,
        $17:begin end;


        $18,   (* VI_V_SYNC_REG *)
        $19,
        $1a,
        $1b:
        begin
        end;

         $1c,   (* VI_H_SYNC_REG *)
         $1d,
         $1e,
         $1f:begin end;

         $20,   (* VI_H_SYNC_LEAP_REG *)
         $21,
         $22,
         $23:begin end;

         $24,   (* VI_H_START_REG *)
         $25,
         $26,
         $27:begin end;

         $28,   (* VI_V_START_REG *)
         $29,
         $2a,
         $2b:begin end;

         $2c,   (* VI_V_BURST_REG *)
         $2d,
         $2e,
         $2f:begin end;

         $30,   (* VI_X_SCALE_REG *)
         $31,
         $32,
         $33:begin end;

         $34,   (* VI_Y_SCALE_REG *)
         $35,
         $36,
         $37:begin end;


        end; (* switch(virtualaddr  and  $ff) *)

         result := vi_reg[ (virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8450_845f(virtualaddr:uWord):longint;   (* ai_reg *)
var
ai_addr_len_buffer_full:longint;
begin
        ai_addr_len_buffer_full := 0;

        if((virtualaddr  and  $1fffffff) < $04500018) then
        begin
        case (virtualaddr  and  $ff)of

          $00,   (* AI_DRAM_ADDR_REG *)
          $01,
          $02,
          $03:
          begin
          if(ai_addr_len_buffer_full = 0) then
                                ai_addr_len_buffer_full := 1
                        else if(ai_addr_len_buffer_full = 1) then
                                ai_addr_len_buffer_full := 1;
          end;

          $04,   (* AI_LEN_REG *)
          $05,
          $06,
          $07:
          begin
         if(ai_addr_len_buffer_full = 0) then
                                ai_addr_len_buffer_full := 0
                        else if(ai_addr_len_buffer_full = 1) then
                                ai_addr_len_buffer_full := 2;
          end;

          $08,   (* AI_CONTROL_REG *)
          $09,
          $0a,
          $0b:
          begin
          if(ai_addr_len_buffer_full = 2) then
                                ai_addr_len_buffer_full := 3;
          mem_todo :=mem_todo  or _CHECK_AI_REG;
          end;

          $0c,   (* AI_STATUS_REG *)
          $0d,
          $0e,
          $0f:
          begin
          mi_reg[2]  := mi_reg[2]  and not MI_INTR_AI;   (* clr AI int line *)
          reg.do_or_check_sthg  := reg.do_or_check_sthg  and not RS4300I_DO_AI_INTERRUPT;   (* from jeff *)
          result := null_mem[0];
          end;

          $10,   (* AI_DACRATE_REG *)
          $11,
          $12,
          $13:begin end;

          $14,   (* AI_BITRATE_REG *)
          $15,
          $16,
          $17:begin end;

                end; (* switch(virtualaddr  and  $ff) *)

                result := ai_reg[ (virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8460_846f(virtualaddr:uWord):longint;   (* pi_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04600034) then
        begin


        case (virtualaddr  and  $ff) of
          $0c,   (* PI_WR_LEN_REG *)
          $0d,
          $0e,
          $0f:begin
              mem_todo :=  mem_todo or  PI_DMA;
              end;

          $10,   (* PI_STATUS_REG *)
          $11,
          $12,
          $13:begin
          mem_todo := mem_todo or _UPDATE_PI_REG;
          result := (pi_reg_status_w) + (virtualaddr  and  $3);
           end; (* switch(virtualaddr  and  $ff) *)
           end;

                result := pi_reg [(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8470_847f(virtualaddr:uWord):longint;   (* ri_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $04700020) then
        begin
                result := ri_reg[ (virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_8480_848f(virtualaddr:uWord):longint;   (* si_reg *)
begin
        if((virtualaddr  and  $1fffffff) < $0480001c) then
        begin

                case (virtualaddr  and  $ff) of

          $00,   (* SI_DRAM_ADDR_REG *)
          $01,
          $02,
          $03:
                    begin
                    end;

          $04,   (* SI_PIF_ADDR_RD64B_REG *)
          $05,
          $06,
          $07:
                    begin
                    mem_todo := mem_todo or PIF2DRAM_DMA;
                    end;

          $08,   (* reserved *)
          $09,
          $0a,
          $0b:
                        result := null_mem[0];

          $0c,   (* reserved *)
          $0d,
          $0e,
          $0f: result := null_mem[0];

          $10,   (* SI_PIF_ADDR_WR64B_REG *)
          $11,
          $12,
          $13:
                    begin
                    mem_todo := mem_todo or DRAM2PIF_DMA;
                    end;

          $14,   (* reserved *)
          $15,
          $16,
          $17:
                        result := null_mem[0];

          $18,   (* SI_STATUS_REG *)
          $19,
          $1a,
          $1b:
                    begin
                        mi_reg[2] := mi_reg[2] and not MI_INTR_SI;   (* clr SI intr in MI reg *)
                        si_reg[6] := si_reg[6] and not$00000001;   (* BUG:? *)
                        result := null_mem[0];
                    end;
                end; (* switch(virtualaddr  and  $ff) *)

                result := si_reg[(virtualaddr  and  $ff)];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;

function put_mem_9fc0_9fcf(virtualaddr:uWord):longint;   (* pif ram/rom *)
begin
        if((virtualaddr  and  $1fffffff) < $1fc007c0) then
        begin
                result := pi_rom[ (virtualaddr  and  $fff)];
        end
        else if((virtualaddr  and  $1fffffff) < $1fc00800) then
        begin
                result := pi_ram [ (virtualaddr  and  $1fffffff) - $1fc007c0];
        end
        else
                result := (get_electricalnoise(virtualaddr));
end;









procedure write_mem_addr;
begin
   rd_ram     := @mem_addr[0];
   sp_dmem     := @mem_addr[1];
   sp_imem     := @mem_addr[2];
   pi_rom      := @mem_addr[3];
   pi_ram      := @mem_addr[4];
   pi_ram_w    := @mem_addr[5];

   rd_reg      := @mem_addr[6];
   sp_reg      := @mem_addr[7];
   dpc_reg     := @mem_addr[8];
   dps_reg     := @mem_addr[9];
   mi_reg      := @mem_addr[10];
   mi_reg_w    := @mem_addr[11];
   vi_reg      := @mem_addr[12];
   ai_reg      := @mem_addr[13];
   pi_reg      := @mem_addr[14];
   pi_reg_w    := @mem_addr[15];
   ri_reg      := @mem_addr[16];
   si_reg      := @mem_addr[17];
   tmem        := @mem_addr[18];
   null_mem    := @mem_addr[19];
end;









procedure do_display_refresh;
begin
//        dispatch(DISPLAY_REFRESH, 0);
RefreshVisual;
end;





procedure check_vi_reg;
begin
        (* BUG: the order might be changed. most changing reg first. (speed) *)
        if( old_vi_status_reg <> vi_reg[0] ) then
        begin
        old_vi_status_reg := vi_reg[0];
        //dispatch(DISPLAY_REFRESH, 0);
        exit;
        end;

        if( old_vi_width_reg  <> vi_reg[2] ) then
        begin
        old_vi_width_reg  := vi_reg[2];
        //dispatch(DISPLAY_REFRESH, 0);
        exit;
        end;

end; (* static void check_vi_reg() *)





procedure check_ai_reg;
begin
//        dispatch(AUDIO_UPDATE, 0);
end; (* static void update_ai_reg() *)





procedure update_vi_reg;
begin
        (* there are some unused bits in this regs.
           hope that this works *)
        vi_reg[1]  := vi_reg[1] and $003fffff;
        vi_reg[2]  := vi_reg[2] and $00000fff;
        //printf("VI addr reg: %lx\n", vi_reg[1]);

end; (* static void update_vi_reg() *)





procedure update_pi_reg;
begin
        if(pi_reg_status_w  and  $02)<> 0 then
         mi_reg[2]  :=  mi_reg[2]  and not MI_INTR_PI;

end; (* static void update_pi_reg() *)





procedure update_mi_reg;
begin
        if(mi_reg_mode_w  and  $0080) <>0 then       (* MI_CLR_INIT *)
                mi_reg[0]  := mi_reg[0] and not $00000080;

        if(mi_reg_mode_w  and  $0100)<>0 then        (* MI_SET_INIT *)
                mi_reg[0]  := mi_reg[0] or $00000080;

        if(mi_reg_mode_w  and  $0200) <>0 then       (* MI_CLR_EBUS *)
                mi_reg[0]  := mi_reg[0] and not $00000100;

        if(mi_reg_mode_w  and  $0400) <>0 then       (* MI_SET_EBUS *)
                mi_reg[0]  := mi_reg[0] or $00000100;

        if(mi_reg_mode_w  and  $0800)<>0 then        (* MI_CLR_DP_INTR *)
                mi_reg[2]  := mi_reg[0] and not MI_INTR_DP;

        if(mi_reg_mode_w  and  $1000)<>0 then        (* MI_CLR_RDRAM *)
                mi_reg[0]  :=mi_reg[0] and not $00000200;

        if(mi_reg_mode_w  and  $2000)<>0 then        (* MI_SET_RDRAM *)
                mi_reg[0]  := mi_reg[0] or $00000200;



        if(mi_reg_intr_mask_w  and  $0001)<>0 then        (* MI_INTR_MASK_CLR_SP *)
                mi_reg[3]  := mi_reg[3] and not$0000001;

        if(mi_reg_intr_mask_w  and  $0002)<>0 then        (* MI_INTR_MASK_SET_SP *)
                mi_reg[3]  := mi_reg[3] or $00000001;

        if(mi_reg_intr_mask_w  and  $0004)<>0 then        (* MI_INTR_MASK_CLR_SI *)
                mi_reg[3]  := mi_reg[3] and not $0000002;

        if(mi_reg_intr_mask_w  and  $0008)<>0 then        (* MI_INTR_MASK_SET_SI *)
                mi_reg[3] := mi_reg[3] or $00000002;

        if(mi_reg_intr_mask_w  and  $0010)<>0 then        (* MI_INTR_MASK_CLR_AI *)
                mi_reg[3] := mi_reg[3] and not $00000004;

        if(mi_reg_intr_mask_w  and  $0020)<>0 then        (* MI_INTR_MASK_SET_AI *)
                mi_reg[3] := mi_reg[3] or  $00000004;

        if(mi_reg_intr_mask_w  and  $0040)<>0 then        (* MI_INTR_MASK_CLR_VI *)
                mi_reg[3] := mi_reg[3] and not $00000008;

        if(mi_reg_intr_mask_w  and  $0080)<>0 then        (* MI_INTR_MASK_SET_VI *)
                mi_reg[3] := mi_reg[3] or $00000008;

        if(mi_reg_intr_mask_w  and  $0100)<>0 then        (* MI_INTR_MASK_CLR_PI *)
                mi_reg[3] := mi_reg[3] and not $00000010;

        if(mi_reg_intr_mask_w  and  $0200)<>0 then        (* MI_INTR_MASK_SET_PI *)
                mi_reg[3] := mi_reg[3] or $00000010;

        if(mi_reg_intr_mask_w  and  $0400)<>0 then        (* MI_INTR_MASK_CLR_DP *)
                mi_reg[3] := mi_reg[3] and not $00000020;

        if(mi_reg_intr_mask_w  and  $0800)<>0 then        (* MI_INTR_MASK_SET_DP *)
                mi_reg[3]  := mi_reg[3] or $00000020;

end; (* static void update_mi_reg() *)






procedure update_sp_reg;
begin
        if(sp_reg_status_w  and  $00000001)<> 0 then   (* SP_CLR_HALT       *)
        begin
                sp_reg[4] := sp_reg[4] and not $00000001;
                //rsp_reg.halt := 0;
        end;

        if(sp_reg_status_w  and  $00000002)<> 0 then   (* SP_SET_HALT       *)
        begin
                sp_reg[4]  := sp_reg[4] or $00000001;
                //rsp_reg.halt = 1;
        end;

        if(sp_reg_status_w  and  $00000004)<> 0 then   (* SP_CLR_BROKE      *)
                sp_reg[4]  := sp_reg[4] and not $00000002;

        if(sp_reg_status_w  and  $00000008)<> 0 then   (* SP_CLR_INTR       *)
                mi_reg[2] := sp_reg[2] and not MI_INTR_SP;

        if(sp_reg_status_w  and  $00000010)<> 0 then   (* SP_SET_INTR       *)
        begin
                mi_reg[2]  := sp_reg[2] or MI_INTR_SP;
                reg.do_or_check_sthg := RS4300I_CHECK_MI_INTERRUPTS;
        end;

        if(sp_reg_status_w  and  $00000020)<> 0 then   (* SP_CLR_SSTEP      *)
        begin
                sp_reg[4]  := sp_reg[4] and not $00000020;
        end;

        if(sp_reg_status_w  and  $00000040)<> 0 then   (* SP_SET_SSTEP      *)
        begin
                sp_reg[4]  := sp_reg[4] or $00000020;
        end;

        if(sp_reg_status_w  and  $00000080)<> 0 then   (* SP_CLR_INTR_BREAK *)
                sp_reg[4] := sp_reg[4] and not $00000040;

        if(sp_reg_status_w  and  $00000100)<> 0 then   (* SP_SET_INTR_BREAK *)
                sp_reg[4] := sp_reg[4] or $00000040;

        if(sp_reg_status_w  and  $00000200)<> 0 then   (* SP_CLR_SIG0       *)
                sp_reg[4] := sp_reg[4] and not $00000080;

        if(sp_reg_status_w  and  $00000400)<> 0 then   (* SP_SET_SIG0       *)
                sp_reg[4] := sp_reg[4] or  $00000080;

        if(sp_reg_status_w  and  $00000800)<> 0 then   (* SP_CLR_SIG1       *)
                sp_reg[4]  := sp_reg[4] and not $00000100;

        if(sp_reg_status_w  and  $00001000)<> 0 then   (* SP_SET_SIG1       *)
                sp_reg[4] := sp_reg[4] or $00000100;

        if(sp_reg_status_w  and  $00002000)<> 0 then   (* SP_CLR_SIG2       *)
                sp_reg[4]  := sp_reg[4] and not $00000200;

        if(sp_reg_status_w  and  $00004000)<> 0 then   (* SP_SET_SIG2       *)
                sp_reg[4] := sp_reg[4] or  $00000200;

        if(sp_reg_status_w  and  $00008000)<> 0 then   (* SP_CLR_SIG3       *)
                sp_reg[4] := sp_reg[4] and not $00000400;

        if(sp_reg_status_w  and  $00010000)<> 0 then   (* SP_SET_SIG3       *)
                sp_reg[4] := sp_reg[4] or $00000400;

        if(sp_reg_status_w  and  $00020000)<> 0 then   (* SP_CLR_SIG4       *)
                sp_reg[4] := sp_reg[4]  and not $00000800;

        if(sp_reg_status_w  and  $00040000)<> 0 then   (* SP_SET_SIG4       *)
                sp_reg[4]  := sp_reg[4] or $00000800;

        if(sp_reg_status_w  and  $00080000)<> 0 then   (* SP_CLR_SIG5       *)
                sp_reg[4] := sp_reg[4] and not $00001000;

        if(sp_reg_status_w  and  $00100000)<> 0 then   (* SP_SET_SIG5       *)
                sp_reg[4] := sp_reg[4] or $00001000;

        if(sp_reg_status_w  and  $00200000)<> 0 then   (* SP_CLR_SIG6       *)
                sp_reg[4] := sp_reg[4] and not $00002000;

        if(sp_reg_status_w  and  $00400000)<> 0 then   (* SP_SET_SIG6       *)
                sp_reg[4] := sp_reg[4] or  $00002000;

        if(sp_reg_status_w  and  $00800000)<> 0 then   (* SP_CLR_SIG7       *)
                sp_reg[4]  := sp_reg[4] and not $00004000;

        if(sp_reg_status_w  and  $01000000)<> 0 then   (* SP_SET_SIG7       *)
                sp_reg[4]  := sp_reg[4] or $00004000;

end; (* static void update_sp_reg() *)





procedure update_dp_reg;
begin
        if(dpc_reg_status_w  and  $0001)<>0 then      (* DPC_CLR_XBUS_DMEM_DMA *)
                dpc_reg[3]  := dpc_reg[3] and not $0000001;

        if(dpc_reg_status_w  and  $0002)<>0 then      (* DPC_SET_XBUS_DMEM_DMA *)
                dpc_reg[3] := dpc_reg[3] or $00000001;

        if(dpc_reg_status_w  and  $0004)<>0 then      (* DPC_CLR_FREEZE *)
                dpc_reg[3] := dpc_reg[3] and not $0000002;

        if(dpc_reg_status_w  and  $0008)<>0 then       (* DPC_SET_FREEZE *)
                dpc_reg[3] := dpc_reg[3] or $00000002;

        if(dpc_reg_status_w  and  $0010)<>0 then      (* DPC_CLR_FLUSH *)
                dpc_reg[3] := dpc_reg[3] and not $0000004;

        if(dpc_reg_status_w  and  $0020)<>0 then      (* DPC_SET_FLUSH *)
                dpc_reg[3] := dpc_reg[3] or $00000004;

        if(dpc_reg_status_w  and  $0040)<>0 then      (* DPC_CLR_TMEM_CTR *)
                dpc_reg[7] := 0;

        if(dpc_reg_status_w  and  $0080)<>0 then      (* DPC_CLR_PIPE_CTR *)
                dpc_reg[6] := 0;

        if(dpc_reg_status_w  and  $0100)<>0 then      (* DPC_CLR_CMD_CTR *)
                dpc_reg[5] := 0;

        if(dpc_reg_status_w  and  $0200)<>0 then      (* DPC_CLR_CLOCK_CTR *)
                dpc_reg[4] := 0;

end; (* static void update_dp_reg() *)






end.
