unit interrupts;

interface
uses windows;
const MI_INTR_NO   =   $00;
const MI_INTR_ALL  =   $3f;
const MI_INTR_SP   =   $01;
const MI_INTR_SI   =   $02;
const MI_INTR_AI   =   $04;
const MI_INTR_VI   =   $08;
const MI_INTR_PI   =   $10;
const MI_INTR_DP   =   $20;
const INTR_COUNT   =   $80000001;

const VERTICAL_RETRACE_TIME = $98968;
    next_interrupt_count:longint = 0;
    next_vi_interrupt:longint = 0;


procedure rs4300i_InitInterrupts;
procedure  rs4300i_VI_or_CP_calc;
procedure rs4300i_VI_or_CP_interrupt;
procedure rs4300i_MI_Intr_SP;
procedure rs4300i_MI_Intr_SI;
procedure rs4300i_MI_Intr_AI;
procedure rs4300i_MI_Intr_VI;
procedure rs4300i_MI_Intr_PI;
procedure rs4300i_MI_Intr_DP;
procedure rs4300i_CompareInterrupt;
procedure _rs4300i_Check_MI_Interrupts;
procedure _rs4300i_Check_CPU_Interrupts;


implementation
uses exceptions,cpu,emulate,global;

procedure rs4300i_InitInterrupts;
var i:integer;
begin
        next_interrupt_count    := 0;
        next_vi_interrupt       := VERTICAL_RETRACE_TIME;

end;

procedure  rs4300i_VI_or_CP_calc;
var
 vi_diff:longint;
 cp_diff:longint;
begin

        vi_diff := next_vi_interrupt - (reg.cpr[0][COUNT]);
        cp_diff := (reg.cpr[0][COMPARE]) - (reg.cpr[0][COUNT]);
        if(cp_diff < vi_diff) then
        begin
                next_interrupt_count := (reg.cpr[0][COMPARE]);
        end
        else
        begin
                next_interrupt_count := next_vi_interrupt;
        end;

end; (* procedure rs4300i_VI_or_CP_calc; *)




procedure rs4300i_VI_or_CP_interrupt;
begin
        if(next_interrupt_count = next_vi_interrupt) then
        begin
                next_vi_interrupt := next_vi_interrupt + VERTICAL_RETRACE_TIME;
                rs4300i_MI_Intr_VI;
        end;

        if(next_interrupt_count = (reg.cpr[0][COMPARE])) then
        begin
                rs4300i_CompareInterrupt;
        end;

        rs4300i_VI_or_CP_calc;

end; (* procedure rs4300i_VI_or_CP_interrupt; *)




procedure rs4300i_MI_Intr_SP;
begin

        (* add MI_INTR_SP ($01) in MI INTR reg *)
        mi_reg[2] := mi_reg[2] or MI_INTR_SP;


        (* if MI_INTR_SP ($01) in MI INTR MASK reg is disabled: return *)
        if ((mi_reg[3]) and (MI_INTR_SP))=0 then exit;




        (* set IP2 in CAUSE reg *)
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or $0400;
        (* if IP2 or IE bits in STATUS reg are clr: return *)
        if((reg.cpr[0][STATUS] and $0401) <> $0401) then exit;



        (* if EXL or ERL bits in STATUS reg are set: return *)
        if (reg.cpr[0][STATUS] and $0006)<>0 then exit;


       (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not EXC_CODE__MASK;



        jump_to_common_exception_vector;

end; (* procedure rs4300i_MI_Intr_SP; *)




procedure rs4300i_MI_Intr_SI;
begin

        (* add bit # 12 in SI_STATUS_REG *)
           si_reg[6] := 7;//4096;
        (* add MI_INTR_SI ($02) in MI INTR reg *)
          mi_reg[2] := mi_reg[2] or MI_INTR_SI;
        (* if MI_INTR_SI ($02) in MI INTR MASK reg is disabled: return *)
        if ((mi_reg[3]  and  MI_INTR_SI))=0 then exit;

        (* set IP2 in CAUSE reg *)
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] or $0400;


        (* if IP2 or IE bits in STATUS reg are clr: return *)
        if((reg.cpr[0][STATUS]  and  $0401) <> $0401) then exit;


        (* if EXL or ERL bits in STATUS reg are set: return *)
        if(reg.cpr[0][STATUS]  and  $0006)<>0 then exit;


        (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE]  := reg.cpr[0][CAUSE] and not EXC_CODE__MASK;

        jump_to_common_exception_vector;

end; (* procedure rs4300i_MI_Intr_SI; *)

procedure rs4300i_MI_Intr_AI;
begin
        (* add MI_INTR_AI ($04) in MI INTR reg *)
        mi_reg[2] :=mi_reg[2] or MI_INTR_AI;

        (* if MI_INTR_AI ($00) in MI INTR MASK reg is disabled: return *)
        if (mi_reg[3]  and  MI_INTR_AI)=0 then exit;

        (* set IP2 in CAUSE reg *)
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] or $0400;



        (* if IP2 or IE bits in STATUS reg are clr: return *)
        if((reg.cpr[0][STATUS]  and  $0401) <> $0401) then exit;



        (* if EXL or ERL bits in STATUS reg are set: return *)
        if(reg.cpr[0][STATUS]  and  $0006)<>0 then exit;

        (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE]  :=reg.cpr[0][CAUSE] and not EXC_CODE__MASK;



        jump_to_common_exception_vector;

end; (* procedure rs4300i_MI_Intr_AI; *)




procedure rs4300i_MI_Intr_VI;
begin

        (* add MI_INTR_VI ($08) in MI INTR reg *)
        mi_reg[2] := mi_reg[2] or MI_INTR_VI;



        (* if MI_INTR_VI ($08) in MI INTR MASK reg is disabled: return *)
        if (mi_reg[3]  and  MI_INTR_VI) = 0 then exit;

        (* set IP2 in CAUSE reg *)
        reg.cpr[0][13] :=reg.cpr[0][13] or $0400;



        (* if IP2 or IE bits in STATUS reg are clr: return *)
        if((reg.cpr[0][12]  and  $0401) <> $0401) then exit;


        (* if EXL or ERL bits in STATUS reg are set: return *)
        if(reg.cpr[0][12]  and  $0006)=0 then exit;


        (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE]  := reg.cpr[0][CAUSE] and not EXC_CODE__MASK;

        jump_to_common_exception_vector;
end; (* static procedure rs4300i_MI_Intr_VI; *)




procedure rs4300i_MI_Intr_PI;
begin

        (* add MI_INTR_PI ($10) in MI INTR reg *)
        mi_reg[2] :=mi_reg[2] or MI_INTR_PI;



        (* if MI_INTR_PI ($10) in MI INTR MASK reg is disabled: return *)
        if(mi_reg[3]  and  MI_INTR_PI) = 0 then exit;


        (* set IP2 in CAUSE reg *)
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] or $0400;



        (* if IP2 or IE bits in STATUS reg are clr: return *)
        if ((reg.cpr[0][STATUS]  and  $0401) <> $0401) then exit;



        (* if EXL or ERL bits in STATUS reg are set: return *)
        if(reg.cpr[0][STATUS]  and  $0006)<> 0 then exit;

        (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE]  and not EXC_CODE__MASK;


        jump_to_common_exception_vector;

end; (* procedure rs4300i_MI_Intr_PI; *)




procedure rs4300i_MI_Intr_DP;
begin
        (* add MI_INTR_DP ($20) in MI INTR reg *)
        mi_reg[2] :=mi_reg[2] or MI_INTR_DP;



        (* if MI_INTR_DP ($20) in MI INTR MASK reg is disabled: return *)
        if (mi_reg[3]  and  MI_INTR_DP) = 0 then exit;

        (* set IP2 in CAUSE reg *)
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or $0400;


        (* if IP2 or IE bits in STATUS reg are clr: return *)
        if ((reg.cpr[0][STATUS]  and  $0401) <> $0401) then exit;


        (* if EXL or ERL bits in STATUS reg are set: return *)
        if(reg.cpr[0][STATUS]  and  $0006) <> 0 then exit;

        (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] and not  EXC_CODE__MASK;


        jump_to_common_exception_vector;

end; (* procedure rs4300i_MI_Intr_DP; *)





(* IP7 *)
procedure rs4300i_CompareInterrupt;
begin
        (* set IP7 in CAUSE reg *)
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or $8000;



        (* if IP7 or IE bits in STATUS reg are clr: return *)
        if((reg.cpr[0][STATUS]  and  $8001) <> $8001) then exit;



        (* if EXL or ERL bits in status reg are set: return *)
        if(reg.cpr[0][12]  and  $0006) <> 0 then exit;


        (* set ExcCode to Int (0) *)
        reg.cpr[0][CAUSE]  := reg.cpr[0][CAUSE]  and not EXC_CODE__MASK;



        jump_to_common_exception_vector;

end; (* static procedure rs4300i_CompareInterrupt; *)




procedure _rs4300i_Check_MI_Interrupts;
var
mi_old_intr_mask_reg : dword;
begin
        mi_old_intr_mask_reg := MI_INTR_NO;



        if(mi_old_intr_mask_reg <> mi_reg[3]) then
        begin
                mi_old_intr_mask_reg := mi_reg[3];

                if(mi_reg[3] and mi_reg[2]  and  MI_INTR_VI )<>0 then
                begin
                rs4300i_MI_Intr_VI;
                exit;
                end;

                if( (mi_reg)[3]  and  (mi_reg)[2]  and  MI_INTR_SI )<> 0 then
                begin
                rs4300i_MI_Intr_SI;
                exit;
                end;

                if( mi_reg[3]  and mi_reg[2]  and  MI_INTR_SP)<> 0 then
                begin
                rs4300i_MI_Intr_SP;
                exit;
                end;

                if( mi_reg[3]  and  mi_reg[2]  and  MI_INTR_DP ) <> 0 then
                begin
                rs4300i_MI_Intr_DP;
                exit;
                end;

                if( mi_reg[3]  and  mi_reg[2]  and  MI_INTR_AI )<> 0 then exit;
                begin
                rs4300i_MI_Intr_AI;
                exit;
                end;

                if( mi_reg[3]  and  mi_reg[2]  and  MI_INTR_PI ) <> 0 then
                begin
                rs4300i_MI_Intr_PI;
                exit;
                end;

        end; (* if(mi_old_intr_mask_reg <> (mem.mi_reg)[3]) *)

end; (* procedure rs4300i_Check_MI_Interrupts; *)



procedure _rs4300i_Check_CPU_Interrupts;
begin
        if (reg.cpr[0][STATUS]  and  reg.cpr[0][CAUSE]  and  $ff00) <> 0 then (* if any interrupt within mask is pending *)
        begin
                (* if IE bit in STATUS reg is set *)
                if(reg.cpr[0][STATUS]  and  $0001) <> 0 then
                begin
                        (* if EXL and ERL bits in STATUS reg are clr *)
                        if((reg.cpr[0][STATUS]  and  $0006) = $0000)then
                        begin

                                if( $ff00  and  reg.cpr[0][STATUS]  and  reg.cpr[0][CAUSE] )<> 0 then
                                begin
                                        //puts("YEAH!!!");
                                        jump_to_common_exception_vector;
                                end;

                        end; (* if((reg.cpr[0][STATUS]  and  $0006) == $0000) *)

                end; (* if(reg.cpr[0][STATUS]  and  $0001) *)

        end; (* if(reg.cpr[0][STATUS]  and  reg.cpr[0][CAUSE]  and  $ff00) *)

end; (* procedure rs4300i_Check_CPU_Interrupts; *)




end.


