unit exceptions;

interface
procedure jump_to_tlb_exception_vector;
procedure rs4300i_tlb_modification_exception;
procedure rs4300i_tlb_invalid_exception;
procedure rs4300i_tlb_miss_exception;
procedure rs4300i_reserved_instruction_exception;
procedure rs4300i_floating_point_exception;
procedure rs4300i_integer_overflow_exception;
procedure rs4300i_syscall_exception;
procedure rs4300i_break_exception;
procedure rs4300i_trap_exception;
procedure jump_to_common_exception_vector;
implementation
uses emulate,cpu,global;

function EXC_CODE(x:integer):integer;
begin
result :=     ((x)shl 2);
end;

function EXC_CODE_Int:integer;
begin
result := EXC_CODE(0);
end;

function EXC_CODE_Mod :integer;
begin
result := EXC_CODE(1);
end;


function EXC_CODE_TLBL:integer;
begin
result := EXC_CODE(2);
end;

function EXC_CODE_TLBS:integer;
begin
result := EXC_CODE(3);
end;

function EXC_CODE_AdEL:integer;
begin
result :=  EXC_CODE(4);
end;

function EXC_CODE_AdES:integer;
begin
result := EXC_CODE(5);
end;

function EXC_CODE_IBE:integer;
begin
result := EXC_CODE(6);
end;

function EXC_CODE_DBE:integer;
begin
result := EXC_CODE(7);
end;

function EXC_CODE_Sys:integer;
begin
result := EXC_CODE(8);
end;

function EXC_CODE_Bp:integer;
begin
result := EXC_CODE(9);
end;

function EXC_CODE_Ri:integer;
begin
result := EXC_CODE(10);
end;

function EXC_CODE_CpU:integer;
begin
result := EXC_CODE(11);
end;

function EXC_CODE_Ov:integer;
begin
result := EXC_CODE(12);
end;

function EXC_CODE_Tr:integer;
begin
result := EXC_CODE(13);
end;

function EXC_CODE_FPE:integer;
begin
result := EXC_CODE(15);
end;

function EXC_CODE_WATCH:integer;
begin
result := EXC_CODE(23);
end;

procedure rs4300i_trap_exception;
begin

        reg.cpr[0][9] :=reg.cpr[0][9] and not EXC_CODE__MASK;
        reg.cpr[0][9] := reg.cpr[0][9] or EXC_CODE_Tr;
        jump_to_common_exception_vector;
end;


procedure rs4300i_break_exception;
begin

        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not EXC_CODE__MASK;
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] or EXC_CODE_Bp;
        jump_to_common_exception_vector;
end;




procedure rs4300i_syscall_exception;
begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not EXC_CODE__MASK;
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_Sys;
        jump_to_common_exception_vector;
end;


procedure rs4300i_integer_overflow_exception;
begin

        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] and not EXC_CODE__MASK;
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_Ov;
        jump_to_common_exception_vector;
end;

procedure rs4300i_floating_point_exception;
begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] and not EXC_CODE__MASK;
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_FPE;
        jump_to_common_exception_vector;
end;

procedure rs4300i_reserved_instruction_exception;
begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not EXC_CODE__MASK;
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_Ri;

        jump_to_common_exception_vector;
end;

procedure rs4300i_tlb_miss_exception;
begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not EXC_CODE__MASK;
        if(tlb_load_or_store = EXC_TLB_STORE) then
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_TLBS;
        end
        else
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_TLBL;
        end;

        if (reg.cpr[0][STATUS] and $00000002)<> 0 then
        begin
                jump_to_common_exception_vector;
        end
        else
        begin
        jump_to_tlb_exception_vector;
        end;

end;




procedure rs4300i_tlb_invalid_exception;
begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE]  and not EXC_CODE__MASK;
        if(tlb_load_or_store = EXC_TLB_STORE) then
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or EXC_CODE_TLBS;
        end
        else
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE]  or EXC_CODE_TLBL;
        end;
        jump_to_common_exception_vector;
end;

procedure rs4300i_tlb_modification_exception;
begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE]  and not EXC_CODE__MASK;
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE]  or EXC_CODE_Mod;

        jump_to_common_exception_vector;
end;


procedure jump_to_tlb_exception_vector;
begin
        reg.cpr[0][STATUS] :=reg.cpr[0][STATUS] or $00000002;
        reg.cpr[0][EPC]  := reg.pc;

        if(reg.delay = EXEC_DELAY) then
        begin
        reg.cpr[0][CAUSE] := reg.cpr[0][CAUSE] or sword($80000000);
        reg.cpr[0][EPC]   := reg.cpr[0][EPC] - 4;
        end
        else
        begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not $80000000;
        end;
end;





procedure jump_to_common_exception_vector;
begin
        reg.cpr[0][STATUS] := reg.cpr[0][STATUS] or $00000002;
        reg.cpr[0][EPC]  := reg.pc;

        if(reg.delay = EXEC_DELAY) then
        begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] or sword($80000000);
        reg.cpr[0][EPC]   :=reg.cpr[0][EPC] - 4;
        end
        else
        begin
        reg.cpr[0][CAUSE] :=reg.cpr[0][CAUSE] and not $80000000;
        end;

        reg.pc := $80000180;
        reg.delay := NO_DELAY;

end;


end.
