unit dma;

interface
procedure dma_idmem2dram;
procedure dma_dram2idmem;
procedure dma_pif2dram;
procedure dma_dram2pif;
procedure dma_pi_copy;


implementation
uses global,controller;

procedure dma_idmem2dram;

const DMEM = $0000;
const IMEM = $1000;
var
imem_or_dmem,i:integer;
idmem_offset:longint;
dram_offset,dma_count,dma_skip,dma_length:longint;
begin

       idmem_offset := (sp_reg[0] and $fff);
       imem_or_dmem := (sp_reg[0] and $1000);

       dram_offset  := (sp_reg[1] and $ffffff);

       dma_length   := (sp_reg[3] and $00000fff);
//warning The following warnings are because 'count' and 'skip' are not implemented right now (Niki)
       dma_count    := (sp_reg[3] and $000ff000)shr 12;   (* BUG: not impl *)
       dma_skip     := (sp_reg[3] and $fff00000) shr 20;   (* BUG: not impl *)

//		dram_offset = AfterTLB(dram_offset);
        for i:=0 to dma_length-1 do
        begin
                if(imem_or_dmem and IMEM)<>0 then
                begin
                rd_ram[(i+dram_offset)xor 3] := sp_imem[(i+idmem_offset)xor 3];
                end
                else
                begin
                rd_ram[(i+dram_offset)xor 3] := sp_dmem[(i+idmem_offset)xor 3];
                end;

        end;

        reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_SP_INTERRUPT;

end; (* procedure dma_idmem2dram; *)





(*
   write happened to:
   SP_RD_LEN_REG   ($4040008)
*)

var
 newDList:boolean;
procedure dma_dram2idmem;
const DMEM = $0000;
const IMEM = $1000;
var
imem_or_dmem,i:integer;
idmem_offset:longint;
dram_offset,dma_count,dma_skip,dma_length:longint;
begin

       idmem_offset := (sp_reg[0] and $fff);
       imem_or_dmem := (sp_reg[0] and $1000);

       dram_offset  := (sp_reg[1] and $ffffff);

       dma_length   := (sp_reg[2] and $00000fff);
//warning The following warnings are because 'count' and 'skip' are not implemented right now (Niki)
       dma_count    := (sp_reg[2] and $000ff000) shr 12;   (* BUG: not impl *)
       dma_skip     := (sp_reg[2] and $fff00000) shr 20;   (* BUG: not impl *)

//		dram_offset = AfterTLB(dram_offset);
        for i:=0 to dma_length-1 do
        begin
                if(imem_or_dmem and IMEM)<> 0 then
                begin
                sp_imem[(i+idmem_offset)xor 3] := rd_ram[(i+dram_offset)xor 3];
                end
                else
                begin
                sp_dmem[(i+idmem_offset)xor 3] := rd_ram[(i+dram_offset)xor 3];
                end;
        end;

        reg.do_or_check_sthg := reg.do_or_check_sthg or  RS4300I_DO_SP_INTERRUPT;


    (**
    * The following checks if we have a graphics or audio task loaded.
    * This just should happen if the RSP is stopped.
    *
    * We also check if we have written to IMEM last time.
    * This might be a BUG!
    **)
 //       if(rsp_reg.halt = 1) then
//                if(imem_or_dmem and IMEM)<>0 then
  //					rdp_dl_check;


end; (* procedure dma_dram2idmem; *)






(*
   write happened to:
   SI_PIF_ADDR_RD64B_REG   ($4600004)
*)

procedure dma_pif2dram;
var
    i:integer;
   dram_offset:longint;
begin

       dram_offset := si_reg[0];
       controller_check;

        for i:=0 to 64-1 do
        begin
        rd_ram[i+dram_offset] := (pi_ram[i]);
        end;

        reg.do_or_check_sthg :=reg.do_or_check_sthg or RS4300I_DO_SI_INTERRUPT;

end; (* procedure dma_pif2dram; *)





(*
   write happened to:
   SI_PIF_ADDR_WR64B_REG   ($4600010)
*)

procedure dma_dram2pif;
var
i:integer;
dram_offset:longint;
begin

       dram_offset := si_reg[0];

        for i:=0 to 64-1 do
        begin
        pi_ram_w[i] := ord(rd_ram[i+dram_offset]);
        pi_ram[i] := pi_ram_w[i];
        end;

        //controller_check;

        reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_SI_INTERRUPT;

end; (* procedure dma_dram2pif; *)



procedure dma_pi_copy;
var
source,dest,len:longint;
i:integer;
tmp,tmp2:longint;
begin

       source := pi_reg[1];
       dest   := pi_reg[0];
       len    := pi_reg[3];


        (* BUG:? horrible hack *)
        source := source and $3ffffff;   (* 64MB ... assumed as max rom length *)

        if ((source+len) > rom.length) then
                len := rom.length - source;


        for i:=0 to len-1 do
        begin
   //     tmp2 := ;
  //      Image.position := tmp2;
 //       image.read(X,4);
        rd_ram[(i+dest)xor 3] := byte(rom.image[(i+source) xor 3]);
//        Image.position := mpos;
        end;

        reg.do_or_check_sthg := reg.do_or_check_sthg or RS4300I_DO_PI_INTERRUPT;

end; (* procedure dma_pi_copy; *)

end.

