/*$T iFPUWithException.c GC 1.136 03/09/02 17:28:59 */


/*$6
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    Interpretive functions for Coprocessor1 (FPU)
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */


/*
 * 1964 Copyright (C) 1999-2004 Joel Middendorf, <schibo@emulation64.com> This
 * program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version. This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details. You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. To contact the
 * authors: email: schibo@emulation64.com, rice1964@yahoo.com
 */
#include "stdafx.h"

void InterpreterCheckCP1Unusable(void OpcodeAddress(uint32), uint32 Instruction)
{
	if((gHWS_COP0Reg[STATUS] & SR_CU1) || currentromoptions.FPU_Hack == USEFPUHACK_NO)
	{
		OpcodeAddress(Instruction);
	}
	else
	{
		TriggerFPUUnusableException();
	}
}

// Opcodes

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_add_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_add_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_sub_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_sub_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_mul_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_mul_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_div_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_div_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_add_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_add_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_sub_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_sub_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_mul_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_mul_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_div_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_div_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_abs_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_abs_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_sqrt_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_sqrt_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_neg_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_neg_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_abs_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_abs_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_sqrt_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_sqrt_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_neg_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_neg_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_bc1f(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_bc1f, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_bc1t(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_bc1t, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_bc1fl(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_bc1fl, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_bc1tl(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_bc1tl, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_EQ_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_EQ_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_UEQ_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_UEQ_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_EQ_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_EQ_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_UEQ_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_UEQ_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_LT_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_LT_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGE_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGE_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_LT_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_LT_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGE_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGE_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_LE_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_LE_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGT_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGT_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_LE_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_LE_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGT_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGT_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cfc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cfc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_ctc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_ctc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtd_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtd_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtd_w(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtd_w, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtd_l(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtd_l, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvts_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvts_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvts_l(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvts_l, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtw_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtw_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtl_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtl_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtl_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtl_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvts_w(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvts_w, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_cvtw_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_cvtw_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_mtc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_mtc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_mfc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_mfc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_dmtc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_dmtc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_dmfc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_dmfc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_mov_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_mov_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_mov_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_mov_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_lwc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_lwc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_swc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_swc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_ldc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_ldc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_sdc1(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_sdc1, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_truncw_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_truncw_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_truncw_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_truncw_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_truncl_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_truncl_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_truncl_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_truncl_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_floorl_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_floorl_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_floorl_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_floorl_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_floorw_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_floorw_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_floorw_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_floorw_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_roundl_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_roundl_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_roundl_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_roundl_d, Instruction);
}


/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_roundw_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_roundw_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_roundw_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_roundw_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_ceilw_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_ceilw_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_ceilw_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_ceilw_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_ceill_s(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_ceill_s, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_COP1_ceill_d(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_COP1_ceill_d, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_UN_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_UN_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_UN_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_UN_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_OLT_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_OLT_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_OLT_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_OLT_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_ULT_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_ULT_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_ULT_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_ULT_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_OLE_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_OLE_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_OLE_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_OLE_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_ULE_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_ULE_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_ULE_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_ULE_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_SF_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_SF_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_SF_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_SF_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGLE_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGLE_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGLE_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGLE_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_SEQ_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_SEQ_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_SEQ_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_SEQ_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGL_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGL_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_NGL_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_NGL_D, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_F_S(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_F_S, Instruction);
}

/*
 =======================================================================================================================
 =======================================================================================================================
 */
void CU1_r4300i_C_F_D(uint32 Instruction)
{
    InterpreterCheckCP1Unusable(&r4300i_C_F_D, Instruction);
}












//
//
//
//
// Opcode Map
//
//
//
//







void (*CU1_COP1_BC_Instruction[32]) (uint32 Instruction) =
{
	CU1_r4300i_COP1_bc1f, CU1_r4300i_COP1_bc1t, CU1_r4300i_COP1_bc1fl, CU1_r4300i_COP1_bc1tl, UNUSED, UNUSED, UNUSED, UNUSED,
	UNUSED,           UNUSED,           UNUSED,            UNUSED,            UNUSED, UNUSED, UNUSED, UNUSED,
	UNUSED,           UNUSED,           UNUSED,            UNUSED,            UNUSED, UNUSED, UNUSED, UNUSED,
	UNUSED,           UNUSED,           UNUSED,            UNUSED,            UNUSED, UNUSED, UNUSED, UNUSED
};

void (*CU1_COP1_S_Instruction[64]) (uint32 Instruction) =
{
	CU1_r4300i_COP1_add_s,
	CU1_r4300i_COP1_sub_s,
	CU1_r4300i_COP1_mul_s,
	CU1_r4300i_COP1_div_s,
	CU1_r4300i_COP1_sqrt_s,
	CU1_r4300i_COP1_abs_s,
	CU1_r4300i_COP1_mov_s,
	CU1_r4300i_COP1_neg_s,
	CU1_r4300i_COP1_roundl_s,
	CU1_r4300i_COP1_truncl_s,
	CU1_r4300i_COP1_ceill_s,
	CU1_r4300i_COP1_floorl_s,
	CU1_r4300i_COP1_roundw_s,
	CU1_r4300i_COP1_truncw_s,
	CU1_r4300i_COP1_ceilw_s,
	CU1_r4300i_COP1_floorw_s,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_COP1_cvtd_s,
	UNUSED,
	UNUSED,
	CU1_r4300i_COP1_cvtw_s,
	CU1_r4300i_COP1_cvtl_s,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_C_F_S,
	CU1_r4300i_C_UN_S,
	CU1_r4300i_C_EQ_S,
	CU1_r4300i_C_UEQ_S,
	CU1_r4300i_C_OLT_S,
	CU1_r4300i_C_ULT_S,
	CU1_r4300i_C_OLE_S,
	CU1_r4300i_C_ULE_S,
	CU1_r4300i_C_SF_S,
	CU1_r4300i_C_NGLE_S,
	CU1_r4300i_C_SEQ_S,
	CU1_r4300i_C_NGL_S,
	CU1_r4300i_C_LT_S,
	CU1_r4300i_C_NGE_S,
	CU1_r4300i_C_LE_S,
	CU1_r4300i_C_NGT_S
};

void (*CU1_COP1_D_Instruction[64]) (uint32 Instruction) =
{
	CU1_r4300i_COP1_add_d,
	CU1_r4300i_COP1_sub_d,
	CU1_r4300i_COP1_mul_d,
	CU1_r4300i_COP1_div_d,
	CU1_r4300i_COP1_sqrt_d,
	CU1_r4300i_COP1_abs_d,
	CU1_r4300i_COP1_mov_d,
	CU1_r4300i_COP1_neg_d,
	CU1_r4300i_COP1_roundl_d,
	CU1_r4300i_COP1_truncl_d,
	CU1_r4300i_COP1_ceill_d,
	CU1_r4300i_COP1_floorl_d,
	CU1_r4300i_COP1_roundw_d,
	CU1_r4300i_COP1_truncw_d,
	CU1_r4300i_COP1_ceilw_d,
	CU1_r4300i_COP1_floorw_d,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_COP1_cvts_d,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_COP1_cvtw_d,
	CU1_r4300i_COP1_cvtl_d,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_C_F_D,
	CU1_r4300i_C_UN_D,
	CU1_r4300i_C_EQ_D,
	CU1_r4300i_C_UEQ_D,
	CU1_r4300i_C_OLT_D,
	CU1_r4300i_C_ULT_D,
	CU1_r4300i_C_OLE_D,
	CU1_r4300i_C_ULE_D,
	CU1_r4300i_C_SF_D,
	CU1_r4300i_C_NGLE_D,
	CU1_r4300i_C_SEQ_D,
	CU1_r4300i_C_NGL_D,
	CU1_r4300i_C_LT_D,
	CU1_r4300i_C_NGE_D,
	CU1_r4300i_C_LE_D,
	CU1_r4300i_C_NGT_D
};

void (*CU1_COP1_W_Instruction[64]) (uint32 Instruction) =
{
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_COP1_cvts_w,
	CU1_r4300i_COP1_cvtd_w,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED
};

void (*CU1_COP1_L_Instruction[64]) (uint32 Instruction) =
{
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_r4300i_COP1_cvts_l,
	CU1_r4300i_COP1_cvtd_l,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED
};


void CU1_COP1_BC_instr(uint32 Instruction)
{
	CU1_COP1_BC_Instruction[RT_FT](Instruction);
}
void CU1_COP1_D_instr(uint32 Instruction)
{
	CU1_COP1_D_Instruction[_FUNCTION_](Instruction);
}
void CU1_COP1_L_instr(uint32 Instruction)
{
	CU1_COP1_L_Instruction[_FUNCTION_](Instruction);
}
void CU1_COP1_S_instr(uint32 Instruction)
{
	CU1_COP1_S_Instruction[_FUNCTION_](Instruction);
}
void CU1_COP1_W_instr(uint32 Instruction)
{
	CU1_COP1_W_Instruction[_FUNCTION_](Instruction);
}


void (*CU1_COP1_Instruction[32]) (uint32 Instruction) =
{
	CU1_r4300i_COP1_mfc1,
	CU1_r4300i_COP1_dmfc1,
	CU1_r4300i_COP1_cfc1,
	UNUSED,
	CU1_r4300i_COP1_mtc1,
	CU1_r4300i_COP1_dmtc1,
	CU1_r4300i_COP1_ctc1,
	UNUSED,
	CU1_COP1_BC_instr,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	CU1_COP1_S_instr,
	CU1_COP1_D_instr,
	UNUSED,
	UNUSED,
	CU1_COP1_W_instr, //20
	CU1_COP1_L_instr,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED,
	UNUSED
};


void CU1_COP1_instr(uint32 Instruction)
{
	CU1_COP1_Instruction[RS_BASE_FMT](Instruction);
}

